/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class StdPeerGroupParamAdv {
    private static final Logger LOG = Logger.getLogger(StdPeerGroupParamAdv.class.getName());
    private static final String PARAM_TAG = "Parm";
    private static final String PROTO_TAG = "Proto";
    private static final String APP_TAG = "App";
    private static final String SVC_TAG = "Svc";
    private static final String MCID_TAG = "MCID";
    private static final String MSID_TAG = "MSID";
    private static final String MIA_TAG = ModuleImplAdvertisement.getAdvertisementType();
    private final Map<ModuleClassID, Object> services = new HashMap<ModuleClassID, Object>();
    private final Map<ModuleClassID, Object> transports = new HashMap<ModuleClassID, Object>();
    private final Map<ModuleClassID, Object> apps = new HashMap<ModuleClassID, Object>();

    public StdPeerGroupParamAdv() {
    }

    public StdPeerGroupParamAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        this.initialize((XMLElement)root);
    }

    public StdPeerGroupParamAdv(XMLElement doc) {
        this.initialize(doc);
    }

    public void addService(ModuleClassID mcid, Object module) {
        this.services.put(mcid, module);
    }

    public Map<ModuleClassID, Object> getServices() {
        return this.services;
    }

    public void addProto(ModuleClassID mcid, Object module) {
        this.transports.put(mcid, module);
    }

    public Map<ModuleClassID, Object> getProtos() {
        return this.transports;
    }

    public void addApp(ModuleClassID mcid, Object module) {
        this.apps.put(mcid, module);
    }

    public Map<ModuleClassID, Object> getApps() {
        return this.apps;
    }

    public void setServices(Map<ModuleClassID, Object> servicesTable) {
        if (servicesTable == this.services) {
            return;
        }
        this.services.clear();
        if (null != servicesTable) {
            this.services.putAll(servicesTable);
        }
    }

    public void setProtos(Map<ModuleClassID, Object> protosTable) {
        if (protosTable == this.transports) {
            return;
        }
        this.transports.clear();
        if (null != protosTable) {
            this.transports.putAll(protosTable);
        }
    }

    public void setApps(Map<ModuleClassID, Object> appsTable) {
        if (appsTable == this.apps) {
            return;
        }
        this.apps.clear();
        if (null != appsTable) {
            this.apps.putAll(appsTable);
        }
    }

    private void initialize(XMLElement doc) {
        if (!doc.getName().equals(PARAM_TAG)) {
            throw new IllegalArgumentException("Can not construct " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        int appCount = 0;
        Enumeration modules = doc.getChildren();
        while (modules.hasMoreElements()) {
            Object theValue;
            Map<ModuleClassID, Object> theTable;
            XMLElement module = (XMLElement)modules.nextElement();
            String tagName = module.getName();
            if (SVC_TAG.equals(tagName)) {
                theTable = this.services;
            } else if (APP_TAG.equals(tagName)) {
                theTable = this.apps;
            } else if (PROTO_TAG.equals(tagName)) {
                theTable = this.transports;
            } else {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Unhandled top-level tag : " + tagName);
                continue;
            }
            ModuleSpecID specID = null;
            ModuleClassID classID = null;
            ModuleImplAdvertisement inLineAdv = null;
            try {
                if (module.getTextValue() != null) {
                    specID = (ModuleSpecID)IDFactory.fromURI(new URI(module.getTextValue()));
                }
                Enumeration fields = module.getChildren();
                while (fields.hasMoreElements()) {
                    XMLElement field = (XMLElement)fields.nextElement();
                    String fieldName = field.getName();
                    if (MCID_TAG.equals(fieldName)) {
                        classID = (ModuleClassID)IDFactory.fromURI(new URI(field.getTextValue()));
                        continue;
                    }
                    if (MSID_TAG.equals(field.getName())) {
                        specID = (ModuleSpecID)IDFactory.fromURI(new URI(field.getTextValue()));
                        continue;
                    }
                    if (MIA_TAG.equals(field.getName())) {
                        inLineAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(field);
                        continue;
                    }
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Unhandled field : " + fieldName);
                }
            }
            catch (Exception any) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, "Broken entry; skipping", any);
                continue;
            }
            if (inLineAdv == null && specID == null) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Insufficent entry; skipping");
                continue;
            }
            if (inLineAdv != null) {
                specID = inLineAdv.getModuleSpecID();
                theValue = inLineAdv;
            } else {
                theValue = specID;
            }
            if (classID == null) {
                classID = specID.getBaseClass();
            }
            if (theTable == this.apps && classID == PeerGroup.applicationClassID && appCount++ != 0) {
                classID = IDFactory.newModuleClassID(classID);
            }
            theTable.put(classID, theValue);
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(encodeAs, PARAM_TAG);
        this.outputModules(doc, this.services, SVC_TAG);
        this.outputModules(doc, this.transports, PROTO_TAG);
        this.outputModules(doc, this.apps, APP_TAG);
        return doc;
    }

    private void outputModules(StructuredDocument doc, Map<ModuleClassID, Object> modulesTable, String mainTag) {
        for (Map.Entry<ModuleClassID, Object> entry : modulesTable.entrySet()) {
            Object i;
            Object m;
            ModuleClassID mcid = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Advertisement) {
                m = doc.createElement(mainTag);
                doc.appendChild(m);
                if (modulesTable != this.apps && !mcid.equals(mcid.getBaseClass())) {
                    i = doc.createElement(MCID_TAG, mcid.toString());
                    m.appendChild(i);
                }
                StructuredDocument advdoc = (StructuredDocument)((Advertisement)val).getDocument(doc.getMimeType());
                StructuredDocumentUtils.copyElements(doc, m, advdoc);
                continue;
            }
            if (val instanceof ModuleSpecID) {
                if (modulesTable == this.apps || mcid.equals(mcid.getBaseClass())) {
                    m = doc.createElement(mainTag, val.toString());
                    doc.appendChild(m);
                    continue;
                }
                m = doc.createElement(mainTag);
                doc.appendChild(m);
                i = doc.createElement(MCID_TAG, mcid.toString());
                m.appendChild(i);
                i = doc.createElement(MSID_TAG, val.toString());
                m.appendChild(i);
                continue;
            }
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("unsupported class in modules table");
            }
            throw new IllegalStateException("unsupported class in modules table : " + val);
        }
    }
}

