/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEAuthenticatorEngine;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;

public class EngineAuthenticator
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(EngineAuthenticator.class.getName());
    transient PSEMembershipService source;
    transient AuthenticationCredential application;
    transient X509Certificate seedCert;
    transient PSEAuthenticatorEngine authenticatorEngine;
    transient char[] store_password = null;
    transient ID identity = null;
    transient char[] key_password = null;

    EngineAuthenticator(PSEMembershipService source, AuthenticationCredential application, PSEAuthenticatorEngine authenticatorEngine) {
        this.source = source;
        this.application = application;
        this.seedCert = authenticatorEngine.getX509Certificate();
        this.authenticatorEngine = authenticatorEngine;
    }

    EngineAuthenticator(PSEMembershipService source, AuthenticationCredential application) {
        this.source = source;
        this.application = application;
    }

    protected void finalize() throws Throwable {
        if (null != this.store_password) {
            Arrays.fill(this.store_password, '\u0000');
        }
        if (null != this.key_password) {
            Arrays.fill(this.key_password, '\u0000');
        }
        super.finalize();
    }

    public MembershipService getSourceService() {
        return (MembershipService)this.source.getInterface();
    }

    public AuthenticationCredential getAuthenticationCredential() {
        return this.application;
    }

    public String getMethodName() {
        return "EngineAuthentication";
    }

    public synchronized boolean isReadyForJoin() {
        if (null != this.seedCert) {
            return this.authenticatorEngine.isEnginePresent();
        }
        return this.source.pseStore.validPasswd(this.identity, this.store_password, this.key_password);
    }

    public char[] getAuth1_KeyStorePassword() {
        return this.store_password;
    }

    public void setAuth1_KeyStorePassword(String store_password) {
        if (null == store_password) {
            this.setAuth1_KeyStorePassword((char[])null);
        } else {
            this.setAuth1_KeyStorePassword(store_password.toCharArray());
        }
    }

    public void setAuth1_KeyStorePassword(char[] store_password) {
        if (null != this.store_password) {
            Arrays.fill(this.store_password, '\u0000');
        }
        this.store_password = (char[])(null == store_password ? null : (char[])store_password.clone());
    }

    public PeerID[] getIdentities(char[] store_password) {
        if (this.seedCert != null) {
            PeerID[] seed = new PeerID[]{this.source.group.getPeerID()};
            return seed;
        }
        try {
            ID[] allkeys = this.source.pseStore.getKeysList(store_password);
            ArrayList<ID> peersOnly = new ArrayList<ID>();
            for (ID aKey : Arrays.asList(allkeys)) {
                if (!(aKey instanceof PeerID)) continue;
                peersOnly.add(aKey);
            }
            return peersOnly.toArray(new PeerID[peersOnly.size()]);
        }
        catch (IOException failed) {
            return null;
        }
        catch (KeyStoreException failed) {
            return null;
        }
    }

    public X509Certificate getCertificate(char[] store_password, ID aPeer) {
        if (this.seedCert != null) {
            if (aPeer.equals(this.source.group.getPeerID())) {
                return this.seedCert;
            }
            return null;
        }
        try {
            return this.source.pseStore.getTrustedCertificate(aPeer, store_password);
        }
        catch (IOException failed) {
            return null;
        }
        catch (KeyStoreException failed) {
            return null;
        }
    }

    public ID getAuth2Identity() {
        return this.identity;
    }

    public void setAuth2Identity(String id) {
        try {
            URI idURI = new URI(id);
            ID identity = IDFactory.fromURI(idURI);
            this.setAuth2Identity(identity);
        }
        catch (URISyntaxException badID) {
            throw new IllegalArgumentException("Bad ID");
        }
    }

    public void setAuth2Identity(ID identity) {
        this.identity = identity;
    }

    public char[] getAuth3_IdentityPassword() {
        return this.key_password;
    }

    public void setAuth3_IdentityPassword(String key_password) {
        this.setAuth3_IdentityPassword(key_password.toCharArray());
    }

    public void setAuth3_IdentityPassword(char[] key_password) {
        if (null != this.key_password) {
            Arrays.fill(this.key_password, '\u0000');
        }
        this.key_password = (char[])(null == key_password ? null : (char[])key_password.clone());
    }
}

