/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.transportMeter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.transportMeter.TransportMetric;
import net.jxta.impl.endpoint.transportMeter.TransportServiceMonitorFilter;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMetric;
import net.jxta.platform.ModuleClassID;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportServiceMetric
implements ServiceMetric {
    private LinkedList<TransportMetric> transportMetrics = new LinkedList();
    private ModuleClassID moduleClassID = MonitorResources.transportServiceMonitorClassID;

    @Override
    public void init(ModuleClassID moduleClassID) {
        this.moduleClassID = moduleClassID;
    }

    @Override
    public ModuleClassID getModuleClassID() {
        return this.moduleClassID;
    }

    public void addTransportMetric(TransportMetric transportMetric) {
        this.transportMetrics.add(transportMetric);
    }

    public Iterator<TransportMetric> getTransportMetrics() {
        return this.transportMetrics.iterator();
    }

    public TransportMetric getTransportMetric(String protocol, EndpointAddress endpointAddress) {
        for (TransportMetric transportMetric : this.transportMetrics) {
            if (!protocol.equals(transportMetric.getProtocol()) || !endpointAddress.equals(transportMetric.getEndpointAddress())) continue;
            return transportMetric;
        }
        return null;
    }

    public TransportMetric getTransportMetric(TransportMetric prototype) {
        return this.getTransportMetric(prototype.getProtocol(), prototype.getEndpointAddress());
    }

    @Override
    public void serializeTo(Element element2) throws DocumentSerializationException {
        for (TransportMetric transportMetric : this.transportMetrics) {
            DocumentSerializableUtilities.addDocumentSerializable(element2, "transportMetric", transportMetric);
        }
        if (this.moduleClassID != null) {
            DocumentSerializableUtilities.addString(element2, "moduleClassID", this.moduleClassID.toString());
        }
    }

    @Override
    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("transportMetric")) {
                TransportMetric transportMetric = (TransportMetric)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, TransportMetric.class);
                this.transportMetrics.add(transportMetric);
            }
            if (!tagName.equals("moduleClassID")) continue;
            try {
                this.moduleClassID = (ModuleClassID)IDFactory.fromURI(new URI(DocumentSerializableUtilities.getString(childElement)));
            }
            catch (URISyntaxException jex) {
                throw new DocumentSerializationException("Can't read moduleClassID", jex);
            }
        }
    }

    public TransportServiceMetric shallowCopy(TransportServiceMonitorFilter transportServiceMonitorFilter) {
        TransportServiceMetric serviceMetric = new TransportServiceMetric();
        serviceMetric.moduleClassID = this.moduleClassID;
        Iterator<TransportMetric> i = this.getTransportMetrics();
        while (i.hasNext()) {
            TransportMetric transportMetric = i.next();
            String protocol = transportMetric.getProtocol();
            if (!transportServiceMonitorFilter.hasTransport(protocol)) continue;
            serviceMetric.addTransportMetric(transportMetric);
        }
        return serviceMetric;
    }

    @Override
    public void mergeMetrics(ServiceMetric serviceMetric) {
        this.mergeMetrics(serviceMetric, null);
    }

    public void mergeMetrics(ServiceMetric serviceMetric, TransportServiceMonitorFilter transportServiceMonitorFilter) {
        TransportServiceMetric otherTransportServiceMetric = (TransportServiceMetric)serviceMetric;
        Iterator<TransportMetric> i = otherTransportServiceMetric.getTransportMetrics();
        while (i.hasNext()) {
            TransportMetric otherTransportMetric = i.next();
            String protocol = otherTransportMetric.getProtocol();
            if (transportServiceMonitorFilter != null && !transportServiceMonitorFilter.hasTransport(protocol)) continue;
            TransportMetric transportMetric = this.getTransportMetric(otherTransportMetric.getProtocol(), otherTransportMetric.getEndpointAddress());
            if (transportMetric == null) {
                transportMetric = new TransportMetric(otherTransportMetric);
                this.addTransportMetric(transportMetric);
            }
            transportMetric.mergeMetrics(otherTransportMetric);
        }
    }

    public TransportServiceMetric deepCopy(TransportServiceMonitorFilter transportServiceMonitorFilter) {
        TransportServiceMetric serviceMetric = new TransportServiceMetric();
        serviceMetric.moduleClassID = this.moduleClassID;
        serviceMetric.mergeMetrics(this, transportServiceMonitorFilter);
        return serviceMetric;
    }

    @Override
    public void diffMetrics(ServiceMetric otherOne) {
        throw new RuntimeException("Not Supported");
    }
}

