/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.transportMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.peer.PeerID;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class TransportBindingMetric
implements DocumentSerializable {
    public static final String CONNECTED = "connected";
    public static final String CLOSED = "closed";
    public static final String DROPPED = "dropped";
    public static final String FAILED = "failed";
    private PeerID peerID;
    private EndpointAddress endpointAddress;
    private String initiatorState = null;
    private String acceptorState = null;
    private long initiatorTransitionTime;
    private long acceptorTransitionTime;
    private int acceptorBytesReceived;
    private int acceptorBytesSent;
    private int acceptorConnections;
    private int acceptorConnectionsClosed;
    private int acceptorConnectionsDropped;
    private int acceptorConnectionsFailed;
    private int acceptorMessagesReceived;
    private int acceptorMessagesSent;
    private long acceptorReceiveFailureProcessingTime;
    private int acceptorReceiveFailures;
    private long acceptorReceiveProcessingTime;
    private long acceptorSendFailureProcessingTime;
    private int acceptorSendFailures;
    private long acceptorSendProcessingTime;
    private long acceptorTotalTimeConnected;
    private long acceptorTimeToConnect;
    private long acceptorTimeToFail;
    private int initiatorBytesReceived;
    private int initiatorBytesSent;
    private long initiatorTotalTimeConnected;
    private int initiatorConnections;
    private int initiatorConnectionsClosed;
    private int initiatorConnectionsDropped;
    private int initiatorConnectionsFailed;
    private int initiatorMessagesReceived;
    private int initiatorMessagesSent;
    private long initiatorReceiveFailureProcessingTime;
    private int initiatorReceiveFailures;
    private long initiatorReceiveProcessingTime;
    private long initiatorSendFailureProcessingTime;
    private int initiatorSendFailures;
    private long initiatorSendProcessingTime;
    private long initiatorTimeToConnect;
    private long initiatorTimeToFail;
    private int numPings;
    private int numFailedPings;
    private long pingTime;
    private long pingFailedTime;
    private int numPingsReceived;

    public TransportBindingMetric(TransportBindingMeter transportBindingMeter, boolean initiatorConnected, boolean acceptorConnected) {
        this.peerID = transportBindingMeter.getPeerID();
        this.endpointAddress = transportBindingMeter.getEndpointAddress();
        this.initiatorState = initiatorConnected ? CONNECTED : CLOSED;
        this.acceptorState = acceptorConnected ? CONNECTED : CLOSED;
    }

    public TransportBindingMetric() {
    }

    public TransportBindingMetric(TransportBindingMetric prototype) {
        this.peerID = prototype.peerID;
        this.endpointAddress = prototype.endpointAddress;
        this.initiatorState = prototype.initiatorState;
        this.acceptorState = prototype.acceptorState;
        this.initiatorTransitionTime = prototype.initiatorTransitionTime;
        this.acceptorTransitionTime = prototype.acceptorTransitionTime;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TransportBindingMetric) {
            TransportBindingMetric other = (TransportBindingMetric)obj;
            return this.endpointAddress.equals(other.endpointAddress);
        }
        return false;
    }

    public int hashCode() {
        return this.peerID.hashCode() + this.endpointAddress.hashCode();
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public void setPeerID(PeerID peerID) {
        this.peerID = peerID;
    }

    public EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    public String getInitiatorState() {
        return this.initiatorState;
    }

    public String getAcceptorState() {
        return this.acceptorState;
    }

    public long getInitiatorTransitionTime() {
        return this.initiatorTransitionTime;
    }

    public long getAcceptorTransitionTime() {
        return this.acceptorTransitionTime;
    }

    public boolean isAcceptorConnected() {
        return this.acceptorState != null && this.acceptorState.equals(CONNECTED);
    }

    public boolean isInitiatorConnected() {
        return this.initiatorState != null && this.initiatorState.equals(CONNECTED);
    }

    public long getTimeAcceptorConnectionEstablished() {
        return this.isAcceptorConnected() ? this.acceptorTransitionTime : 0L;
    }

    public long getTimeInitiatorConnectionEstablished() {
        return this.isInitiatorConnected() ? this.initiatorTransitionTime : 0L;
    }

    public int getAcceptorBytesReceived() {
        return this.acceptorBytesReceived;
    }

    public int getAcceptorBytesSent() {
        return this.acceptorBytesSent;
    }

    public int getAcceptorConnections() {
        return this.acceptorConnections;
    }

    public int getAcceptorConnectionsClosed() {
        return this.acceptorConnectionsClosed;
    }

    public int getAcceptorConnectionsDropped() {
        return this.acceptorConnectionsDropped;
    }

    public int getAcceptorConnectionsFailed() {
        return this.acceptorConnectionsFailed;
    }

    public int getAcceptorMessagesReceived() {
        return this.acceptorMessagesReceived;
    }

    public int getAcceptorMessagesSent() {
        return this.acceptorMessagesSent;
    }

    public long getAcceptorReceiveFailureProcessingTime() {
        return this.acceptorReceiveFailureProcessingTime;
    }

    public int getAcceptorReceiveFailures() {
        return this.acceptorReceiveFailures;
    }

    public long getAcceptorReceiveProcessingTime() {
        return this.acceptorReceiveProcessingTime;
    }

    public long getAcceptorSendFailureProcessingTime() {
        return this.acceptorSendFailureProcessingTime;
    }

    public int getAcceptorSendFailures() {
        return this.acceptorSendFailures;
    }

    public long getAcceptorSendProcessingTime() {
        return this.acceptorSendProcessingTime;
    }

    public long getAcceptorTimeToConnect() {
        return this.acceptorTimeToConnect;
    }

    public long getAcceptorTimeToFail() {
        return this.acceptorTimeToFail;
    }

    public int getInitiatorBytesReceived() {
        return this.initiatorBytesReceived;
    }

    public int getInitiatorBytesSent() {
        return this.initiatorBytesSent;
    }

    public int getInitiatorConnections() {
        return this.initiatorConnections;
    }

    public int getInitiatorConnectionsClosed() {
        return this.initiatorConnectionsClosed;
    }

    public int getInitiatorConnectionsDropped() {
        return this.initiatorConnectionsDropped;
    }

    public int getInitiatorConnectionsFailed() {
        return this.initiatorConnectionsFailed;
    }

    public int getInitiatorMessagesReceived() {
        return this.initiatorMessagesReceived;
    }

    public int getInitiatorMessagesSent() {
        return this.initiatorMessagesSent;
    }

    public long getInitiatorReceiveFailureProcessingTime() {
        return this.initiatorReceiveFailureProcessingTime;
    }

    public int getInitiatorReceiveFailures() {
        return this.initiatorReceiveFailures;
    }

    public long getInitiatorReceiveProcessingTime() {
        return this.initiatorReceiveProcessingTime;
    }

    public long getInitiatorSendFailureProcessingTime() {
        return this.initiatorSendFailureProcessingTime;
    }

    public int getInitiatorSendFailures() {
        return this.initiatorSendFailures;
    }

    public long getInitiatorSendProcessingTime() {
        return this.initiatorSendProcessingTime;
    }

    public long getInitiatorTimeToConnect() {
        return this.initiatorTimeToConnect;
    }

    public long getInitiatorTimeToFail() {
        return this.initiatorTimeToFail;
    }

    public int getNumPings() {
        return this.numPings;
    }

    public int getNumFailedPings() {
        return this.numFailedPings;
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public long getPingFailedTime() {
        return this.pingFailedTime;
    }

    public int getNumPingsReceived() {
        return this.numPingsReceived;
    }

    public int getBytesReceived() {
        return this.acceptorBytesReceived + this.initiatorBytesReceived;
    }

    public int getBytesSent() {
        return this.acceptorBytesSent + this.initiatorBytesSent;
    }

    public int getConnections() {
        return this.acceptorConnections + this.initiatorConnections;
    }

    public int getConnectionsClosed() {
        return this.acceptorConnectionsClosed + this.initiatorConnectionsClosed;
    }

    public int getConnectionsDropped() {
        return this.acceptorConnectionsDropped + this.initiatorConnectionsDropped;
    }

    public int getConnectionsFailed() {
        return this.acceptorConnectionsFailed + this.initiatorConnectionsFailed;
    }

    public int getMessagesReceived() {
        return this.acceptorMessagesReceived + this.initiatorMessagesReceived;
    }

    public int getMessagesSent() {
        return this.acceptorMessagesSent + this.initiatorMessagesSent;
    }

    public long getReceiveFailureProcessingTime() {
        return this.acceptorReceiveFailureProcessingTime + this.initiatorReceiveFailureProcessingTime;
    }

    public int getReceiveFailures() {
        return this.acceptorReceiveFailures + this.initiatorReceiveFailures;
    }

    public long getReceiveProcessingTime() {
        return this.acceptorReceiveProcessingTime + this.initiatorReceiveProcessingTime;
    }

    public long getSendFailureProcessingTime() {
        return this.acceptorSendFailureProcessingTime + this.initiatorSendFailureProcessingTime;
    }

    public int getSendFailures() {
        return this.acceptorSendFailures + this.initiatorSendFailures;
    }

    public long getSendProcessingTime() {
        return this.acceptorSendProcessingTime + this.initiatorSendProcessingTime;
    }

    public long getTotalTimeConnected() {
        return this.acceptorTotalTimeConnected + this.initiatorTotalTimeConnected;
    }

    public long getTimeToConnect() {
        return this.acceptorTimeToConnect + this.initiatorTimeToConnect;
    }

    public long getTimeToFail() {
        return this.acceptorTimeToFail + this.initiatorTimeToFail;
    }

    public int getAveragePingTime() {
        return (int)(this.numPings != 0 ? this.pingTime / (long)this.numPings : 0L);
    }

    public int getAveragePingFailedTime() {
        return (int)(this.numFailedPings != 0 ? this.pingFailedTime / (long)this.numFailedPings : 0L);
    }

    public int getAverageAcceptorReceiveFailureProcessingTime() {
        return (int)(this.acceptorReceiveFailures != 0 ? this.acceptorReceiveFailureProcessingTime / (long)this.acceptorReceiveFailures : 0L);
    }

    public int getAverageAcceptorReceiveProcessingTime() {
        return (int)(this.acceptorMessagesReceived != 0 ? this.acceptorReceiveProcessingTime / (long)this.acceptorMessagesReceived : 0L);
    }

    public int getAverageAcceptorSendFailureProcessingTime() {
        return (int)(this.acceptorSendFailures != 0 ? this.acceptorSendFailureProcessingTime / (long)this.acceptorSendFailures : 0L);
    }

    public int getAverageAcceptorSendProcessingTime() {
        return (int)(this.acceptorMessagesSent != 0 ? this.acceptorSendProcessingTime / (long)this.acceptorMessagesSent : 0L);
    }

    public int getAverageAcceptorTimeToConnect() {
        return (int)(this.acceptorConnections != 0 ? this.acceptorTimeToConnect / (long)this.acceptorConnections : 0L);
    }

    public int getAverageAcceptorTimeToFail() {
        return (int)(this.acceptorConnectionsFailed != 0 ? this.acceptorTimeToFail / (long)this.acceptorConnectionsFailed : 0L);
    }

    public int getAverageInitiatorReceiveFailureProcessingTime() {
        return (int)(this.initiatorReceiveFailures != 0 ? this.initiatorReceiveFailureProcessingTime / (long)this.initiatorReceiveFailures : 0L);
    }

    public int getAverageInitiatorReceiveProcessingTime() {
        return (int)(this.initiatorMessagesReceived != 0 ? this.initiatorReceiveProcessingTime / (long)this.initiatorMessagesReceived : 0L);
    }

    public int getAverageInitiatorSendFailureProcessingTime() {
        return (int)(this.initiatorSendFailures != 0 ? this.initiatorSendFailureProcessingTime / (long)this.initiatorSendFailures : 0L);
    }

    public int getAverageInitiatorSendProcessingTime() {
        return (int)(this.initiatorMessagesSent != 0 ? this.initiatorSendProcessingTime / (long)this.initiatorMessagesSent : 0L);
    }

    public int getAverageInitiatorTimeToConnect() {
        return (int)(this.initiatorConnections != 0 ? this.initiatorTimeToConnect / (long)this.initiatorConnections : 0L);
    }

    public int getAverageInitiatorTimeToFail() {
        return (int)(this.initiatorConnectionsFailed != 0 ? this.initiatorTimeToFail / (long)this.initiatorConnectionsFailed : 0L);
    }

    public int getAverageReceiveFailureProcessingTime() {
        return (int)(this.initiatorReceiveFailures + this.acceptorReceiveFailures != 0 ? (this.initiatorReceiveFailureProcessingTime + this.acceptorReceiveFailureProcessingTime) / (long)(this.initiatorReceiveFailures + this.acceptorReceiveFailures) : 0L);
    }

    public int getAverageReceiveProcessingTime() {
        return (int)(this.initiatorMessagesReceived + this.acceptorMessagesReceived != 0 ? (this.initiatorReceiveProcessingTime + this.acceptorReceiveProcessingTime) / (long)(this.initiatorMessagesReceived + this.acceptorMessagesReceived) : 0L);
    }

    public int getAverageSendFailureProcessingTime() {
        return (int)(this.initiatorSendFailures + this.acceptorSendFailures != 0 ? (this.initiatorSendFailureProcessingTime + this.acceptorSendFailureProcessingTime) / (long)(this.initiatorSendFailures + this.acceptorSendFailures) : 0L);
    }

    public int getAverageSendProcessingTime() {
        return (int)(this.initiatorMessagesSent + this.acceptorMessagesSent != 0 ? (this.initiatorSendProcessingTime + this.acceptorSendProcessingTime) / (long)(this.initiatorMessagesSent + this.acceptorMessagesSent) : 0L);
    }

    public int getAverageTimeToConnect() {
        return (int)(this.initiatorConnections + this.acceptorConnections != 0 ? (this.initiatorTimeToConnect + this.acceptorTimeToConnect) / (long)(this.initiatorConnections + this.acceptorConnections) : 0L);
    }

    public int getAverageTimeToFail() {
        return (int)(this.initiatorConnectionsFailed + this.acceptorConnectionsFailed != 0 ? (this.initiatorTimeToFail + this.acceptorTimeToFail) / (long)(this.initiatorConnectionsFailed + this.acceptorConnectionsFailed) : 0L);
    }

    public long getInitiatorTotalTimeConnected() {
        return this.initiatorTotalTimeConnected;
    }

    public long getInitiatorTotalTimeConnected(long adjustmentTime) {
        long result = this.initiatorTotalTimeConnected;
        if (this.isInitiatorConnected()) {
            result += adjustmentTime - this.initiatorTransitionTime;
        }
        return result;
    }

    public long getInitiatorTimeConnected() {
        return this.getInitiatorTimeConnected(System.currentTimeMillis());
    }

    public long getInitiatorTimeConnected(long adjustmentTime) {
        if (this.isInitiatorConnected()) {
            return adjustmentTime - this.initiatorTransitionTime;
        }
        return 0L;
    }

    public long getAcceptorTotalTimeConnected() {
        return this.acceptorTotalTimeConnected;
    }

    public long getAcceptorTotalTimeConnected(long adjustmentTime) {
        long result = this.acceptorTotalTimeConnected;
        if (this.isAcceptorConnected()) {
            result += adjustmentTime - this.acceptorTransitionTime;
        }
        return result;
    }

    public long getAcceptorTimeConnected() {
        return this.getAcceptorTimeConnected(System.currentTimeMillis());
    }

    public long getAcceptorTimeConnected(long adjustmentTime) {
        if (this.isAcceptorConnected()) {
            return adjustmentTime - this.acceptorTransitionTime;
        }
        return 0L;
    }

    void resetInitiatorState(String state, long transitionTime) {
        if (this.isInitiatorConnected()) {
            this.acceptorTotalTimeConnected += System.currentTimeMillis() - this.initiatorTransitionTime;
        }
        this.initiatorState = state;
        this.initiatorTransitionTime = transitionTime;
    }

    void resetAcceptorState(String state, long transitionTime) {
        if (this.isAcceptorConnected()) {
            this.initiatorTotalTimeConnected += System.currentTimeMillis() - this.acceptorTransitionTime;
        }
        this.acceptorState = state;
        this.acceptorTransitionTime = transitionTime;
    }

    void connectionEstablished(boolean initiator, long timeToConnect, long transitionTime) {
        if (initiator) {
            this.resetInitiatorState(CONNECTED, transitionTime);
            ++this.initiatorConnections;
            this.initiatorTimeToConnect += timeToConnect;
        } else {
            this.resetAcceptorState(CONNECTED, transitionTime);
            ++this.acceptorConnections;
            this.acceptorTimeToConnect += timeToConnect;
        }
    }

    void connectionFailed(boolean initiator, long timeToConnect, long transitionTime) {
        if (initiator) {
            this.resetInitiatorState(FAILED, transitionTime);
            ++this.initiatorConnectionsFailed;
            this.initiatorTimeToFail += timeToConnect;
        } else {
            this.resetAcceptorState(FAILED, transitionTime);
            ++this.acceptorConnectionsFailed;
            this.acceptorTimeToFail += timeToConnect;
        }
    }

    void connectionClosed(boolean initiator, long transitionTime) {
        if (initiator) {
            this.resetInitiatorState(CLOSED, transitionTime);
            ++this.initiatorConnectionsClosed;
        } else {
            this.resetAcceptorState(CLOSED, transitionTime);
            ++this.acceptorConnectionsClosed;
        }
    }

    void connectionDropped(boolean initiator, long transitionTime) {
        if (initiator) {
            this.resetInitiatorState(DROPPED, transitionTime);
            ++this.initiatorConnectionsDropped;
        } else {
            this.resetAcceptorState(DROPPED, transitionTime);
            ++this.acceptorConnectionsDropped;
        }
    }

    void pingReceived() {
        ++this.numPingsReceived;
    }

    void ping(long time) {
        ++this.numPings;
        this.pingTime += time;
    }

    void pingFailed(long time) {
        ++this.numFailedPings;
        this.pingFailedTime += time;
    }

    void dataReceived(boolean initiator, int size) {
        if (initiator) {
            this.initiatorBytesReceived += size;
        } else {
            this.acceptorBytesReceived += size;
        }
    }

    void messageReceived(boolean initiator, Message message, long time, long size) {
        if (initiator) {
            ++this.initiatorMessagesReceived;
            this.initiatorReceiveProcessingTime += time;
            this.initiatorBytesReceived = (int)((long)this.initiatorBytesReceived + size);
        } else {
            ++this.acceptorMessagesReceived;
            this.acceptorReceiveProcessingTime += time;
            this.acceptorBytesReceived = (int)((long)this.acceptorBytesReceived + size);
        }
    }

    void receiveFailure(boolean initiator, long time, long size) {
        if (initiator) {
            ++this.initiatorReceiveFailures;
            this.initiatorReceiveFailureProcessingTime += time;
            this.initiatorBytesReceived = (int)((long)this.initiatorBytesReceived + size);
        } else {
            ++this.acceptorReceiveFailures;
            this.acceptorReceiveFailureProcessingTime += time;
            this.acceptorBytesReceived = (int)((long)this.acceptorBytesReceived + size);
        }
    }

    void dataSent(boolean initiator, long size) {
        if (initiator) {
            this.initiatorBytesSent = (int)((long)this.initiatorBytesSent + size);
        } else {
            this.acceptorBytesSent = (int)((long)this.acceptorBytesSent + size);
        }
    }

    void sendFailure(boolean initiator, Message message, long time, long size) {
        if (initiator) {
            ++this.initiatorSendFailures;
            this.initiatorSendFailureProcessingTime += time;
            this.initiatorBytesSent = (int)((long)this.initiatorBytesSent + size);
        } else {
            ++this.acceptorSendFailures;
            this.acceptorSendFailureProcessingTime += time;
            this.acceptorBytesSent = (int)((long)this.acceptorBytesSent + size);
        }
    }

    void messageSent(boolean initiator, Message message, long time, long size) {
        if (initiator) {
            ++this.initiatorMessagesSent;
            this.initiatorSendProcessingTime += time;
            this.initiatorBytesSent = (int)((long)this.initiatorBytesSent + size);
        } else {
            ++this.acceptorMessagesSent;
            this.acceptorSendProcessingTime += time;
            this.acceptorBytesSent = (int)((long)this.acceptorBytesSent + size);
        }
    }

    public void mergeMetrics(TransportBindingMetric other) {
        this.peerID = other.peerID;
        if (other.initiatorState != null) {
            this.initiatorState = other.initiatorState;
        }
        if (other.initiatorTransitionTime != 0L) {
            this.initiatorTransitionTime = other.initiatorTransitionTime;
        }
        if (other.acceptorState != null) {
            this.acceptorState = other.acceptorState;
        }
        if (other.initiatorTransitionTime != 0L) {
            this.acceptorTransitionTime = other.acceptorTransitionTime;
        }
        this.acceptorBytesReceived += other.acceptorBytesReceived;
        this.acceptorBytesSent += other.acceptorBytesSent;
        this.acceptorConnections += other.acceptorConnections;
        this.acceptorConnectionsClosed += other.acceptorConnectionsClosed;
        this.acceptorConnectionsDropped += other.acceptorConnectionsDropped;
        this.acceptorConnectionsFailed += other.acceptorConnectionsFailed;
        this.acceptorMessagesReceived += other.acceptorMessagesReceived;
        this.acceptorMessagesSent += other.acceptorMessagesSent;
        this.acceptorReceiveFailureProcessingTime += other.acceptorReceiveFailureProcessingTime;
        this.acceptorReceiveFailures += other.acceptorReceiveFailures;
        this.acceptorReceiveProcessingTime += other.acceptorReceiveProcessingTime;
        this.acceptorSendFailureProcessingTime += other.acceptorSendFailureProcessingTime;
        this.acceptorSendFailures += other.acceptorSendFailures;
        this.acceptorSendProcessingTime += other.acceptorSendProcessingTime;
        this.acceptorTotalTimeConnected += other.acceptorTotalTimeConnected;
        this.acceptorTimeToConnect += other.acceptorTimeToConnect;
        this.acceptorTimeToFail += other.acceptorTimeToFail;
        this.initiatorBytesReceived += other.initiatorBytesReceived;
        this.initiatorBytesSent += other.initiatorBytesSent;
        this.initiatorTotalTimeConnected += other.initiatorTotalTimeConnected;
        this.initiatorConnections += other.initiatorConnections;
        this.initiatorConnectionsClosed += other.initiatorConnectionsClosed;
        this.initiatorConnectionsDropped += other.initiatorConnectionsDropped;
        this.initiatorConnectionsFailed += other.initiatorConnectionsFailed;
        this.initiatorMessagesReceived += other.initiatorMessagesReceived;
        this.initiatorMessagesSent += other.initiatorMessagesSent;
        this.initiatorReceiveFailureProcessingTime += other.initiatorReceiveFailureProcessingTime;
        this.initiatorReceiveFailures += other.initiatorReceiveFailures;
        this.initiatorReceiveProcessingTime += other.initiatorReceiveProcessingTime;
        this.initiatorSendFailureProcessingTime += other.initiatorSendFailureProcessingTime;
        this.initiatorSendFailures += other.initiatorSendFailures;
        this.initiatorSendProcessingTime += other.initiatorSendProcessingTime;
        this.initiatorTimeToConnect += other.initiatorTimeToConnect;
        this.initiatorTimeToFail += other.initiatorTimeToFail;
        this.numPings += other.numPings;
        this.numFailedPings += other.numFailedPings;
        this.pingTime += other.pingTime;
        this.pingFailedTime += other.pingFailedTime;
        this.numPingsReceived += other.numPingsReceived;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "peerID", this.peerID.toString());
        DocumentSerializableUtilities.addString(element2, "endpointAddress", this.endpointAddress.toString());
        if (this.initiatorState != null) {
            DocumentSerializableUtilities.addString(element2, "initiatorState", this.initiatorState);
        }
        if (this.initiatorTransitionTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "initiatorTransitionTime", this.initiatorTransitionTime);
        }
        if (this.acceptorState != null) {
            DocumentSerializableUtilities.addString(element2, "acceptorState", this.acceptorState);
        }
        if (this.acceptorTransitionTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "acceptorTransitionTime", this.acceptorTransitionTime);
        }
        if (this.acceptorBytesReceived != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorBytesReceived", this.acceptorBytesReceived);
        }
        if (this.acceptorBytesSent != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorBytesSent", this.acceptorBytesSent);
        }
        if (this.acceptorConnections != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorConnections", this.acceptorConnections);
        }
        if (this.acceptorConnectionsClosed != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorConnectionsClosed", this.acceptorConnectionsClosed);
        }
        if (this.acceptorConnectionsDropped != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorConnectionsDropped", this.acceptorConnectionsDropped);
        }
        if (this.acceptorConnectionsFailed != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorConnectionsFailed", this.acceptorConnectionsFailed);
        }
        if (this.acceptorMessagesReceived != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorMessagesReceived", this.acceptorMessagesReceived);
        }
        if (this.acceptorMessagesSent != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorMessagesSent", this.acceptorMessagesSent);
        }
        if (this.acceptorReceiveFailureProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "acceptorReceiveFailureProcessingTime", this.acceptorReceiveFailureProcessingTime);
        }
        if (this.acceptorReceiveFailures != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorReceiveFailures", this.acceptorReceiveFailures);
        }
        if (this.acceptorReceiveProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "acceptorReceiveProcessingTime", this.acceptorReceiveProcessingTime);
        }
        if (this.acceptorSendFailureProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "acceptorSendFailureProcessingTime", this.acceptorSendFailureProcessingTime);
        }
        if (this.acceptorSendFailures != 0) {
            DocumentSerializableUtilities.addInt(element2, "acceptorSendFailures", this.acceptorSendFailures);
        }
        if (this.acceptorSendProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "acceptorSendProcessingTime", this.acceptorSendProcessingTime);
        }
        if (this.acceptorTotalTimeConnected != 0L) {
            DocumentSerializableUtilities.addLong(element2, "acceptorTotalTimeConnected", this.acceptorTotalTimeConnected);
        }
        if (this.acceptorTimeToConnect != 0L) {
            DocumentSerializableUtilities.addLong(element2, "acceptorTimeToConnect", this.acceptorTimeToConnect);
        }
        if (this.acceptorTimeToFail != 0L) {
            DocumentSerializableUtilities.addLong(element2, "acceptorTimeToFail", this.acceptorTimeToFail);
        }
        if (this.initiatorBytesReceived != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorBytesReceived", this.initiatorBytesReceived);
        }
        if (this.initiatorBytesSent != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorBytesSent", this.initiatorBytesSent);
        }
        if (this.initiatorTotalTimeConnected != 0L) {
            DocumentSerializableUtilities.addLong(element2, "initiatorTotalTimeConnected", this.initiatorTotalTimeConnected);
        }
        if (this.initiatorConnections != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorConnections", this.initiatorConnections);
        }
        if (this.initiatorConnectionsClosed != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorConnectionsClosed", this.initiatorConnectionsClosed);
        }
        if (this.initiatorConnectionsDropped != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorConnectionsDropped", this.initiatorConnectionsDropped);
        }
        if (this.initiatorConnectionsFailed != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorConnectionsFailed", this.initiatorConnectionsFailed);
        }
        if (this.initiatorMessagesReceived != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorMessagesReceived", this.initiatorMessagesReceived);
        }
        if (this.initiatorMessagesSent != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorMessagesSent", this.initiatorMessagesSent);
        }
        if (this.initiatorReceiveFailureProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "initiatorReceiveFailureProcessingTime", this.initiatorReceiveFailureProcessingTime);
        }
        if (this.initiatorReceiveFailures != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorReceiveFailures", this.initiatorReceiveFailures);
        }
        if (this.initiatorReceiveProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "initiatorReceiveProcessingTime", this.initiatorReceiveProcessingTime);
        }
        if (this.initiatorSendFailureProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "initiatorSendFailureProcessingTime", this.initiatorSendFailureProcessingTime);
        }
        if (this.initiatorSendFailures != 0) {
            DocumentSerializableUtilities.addInt(element2, "initiatorSendFailures", this.initiatorSendFailures);
        }
        if (this.initiatorSendProcessingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "initiatorSendProcessingTime", this.initiatorSendProcessingTime);
        }
        if (this.initiatorTimeToConnect != 0L) {
            DocumentSerializableUtilities.addLong(element2, "initiatorTimeToConnect", this.initiatorTimeToConnect);
        }
        if (this.initiatorTimeToFail != 0L) {
            DocumentSerializableUtilities.addLong(element2, "initiatorTimeToFail", this.initiatorTimeToFail);
        }
        if (this.numPings != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPings", this.numPings);
        }
        if (this.numFailedPings != 0) {
            DocumentSerializableUtilities.addInt(element2, "numFailedPings", this.numFailedPings);
        }
        if (this.pingTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "pingTime", this.pingTime);
        }
        if (this.pingFailedTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "pingFailedTime", this.pingFailedTime);
        }
        if (this.initiatorTimeToFail != 0L) {
            DocumentSerializableUtilities.addInt(element2, "numPingsReceived", this.numPingsReceived);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("peerID")) {
                String peerIdString = DocumentSerializableUtilities.getString(childElement);
                this.peerID = MetricUtilities.getPeerIdFromString(peerIdString);
            }
            if (tagName.equals("endpointAddress")) {
                String endpointAddressString = DocumentSerializableUtilities.getString(childElement);
                this.endpointAddress = new EndpointAddress(endpointAddressString);
                continue;
            }
            if (tagName.equals("acceptorBytesReceived")) {
                this.acceptorBytesReceived = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorBytesSent")) {
                this.acceptorBytesSent = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorConnections")) {
                this.acceptorConnections = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorConnectionsClosed")) {
                this.acceptorConnectionsClosed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorConnectionsDropped")) {
                this.acceptorConnectionsDropped = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorConnectionsFailed")) {
                this.acceptorConnectionsFailed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorMessagesReceived")) {
                this.acceptorMessagesReceived = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorMessagesSent")) {
                this.acceptorMessagesSent = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorReceiveFailureProcessingTime")) {
                this.acceptorReceiveFailureProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("acceptorReceiveFailures")) {
                this.acceptorReceiveFailures = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorReceiveProcessingTime")) {
                this.acceptorReceiveProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("acceptorSendFailureProcessingTime")) {
                this.acceptorSendFailureProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("acceptorSendFailures")) {
                this.acceptorSendFailures = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("acceptorSendProcessingTime")) {
                this.acceptorSendProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("acceptorTotalTimeConnected")) {
                this.acceptorTotalTimeConnected = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("acceptorTimeToConnect")) {
                this.acceptorTimeToConnect = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("acceptorTimeToFail")) {
                this.acceptorTimeToFail = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("initiatorBytesReceived")) {
                this.initiatorBytesReceived = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorBytesSent")) {
                this.initiatorBytesSent = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorTotalTimeConnected")) {
                this.initiatorTotalTimeConnected = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("initiatorConnections")) {
                this.initiatorConnections = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorConnectionsClosed")) {
                this.initiatorConnectionsClosed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorConnectionsDropped")) {
                this.initiatorConnectionsDropped = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorConnectionsFailed")) {
                this.initiatorConnectionsFailed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorMessagesReceived")) {
                this.initiatorMessagesReceived = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorMessagesSent")) {
                this.initiatorMessagesSent = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorReceiveFailureProcessingTime")) {
                this.initiatorReceiveFailureProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("initiatorReceiveFailures")) {
                this.initiatorReceiveFailures = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorReceiveProcessingTime")) {
                this.initiatorReceiveProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("initiatorSendFailureProcessingTime")) {
                this.initiatorSendFailureProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("initiatorSendFailures")) {
                this.initiatorSendFailures = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("initiatorSendProcessingTime")) {
                this.initiatorSendProcessingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("initiatorTimeToConnect")) {
                this.initiatorTimeToConnect = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("initiatorTimeToFail")) {
                this.initiatorTimeToFail = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numPingsReceived")) {
                this.numPingsReceived = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPings")) {
                this.numPings = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numFailedPings")) {
                this.numFailedPings = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("pingTime")) {
                this.pingTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (!tagName.equals("pingFailedTime")) continue;
            this.pingFailedTime = DocumentSerializableUtilities.getLong(childElement);
        }
    }
}

