/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsManager;
import net.jxta.impl.endpoint.tls.TlsMessenger;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;

public class TlsTransport
implements Module,
MessageSender,
MessageReceiver {
    private static final transient Logger LOG = Logger.getLogger(TlsTransport.class.getName());
    static final boolean ACT_AS_SERVER = true;
    private PeerGroup group = null;
    ID assignedID = null;
    ModuleImplAdvertisement implAdvertisement = null;
    EndpointService endpoint = null;
    PSEMembershipService membership = null;
    private membershipPCL membershipListener = null;
    X509Certificate[] serviceCert = null;
    PSECredential credential = null;
    private credentialPCL credentialListener = null;
    EndpointAddress localPeerAddr = null;
    EndpointAddress localTlsPeerAddr = null;
    PeerID localPeerId = null;
    long MIN_IDLE_RECONNECT = 60000L;
    long CONNECTION_IDLE_TIMEOUT = 300000L;
    long RETRMAXAGE = 120000L;
    private TlsManager manager = null;
    ThreadGroup myThreadGroup = null;

    public TlsTransport() {
        try {
            long override_long;
            String override_str;
            ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.user");
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.idletimeout");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.CONNECTION_IDLE_TIMEOUT = override_long * 60000L;
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.info("Adjusting TLS connection idle timeout to " + this.CONNECTION_IDLE_TIMEOUT + " millis.");
                    }
                }
            }
            catch (NumberFormatException badvalue) {
                // empty catch block
            }
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.minidlereconnect");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.MIN_IDLE_RECONNECT = override_long * 60000L;
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.info("Adjusting TLS min reconnection idle to " + this.MIN_IDLE_RECONNECT + " millis.");
                    }
                }
            }
            catch (NumberFormatException badvalue) {
                // empty catch block
            }
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.maxretryage");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.RETRMAXAGE = override_long * 60000L;
                    if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                        LOG.info("Adjusting TLS maximum retry queue age to " + this.RETRMAXAGE + " millis.");
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.MIN_IDLE_RECONNECT = Math.min(this.MIN_IDLE_RECONNECT, this.CONNECTION_IDLE_TIMEOUT);
            this.RETRMAXAGE = Math.min(this.RETRMAXAGE, this.CONNECTION_IDLE_TIMEOUT);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (null == target) {
            return false;
        }
        if (target instanceof TlsTransport) {
            TlsTransport likeMe = (TlsTransport)target;
            if (!this.getProtocolName().equals(likeMe.getProtocolName())) {
                return false;
            }
            return this.localTlsPeerAddr.equals(likeMe.localTlsPeerAddr);
        }
        return false;
    }

    PeerGroup getPeerGroup() {
        return this.group;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = group;
        this.assignedID = assignedID;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.localPeerId = group.getPeerID();
        this.localPeerAddr = TlsTransport.mkAddress(group.getPeerID(), null, null);
        this.localTlsPeerAddr = new EndpointAddress(JTlsDefs.tlsPName, this.localPeerId.getUniqueValue().toString(), null, null);
        this.myThreadGroup = new ThreadGroup(group.getHomeThreadGroup(), "TLSTransport " + this.localTlsPeerAddr);
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring TLS Transport : " + assignedID);
            if (null != this.implAdvertisement) {
                configInfo.append("\n\tImplementation:");
                configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tProtocol: " + JTlsDefs.tlsPName);
            configInfo.append("\n\t\tOutgoing Connections Enabled: " + Boolean.TRUE);
            configInfo.append("\n\t\tIncoming Connections Enabled: true");
            configInfo.append("\n\t\tMinimum idle for reconnect : " + this.MIN_IDLE_RECONNECT + "ms");
            configInfo.append("\n\t\tConnection idle timeout : " + this.CONNECTION_IDLE_TIMEOUT + "ms");
            configInfo.append("\n\t\tRetry queue maximum age : " + this.RETRMAXAGE + "ms");
            configInfo.append("\n\t\tPeerID : " + this.localPeerId);
            configInfo.append("\n\t\tRoute through : " + this.localPeerAddr);
            configInfo.append("\n\t\tPublic Address : " + this.localTlsPeerAddr);
            LOG.config(configInfo.toString());
        }
    }

    public synchronized int startApp(String[] args) {
        this.endpoint = this.group.getEndpointService();
        if (null == this.endpoint) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        MembershipService groupMembership = this.group.getMembershipService();
        if (null == groupMembership) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is a membership service");
            }
            return 2;
        }
        if (!(groupMembership instanceof PSEMembershipService)) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("TLS Transport requires PSE Membership Service");
            }
            return -1;
        }
        if (this.endpoint.addMessageTransport(this) == null) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Transport registration refused");
            }
            return -1;
        }
        this.membership = (PSEMembershipService)groupMembership;
        membershipPCL mpcl = new membershipPCL();
        this.membership.addPropertyChangeListener(mpcl);
        try {
            this.serviceCert = this.membership.getPSEConfig().getTrustedCertificateChain(this.assignedID);
            Enumeration<Credential> eachCred = this.membership.getCurrentCredentials();
            while (eachCred.hasMoreElements()) {
                PSECredential aCred = (PSECredential)eachCred.nextElement();
                mpcl.propertyChange(new PropertyChangeEvent(this.membership, "addCredential", null, aCred));
            }
        }
        catch (IOException failed) {
            this.serviceCert = null;
        }
        catch (KeyStoreException failed) {
            this.serviceCert = null;
        }
        this.manager = new TlsManager(this);
        try {
            this.endpoint.addIncomingMessageListener(this.manager, "TlsTransport", null);
        }
        catch (Throwable e2) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "TLS could not register listener...as good as dead", e2);
            }
            return -1;
        }
        return 0;
    }

    public synchronized void stopApp() {
        PSECredential temp;
        if (null != this.endpoint) {
            this.endpoint.removeIncomingMessageListener("TlsTransport", null);
            this.endpoint.removeMessageTransport(this);
            this.endpoint = null;
        }
        if (null != this.manager) {
            this.manager.close();
            this.manager = null;
        }
        if (null != this.membership) {
            this.membership.removePropertyChangeListener(this.membershipListener);
            this.membershipListener = null;
            this.membership = null;
        }
        if (null != (temp = this.credential)) {
            temp.removePropertyChangeListener(this.credentialListener);
            this.credentialListener = null;
            this.credential = null;
        }
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean allowsRouting() {
        return false;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    public EndpointAddress getPublicAddress() {
        return this.localTlsPeerAddr;
    }

    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    public Iterator getPublicAddresses() {
        return Collections.singletonList(this.getPublicAddress()).iterator();
    }

    public String getProtocolName() {
        return JTlsDefs.tlsPName;
    }

    public boolean ping(EndpointAddress addr) {
        return null != this.getMessenger(addr, null);
    }

    public Messenger getMessenger(EndpointAddress addr, Object hintIgnored) {
        EndpointAddress plainAddress;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("getMessenger for " + addr);
        }
        if ((plainAddress = new EndpointAddress(addr, null, null)).equals(this.localTlsPeerAddr)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("returning LoopbackMessenger");
            }
            return new TlsLoopbackMessenger(this.endpoint, plainAddress, addr, this.localPeerAddr);
        }
        EndpointAddress dstPAddr = TlsTransport.mkAddress("urn:jxta:" + addr.getProtocolAddress(), null, null);
        TlsConn conn = this.manager.getTlsConn(dstPAddr);
        if (conn == null) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Cannot get a TLS connection for " + dstPAddr);
            }
            return null;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("TlsMessanger with TlsConn DONE");
        }
        return new TlsMessenger(addr, conn, this);
    }

    void processReceivedMessage(final Message msg) {
        block3: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("processReceivedMessage starts");
            }
            msg.setMessageProperty(TlsTransport.class, this);
            try {
                ((GenericPeerGroup)this.group).getExecutor().execute(new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                TlsTransport.this.endpoint.demux(msg);
                            }
                            catch (Throwable uncaught) {
                                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block2;
                                LOG.log(Level.WARNING, "Failure demuxing an incoming message", uncaught);
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block3;
                LOG.log(Level.WARNING, "Failure demuxing an incoming message", e);
            }
        }
    }

    private static final EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURI(new URI(destPeer));
        }
        catch (URISyntaxException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return TlsTransport.mkAddress(asID, serv, parm);
    }

    private static final EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    class membershipPCL
    implements PropertyChangeListener {
        membershipPCL() {
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            X500Principal credSubjectDN;
            Exception failure;
            String evtProp = evt.getPropertyName();
            PSECredential cred = (PSECredential)evt.getNewValue();
            boolean validCertificate = true;
            if (null != TlsTransport.this.serviceCert) {
                try {
                    TlsTransport.this.serviceCert[0].checkValidity();
                }
                catch (Exception notValidException) {
                    validCertificate = false;
                }
            }
            if ("addCredential".equals(evtProp) && (null == TlsTransport.this.serviceCert || !validCertificate)) {
                failure = null;
                try {
                    X509Certificate peerCert = TlsTransport.this.membership.getPSEConfig().getTrustedCertificate(TlsTransport.this.group.getPeerID());
                    credSubjectDN = cred.getCertificate().getSubjectX500Principal();
                    X500Principal peerCertSubjectDN = peerCert.getSubjectX500Principal();
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Checking credential cert for match to peer cert\n\tcred subject=" + credSubjectDN + "\n\tpeer subject=" + peerCertSubjectDN);
                    }
                    if (peerCertSubjectDN.equals(credSubjectDN)) {
                        TlsTransport.this.serviceCert = cred.generateServiceCertificate(TlsTransport.this.assignedID);
                    }
                }
                catch (IOException failed) {
                    failure = failed;
                }
                catch (KeyStoreException failed) {
                    failure = failed;
                }
                catch (InvalidKeyException failed) {
                    failure = failed;
                }
                catch (SignatureException failed) {
                    failure = failed;
                }
                if (null != failure) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Failure building service certificate", failure);
                    }
                    return;
                }
            }
            if ("addCredential".equals(evtProp)) {
                failure = null;
                try {
                    X509Certificate credCert = cred.getCertificate();
                    credSubjectDN = credCert.getSubjectX500Principal();
                    X500Principal serviceIssuerDN = TlsTransport.this.serviceCert[0].getIssuerX500Principal();
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Checking credential cert for match to service issuer cert\n\tcred subject=" + credSubjectDN + "\n\t  svc issuer=" + serviceIssuerDN);
                    }
                    if (credSubjectDN.equals(serviceIssuerDN)) {
                        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                            LOG.info("Setting credential/certfile ");
                        }
                        TlsTransport.this.credential = cred.getServiceCredential(TlsTransport.this.assignedID);
                        if (null != TlsTransport.this.credential) {
                            TlsTransport.this.credentialListener = new credentialPCL();
                            TlsTransport.this.credential.addPropertyChangeListener(TlsTransport.this.credentialListener);
                        }
                    }
                }
                catch (IOException failed) {
                    failure = failed;
                }
                catch (PeerGroupException failed) {
                    failure = failed;
                }
                catch (InvalidKeyException failed) {
                    failure = failed;
                }
                catch (SignatureException failed) {
                    failure = failed;
                }
                if (null != failure) {
                    if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                        LOG.log(Level.SEVERE, "Failure building service credential", failure);
                    }
                    return;
                }
            }
        }
    }

    class credentialPCL
    implements PropertyChangeListener {
        credentialPCL() {
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (TlsTransport.this.credential == evt.getSource() && !TlsTransport.this.credential.isValid()) {
                if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                    LOG.info("Clearing credential/certfile ");
                }
                TlsTransport.this.credential.removePropertyChangeListener(this);
                TlsTransport.this.credential = null;
            }
        }
    }

    class TlsLoopbackMessenger
    extends LoopbackMessenger {
        TlsLoopbackMessenger(EndpointService ep, EndpointAddress src, EndpointAddress dest, EndpointAddress logicalDest) {
            super(TlsTransport.this.group, ep, src, dest, logicalDest);
        }

        public void sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
            message.setMessageProperty(TlsTransport.class, TlsTransport.this);
            super.sendMessageBImpl(message, service, serviceParam);
        }
    }
}

