/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.router.BadRoute;
import net.jxta.impl.endpoint.router.Destinations;
import net.jxta.impl.endpoint.router.EndpointRouterMessage;
import net.jxta.impl.endpoint.router.RouteCM;
import net.jxta.impl.endpoint.router.RouteControl;
import net.jxta.impl.endpoint.router.RouteResolver;
import net.jxta.impl.endpoint.router.RouterMessenger;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRouter
implements EndpointListener,
MessageReceiver,
MessageSender,
MessengerEventListener,
Module {
    private static final transient Logger LOG = Logger.getLogger(EndpointRouter.class.getName());
    private static final String ROUTER_PROTOCOL_NAME = "jxta";
    private static final String ROUTER_SERVICE_NAME = "EndpointRouter";
    public static final long ASYNC_MESSENGER_WAIT = 3000L;
    public static final Integer GET_ROUTE_CONTROL = 0;
    public static final int RouteControlOp = 0;
    private static final long MAX_FINDROUTE_TIMEOUT = 60000L;
    private static final long MAX_ASYNC_GETMESSENGER_RETRY = 30000L;
    private final Map<ID, RouteAdvertisement> routedRoutes = new HashMap<ID, RouteAdvertisement>(16);
    private final Map<PeerID, Long> triedAndFailed = new HashMap<PeerID, Long>();
    private EndpointAddress localPeerAddr = null;
    private PeerID localPeerId = null;
    private EndpointService endpoint = null;
    private PeerGroup group = null;
    private ID assignedID = null;
    private boolean stopped = false;
    private final Set<EndpointAddress> newDestinations = Collections.synchronizedSet(new HashSet());
    private Destinations destinations;
    private final Map<EndpointAddress, BadRoute> badRoutes = new HashMap<EndpointAddress, BadRoute>();
    private final Map<PeerID, ClearPendingQuery> pendingQueries = Collections.synchronizedMap(new HashMap());
    private final Timer timer = new Timer("EndpointRouter Timer", true);
    private PeerAdvertisement lastPeerAdv = null;
    private int lastModCount = -1;
    private RouteAdvertisement localRoute = null;
    private RouteCM routeCM = null;
    private RouteResolver routeResolver;

    RouteAdvertisement getMyLocalRoute() {
        block7: {
            PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
            int newModCount = newPadv.getModCount();
            if (this.lastPeerAdv == newPadv && this.lastModCount == newModCount && null != this.localRoute) {
                return this.localRoute;
            }
            this.lastPeerAdv = newPadv;
            this.lastModCount = newModCount;
            XMLElement endpParam = (XMLElement)((Object)newPadv.getServiceParam(PeerGroup.endpointClassID));
            if (endpParam == null) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.severe("no Endpoint SVC Params");
                }
                return this.localRoute;
            }
            Enumeration paramChilds = endpParam.getChildren(RouteAdvertisement.getAdvertisementType());
            if (!paramChilds.hasMoreElements()) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.severe("no Endpoint Route Adv");
                }
                return this.localRoute;
            }
            XMLElement param = (XMLElement)paramChilds.nextElement();
            try {
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(param);
                route.setDestPeerID(this.localPeerId);
                this.localRoute = route;
            }
            catch (Exception ex) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block7;
                LOG.log(Level.WARNING, "Failure extracting route", ex);
            }
        }
        return this.localRoute;
    }

    boolean isLocalRoute(EndpointAddress peerAddress) {
        return this.destinations.isCurrentlyReachable(peerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Messenger ensureLocalRoute(EndpointAddress peerAddress, RouteAdvertisement hint) {
        Messenger messenger = this.destinations.getCurrentMessenger(peerAddress);
        if (messenger != null) {
            return messenger;
        }
        messenger = this.findReachableEndpoint(peerAddress, false, hint);
        if (messenger == null) {
            this.destinations.noOutgoingMessenger(peerAddress);
            return null;
        }
        this.destinations.addOutgoingMessenger(peerAddress, messenger);
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            this.notifyAll();
        }
        return messenger;
    }

    void sendOnLocalRoute(EndpointAddress destination, Message message) throws IOException {
        Messenger sendVia;
        IOException lastIoe = null;
        while ((sendVia = this.ensureLocalRoute(destination, null)) != null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sending " + message + " to " + destination + " via " + sendVia);
            }
            try {
                sendVia.sendMessageB(message, ROUTER_SERVICE_NAME, null);
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Sent " + message + " to " + destination);
                }
                return;
            }
            catch (IOException ioe) {
                lastIoe = ioe;
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Trying next messenger to " + destination);
            }
        }
        if (lastIoe == null) {
            lastIoe = new IOException("No reachable endpoints for " + destination);
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Could not send to " + destination, lastIoe);
        }
        throw lastIoe;
    }

    @Override
    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.timer.schedule((TimerTask)new TimerThreadNamer("EndpointRouter Timer for " + group.getPeerGroupID()), 0L);
        this.group = group;
        this.assignedID = assignedID;
        ModuleImplAdvertisement implAdvertisement = (ModuleImplAdvertisement)impl;
        this.localPeerId = group.getPeerID();
        this.localPeerAddr = EndpointRouter.pid2addr(group.getPeerID());
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Router Transport : " + assignedID);
            if (implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ").append(implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tProtocol : ").append(this.getProtocolName());
            configInfo.append("\n\t\tPublic Address : ").append(this.localPeerAddr);
            LOG.config(configInfo.toString());
        }
    }

    @Override
    public synchronized int startApp(String[] arg) {
        this.endpoint = this.group.getEndpointService();
        if (null == this.endpoint) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Stalled until there is an endpoint service");
            }
            return 2;
        }
        Service needed = this.group.getResolverService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Endpoint Router start stalled until resolver service available");
            }
            return 2;
        }
        needed = this.group.getMembershipService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Endpoint Router start stalled until membership service available");
            }
            return 2;
        }
        needed = this.group.getRendezVousService();
        if (null == needed) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Endpoint Router start stalled until rendezvous service available");
            }
            return 2;
        }
        this.destinations = new Destinations(this.endpoint);
        try {
            this.routeCM = new RouteCM();
            this.routeResolver = new RouteResolver(this);
            this.routeCM.init(this.group, this.assignedID, null);
            this.routeResolver.init(this.group, this.assignedID, null);
        }
        catch (PeerGroupException failure) {
            return -1;
        }
        int status = this.routeCM.startApp(arg);
        if (status != 0) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Route CM failed to start : " + status);
            }
            return status;
        }
        status = this.routeResolver.startApp(arg);
        if (status != 0) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Route Resolver failed to start : " + status);
            }
            return status;
        }
        this.routeCM.publishRoute(this.getMyLocalRoute());
        this.endpoint.addMessengerEventListener(this, 1);
        this.endpoint.addIncomingMessageListener(this, ROUTER_SERVICE_NAME, null);
        if (this.endpoint.addMessageTransport(this) == null) {
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Transport registration refused");
            }
            return -1;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info(this.group + " : Router Message Transport started.");
        }
        return status;
    }

    @Override
    public synchronized void stopApp() {
        this.stopped = true;
        if (this.endpoint != null) {
            this.endpoint.removeIncomingMessageListener(ROUTER_SERVICE_NAME, null);
            this.endpoint.removeMessengerEventListener(this, 1);
            this.endpoint.removeMessageTransport(this);
        }
        this.routeCM.stopApp();
        this.routeResolver.stopApp();
        this.destinations.close();
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info(this.group + " : Router Message Transport stopped.");
        }
    }

    @Override
    public boolean isConnectionOriented() {
        return false;
    }

    @Override
    public boolean allowsRouting() {
        return false;
    }

    @Override
    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    @Override
    public EndpointAddress getPublicAddress() {
        return this.localPeerAddr;
    }

    @Override
    public Iterator<EndpointAddress> getPublicAddresses() {
        return Collections.singletonList(this.getPublicAddress()).iterator();
    }

    @Override
    public String getProtocolName() {
        return ROUTER_PROTOCOL_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EndpointAddress getGatewayAddress(EndpointAddress peerAddress, boolean seekRoute, RouteAdvertisement hint) {
        PeerID peerID = EndpointRouter.addr2pid(peerAddress);
        try {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Searching local" + (seekRoute ? " & remote" : "") + " for route for " + peerAddress);
            }
            long quitAt = TimeUtils.toAbsoluteTimeMillis(60000L);
            long findRouteAt = TimeUtils.toAbsoluteTimeMillis(3000L);
            while (TimeUtils.toRelativeTimeMillis(quitAt) > 0L) {
                Messenger directMessenger = this.ensureLocalRoute(peerAddress, hint);
                if (null != directMessenger) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Found direct route for " + peerAddress + " via " + directMessenger.getDestinationAddress());
                    }
                    return peerAddress;
                }
                RouteAdvertisement route = hint != null ? hint : this.getRoute(peerAddress, seekRoute);
                if (route != null && route.size() > 0) {
                    EndpointAddress addr = EndpointRouter.pid2addr(route.getLastHop().getPeerID());
                    if (this.ensureLocalRoute(addr, null) != null) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Found last hop remote address: " + peerAddress + " -> " + route.getLastHop().getPeerID());
                        }
                        return addr;
                    }
                    addr = EndpointRouter.pid2addr(route.getFirstHop().getPeerID());
                    if (this.ensureLocalRoute(addr, null) != null) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Found first hop remote address first hop: " + peerAddress + " -> " + route.getFirstHop().getPeerID());
                        }
                        return addr;
                    }
                    this.removeRoute(peerID);
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Found no reachable route to " + peerAddress);
                    }
                }
                if (!seekRoute || !this.routeResolver.useRouteResolver()) break;
                Long nextTry = this.triedAndFailed.get(peerID);
                if (nextTry == null || nextTry < TimeUtils.toAbsoluteTimeMillis(30000L) || TimeUtils.toRelativeTimeMillis(findRouteAt) <= 0L) {
                    boolean doFind = false;
                    Map<PeerID, ClearPendingQuery> map = this.pendingQueries;
                    synchronized (map) {
                        ClearPendingQuery t = this.pendingQueries.get(peerID);
                        if (t == null) {
                            doFind = true;
                            t = new ClearPendingQuery(peerID);
                            this.pendingQueries.put(peerID, t);
                        } else {
                            if (t.isFailed()) {
                                break;
                            }
                            if (t.isTimeToResolveRoute()) {
                                doFind = true;
                            }
                        }
                    }
                    if (doFind) {
                        this.routeResolver.findRoute(peerAddress);
                        seekRoute = false;
                    }
                }
                EndpointRouter endpointRouter = this;
                synchronized (endpointRouter) {
                    try {
                        if (this.destinations.getCurrentMessenger(peerAddress) == null) {
                            this.wait(3000L);
                        }
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                }
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("No route to " + peerAddress);
            }
            return null;
        }
        catch (Exception ex) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "getGatewayAddress exception", ex);
            }
            return null;
        }
    }

    @Override
    @Deprecated
    public boolean ping(EndpointAddress addr) {
        EndpointAddress plainAddr = new EndpointAddress(addr, null, null);
        try {
            return this.getGatewayAddress(plainAddr, true, null) != null;
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.FINE, "Ping failure (exception) for : " + plainAddr, e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean messengerReady(MessengerEvent event) {
        Messenger messenger = event.getMessenger();
        Object source = event.getSource();
        EndpointAddress logDest = messenger.getLogicalDestinationAddress();
        if (source instanceof MessageSender && !((MessageSender)source).allowsRouting()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Ignoring messenger to :" + logDest);
            }
            return false;
        }
        boolean taken = this.destinations.addIncomingMessenger(logDest, messenger);
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            this.notifyAll();
        }
        return taken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noMessenger(EndpointAddress logDest) {
        PeerID peerID = EndpointRouter.addr2pid(logDest);
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            Long curr = this.triedAndFailed.get(peerID);
            if (curr != null && curr > TimeUtils.toAbsoluteTimeMillis(30000L)) {
                this.triedAndFailed.put(peerID, TimeUtils.toAbsoluteTimeMillis(30000L));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean newMessenger(MessengerEvent event) {
        Messenger messenger = event.getMessenger();
        EndpointAddress logDest = messenger.getLogicalDestinationAddress();
        this.destinations.addOutgoingMessenger(logDest, messenger);
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            this.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RouteAdvertisement getRoute(EndpointAddress peerAddress, boolean seekRoute) {
        RouteAdvertisement route;
        PeerID peerID = EndpointRouter.addr2pid(peerAddress);
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            route = this.routedRoutes.get(peerID);
        }
        if (route != null || !seekRoute) {
            return route;
        }
        Iterator<RouteAdvertisement> allRadvs = this.routeCM.getRouteAdv(peerID);
        block3: while (allRadvs.hasNext()) {
            PeerID hopID;
            route = allRadvs.next();
            Vector<AccessPointAdvertisement> hops = route.getVectorHops();
            if (hops.isEmpty()) continue;
            RouteAdvertisement newRoute = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            newRoute.setDest(route.getDest().clone());
            Vector<AccessPointAdvertisement> newHops = new Vector<AccessPointAdvertisement>();
            for (int i = hops.size() - 1; i >= 0 && !this.localPeerId.equals(hopID = hops.elementAt(i).getPeerID()); --i) {
                EndpointAddress addr = EndpointRouter.pid2addr(hopID);
                if (this.ensureLocalRoute(addr, null) == null) continue;
                for (int j = i; j <= hops.size() - 1; ++j) {
                    newHops.add(hops.elementAt(j).clone());
                }
                if (newHops.isEmpty()) continue block3;
                newRoute.setHops(newHops);
                if (!this.setRoute(newRoute, false)) continue block3;
                return newRoute;
            }
        }
        return null;
    }

    private boolean checkRoute(RouteAdvertisement routeAdvertisement) {
        if (0 == routeAdvertisement.size()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("route is empty");
            }
            return false;
        }
        if (routeAdvertisement.containsHop(this.localPeerId)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("route contains this peer - loopback");
            }
            return false;
        }
        PeerID destPid = routeAdvertisement.getDest().getPeerID();
        if (routeAdvertisement.containsHop(destPid)) {
            Vector<AccessPointAdvertisement> hops = routeAdvertisement.getVectorHops();
            hops.remove(hops.lastElement());
            if (routeAdvertisement.containsHop(destPid)) {
                return false;
            }
        }
        if (routeAdvertisement.hasALoop()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("route has a loop ");
            }
            return false;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("route is ok");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setRoute(RouteAdvertisement route, boolean force) {
        boolean status;
        PeerID peerID;
        boolean pushNeeded = false;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("setRoute:");
        }
        if (route == null) {
            return false;
        }
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            EndpointAddress peerAddress;
            try {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine(route.display());
                }
                peerID = route.getDest().getPeerID();
                peerAddress = EndpointRouter.pid2addr(peerID);
                if (!force) {
                    BadRoute badRoute = this.badRoutes.get(peerAddress);
                    if (badRoute != null) {
                        Long nextTry = badRoute.getExpiration();
                        if (nextTry > System.currentTimeMillis()) {
                            RouteAdvertisement routeClean = route.cloneOnlyPIDs();
                            if (routeClean.equals(badRoute.getRoute())) {
                                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("try to use a known bad route");
                                }
                                return false;
                            }
                        } else {
                            this.badRoutes.remove(peerAddress);
                        }
                    }
                } else {
                    this.badRoutes.remove(peerAddress);
                }
                if (!this.checkRoute(route)) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Route is invalid");
                    }
                    return false;
                }
                if (!this.isLocalRoute(EndpointRouter.pid2addr(route.getFirstHop().getPeerID()))) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Unreachable route - ignore");
                    }
                    return false;
                }
            }
            catch (Exception ez1) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Got an empty route - discard" + route.display());
                }
                return false;
            }
            try {
                if (this.group.isRendezvous() && !this.routedRoutes.containsKey(peerID)) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("push new SRDI route " + peerID);
                    }
                    pushNeeded = true;
                }
                if (!this.routedRoutes.containsKey(peerID)) {
                    this.routeCM.createRoute(route);
                    this.newDestinations.add(peerAddress);
                }
                RouteAdvertisement newRoute = route.cloneOnlyPIDs();
                this.routedRoutes.put(peerID, newRoute);
                this.badRoutes.remove(peerAddress);
                this.notifyAll();
                status = true;
            }
            catch (Exception e2) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("   failed setting route with " + e2);
                }
                status = false;
            }
        }
        if (pushNeeded && status) {
            this.routeResolver.pushSrdi(null, peerID);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRoute(PeerID peerID) {
        boolean needRemove;
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            needRemove = false;
            if (this.routedRoutes.containsKey(peerID)) {
                if (this.group.isRendezvous()) {
                    needRemove = true;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("remove SRDI route " + peerID);
                    }
                }
                this.routedRoutes.remove(peerID);
            }
        }
        if (needRemove) {
            this.routeResolver.removeSrdi(null, peerID);
        }
    }

    @Override
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        RouteAdvertisement radv;
        EndpointAddress destPeer;
        EndpointAddress srcPeerAddress;
        EndpointAddress origDstAddr;
        EndpointAddress origSrcAddr;
        EndpointAddress lastHop = null;
        boolean connectLastHop = false;
        Vector<AccessPointAdvertisement> origHops = null;
        EndpointAddress nextHop = null;
        EndpointRouterMessage routerMsg = new EndpointRouterMessage(msg, false);
        if (!routerMsg.msgExists()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Discarding " + msg + ". No routing info.");
            }
            return;
        }
        try {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine(routerMsg.display());
            }
            origSrcAddr = routerMsg.getSrcAddress();
            origDstAddr = routerMsg.getDestAddress();
            srcPeerAddress = new EndpointAddress(origSrcAddr, null, null);
            destPeer = new EndpointAddress(origDstAddr, null, null);
            lastHop = routerMsg.getLastHop();
            radv = routerMsg.getRouteAdv();
            if (radv != null) {
                if (EndpointRouter.pid2addr(radv.getDestPeerID()).equals(lastHop)) {
                    connectLastHop = true;
                }
                this.setRoute(radv, true);
                this.updateRouteAdv(radv);
            }
        }
        catch (Exception badHdr) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Bad routing header or bad message. Dropping " + msg);
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Exception: ", badHdr);
            }
            return;
        }
        if (srcPeerAddress != null && srcPeerAddress.equals(this.localPeerAddr)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("dropped loopback");
            }
            return;
        }
        if (lastHop != null && lastHop.equals(this.localPeerAddr)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("dropped loopback from impersonating Peer");
            }
            return;
        }
        if (connectLastHop) {
            this.ensureLocalRoute(lastHop, radv);
        }
        try {
            Vector<AccessPointAdvertisement> reverseHops = routerMsg.getReverseHops();
            if (reverseHops == null) {
                reverseHops = new Vector();
            }
            if (!this.isLocalRoute(srcPeerAddress) && lastHop != null && reverseHops.size() > 0 && reverseHops.firstElement().getPeerID().equals(EndpointRouter.addr2pid(lastHop))) {
                this.setRoute(RouteAdvertisement.newRoute(EndpointRouter.addr2pid(srcPeerAddress), null, (Vector)reverseHops.clone()), true);
            }
            if (destPeer.equals(this.localPeerAddr)) {
                routerMsg.clearAll();
                routerMsg.updateMessage();
                this.endpoint.processIncomingMessage(msg, origSrcAddr, origDstAddr);
                return;
            }
            AccessPointAdvertisement selfAp = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            selfAp.setPeerID(this.localPeerId);
            if (reverseHops.contains(selfAp)) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Routing loop detected. Message dropped");
                }
                this.removeRoute(EndpointRouter.addr2pid(destPeer));
                return;
            }
            if (this.isLocalRoute(lastHop)) {
                reverseHops.add(0, selfAp);
                routerMsg.prependReverseHop(selfAp);
            } else {
                RouteAdvertisement newReverseRoute = this.routedRoutes.get(EndpointRouter.addr2pid(srcPeerAddress));
                if (newReverseRoute != null) {
                    reverseHops = (Vector)newReverseRoute.getVectorHops().clone();
                    reverseHops.add(0, selfAp);
                } else {
                    reverseHops = null;
                }
                routerMsg.setReverseHops(reverseHops);
            }
            origHops = routerMsg.getForwardHops();
            if (origHops != null) {
                nextHop = this.getNextHop(origHops);
            }
            if (this.isLocalRoute(destPeer)) {
                routerMsg.setForwardHops(null);
                nextHop = destPeer;
            } else {
                if (nextHop == null) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("No next hop in forward route - Using destination as next hop");
                    }
                    nextHop = destPeer;
                    routerMsg.setForwardHops(null);
                }
                if (this.ensureLocalRoute(nextHop, null) == null) {
                    RouteAdvertisement route;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Forward route element broken - trying alternate route");
                    }
                    if ((route = this.getRoute(destPeer, false)) == null) {
                        this.cantRoute("No new route to repair the route - drop message", null, origSrcAddr, destPeer, origHops);
                        return;
                    }
                    if (EndpointRouter.pid2addr(route.getFirstHop().getPeerID()).equals(nextHop)) {
                        this.removeRoute(EndpointRouter.addr2pid(destPeer));
                        this.cantRoute("No better route to repair the route - drop message", null, origSrcAddr, destPeer, origHops);
                        return;
                    }
                    EndpointAddress addr = EndpointRouter.pid2addr(route.getLastHop().getPeerID());
                    if (this.isLocalRoute(addr)) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Found new remote route via : " + addr);
                        }
                        routerMsg.setForwardHops(null);
                    } else {
                        Vector newHops = (Vector)route.getVectorHops().clone();
                        addr = EndpointRouter.pid2addr(((AccessPointAdvertisement)newHops.remove(0)).getPeerID());
                        if (!this.isLocalRoute(addr)) {
                            this.removeRoute(EndpointRouter.addr2pid(destPeer));
                            this.cantRoute("No usable route to repair the route - drop message", null, origSrcAddr, destPeer, origHops);
                            return;
                        }
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Found new remote route via : " + addr);
                        }
                        routerMsg.setForwardHops(newHops);
                    }
                    nextHop = addr;
                }
            }
            RouteAdvertisement myRoute = this.getMyLocalRoute();
            if (myRoute != null && this.destinations.isWelcomeNeeded(nextHop)) {
                routerMsg.setRouteAdv(myRoute);
            }
            routerMsg.setLastHop(this.localPeerAddr);
            routerMsg.updateMessage();
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Trying to forward to " + nextHop);
            }
            this.sendOnLocalRoute(nextHop, msg);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Successfully forwarded to " + nextHop);
            }
        }
        catch (Exception e) {
            this.cantRoute("Failed to deliver or forward message for " + destPeer, e, origSrcAddr, destPeer, origHops);
        }
    }

    private void cantRoute(String logMsg, Exception exception, EndpointAddress origSrcAddr, EndpointAddress destPeer, Vector origHops) {
        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            if (exception == null) {
                LOG.warning(logMsg);
            } else {
                LOG.log(Level.WARNING, logMsg, exception);
            }
        }
        this.routeResolver.generateNACKRoute(EndpointRouter.addr2pid(origSrcAddr), EndpointRouter.addr2pid(destPeer), origHops);
    }

    private EndpointAddress getNextHop(Vector hops) {
        if (hops == null || hops.size() == 0) {
            return null;
        }
        Enumeration e = hops.elements();
        while (e.hasMoreElements()) {
            AccessPointAdvertisement ap = (AccessPointAdvertisement)e.nextElement();
            if (!this.localPeerId.equals(ap.getPeerID())) continue;
            if (!e.hasMoreElements()) {
                return null;
            }
            return EndpointRouter.pid2addr(((AccessPointAdvertisement)e.nextElement()).getPeerID());
        }
        return EndpointRouter.pid2addr(((AccessPointAdvertisement)hops.elementAt(0)).getPeerID());
    }

    private boolean isFast(MessageTransport p) {
        String name = p.getProtocolName();
        return name.equals("tcp") || name.equals("beep");
    }

    private boolean isRelay(MessageTransport p) {
        String name = p.getProtocolName();
        return name.equals("relay");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Messenger findBestReachableEndpoint(EndpointAddress dest, List<EndpointAddress> mightWork, boolean exist) {
        ArrayList<Integer> rankings = new ArrayList<Integer>(mightWork.size());
        ArrayList<EndpointAddress> worthTrying = new ArrayList<EndpointAddress>(mightWork.size());
        Iterator<EndpointAddress> i$ = mightWork.iterator();
        block8: while (i$.hasNext()) {
            EndpointAddress aMightWork;
            EndpointAddress addr = aMightWork = i$.next();
            if (this.getProtocolName().equals(addr.getProtocolName())) continue;
            int rank = -1;
            Iterator<MessageTransport> eachTransport = this.endpoint.getAllMessageTransports();
            while (eachTransport.hasNext()) {
                MessageSender sender;
                MessageTransport transpt = eachTransport.next();
                if (!transpt.getProtocolName().equals(addr.getProtocolName()) || !(transpt instanceof MessageSender) || !(sender = (MessageSender)transpt).allowsRouting()) continue;
                ++rank;
                if (sender.isConnectionOriented()) {
                    rank += 2;
                }
                if (this.isRelay(transpt) && exist) {
                    rank -= 1000;
                }
                if (!this.isFast(transpt)) continue;
                rank += 4;
            }
            if (rank < 0) continue;
            for (int eachCurrent = 0; eachCurrent <= rankings.size(); ++eachCurrent) {
                if (rankings.size() == eachCurrent) {
                    rankings.add(rank);
                    worthTrying.add(addr);
                    continue block8;
                }
                if (rank <= (Integer)rankings.get(eachCurrent)) continue;
                rankings.add(eachCurrent, rank);
                worthTrying.add(eachCurrent, addr);
                continue block8;
            }
        }
        rankings = null;
        for (EndpointAddress addr : worthTrying) {
            try {
                EndpointGetMessengerAsyncListener getMessengerListener;
                boolean stat;
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Trying : " + addr);
                }
                if (!(stat = this.endpoint.getMessenger(getMessengerListener = new EndpointGetMessengerAsyncListener(this, dest), new EndpointAddress(addr, ROUTER_SERVICE_NAME, null), null))) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Failed to create async messenger to : " + addr);
                    }
                    EndpointRouter eachTransport = this;
                    synchronized (eachTransport) {
                        this.triedAndFailed.put(EndpointRouter.addr2pid(dest), TimeUtils.toAbsoluteTimeMillis(30000L));
                        continue;
                    }
                }
                boolean quick = this.getRoute(dest, false) != null;
                Messenger messenger = getMessengerListener.waitForMessenger(quick);
                if (messenger == null) {
                    if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("did not get our async messenger. continue");
                    continue;
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("we got our async messenger, proceed");
                }
                EndpointRouter endpointRouter = this;
                synchronized (endpointRouter) {
                    this.triedAndFailed.remove(EndpointRouter.addr2pid(dest));
                    this.notifyAll();
                }
                return messenger;
            }
            catch (RuntimeException e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "failed checking route", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Messenger findReachableEndpoint(EndpointAddress destPeerAddress, boolean exist, RouteAdvertisement hint) {
        PeerID destPeerID;
        block20: {
            destPeerID = EndpointRouter.addr2pid(destPeerAddress);
            EndpointRouter endpointRouter = this;
            synchronized (endpointRouter) {
                Long nextTry = this.triedAndFailed.get(destPeerID);
                if (nextTry != null && nextTry > TimeUtils.timeNow()) {
                    return null;
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Temporarly adding " + destPeerAddress.toString() + " to triedAndFailed, while attempting connection");
                }
                this.triedAndFailed.put(destPeerID, TimeUtils.toAbsoluteTimeMillis(Long.MAX_VALUE));
            }
            try {
                Iterator<RouteAdvertisement> advs = hint != null ? Collections.singletonList(hint).iterator() : this.routeCM.getRouteAdv(destPeerID);
                ArrayList<EndpointAddress> addrs = new ArrayList<EndpointAddress>();
                while (advs.hasNext()) {
                    RouteAdvertisement adv = advs.next();
                    String saddr = null;
                    Enumeration<String> e = adv.getDest().getEndpointAddresses();
                    while (e.hasMoreElements()) {
                        try {
                            saddr = e.nextElement();
                            addrs.add(new EndpointAddress(saddr));
                        }
                        catch (Throwable ex) {
                            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine(" bad address in route adv : " + saddr);
                        }
                    }
                }
                if (!addrs.isEmpty()) {
                    Messenger bestMessenger = this.findBestReachableEndpoint(destPeerAddress, addrs, exist);
                    if (bestMessenger != null) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("found direct route");
                        }
                        return bestMessenger;
                    }
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("findReachableEndpoint : Failed due to empty address list");
                }
            }
            catch (RuntimeException e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block20;
                LOG.log(Level.WARNING, "Failure looking for an address ", e);
            }
        }
        EndpointRouter endpointRouter = this;
        synchronized (endpointRouter) {
            this.triedAndFailed.put(destPeerID, TimeUtils.toAbsoluteTimeMillis(30000L));
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("did not find a direct route to :" + destPeerAddress);
        }
        return null;
    }

    @Override
    public Messenger getMessenger(EndpointAddress addr, Object hint) {
        RouteAdvertisement routeHint = null;
        EndpointAddress plainAddr = new EndpointAddress(addr, null, null);
        if (plainAddr.equals(this.localPeerAddr)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("return LoopbackMessenger");
            }
            return new LoopbackMessenger(this.group, this.endpoint, this.localPeerAddr, addr, addr);
        }
        try {
            if (hint != null && hint instanceof RouteAdvertisement) {
                routeHint = ((RouteAdvertisement)hint).clone();
                AccessPointAdvertisement firstHop = routeHint.getFirstHop();
                EndpointAddress firstHopAddr = null;
                if (firstHop != null) {
                    PeerID firstHopPid = firstHop.getPeerID();
                    firstHopAddr = EndpointRouter.pid2addr(firstHopPid);
                    if (firstHopAddr.equals(addr)) {
                        routeHint.removeHop(firstHopPid);
                        firstHop = null;
                    } else if (firstHopPid.equals(this.localPeerId)) {
                        firstHop = null;
                    }
                }
                if (firstHop == null) {
                    EndpointAddress da = EndpointRouter.pid2addr(routeHint.getDestPeerID());
                    if (!this.isLocalRoute(da) && !this.routedRoutes.containsKey(routeHint.getDestPeerID())) {
                        this.routeCM.publishRoute(routeHint);
                    }
                } else {
                    RouteAdvertisement routeFirstHop = null;
                    if (!this.isLocalRoute(firstHopAddr) && !this.routedRoutes.containsKey(firstHop.getPeerID())) {
                        routeFirstHop = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                        routeFirstHop.setDest(firstHop.clone());
                        this.updateRouteAdv(routeFirstHop);
                    }
                    if (this.ensureLocalRoute(firstHopAddr, routeFirstHop) != null) {
                        this.setRoute(routeHint.clone(), false);
                    }
                }
            }
        }
        catch (Throwable ioe) {
            return null;
        }
        try {
            return new RouterMessenger(addr, this, routeHint);
        }
        catch (IOException caught) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Can't generate messenger for addr " + addr, caught);
            }
            return null;
        }
    }

    EndpointAddress addressMessage(Message message, EndpointAddress dstAddress) {
        EndpointAddress theGatewayAddress;
        EndpointRouterMessage routerMsg;
        if (this.endpoint == null) {
            return null;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Create a new EndpointRouterMessage " + dstAddress);
        }
        if ((routerMsg = new EndpointRouterMessage(message, true)).isDirty()) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Probable transport recursion");
            }
            throw new IllegalStateException("RouterMessage element already present");
        }
        routerMsg.setSrcAddress(this.localPeerAddr);
        routerMsg.setDestAddress(dstAddress);
        EndpointAddress dstAddressPlain = new EndpointAddress(dstAddress, null, null);
        try {
            RouteAdvertisement route = null;
            theGatewayAddress = this.getGatewayAddress(dstAddressPlain, true, null);
            if (theGatewayAddress == null) {
                routerMsg.clearAll();
                routerMsg.updateMessage();
                return null;
            }
            if (!theGatewayAddress.equals(dstAddressPlain)) {
                route = this.getRoute(dstAddressPlain, false);
            }
            if (route != null) {
                routerMsg.setForwardHops((Vector)route.getVectorHops().clone());
            }
            routerMsg.setLastHop(this.localPeerAddr);
            RouteAdvertisement myRoute = this.getMyLocalRoute();
            if (myRoute != null) {
                boolean newDest = this.newDestinations.remove(dstAddressPlain);
                boolean newGatw = this.destinations.isWelcomeNeeded(theGatewayAddress);
                if (newDest || newGatw) {
                    routerMsg.setRouteAdv(myRoute);
                }
            }
            routerMsg.updateMessage();
        }
        catch (Exception ez1) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Could not fully address message", ez1);
            }
            return null;
        }
        return theGatewayAddress;
    }

    @Override
    public Object transportControl(Object operation, Object value) {
        if (!(operation instanceof Integer)) {
            return null;
        }
        int op = (Integer)operation;
        switch (op) {
            case 0: {
                return new RouteControl(this, this.localPeerId);
            }
        }
        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Invalid Transport Control operation argument");
        }
        return null;
    }

    static PeerID addr2pid(EndpointAddress addr) {
        block4: {
            URI asURI = null;
            try {
                asURI = new URI("urn", "jxta:" + addr.getProtocolAddress(), null);
                return (PeerID)IDFactory.fromURI(asURI);
            }
            catch (URISyntaxException ex) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Error converting a source address into a virtual address : " + addr, ex);
                }
            }
            catch (ClassCastException cce) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block4;
                LOG.log(Level.WARNING, "Error converting a source address into a virtual address: " + addr, cce);
            }
        }
        return null;
    }

    static EndpointAddress pid2addr(ID pid) {
        return new EndpointAddress(ROUTER_PROTOCOL_NAME, pid.getUniqueValue().toString(), null, null);
    }

    void updateRouteAdv(RouteAdvertisement route) {
        this.updateRouteAdv(route, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRouteAdv(RouteAdvertisement route, boolean force) {
        block12: {
            try {
                PeerID pID = route.getDestPeerID();
                if (this.routeCM.updateRoute(route)) {
                    EndpointRouter endpointRouter = this;
                    synchronized (endpointRouter) {
                        Long nextTry = this.triedAndFailed.get(pID);
                        if (nextTry != null && nextTry <= TimeUtils.toAbsoluteTimeMillis(30000L)) {
                            this.triedAndFailed.remove(pID);
                            this.notifyAll();
                        }
                        break block12;
                    }
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Route for " + pID + " is same as existing route, not publishing it");
                }
                if (!force) break block12;
                EndpointRouter endpointRouter = this;
                synchronized (endpointRouter) {
                    Long nextTry = this.triedAndFailed.get(pID);
                    if (nextTry != null && nextTry <= TimeUtils.toAbsoluteTimeMillis(30000L)) {
                        this.triedAndFailed.remove(pID);
                        this.notifyAll();
                    }
                }
            }
            catch (Exception e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block12;
                LOG.log(Level.WARNING, "Failed to publish route advertisement", e);
            }
        }
    }

    boolean isPendingRouteQuery(PeerID peerID) {
        return this.pendingQueries.containsKey(peerID);
    }

    ClearPendingQuery getPendingRouteQuery(PeerID peerID) {
        return this.pendingQueries.get(peerID);
    }

    boolean isRoutedRoute(PeerID peerID) {
        return peerID != null && this.routedRoutes.containsKey(peerID);
    }

    Messenger getCachedMessenger(EndpointAddress addr) {
        return this.destinations.getCurrentMessenger(addr);
    }

    Iterator<EndpointAddress> getAllCachedMessengerDestinations() {
        return this.destinations.allDestinations().iterator();
    }

    Iterator<Map.Entry<ID, RouteAdvertisement>> getRoutedRouteAllDestinations() {
        return this.routedRoutes.entrySet().iterator();
    }

    Iterator<ID> getAllRoutedRouteAddresses() {
        return this.routedRoutes.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Map.Entry<PeerID, ClearPendingQuery>> getPendingQueriesAllDestinations() {
        ArrayList<Map.Entry<PeerID, ClearPendingQuery>> copy = new ArrayList<Map.Entry<PeerID, ClearPendingQuery>>(this.pendingQueries.size());
        Map<PeerID, ClearPendingQuery> map = this.pendingQueries;
        synchronized (map) {
            copy.addAll(this.pendingQueries.entrySet());
        }
        return copy;
    }

    RouteCM getRouteCM() {
        return this.routeCM;
    }

    RouteResolver getRouteResolver() {
        return this.routeResolver;
    }

    synchronized void setBadRoute(EndpointAddress addr, BadRoute badRoute) {
        this.badRoutes.put(addr, badRoute);
    }

    synchronized BadRoute getBadRoute(EndpointAddress addr) {
        return this.badRoutes.get(addr);
    }

    private static class EndpointGetMessengerAsyncListener
    implements MessengerEventListener {
        private final EndpointRouter router;
        private final EndpointAddress logDest;
        volatile boolean hasResponse = false;
        volatile boolean isGone = false;
        private Messenger messenger = null;

        EndpointGetMessengerAsyncListener(EndpointRouter router, EndpointAddress dest) {
            this.router = router;
            this.logDest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean messengerReady(MessengerEvent event) {
            Messenger toClose = null;
            EndpointGetMessengerAsyncListener endpointGetMessengerAsyncListener = this;
            synchronized (endpointGetMessengerAsyncListener) {
                this.hasResponse = true;
                if (event != null) {
                    this.messenger = event.getMessenger();
                    if (null != this.messenger) {
                        if (!this.logDest.equals(this.messenger.getLogicalDestinationAddress())) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("Incorrect Messenger logical destination : " + this.logDest + "!=" + this.messenger.getLogicalDestinationAddress());
                            }
                            toClose = this.messenger;
                            this.messenger = null;
                        }
                    } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                        LOG.warning("null messenger for dest :" + this.logDest);
                    }
                } else if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("null messenger event for dest :" + this.logDest);
                }
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                if (this.messenger == null) {
                    LOG.fine("error creating messenger for dest :" + this.logDest);
                } else {
                    LOG.fine("got a new messenger for dest :" + this.logDest);
                }
            }
            if (this.messenger == null) {
                if (toClose != null) {
                    toClose.close();
                }
                this.router.noMessenger(this.logDest);
                endpointGetMessengerAsyncListener = this;
                synchronized (endpointGetMessengerAsyncListener) {
                    this.notify();
                }
                return false;
            }
            endpointGetMessengerAsyncListener = this;
            synchronized (endpointGetMessengerAsyncListener) {
                if (!this.isGone) {
                    this.notify();
                    return true;
                }
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("async caller gone add the messenger " + this.logDest);
            }
            return this.router.newMessenger(event);
        }

        public synchronized Messenger waitForMessenger(boolean quick) {
            if (!quick) {
                long quitAt = TimeUtils.toAbsoluteTimeMillis(3000L);
                while (TimeUtils.toRelativeTimeMillis(quitAt) > 0L) {
                    try {
                        if (this.hasResponse) break;
                        this.wait(3000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                        break;
                    }
                }
            }
            this.isGone = true;
            return this.messenger;
        }
    }

    class ClearPendingQuery
    extends TimerTask {
        final PeerID peerID;
        volatile boolean failed = false;
        long nextRouteResolveAt = 0L;

        ClearPendingQuery(PeerID peerID) {
            this.peerID = peerID;
            EndpointRouter.this.timer.schedule((TimerTask)this, 60000L, 300000L);
            this.nextRouteResolveAt = TimeUtils.toAbsoluteTimeMillis(20000L);
        }

        public void run() {
            block4: {
                try {
                    if (this.failed) {
                        EndpointRouter.this.pendingQueries.remove(this.peerID);
                        this.cancel();
                    } else {
                        this.failed = true;
                    }
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block4;
                    LOG.log(Level.SEVERE, "Uncaught Throwable in timer task " + Thread.currentThread().getName() + " for " + this.peerID, all);
                }
            }
        }

        public synchronized boolean isTimeToResolveRoute() {
            if (TimeUtils.toRelativeTimeMillis(this.nextRouteResolveAt) > 0L) {
                return false;
            }
            this.nextRouteResolveAt = TimeUtils.toAbsoluteTimeMillis(20000L);
            return true;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

