/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.endpointMeter.InboundMeter;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class InboundMetric
implements DocumentSerializable {
    private String serviceName;
    private String serviceParameter;
    private String serviceIdString;
    private int numInboundQueued;
    private int numInboundDropped;
    private long timeToDropInbound;
    private int numInboundDeQueued;
    private long timeInInboundQueue;
    private int numInboundProcessed;
    private long timeToProcessInbound;

    public InboundMetric(InboundMeter inboundMeter) {
        this.serviceName = inboundMeter.getServiceName();
        this.serviceParameter = inboundMeter.getServiceParameter();
        this.serviceIdString = this.serviceName + this.serviceParameter;
    }

    public InboundMetric(InboundMetric prototype) {
        this.serviceName = prototype.getServiceName();
        this.serviceParameter = prototype.getServiceParameter();
        this.serviceIdString = this.serviceName + this.serviceParameter;
    }

    public InboundMetric() {
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceParameter() {
        return this.serviceParameter;
    }

    public int getNumInboundQueued() {
        return this.numInboundQueued;
    }

    public int getNumInboundDropped() {
        return this.numInboundDropped;
    }

    public long getTimeToDropInbound() {
        return this.timeToDropInbound;
    }

    public int getNumInboundDeQueued() {
        return this.numInboundDeQueued;
    }

    public long getTimeInInboundQueue() {
        return this.timeInInboundQueue;
    }

    public int getNumInboundProcessed() {
        return this.numInboundProcessed;
    }

    public long getTimeToProcessInbound() {
        return this.timeToProcessInbound;
    }

    public long getAverageTimeInInboundQueue() {
        return this.numInboundDeQueued == 0 ? 0L : this.timeInInboundQueue / (long)this.numInboundDeQueued;
    }

    public long getAverageInboundDropTime() {
        return this.numInboundDropped == 0 ? 0L : this.timeToDropInbound / (long)this.numInboundDropped;
    }

    public long getAverageInboundProcessTime() {
        return this.numInboundProcessed == 0 ? 0L : this.timeToProcessInbound / (long)this.numInboundProcessed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InboundMetric) {
            InboundMetric other = (InboundMetric)obj;
            return this.serviceIdString.equals(other.serviceIdString);
        }
        return false;
    }

    public boolean matches(String serviceName, String serviceParam) {
        if (serviceName.equals(this.getServiceName())) {
            if (serviceParam == null && this.getServiceParameter() == null) {
                return true;
            }
            if (serviceParam != null && this.getServiceParameter() != null) {
                return serviceParam.equals(this.getServiceParameter());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.serviceIdString.hashCode();
    }

    void inboundMessageQueued(Message message) {
        ++this.numInboundQueued;
    }

    void inboundMessageDropped(Message message, long time) {
        ++this.numInboundDropped;
        this.timeToDropInbound += time;
    }

    void inboundMessageDeQueued(Message message, long time) {
        ++this.numInboundDeQueued;
        this.timeInInboundQueue += time;
    }

    void inboundMessageProcessed(Message message, long time) {
        ++this.numInboundProcessed;
        this.timeToProcessInbound += time;
    }

    public void mergeMetrics(InboundMetric other) {
        this.numInboundQueued += other.numInboundQueued;
        this.numInboundDropped += other.numInboundDropped;
        this.timeToDropInbound += other.timeToDropInbound;
        this.numInboundDeQueued += other.numInboundDeQueued;
        this.timeInInboundQueue += other.timeInInboundQueue;
        this.numInboundProcessed += other.numInboundProcessed;
        this.timeToProcessInbound += other.timeToProcessInbound;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "serviceName", this.serviceName);
        DocumentSerializableUtilities.addString(element2, "serviceParam", this.serviceParameter);
        if (this.numInboundQueued != 0) {
            DocumentSerializableUtilities.addInt(element2, "numInboundQueued", this.numInboundQueued);
        }
        if (this.numInboundDropped != 0) {
            DocumentSerializableUtilities.addInt(element2, "numInboundDropped", this.numInboundDropped);
        }
        if (this.timeToDropInbound != 0L) {
            DocumentSerializableUtilities.addLong(element2, "timeToDropInbound", this.timeToDropInbound);
        }
        if (this.numInboundDeQueued != 0) {
            DocumentSerializableUtilities.addInt(element2, "numInboundDeQueued", this.numInboundDeQueued);
        }
        if (this.timeInInboundQueue != 0L) {
            DocumentSerializableUtilities.addLong(element2, "timeInInboundQueue", this.timeInInboundQueue);
        }
        if (this.numInboundProcessed != 0) {
            DocumentSerializableUtilities.addInt(element2, "numInboundProcessed", this.numInboundProcessed);
        }
        if (this.timeToProcessInbound != 0L) {
            DocumentSerializableUtilities.addLong(element2, "timeToProcessInbound", this.timeToProcessInbound);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("serviceName")) {
                this.serviceName = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("serviceParam")) {
                this.serviceParameter = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("numInboundQueued")) {
                this.numInboundQueued = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numInboundDropped")) {
                this.numInboundDropped = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("timeToDropInbound")) {
                this.timeToDropInbound = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numInboundDeQueued")) {
                this.numInboundDeQueued = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("timeInInboundQueue")) {
                this.timeInInboundQueue = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("numInboundProcessed")) {
                this.numInboundProcessed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("timeToProcessInbound")) continue;
            this.timeToProcessInbound = DocumentSerializableUtilities.getLong(childElement);
        }
        this.serviceIdString = this.serviceName + this.serviceParameter;
    }
}

