/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import net.jxta.impl.endpoint.endpointMeter.EndpointMetric;

public class EndpointMeter {
    private EndpointMetric total = new EndpointMetric();
    private EndpointMetric delta;

    public EndpointMetric getCumulativeMetrics() {
        this.total.setEndpointUpTime(System.currentTimeMillis() - this.total.getEndpointStartTime());
        return this.total;
    }

    public synchronized EndpointMetric collectMetrics() {
        if (this.delta != null) {
            this.delta.setEndpointUpTime(System.currentTimeMillis() - this.total.getEndpointStartTime());
        }
        EndpointMetric oldDelta = this.delta;
        this.delta = null;
        return oldDelta;
    }

    public void invalidIncomingMessage() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.invalidIncomingMessage();
        this.total.invalidIncomingMessage();
    }

    public void noListenerForIncomingMessage() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.noListenerForIncomingMessage();
        this.total.noListenerForIncomingMessage();
    }

    public void errorProcessingIncomingMessage() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.errorProcessingIncomingMessage();
        this.total.errorProcessingIncomingMessage();
    }

    public void noDestinationAddressForDemuxMessage() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.noDestinationAddressForDemuxMessage();
        this.total.noDestinationAddressForDemuxMessage();
    }

    public void noSourceAddressForDemuxMessage() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.noSourceAddressForDemuxMessage();
        this.total.noSourceAddressForDemuxMessage();
    }

    public void discardedLoopbackDemuxMessage() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.discardedLoopbackDemuxMessage();
        this.total.discardedLoopbackDemuxMessage();
    }

    public void incomingMessageFilteredOut() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.incomingMessageFilteredOut();
        this.total.incomingMessageFilteredOut();
    }

    public void incomingMessageSentToEndpointListener() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.incomingMessageSentToEndpointListener();
        this.total.incomingMessageSentToEndpointListener();
    }

    public void demuxMessageProcessed() {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.demuxMessageProcessed();
        this.total.demuxMessageProcessed();
    }

    private void createDeltaMetric() {
        this.delta = new EndpointMetric(this.total);
    }

    public String toString() {
        return "EndpointMeter()";
    }
}

