/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageFilterListener;
import net.jxta.endpoint.MessagePropagater;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.ThreadedMessenger;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.EndpointServiceInterface;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.endpoint.endpointMeter.EndpointMeter;
import net.jxta.impl.endpoint.endpointMeter.EndpointMeterBuildSettings;
import net.jxta.impl.endpoint.endpointMeter.EndpointServiceMonitor;
import net.jxta.impl.endpoint.endpointMeter.InboundMeter;
import net.jxta.impl.endpoint.endpointMeter.OutboundMeter;
import net.jxta.impl.endpoint.endpointMeter.PropagationMeter;
import net.jxta.impl.endpoint.relay.RelayClient;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import net.jxta.impl.meter.MonitorManager;
import net.jxta.impl.util.SequenceIterator;
import net.jxta.logging.Logging;
import net.jxta.meter.MonitorResources;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointServiceImpl
implements EndpointService,
MessengerEventListener {
    private static final Logger LOG = Logger.getLogger(EndpointServiceImpl.class.getName());
    public static final MimeMediaType DEFAULT_MESSAGE_TYPE = new MimeMediaType("application/x-jxta-msg").intern();
    public static final String ENDPOINTSERVICE_NAME = "EndpointService";
    public static final String MESSAGE_EMPTY_NS = "";
    public static final String MESSAGE_JXTA_NS = "jxta";
    public static final String MESSAGE_SOURCE_NS = "jxta";
    public static final String MESSAGE_SOURCE_NAME = "EndpointSourceAddress";
    public static final String MESSAGE_DESTINATION_NS = "jxta";
    public static final String MESSAGE_DESTINATION_NAME = "EndpointDestinationAddress";
    public static final String MESSAGE_SRCPEERHDR_NS = "jxta";
    public static final String MESSAGE_SRCPEERHDR_NAME = "EndpointHeaderSrcPeer";
    private static final int DEFAULT_MESSAGE_QUEUE_SIZE = 20;
    private static final boolean DEFAULT_USE_PARENT_ENDPOINT = true;
    EndpointServiceMonitor endpointServiceMonitor;
    private EndpointMeter endpointMeter;
    private PropagationMeter propagationMeter;
    private boolean initialized = false;
    private int vmQueueSize = 20;
    private PeerGroup group = null;
    private ID assignedID = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private String localPeerId = null;
    private boolean useParentEndpoint = true;
    private EndpointService parentEndpoint = null;
    private String myServiceName = null;
    private final Collection<MessageTransport> messageTransports = new HashSet<MessageTransport>();
    private final Collection[] passiveMessengerListeners = new Collection[]{Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList()), Collections.synchronizedList(new ArrayList())};
    private final Map<String, EndpointListener> incomingMessageListeners = new HashMap<String, EndpointListener>(16);
    private final Map<EndpointAddress, Reference<Messenger>> messengerMap = new WeakHashMap<EndpointAddress, Reference<Messenger>>(32);
    private final Map<EndpointAddress, Reference<Messenger>> directMessengerMap = new WeakHashMap<EndpointAddress, Reference<Messenger>>(32);
    private final Collection<FilterListenerAndMask> incomingFilterListeners = new ArrayList<FilterListenerAndMask>();
    private final Collection<FilterListenerAndMask> outgoingFilterListeners = new ArrayList<FilterListenerAndMask>();

    @Override
    public synchronized void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        if (this.initialized) {
            throw new PeerGroupException("Cannot initialize service more than once");
        }
        this.group = group;
        this.assignedID = assignedID;
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.localPeerId = group.getPeerID().toString();
        this.myServiceName = "EndpointService:" + group.getPeerGroupID().getUniqueValue().toString();
        ConfigParams confAdv = group.getConfigAdvertisement();
        XMLElement paramBlock = null;
        if (confAdv != null) {
            paramBlock = (XMLElement)((Object)confAdv.getServiceParam(assignedID));
        }
        if (paramBlock != null) {
            Enumeration param;
            block14: {
                param = paramBlock.getChildren("MessengerQueueSize");
                if (param.hasMoreElements()) {
                    String textQSz = ((XMLElement)param.nextElement()).getTextValue();
                    try {
                        Integer requestedSize = Integer.parseInt(textQSz.trim());
                        if (requestedSize > 0) {
                            this.vmQueueSize = requestedSize;
                        } else {
                            LOG.warning("Illegal MessengerQueueSize : " + textQSz);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block14;
                        LOG.log(Level.WARNING, "could not parse MessengerQueueSize string", e);
                    }
                }
            }
            if ((param = paramBlock.getChildren("UseParentEndpoint")).hasMoreElements()) {
                String textUPE = ((XMLElement)param.nextElement()).getTextValue();
                this.useParentEndpoint = textUPE.trim().equalsIgnoreCase("true");
            }
        }
        PeerGroup parentGroup = group.getParentGroup();
        if (this.useParentEndpoint && parentGroup != null) {
            this.parentEndpoint = parentGroup.getEndpointService();
            this.parentEndpoint.addMessengerEventListener(this, 0);
        }
        this.initialized = true;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Endpoint Service : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: ");
                configInfo.append(this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : ").append(this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : ").append(this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : ").append(this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : ").append(group);
            configInfo.append("\n\t\tPeer ID : ").append(group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            if (null == parentGroup) {
                configInfo.append("\n\t\tHome Group : (none)");
            } else {
                configInfo.append("\n\t\tHome Group : ").append(parentGroup.getPeerGroupName()).append(" / ").append(parentGroup.getPeerGroupID());
            }
            configInfo.append("\n\t\tUsing home group endpoint : ").append(this.parentEndpoint);
            configInfo.append("\n\t\tVirtual Messenger Queue Size : ").append(this.vmQueueSize);
            LOG.config(configInfo.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startApp(String[] args) {
        if (!this.initialized) {
            return -1;
        }
        if (EndpointMeterBuildSettings.ENDPOINT_METERING) {
            this.endpointServiceMonitor = (EndpointServiceMonitor)MonitorManager.getServiceMonitor(this.group, MonitorResources.endpointServiceMonitorClassID);
            if (this.endpointServiceMonitor != null) {
                this.endpointMeter = this.endpointServiceMonitor.getEndpointMeter();
            }
        }
        if (this.parentEndpoint != null) {
            Iterator<MessageTransport> parentMTs = this.parentEndpoint.getAllMessageTransports();
            EndpointServiceImpl endpointServiceImpl = this;
            synchronized (endpointServiceImpl) {
                while (parentMTs.hasNext()) {
                    this.addProtoToAdv(parentMTs.next());
                }
            }
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Endpoint Service started.");
        }
        return 0;
    }

    @Override
    public void stopApp() {
        if (this.parentEndpoint != null) {
            this.parentEndpoint.removeMessengerEventListener(this, 0);
        }
        int prec = 2;
        while (prec >= 0) {
            this.passiveMessengerListeners[prec--].clear();
        }
        this.messengerMap.clear();
        this.directMessengerMap.clear();
        this.incomingMessageListeners.clear();
        this.incomingFilterListeners.clear();
        this.outgoingFilterListeners.clear();
        this.messageTransports.clear();
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Endpoint Service stopped.");
        }
    }

    @Override
    public PeerGroup getGroup() {
        return this.group;
    }

    @Override
    public EndpointService getInterface() {
        return new EndpointServiceInterface(this);
    }

    @Override
    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    private void propagateThroughAll(Iterator<MessageTransport> eachProto, Message myMsg, String serviceName, String serviceParam, int initialTTL, Metrics metrics) {
        Message filtered = null;
        while (eachProto.hasNext()) {
            MessageTransport aTransport = eachProto.next();
            try {
                if (!(aTransport instanceof MessagePropagater)) continue;
                MessagePropagater propagater = (MessagePropagater)aTransport;
                if (null == filtered) {
                    filtered = this.processFilters(myMsg, propagater.getPublicAddress(), new EndpointAddress(this.group.getPeerGroupID(), serviceName, serviceParam), false);
                }
                if (null == filtered) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("   message " + myMsg + " discarded upon filter decision");
                    }
                    if (!EndpointMeterBuildSettings.ENDPOINT_METERING) break;
                    ++metrics.numFilteredOut;
                    break;
                }
                propagater.propagate(filtered.clone(), serviceName, serviceParam, initialTTL);
                if (!EndpointMeterBuildSettings.ENDPOINT_METERING) continue;
                ++metrics.numPropagatedTo;
            }
            catch (Exception e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failed propagating message " + filtered + " on message transport " + aTransport, e);
                }
                if (!EndpointMeterBuildSettings.ENDPOINT_METERING) continue;
                ++metrics.numErrorsPropagated;
            }
        }
    }

    @Override
    public void propagate(Message msg, String serviceName, String serviceParam) {
        this.propagate(msg, serviceName, serviceParam, Integer.MAX_VALUE);
    }

    @Override
    public void propagate(Message msg, String serviceName, String serviceParam, int initialTTL) {
        long startPropagationTime = 0L;
        if (null == serviceName) {
            throw new IllegalArgumentException("serviceName may not be null");
        }
        Metrics metrics = null;
        if (EndpointMeterBuildSettings.ENDPOINT_METERING) {
            metrics = new Metrics();
        }
        msg = msg.clone();
        if (EndpointMeterBuildSettings.ENDPOINT_METERING) {
            startPropagationTime = System.currentTimeMillis();
        }
        StringMessageElement srcHdrElement = new StringMessageElement(MESSAGE_SRCPEERHDR_NAME, this.localPeerId, null);
        msg.replaceMessageElement("jxta", srcHdrElement);
        Iterator<MessageTransport> eachProto = this.getAllLocalTransports();
        this.propagateThroughAll(eachProto, msg.clone(), serviceName, serviceParam, initialTTL, metrics);
        if (this.parentEndpoint != null) {
            eachProto = this.parentEndpoint.getAllMessageTransports();
            StringBuilder mangled = new StringBuilder(serviceName);
            if (null != serviceParam) {
                mangled.append('/');
                mangled.append(serviceParam);
            }
            this.propagateThroughAll(eachProto, msg.clone(), this.myServiceName, mangled.toString(), initialTTL, metrics);
        }
        if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointServiceMonitor != null) {
            PropagationMeter propagationMeter = this.endpointServiceMonitor.getPropagationMeter(serviceName, serviceParam);
            propagationMeter.registerPropagateMessageStats(metrics.numPropagatedTo, metrics.numFilteredOut, metrics.numErrorsPropagated, System.currentTimeMillis() - startPropagationTime);
        }
    }

    private Message processFilters(Message message, EndpointAddress srcAddress, EndpointAddress dstAddress, boolean incoming) {
        Iterator<FilterListenerAndMask> eachFilter;
        Iterator<FilterListenerAndMask> iterator = eachFilter = incoming ? this.incomingFilterListeners.iterator() : this.outgoingFilterListeners.iterator();
        while (eachFilter.hasNext()) {
            FilterListenerAndMask aFilter = eachFilter.next();
            Message.ElementIterator eachElement = message.getMessageElements();
            while (eachElement.hasNext()) {
                MessageElement anElement = eachElement.next();
                if (null != aFilter.namespace && !aFilter.namespace.equals(eachElement.getNamespace()) || null != aFilter.name && !aFilter.name.equals(anElement.getElementName()) || null != (message = aFilter.listener.filterMessage(message, srcAddress, dstAddress))) continue;
                return null;
            }
        }
        return message;
    }

    private static EndpointAddress demangleAddress(EndpointAddress mangled) {
        String serviceName = mangled.getServiceName();
        if (null == serviceName) {
            return mangled;
        }
        if (!serviceName.startsWith("EndpointService:")) {
            return mangled;
        }
        String serviceParam = mangled.getServiceParameter();
        if (null == serviceParam) {
            return new EndpointAddress(mangled, null, null);
        }
        int slashAt = serviceParam.indexOf(47);
        if (-1 == slashAt) {
            return new EndpointAddress(mangled, serviceParam, null);
        }
        return new EndpointAddress(mangled, serviceParam.substring(0, slashAt), serviceParam.substring(slashAt + 1));
    }

    @Override
    public void processIncomingMessage(Message msg, EndpointAddress srcAddress, EndpointAddress dstAddress) {
        block28: {
            EndpointListener listener;
            MessageElement srcPeerElement = msg.getMessageElement("jxta", MESSAGE_SRCPEERHDR_NAME);
            if (null != srcPeerElement) {
                msg.removeMessageElement(srcPeerElement);
                String srcPeer = srcPeerElement.toString();
                if (this.localPeerId.equals(srcPeer)) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine(msg + " is a propagate loopback. Discarded");
                    }
                    if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                        this.endpointMeter.discardedLoopbackDemuxMessage();
                    }
                    return;
                }
            }
            if (null == srcAddress) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("null src address, discarding message " + msg);
                }
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                    this.endpointMeter.invalidIncomingMessage();
                }
                return;
            }
            if (null == dstAddress) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("null destination address, discarding message " + msg);
                }
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                    this.endpointMeter.invalidIncomingMessage();
                }
                return;
            }
            EndpointAddress demangledAddress = EndpointServiceImpl.demangleAddress(dstAddress);
            String decodedServiceName = demangledAddress.getServiceName();
            String decodedServiceParam = demangledAddress.getServiceParameter();
            if (null == decodedServiceName || 0 == decodedServiceName.length()) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("dest serviceName must not be null, discarding message " + msg);
                }
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                    this.endpointMeter.invalidIncomingMessage();
                }
                return;
            }
            if ((msg = this.processFilters(msg, srcAddress, demangledAddress, true)) == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Message discarded during filter processing");
                }
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                    this.endpointMeter.incomingMessageFilteredOut();
                }
                return;
            }
            if (demangledAddress != dstAddress) {
                decodedServiceName = dstAddress.getServiceName() + "/" + decodedServiceName;
            }
            if ((listener = this.getIncomingMessageListener(decodedServiceName, decodedServiceParam)) == null) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("No listener for '" + dstAddress + "' in group " + this.group + "\n\tdecodedServiceName :" + decodedServiceName + "\tdecodedServiceParam :" + decodedServiceParam);
                }
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                    this.endpointMeter.noListenerForIncomingMessage();
                }
                return;
            }
            try {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    if (null != decodedServiceParam) {
                        LOG.fine("Calling listener for '" + decodedServiceName + "/" + decodedServiceParam + "' with " + msg);
                    } else {
                        LOG.fine("Calling listener for '" + decodedServiceName + "' with " + msg);
                    }
                }
                listener.processIncomingMessage(msg, srcAddress, demangledAddress);
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                    this.endpointMeter.incomingMessageSentToEndpointListener();
                }
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                    this.endpointMeter.demuxMessageProcessed();
                }
            }
            catch (Throwable all) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "Uncaught throwable from listener for " + dstAddress, all);
                }
                if (!EndpointMeterBuildSettings.ENDPOINT_METERING || this.endpointMeter == null) break block28;
                this.endpointMeter.errorProcessingIncomingMessage();
            }
        }
    }

    @Override
    public void demux(Message msg) {
        MessageElement dstAddressElement = msg.getMessageElement("jxta", MESSAGE_DESTINATION_NAME);
        if (null == dstAddressElement) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning(msg + " has no destination address. Discarded");
            }
            if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                this.endpointMeter.noDestinationAddressForDemuxMessage();
            }
            return;
        }
        msg.removeMessageElement(dstAddressElement);
        EndpointAddress dstAddress = new EndpointAddress(dstAddressElement.toString());
        MessageElement srcAddressElement = msg.getMessageElement("jxta", MESSAGE_SOURCE_NAME);
        if (null == srcAddressElement) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning(msg + " has no source address. Discarded");
            }
            if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointMeter != null) {
                this.endpointMeter.noSourceAddressForDemuxMessage();
            }
            return;
        }
        msg.removeMessageElement(srcAddressElement);
        EndpointAddress msgScrAddress = new EndpointAddress(srcAddressElement.toString());
        this.processIncomingMessage(msg, msgScrAddress, dstAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessengerEventListener addMessageTransport(MessageTransport transpt) {
        Collection<MessageTransport> collection = this.messageTransports;
        synchronized (collection) {
            if (!this.messageTransports.contains(transpt)) {
                this.clearProtoFromAdv(transpt);
                this.messageTransports.add(transpt);
                this.addProtoToAdv(transpt);
                return this;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMessageTransport(MessageTransport transpt) {
        boolean removed;
        Collection<MessageTransport> collection = this.messageTransports;
        synchronized (collection) {
            removed = this.messageTransports.remove(transpt);
        }
        if (removed) {
            this.clearProtoFromAdv(transpt);
        }
        return removed;
    }

    @Override
    public Iterator<MessageTransport> getAllMessageTransports() {
        if (null != this.parentEndpoint) {
            return new SequenceIterator(this.getAllLocalTransports(), this.parentEndpoint.getAllMessageTransports());
        }
        return this.getAllLocalTransports();
    }

    @Override
    public MessageTransport getMessageTransport(String name) {
        Iterator<MessageTransport> allTransports = this.getAllMessageTransports();
        while (allTransports.hasNext()) {
            MessageTransport transpt = allTransports.next();
            if (!transpt.getProtocolName().equals(name)) continue;
            return transpt;
        }
        return null;
    }

    private void addProtoToAdv(MessageTransport proto) {
        block12: {
            boolean relay = false;
            try {
                Enumeration paramChilds;
                if (!(proto instanceof MessageReceiver)) {
                    return;
                }
                if (proto instanceof EndpointRouter) {
                    this.addActiveRelayListener(this.group);
                    return;
                }
                if (proto instanceof RelayClient) {
                    relay = true;
                    ((RelayClient)proto).addActiveRelayListener(this.group);
                }
                Iterator<EndpointAddress> allAddresses = ((MessageReceiver)proto).getPublicAddresses();
                Vector<String> ea = new Vector<String>();
                while (allAddresses.hasNext()) {
                    EndpointAddress anEndpointAddress = allAddresses.next();
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Adding endpoint address to route advertisement : " + anEndpointAddress);
                    }
                    ea.add(anEndpointAddress.toString());
                }
                PeerAdvertisement padv = this.group.getPeerAdvertisement();
                StructuredDocument myParam = padv.getServiceParam(this.assignedID);
                ExtendableAdvertisement route = null;
                if (myParam != null && (paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType())).hasMoreElements()) {
                    Vector<AccessPointAdvertisement> hops;
                    XMLElement param = (XMLElement)paramChilds.nextElement();
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(param);
                    ((RouteAdvertisement)route).addDestEndpointAddresses(ea);
                    if (relay && !(hops = ((RelayClient)proto).getActiveRelays(this.group)).isEmpty()) {
                        ((RouteAdvertisement)route).setHops(hops);
                    }
                }
                if (null == route) {
                    Vector<AccessPointAdvertisement> hops;
                    AccessPointAdvertisement destAP = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
                    destAP.setPeerID(this.group.getPeerID());
                    destAP.setEndpointAddresses(ea);
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                    ((RouteAdvertisement)route).setDest(destAP);
                    if (relay && !(hops = ((RelayClient)proto).getActiveRelays(this.group)).isEmpty()) {
                        ((RouteAdvertisement)route).setHops(hops);
                    }
                }
                XMLDocument newParam = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                XMLDocument xptDoc = (XMLDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(newParam, newParam, xptDoc);
                padv.putServiceParam(this.assignedID, newParam);
                DiscoveryService discovery = this.group.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, Long.MAX_VALUE, 0x6DDD00L);
                }
            }
            catch (Exception ex) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block12;
                LOG.log(Level.SEVERE, "Exception adding message transport ", ex);
            }
        }
    }

    private void clearProtoFromAdv(MessageTransport transpt) {
        block10: {
            try {
                if (!(transpt instanceof MessageReceiver)) {
                    return;
                }
                if (transpt instanceof EndpointRouter) {
                    this.removeActiveRelayListener(this.group);
                    return;
                }
                if (transpt instanceof RelayClient) {
                    ((RelayClient)transpt).removeActiveRelayListener(this.group);
                }
                Iterator<EndpointAddress> allAddresses = ((MessageReceiver)transpt).getPublicAddresses();
                Vector<String> ea = new Vector<String>();
                while (allAddresses.hasNext()) {
                    EndpointAddress anEndpointAddress = allAddresses.next();
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removing endpoint address from route advertisement : " + anEndpointAddress);
                    }
                    ea.add(anEndpointAddress.toString());
                }
                PeerAdvertisement padv = this.group.getPeerAdvertisement();
                XMLDocument myParam = (XMLDocument)padv.getServiceParam(this.assignedID);
                if (myParam == null) {
                    return;
                }
                Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                if (!paramChilds.hasMoreElements()) {
                    return;
                }
                XMLElement param = (XMLElement)paramChilds.nextElement();
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(param);
                route.removeDestEndpointAddresses(ea);
                XMLDocument newParam = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                XMLDocument xptDoc = (XMLDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(newParam, newParam, xptDoc);
                padv.putServiceParam(this.assignedID, newParam);
                DiscoveryService discovery = this.group.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, Long.MAX_VALUE, 0x6DDD00L);
                }
            }
            catch (Exception ex) {
                if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block10;
                LOG.log(Level.SEVERE, "Exception removing messsage transport ", ex);
            }
        }
    }

    @Override
    public boolean addMessengerEventListener(MessengerEventListener listener, int prio) {
        int priority = prio;
        if (priority > 2) {
            priority = 2;
        }
        if (priority < 0) {
            priority = 0;
        }
        return this.passiveMessengerListeners[priority].add(listener);
    }

    @Override
    public boolean removeMessengerEventListener(MessengerEventListener listener, int prio) {
        int priority = prio;
        if (priority > 2) {
            priority = 2;
        }
        if (priority < 0) {
            priority = 0;
        }
        return this.passiveMessengerListeners[priority].remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addIncomingMessageListener(EndpointListener listener, String serviceName, String serviceParam) {
        if (null == listener) {
            throw new IllegalArgumentException("EndpointListener must be non-null");
        }
        if (null == serviceName) {
            throw new IllegalArgumentException("serviceName must not be null");
        }
        if (-1 != serviceName.indexOf(47)) {
            throw new IllegalArgumentException("serviceName may not contain '/' characters");
        }
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        Map<String, EndpointListener> map = this.incomingMessageListeners;
        synchronized (map) {
            if (this.incomingMessageListeners.containsKey(address)) {
                return false;
            }
            InboundMeter incomingMessageListenerMeter = null;
            if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointServiceMonitor != null) {
                incomingMessageListenerMeter = this.endpointServiceMonitor.getInboundMeter(serviceName, serviceParam);
            }
            this.incomingMessageListeners.put(address, listener);
        }
        if (this.parentEndpoint != null) {
            if (serviceName.startsWith("EndpointService:")) {
                this.parentEndpoint.addIncomingMessageListener(listener, serviceName, serviceParam);
            } else {
                this.parentEndpoint.addIncomingMessageListener(listener, this.myServiceName, address);
            }
        }
        return true;
    }

    @Override
    public EndpointListener getIncomingMessageListener(String serviceName, String serviceParam) {
        if (null == serviceName) {
            throw new IllegalArgumentException("serviceName must not be null");
        }
        EndpointListener listener = null;
        if (null != serviceParam) {
            listener = this.incomingMessageListeners.get(serviceName + "/" + serviceParam);
        }
        if (listener == null) {
            listener = this.incomingMessageListeners.get(serviceName);
        }
        if (listener == null && null != (listener = this.incomingMessageListeners.get(serviceName + serviceParam)) && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Found handler only via compatibility listener : " + serviceName + serviceParam);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndpointListener removeIncomingMessageListener(String serviceName, String serviceParam) {
        EndpointListener removedListener;
        if (null == serviceName) {
            throw new IllegalArgumentException("serviceName must not be null");
        }
        if (-1 != serviceName.indexOf(47)) {
            throw new IllegalArgumentException("serviceName may not contain '/' characters");
        }
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        Map<String, EndpointListener> map = this.incomingMessageListeners;
        synchronized (map) {
            removedListener = this.incomingMessageListeners.remove(address);
        }
        if (this.parentEndpoint != null) {
            if (serviceName.startsWith("EndpointService:")) {
                this.parentEndpoint.removeIncomingMessageListener(serviceName, serviceParam);
            } else {
                this.parentEndpoint.removeIncomingMessageListener(this.myServiceName, address);
            }
        }
        return removedListener;
    }

    private MessageSender getLocalSenderForAddress(EndpointAddress addr) {
        Iterator<MessageTransport> localTransports = this.getAllLocalTransports();
        while (localTransports.hasNext()) {
            MessageTransport transpt = localTransports.next();
            if (!transpt.getProtocolName().equals(addr.getProtocolName()) || !(transpt instanceof MessageSender)) continue;
            return (MessageSender)transpt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Messenger getCanonicalMessenger(EndpointAddress addr, Object hint) {
        if (addr == null) {
            throw new IllegalArgumentException("null endpoint address not allowed.");
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            Throwable trace = new Throwable("Stack Trace");
            StackTraceElement[] elements = trace.getStackTrace();
            int position = 1;
            while (elements[position].getClassName().startsWith("net.jxta.impl.endpoint.EndpointService")) {
                ++position;
            }
            if (elements.length - 1 == position) {
                --position;
            }
            LOG.fine("Get Messenger for " + addr + " by " + elements[position]);
        }
        Map<EndpointAddress, Reference<Messenger>> map = this.messengerMap;
        synchronized (map) {
            Reference<Messenger> ref = this.messengerMap.get(addr);
            if (ref != null) {
                Messenger found = ref.get();
                if (found != null && (found.getState() & 0x3FF) != 0) {
                    return found;
                }
                this.messengerMap.remove(addr);
            }
            if (this.getLocalSenderForAddress(addr) != null) {
                OutboundMeter messengerMeter = null;
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.endpointServiceMonitor != null) {
                    messengerMeter = this.endpointServiceMonitor.getOutboundMeter(addr);
                }
                CanonicalMessenger m = new CanonicalMessenger(this.vmQueueSize, addr, null, hint, messengerMeter);
                this.messengerMap.put(m.getDestinationAddress(), new SoftReference<CanonicalMessenger>(m));
                return m;
            }
        }
        if (this.parentEndpoint == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Could not create messenger for : " + addr);
            }
            return null;
        }
        return this.parentEndpoint.getCanonicalMessenger(addr, hint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<MessageTransport> getAllLocalTransports() {
        ArrayList<MessageTransport> transportList;
        Collection<MessageTransport> collection = this.messageTransports;
        synchronized (collection) {
            transportList = new ArrayList<MessageTransport>(this.messageTransports);
        }
        return transportList.iterator();
    }

    private Messenger getLocalTransportMessenger(EndpointAddress addr, Object hint) {
        MessageSender sender = this.getLocalSenderForAddress(addr);
        Messenger messenger = null;
        if (sender != null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Trying address '" + addr + "' with : " + sender);
            }
            messenger = sender.getMessenger(addr, hint);
        }
        if (messenger == null && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Couldn't create messenger for : " + addr);
        }
        return messenger;
    }

    @Override
    public synchronized void addIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        if (null == listener) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        FilterListenerAndMask aFilter = new FilterListenerAndMask(listener, namespace, name);
        this.incomingFilterListeners.add(aFilter);
    }

    @Override
    public synchronized void addOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        if (null == listener) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        FilterListenerAndMask aFilter = new FilterListenerAndMask(listener, namespace, name);
        this.outgoingFilterListeners.add(aFilter);
    }

    @Override
    public synchronized MessageFilterListener removeIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        Iterator<FilterListenerAndMask> eachListener = this.incomingFilterListeners.iterator();
        while (eachListener.hasNext()) {
            FilterListenerAndMask aFilter = eachListener.next();
            if (listener != aFilter.listener) continue;
            eachListener.remove();
            return listener;
        }
        return null;
    }

    @Override
    public synchronized MessageFilterListener removeOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        Iterator<FilterListenerAndMask> eachListener = this.outgoingFilterListeners.iterator();
        while (eachListener.hasNext()) {
            FilterListenerAndMask aFilter = eachListener.next();
            if (listener != aFilter.listener || !(null != namespace ? namespace.equals(aFilter.namespace) : null == aFilter.namespace) || !(null != name ? name.equals(aFilter.name) : null == aFilter.name)) continue;
            eachListener.remove();
            return listener;
        }
        return null;
    }

    @Override
    public boolean messengerReady(MessengerEvent event) {
        String cgServiceName;
        Messenger messenger = event.getMessenger();
        EndpointAddress connAddr = event.getConnectionAddress();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("New " + messenger + " for : " + messenger.getDestinationAddress() + " (" + messenger.getLogicalDestinationAddress() + ")");
        }
        int highestPrec = 2;
        int lowestPrec = 0;
        if (connAddr != null && (cgServiceName = connAddr.getServiceName()) != null && cgServiceName.startsWith("EndpointService:")) {
            if (!this.myServiceName.equals(cgServiceName)) {
                highestPrec = 0;
            } else {
                lowestPrec = 1;
                String serviceParam = connAddr.getServiceParameter();
                String realService = null;
                String realParam = null;
                if (null != serviceParam) {
                    int slashAt = serviceParam.indexOf(47);
                    if (-1 == slashAt) {
                        realService = serviceParam;
                    } else {
                        realService = serviceParam.substring(0, slashAt);
                        realParam = serviceParam.substring(slashAt + 1);
                    }
                }
                connAddr = new EndpointAddress(connAddr, realService, realParam);
            }
        }
        Messenger messengerForHere = event.getMessenger().getChannelMessenger(this.group.getPeerGroupID(), null, null);
        int prec = highestPrec + 1;
        while (prec-- > lowestPrec) {
            MessengerEvent newMessenger = new MessengerEvent(event.getSource(), prec == 0 ? messenger : messengerForHere, connAddr);
            ArrayList allML = new ArrayList(this.passiveMessengerListeners[prec]);
            for (MessengerEventListener listener : allML) {
                try {
                    if (!listener.messengerReady(newMessenger)) continue;
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine(newMessenger + " claimed by " + listener);
                    }
                    return true;
                }
                catch (Throwable all) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Uncaught Throwable in listener " + listener, all);
                }
            }
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Nobody cared about " + event);
        }
        return false;
    }

    private void addActiveRelayListener(PeerGroup listeningGroup) {
        block0: for (PeerGroup parentGroup = this.group.getParentGroup(); parentGroup != null; parentGroup = parentGroup.getParentGroup()) {
            EndpointService parentEndpoint = parentGroup.getEndpointService();
            Iterator<MessageTransport> it = parentEndpoint.getAllMessageTransports();
            while (it.hasNext()) {
                MessageTransport mt = it.next();
                if (!(mt instanceof RelayClient)) continue;
                ((RelayClient)mt).addActiveRelayListener(listeningGroup);
                continue block0;
            }
        }
    }

    private void removeActiveRelayListener(PeerGroup listeningGroup) {
        block0: for (PeerGroup parentGroup = this.group.getParentGroup(); parentGroup != null; parentGroup = parentGroup.getParentGroup()) {
            EndpointService parentEndpoint = parentGroup.getEndpointService();
            Iterator<MessageTransport> it = parentEndpoint.getAllMessageTransports();
            while (it.hasNext()) {
                MessageTransport mt = it.next();
                if (!(mt instanceof RelayClient)) continue;
                ((RelayClient)mt).removeActiveRelayListener(listeningGroup);
                continue block0;
            }
        }
    }

    @Override
    @Deprecated
    public boolean ping(EndpointAddress addr) {
        throw new UnsupportedOperationException("Legacy method not implemented. Use an interface object.");
    }

    @Override
    @Deprecated
    public boolean getMessenger(MessengerEventListener listener, EndpointAddress addr, Object hint) {
        throw new UnsupportedOperationException("Legacy method not implemented. Use an interface object.");
    }

    @Override
    public Messenger getMessenger(EndpointAddress addr) {
        throw new UnsupportedOperationException("Convenience method not implemented. Use an interface object.");
    }

    @Override
    public Messenger getMessengerImmediate(EndpointAddress addr, Object hint) {
        throw new UnsupportedOperationException("Convenience method not implemented. Use an interface object.");
    }

    @Override
    public Messenger getMessenger(EndpointAddress addr, Object hint) {
        throw new UnsupportedOperationException("Convenience method not implemented. Use an interface object.");
    }

    @Override
    public Messenger getDirectMessenger(EndpointAddress address, Object hint, boolean exclusive) {
        Messenger messenger;
        Reference<Messenger> reference;
        if (!exclusive && (reference = this.directMessengerMap.get(address)) != null && (messenger = reference.get()) != null && !messenger.isClosed()) {
            return messenger;
        }
        TcpTransport tcpTransport = (TcpTransport)this.getMessageTransport("tcp");
        if (tcpTransport != null && hint != null) {
            RouteAdvertisement route;
            if (hint instanceof RouteAdvertisement) {
                route = (RouteAdvertisement)hint;
            } else if (hint instanceof PeerAdvertisement) {
                route = EndpointUtils.extractRouteAdv((PeerAdvertisement)hint);
            } else {
                throw new IllegalArgumentException("Unknown route hint object type" + hint);
            }
            for (EndpointAddress transportAddr : route.getDestEndpointAddresses()) {
                EndpointAddress direct;
                Messenger messenger2;
                if (!transportAddr.getProtocolName().equals("tcp") || (messenger2 = tcpTransport.getMessenger(direct = this.createDirectAddress(transportAddr, address), route, false)) == null) continue;
                if (!exclusive) {
                    this.directMessengerMap.put(address, new WeakReference<Messenger>(messenger2));
                }
                return messenger2;
            }
        }
        return null;
    }

    private EndpointAddress createDirectAddress(EndpointAddress transportAddr, EndpointAddress serviceEndpoint) {
        StringBuilder destStr = new StringBuilder(transportAddr.toString()).append("/");
        destStr.append(ENDPOINTSERVICE_NAME);
        destStr.append(":").append(this.group.getPeerGroupID().getUniqueValue().toString()).append("/");
        destStr.append(serviceEndpoint.getServiceName()).append("/").append(serviceEndpoint.getServiceParameter());
        return new EndpointAddress(destStr.toString());
    }

    private static class Metrics {
        int numFilteredOut = 0;
        int numPropagatedTo = 0;
        int numErrorsPropagated = 0;

        private Metrics() {
        }
    }

    private class CanonicalMessenger
    extends ThreadedMessenger {
        Object hint;
        Messenger cachedMessenger;

        public CanonicalMessenger(int vmQueueSize, EndpointAddress destination, EndpointAddress logicalDestination, Object hint, OutboundMeter messengerMeter) {
            super(EndpointServiceImpl.this.group.getPeerGroupID(), destination, logicalDestination, vmQueueSize);
            this.cachedMessenger = null;
            this.hint = hint;
        }

        public void close() {
        }

        protected void closeImpl() {
            if (this.cachedMessenger != null) {
                this.cachedMessenger.close();
                this.cachedMessenger = null;
            } else if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Internal messenger error: close requested while not connected.");
            }
        }

        protected boolean connectImpl() {
            block7: {
                if (this.cachedMessenger != null) {
                    if ((this.cachedMessenger.getState() & 0x70000) != 0) {
                        if (Logging.SHOW_FINE && LOG.isLoggable(Level.SEVERE)) {
                            LOG.fine("Closing TERMINAL internal messenger : attempting requested connect.");
                        }
                        this.cachedMessenger.close();
                        this.cachedMessenger = null;
                    } else {
                        return true;
                    }
                }
                Object theHint = this.hint;
                this.hint = null;
                this.cachedMessenger = EndpointServiceImpl.this.getLocalTransportMessenger(this.getDestinationAddress(), theHint);
                if (this.cachedMessenger == null) {
                    return false;
                }
                try {
                    ((BlockingMessenger)this.cachedMessenger).setOwner(this);
                }
                catch (ClassCastException cce) {
                    if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block7;
                    LOG.severe("Transport messengers must all extend BlockingMessenger for now. " + this.cachedMessenger + " may remain open beyond its use.");
                }
            }
            return true;
        }

        protected EndpointAddress getLogicalDestinationImpl() {
            if (this.cachedMessenger == null) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.severe("Internal messenger error: logical destination requested while not connected.");
                }
                return null;
            }
            return this.cachedMessenger.getLogicalDestinationAddress();
        }

        protected void sendMessageBImpl(Message msg, String service, String param) throws IOException {
            if (this.cachedMessenger == null) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.severe("Internal messenger error: send requested while not connected.");
                }
                throw new IOException("Internal messenger error.");
            }
            try {
                this.cachedMessenger.sendMessageB(msg, service, param);
            }
            catch (IOException any) {
                this.cachedMessenger = null;
                throw any;
            }
            catch (RuntimeException any) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failure sending " + msg, any);
                }
                throw any;
            }
        }
    }

    private static class FilterListenerAndMask {
        final String namespace;
        final String name;
        final MessageFilterListener listener;

        public FilterListenerAndMask(MessageFilterListener listener, String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
            this.listener = listener;
        }

        public boolean equals(Object target) {
            if (this == target) {
                return true;
            }
            if (target instanceof FilterListenerAndMask) {
                boolean result;
                FilterListenerAndMask likeMe = (FilterListenerAndMask)target;
                boolean bl = null != this.namespace ? this.namespace.equals(likeMe.namespace) : (result = null == likeMe.namespace);
                result &= null != this.name ? this.name.equals(likeMe.name) : null == likeMe.name;
                return result &= this.listener == likeMe.listener;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

