/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import net.jxta.endpoint.AbstractMessenger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.ListenerAdaptor;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.peergroup.PeerGroupID;

public abstract class ChannelMessenger
extends AbstractMessenger
implements Messenger {
    public static final String InsertedServicePrefix = "EndpointService:";
    private String insertedService;
    private ListenerAdaptor messageWatcher;
    protected String origService;
    protected String origServiceParam;

    protected String effectiveService(String service) {
        if (this.insertedService == null) {
            return service == null ? this.origService : service;
        }
        return service != null && service.startsWith(InsertedServicePrefix) ? service : this.insertedService;
    }

    protected String effectiveParam(String service, String serviceParam) {
        if (this.insertedService == null || service != null && service.startsWith(InsertedServicePrefix)) {
            return serviceParam == null ? this.origServiceParam : serviceParam;
        }
        if (service == null) {
            service = this.origService;
        }
        if (serviceParam == null) {
            serviceParam = this.origServiceParam;
        }
        return null != service && null != serviceParam ? service + "/" + serviceParam : service;
    }

    public void setMessageWatcher(ListenerAdaptor messageWatcher) {
        this.messageWatcher = messageWatcher;
    }

    public ChannelMessenger(EndpointAddress baseAddress, PeerGroupID groupRedirection, String origService, String origServiceParam) {
        super(baseAddress);
        this.insertedService = groupRedirection == null ? null : InsertedServicePrefix + groupRedirection.getUniqueValue().toString();
        this.origService = origService;
        this.origServiceParam = origServiceParam;
    }

    public Messenger getChannelMessenger(PeerGroupID redirection, String service, String serviceParam) {
        return null;
    }

    public void sendMessage(Message msg, String service, String serviceParam, OutgoingMessageEventListener listener) {
        if (this.messageWatcher == null) {
            throw new UnsupportedOperationException("This channel was not configured to emulate this legacy method.");
        }
        msg.setMessageProperty(Messenger.class, null);
        this.messageWatcher.watchMessage(listener, msg);
        this.sendMessageN(msg, service, serviceParam);
    }
}

