/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;

public class BinaryDocument
implements Document {
    private static final MimeMediaType[] myTypes = new MimeMediaType[]{MimeMediaType.AOS};
    private final byte[] ourBytes;
    private final MimeMediaType ourType;

    public static MimeMediaType[] getSupportedMimeTypes() {
        return (MimeMediaType[])myTypes.clone();
    }

    public BinaryDocument(byte[] someBytes) {
        this(someBytes, myTypes[0]);
    }

    public BinaryDocument(byte[] someBytes, MimeMediaType type) {
        this.ourBytes = someBytes;
        this.ourType = type;
    }

    public MimeMediaType getMimeType() {
        return this.ourType;
    }

    public String getFileExtension() {
        return StructuredDocumentFactory.getFileExtensionForMimeType(this.ourType);
    }

    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(this.ourBytes);
    }

    public void sendToStream(OutputStream stream) throws IOException {
        stream.write(this.ourBytes);
    }
}

