/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.jsf;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmaki.runtime.jsf.AjaxResult;
import jmaki.runtime.jsf.Util;

public class AjaxWrapperPhaseListener
implements PhaseListener {
    public static String JMAKI_AJAX = ".ajax";
    private static String CACHE = "jmaki_cache";
    private static String CACHE_TIMES = "jmaki_cache_times";
    private static Logger logger;
    public static String cpRoot;
    private boolean isEnabled;
    private boolean isEnabledChecked = false;

    private boolean isEnabled() {
        if (!this.isEnabledChecked) {
            String uriManagerFactoryClassName = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("jmaki-urimanagerfactory");
            this.isEnabled = uriManagerFactoryClassName == null || uriManagerFactoryClassName.equals("jmaki.runtime.jsf.JsfUriManagerImpl");
            this.isEnabledChecked = true;
        }
        return this.isEnabled;
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("jmaki.runtime.Log");
        }
        return logger;
    }

    public void afterPhase(PhaseEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        FacesContext context = event.getFacesContext();
        if (context.getResponseComplete()) {
            return;
        }
        String rootId = context.getViewRoot().getViewId();
        if (Util.resourceMapsToFacesServlet(event.getFacesContext(), rootId)) {
            return;
        }
        if (rootId.endsWith(".jsp") || rootId.endsWith(".xhtml")) {
            return;
        }
        if (rootId.endsWith(".js")) {
            this.getResource(event, rootId, true, true, "text/javascript");
        } else if (rootId.endsWith(".html") || rootId.endsWith(".htm")) {
            this.getResource(event, rootId, true, true, "text/html");
        } else if (rootId.endsWith(".css")) {
            this.getBinaryResource(event, rootId, true, "text/css");
        } else if (rootId.endsWith(".gif")) {
            this.getBinaryResource(event, rootId, true, "image/GIF");
        } else if (rootId.endsWith(".jpg")) {
            this.getBinaryResource(event, rootId, true, "image/JPEG");
        } else if (rootId.endsWith(".png")) {
            this.getBinaryResource(event, rootId, true, "image/png");
        } else if (rootId.endsWith(JMAKI_AJAX)) {
            this.handleAjaxRequest(rootId, event);
        } else {
            this.getBinaryResource(event, rootId, true, null);
        }
    }

    private boolean updateValueBoundObject(FacesContext context, String valueBinding, String value) {
        try {
            ValueBinding vb = context.getApplication().createValueBinding(valueBinding);
            vb.setValue(context, (Object)value);
        }
        catch (EvaluationException ex) {
            return false;
        }
        return true;
    }

    public void beforePhase(PhaseEvent event) {
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAjaxRequest(String rootId, PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        Object object = context.getExternalContext().getRequest();
        if (!(object instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)object;
        String cmd = request.getParameter("cmd");
        String uuid = request.getParameter("uuid");
        String argString = request.getParameter("args");
        String[] args = null;
        if (argString != null) {
            args = argString.split(",");
        }
        int targetIndex = rootId.lastIndexOf("/");
        String[] nRoot = rootId.split("/");
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        String target = rootId.substring(targetIndex, rootId.length());
        String[] bindingArgs = target.split("-");
        String tO = bindingArgs[0].substring(1, bindingArgs[0].length());
        String tM = bindingArgs[1].substring(0, bindingArgs[1].length() - ".ajax".length());
        String bindingExpression = "#{" + tO + "." + tM + "}";
        try {
            if (cmd != null && "update".equals(cmd)) {
                String value = request.getParameter("value");
                if (value != null) {
                    boolean success = this.updateValueBoundObject(context, bindingExpression, value);
                    response.setHeader("Cache-Control", "no-cache");
                    response.getWriter().write("<status>" + success + "</status>");
                }
            } else {
                AjaxResult result = this.invokeBinding(context, bindingExpression);
                if (result.getResponseType() == AjaxResult.XML) {
                    response.setContentType("text/xml");
                }
                response.setHeader("Cache-Control", "no-cache");
                response.getWriter().write(result.toString());
            }
        }
        catch (EvaluationException ee) {
            AjaxWrapperPhaseListener.getLogger().severe(ee.toString());
        }
        catch (IOException ioe) {
            AjaxWrapperPhaseListener.getLogger().severe(ioe.toString());
        }
        finally {
            event.getFacesContext().responseComplete();
            return;
        }
    }

    private AjaxResult invokeBinding(FacesContext context, String methodBinding) {
        if (UIComponentTag.isValueReference((String)methodBinding)) {
            Class[] argTypes = new Class[]{FacesContext.class, AjaxResult.class};
            MethodBinding vb = context.getApplication().createMethodBinding(methodBinding, argTypes);
            AjaxResult result = new AjaxResult();
            Object[] args = new Object[]{context, result};
            vb.invoke(context, args);
            return result;
        }
        AjaxWrapperPhaseListener.getLogger().severe("AjaxWrapperPhaseListener Error: Bad method binding: " + methodBinding);
        return null;
    }

    public void getBinaryResource(PhaseEvent event, String resource, boolean fromWeb, String contentType) {
        FacesContext context = event.getFacesContext();
        ServletContext ctx = (ServletContext)context.getExternalContext().getContext();
        Object stream = null;
        ByteArrayOutputStream buffer = null;
        try {
            URL url = ctx.getResource(resource);
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            if (url == null && (url = AjaxWrapperPhaseListener.class.getClassLoader().getResource(cpRoot + resource)) == null) {
                event.getFacesContext().responseComplete();
                response.sendError(404);
                return;
            }
            URLConnection con = url.openConnection();
            buffer = this.getBinaryResource(con.getInputStream());
            if (contentType != null) {
                response.setContentType(contentType);
            }
            if (buffer != null) {
                response.getOutputStream().write(buffer.toByteArray());
                buffer.close();
            }
            event.getFacesContext().responseComplete();
            return;
        }
        catch (Exception e) {
            AjaxWrapperPhaseListener.getLogger().severe("AjaxWrapperPhaseListener Error: Could not load " + resource);
            event.getFacesContext().responseComplete();
            return;
        }
    }

    private ByteArrayOutputStream getBinaryResource(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        try {
            int read = 0;
            while ((read = in.read(bytes)) > 0) {
                out.write(bytes, 0, read);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            AjaxWrapperPhaseListener.getLogger().severe("AjaxWrapperPhaseListener:loadResource from stream error:" + e);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResource(PhaseEvent event, String resource, boolean fromWeb, boolean cacheContent, String contentType) {
        FacesContext context = event.getFacesContext();
        ServletContext ctx = (ServletContext)context.getExternalContext().getContext();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        Object stream = null;
        StringBuffer buffer = null;
        try {
            URL url = ctx.getResource(resource);
            if (url == null && (url = AjaxWrapperPhaseListener.class.getClassLoader().getResource(cpRoot + resource)) == null) {
                event.getFacesContext().responseComplete();
                response.sendError(404);
                return;
            }
            if (contentType != null) {
                response.setContentType(contentType);
            }
            URLConnection con = url.openConnection();
            if (cacheContent) {
                HashMap<String, StringBuffer> cache = (HashMap<String, StringBuffer>)ctx.getAttribute(CACHE);
                HashMap<String, Long> cacheTimes = (HashMap<String, Long>)ctx.getAttribute(CACHE_TIMES);
                if (cache == null) {
                    cache = new HashMap<String, StringBuffer>();
                    cacheTimes = new HashMap<String, Long>();
                    ctx.setAttribute(CACHE, cache);
                    ctx.setAttribute(CACHE_TIMES, cacheTimes);
                }
                long lastModified = con.getLastModified();
                long cacheModified = 0L;
                if (cacheTimes.get(resource) != null) {
                    cacheModified = (Long)cacheTimes.get(resource);
                }
                if (cacheModified < lastModified) {
                    buffer = this.getResource(con.getInputStream());
                    HashMap<String, Long> hashMap = cacheTimes;
                    synchronized (hashMap) {
                        cacheTimes.put(resource, new Long(lastModified));
                    }
                    hashMap = cache;
                    synchronized (hashMap) {
                        cache.put(resource, buffer);
                    }
                }
                buffer = (StringBuffer)cache.get(resource);
            } else {
                buffer = this.getResource(con.getInputStream());
            }
            if (buffer != null) {
                response.getWriter().write(buffer.toString());
            }
        }
        catch (Exception e) {
            AjaxWrapperPhaseListener.getLogger().severe("AjaxWrapperRenderer Error: Could not load " + resource);
        }
        event.getFacesContext().responseComplete();
    }

    private StringBuffer getResource(InputStream stream) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader bufReader = null;
        String curLine = null;
        try {
            bufReader = new BufferedReader(new InputStreamReader(stream));
            while (null != (curLine = bufReader.readLine())) {
                buffer.append(curLine + "\n");
            }
        }
        catch (Exception e) {
            AjaxWrapperPhaseListener.getLogger().severe("AJAXTag:loadResource from stream error:" + e);
        }
        return buffer;
    }

    static {
        cpRoot = "META-INF";
    }
}

