/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.util.Iterator;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.AjaxWriter;
import jmaki.runtime.IOUtil;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.config.Extension;
import jmaki.runtime.config.GlueInclude;

public abstract class CommonGlobalRenderer {
    public static void writeBootStrap(AjaxContext ajx, AjaxWriter out) throws IOException {
        String jmakiBootUri;
        String resourcesDir = ajx.getResourceHandler().getResourcesDir();
        String string = jmakiBootUri = ajx.isCompressedScript() ? "/jmaki.js" : "/jmaki-uncompressed.js";
        if (ajx.isWriteComments()) {
            out.writeComment("CommonGlobalRenderer.writeBootStrap()");
        }
        out.writeLib(ajx.buildResourceReference(resourcesDir + jmakiBootUri, ajx.getGlobalConfig().isGlobalBootstrapScriptWebAppResource()));
        String clientLocale = "";
        if (ajx.getClientLocale() != null) {
            clientLocale = "jmaki.locale='" + ajx.getClientLocale() + "';";
        }
        out.writeScript("jmaki.webRoot='" + ajx.getGlobalWebRoot() + "';" + "jmaki.resourcesRoot ='" + resourcesDir + "';" + "jmaki.xhp ='" + ajx.getApplicationRoot() + ajx.getXhpMapping() + "';" + clientLocale);
    }

    public static void writeExtensions(AjaxContext ajx, AjaxWriter out) throws IOException {
        if (ajx.isWriteComments()) {
            out.writeComment("CommonGlobalRenderer.writeExtensions()");
        }
        Iterator extensions = ajx.getGlobalConfig().getExtensions();
        while (extensions.hasNext()) {
            Extension ex = (Extension)extensions.next();
            String name = ex.getName();
            String args = ex.getArgs();
            String url = ex.getURL();
            if (ajx.isExtensionWritten(args == null ? name : name + args) || url != null && !IOUtil.matchURL(ajx.getCurrentURI(), url)) continue;
            CommonGlobalRenderer.writeExtension(ajx, out, name, args);
            ajx.setExtensionWritten(args == null ? name : name + args);
        }
    }

    public static void writeGlueIncludes(AjaxContext ajx, AjaxWriter out) throws IOException {
        if (ajx.isWriteComments()) {
            out.writeComment("CommonGlobalRenderer.writeGlueIncludes()");
        }
        Iterator glueIncludes = ajx.getGlobalConfig().getGlueIncludes();
        while (glueIncludes.hasNext()) {
            GlueInclude glueInclude = (GlueInclude)glueIncludes.next();
            String glueIncludeLib = null;
            if (!IOUtil.matchURL(ajx.getCurrentURI(), glueInclude.getURL()) || ajx.isLibraryWritten(glueIncludeLib = glueInclude.getLib())) continue;
            out.writeLib(ajx.buildResourceReference(glueIncludeLib));
            ajx.setLibraryWritten(glueIncludeLib);
        }
    }

    public static void writeExtension(AjaxContext ajx, AjaxWriter out, String extensionName, String args) throws IOException, AjaxException {
        ResourceManager resourceManager;
        String extensionDir;
        String extensionLib;
        if (ajx.isWriteComments()) {
            out.writeComment("CommonGlobalRenderer.writeExtension(" + extensionName + "," + args + ")");
        }
        if (!ajx.isLibraryWritten(extensionLib = (extensionDir = ajx.buildResourceReference((resourceManager = ajx.getResourceHandler()).getResourcesDir() + resourceManager.getExtensionDir(extensionName))) + "/extension.js")) {
            out.writeLib(extensionLib);
            ajx.setLibraryWritten(extensionLib);
        }
        if (args == null) {
            out.writeScript("jmaki.addExtension({name : '" + extensionName + "', extensionDir : '" + extensionDir + "'});");
        } else {
            out.writeScript("jmaki.addExtension({name : '" + extensionName + "', extensionDir : '" + extensionDir + "', args : " + args + "});");
        }
    }
}

