/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmaki;

import com.sun.jmaki.AjaxContext;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AjaxCommon {
    private static String COUNTER = "jmaki_counter";
    private static String WROTE_SCRIPTS = "jmaki_wrote_script";
    private static String TYPES = "jmaki_types";
    private static String PROPERTIES_OLD = "jmaki_properties_old";
    private static String CHECKED_FOR_UPDATE = "jmaki_checked_for_update";
    private static String WROTE_STYLES = "jmaki_wrote_style";
    private static String WROTE_BOOTSTRAP = "jmaki_wrote_bootstrap";
    private static String WROTE_TYPES = "jmaki_included_types";
    private static String JS_LIBS = "jmaki_js_libs";
    private static String CACHE = "jmaki_cache";
    private static String CACHE_TIMES = "jmaki_cache_times";
    private static String DEFAULT_RESOURCE_ROOT = "resources/";
    public static String CLASSPATH_ROOT = "META-INF";
    private static String COMPONENT_NAME = "component";
    public static final int TEMPLATE = 1;
    public static final int STYLE = 2;
    public static final int SCRIPT = 3;
    private static Logger logger;

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("com.sun.jmaki.Log");
        }
        return logger;
    }

    public static JSONObject loadTypes(InputStream is, JSONObject prev) {
        JSONObject dConfig = null;
        JSONObject types = null;
        JSONObject apikeys = null;
        JSONObject config = null;
        try {
            String key;
            JSONObject value;
            int l;
            if (prev != null) {
                config = prev;
                types = config.has("types") ? config.getJSONObject("types") : new JSONObject();
                apikeys = config.has("apikeys") ? config.getJSONObject("apikeys") : new JSONObject();
            } else {
                config = new JSONObject();
                types = new JSONObject();
                apikeys = new JSONObject();
            }
            dConfig = AjaxCommon.loadJSONObject(is).getJSONObject("config");
            if (dConfig.has("types")) {
                JSONArray sA = dConfig.getJSONArray("types");
                for (l = 0; l < sA.length(); ++l) {
                    value = sA.getJSONObject(l);
                    key = value.getString("id");
                    JSONArray styles = new JSONArray();
                    if (value.has("styles")) {
                        JSONArray nA = value.getJSONArray("styles");
                        for (int il = 0; il < nA.length(); ++il) {
                            String s = nA.getString(il);
                            styles.put((Object)s);
                        }
                        if (!types.has("styles")) {
                            types.put("styles", (Object)styles);
                        }
                    }
                    if (types.has(key)) continue;
                    types.put(key, (Object)value);
                }
            }
            if (dConfig.has("apikeys")) {
                JSONArray nA = dConfig.getJSONArray("apikeys");
                for (l = 0; l < nA.length(); ++l) {
                    value = nA.getJSONObject(l);
                    key = value.getString("id");
                    if (apikeys.has(key)) continue;
                    apikeys.put(key, (Object)value);
                }
            }
            if (dConfig.has("glue")) {
                config.put("glue", (Object)dConfig.getJSONObject("glue"));
            }
            config.put("types", (Object)types);
            config.put("apikeys", (Object)apikeys);
        }
        catch (Exception ex) {
            AjaxCommon.getLogger().severe("AjaxCommon error loading config: " + ex);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject loadJSONObject(InputStream in) {
        ByteArrayOutputStream out = null;
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            out = new ByteArrayOutputStream();
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            JSONObject jSONObject = new JSONObject(out.toString());
            return jSONObject;
        }
        catch (Exception e) {
            AjaxCommon.getLogger().severe("AjaxCommon error reading in json " + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static synchronized void doProcess(AjaxContext ajx) {
        String webRoot;
        Writer out = ajx.getWriter();
        String resourcesDir = DEFAULT_RESOURCE_ROOT;
        String http = ajx.getScheme() + ":";
        String basePath = ajx.getRequestURI();
        String contextPath = ajx.getContextPath();
        String workingDir = "";
        JSONObject globalConfig = (JSONObject)ajx.getAttribute(TYPES);
        JSONObject globalTypes = null;
        int first = basePath.indexOf("/", 1);
        int last = basePath.lastIndexOf("/");
        if (first != -1 && last != -1) {
            workingDir = basePath.substring(first + 1, last + 1);
            ajx.getProperties().put("workingDir", workingDir);
        }
        if ((webRoot = ajx.getString("webRoot")) == null) {
            webRoot = http + "//" + ajx.getServerName();
            if (ajx.getServerPort() != 80) {
                webRoot = webRoot + ":" + ajx.getServerPort();
            }
            webRoot = webRoot + contextPath;
            ajx.getProperties().put("webRoot", webRoot);
        }
        if (ajx.getInitParameter("jmaki-resources") != null) {
            resourcesDir = ajx.getInitParameter("jmaki-resources");
        }
        String xhpMapping = "/xhp";
        if (ajx.getInitParameter("jmaki-xhp-mapping") != null) {
            xhpMapping = ajx.getInitParameter("jmaki-xhp-mapping");
        }
        xhpMapping = webRoot + xhpMapping;
        ajx.getProperties().put("xhpMapping", xhpMapping);
        if (resourcesDir.endsWith("/")) {
            resourcesDir = resourcesDir.substring(0, resourcesDir.length() - 1);
        }
        ajx.getProperties().put("resourcesDir", resourcesDir);
        boolean checkProps = ajx.getRequestAttribute(CHECKED_FOR_UPDATE) == null;
        boolean propsUpdated = false;
        if (globalConfig == null) {
            propsUpdated = true;
        } else if (checkProps) {
            propsUpdated = AjaxCommon.checkForUpdate("/" + resourcesDir, "/config.json", ajx);
            if (!propsUpdated) {
                propsUpdated = AjaxCommon.checkForUpdate("/WEB-INF/", "config.json", ajx);
            }
            ajx.setRequestAttribute(CHECKED_FOR_UPDATE, new Boolean(true));
        }
        if (propsUpdated) {
            try {
                URL url = ajx.getResource("/" + resourcesDir + "/config.json");
                InputStream is = null;
                if (null != url) {
                    is = url.openConnection().getInputStream();
                    if (is != null) {
                        globalConfig = AjaxCommon.loadTypes(is, null);
                        is.close();
                    } else {
                        AjaxCommon.getLogger().severe("AjaxCommon could not find config.json");
                    }
                }
                if (null != (url = ajx.getClass().getResource("/" + CLASSPATH_ROOT + "/" + resourcesDir + "/config.json"))) {
                    is = url.openConnection().getInputStream();
                    if (is != null) {
                        globalConfig = AjaxCommon.loadTypes(is, globalConfig);
                        is.close();
                    } else {
                        AjaxCommon.getLogger().severe("AjaxCommon could not find config.json");
                    }
                }
                ajx.setAttribute(TYPES, globalConfig);
            }
            catch (IOException e) {
                AjaxCommon.getLogger().severe("AjaxCommon error loading configuration: " + e);
            }
        }
        try {
            if (globalConfig != null) {
                globalTypes = globalConfig.getJSONObject("types");
            }
        }
        catch (JSONException je) {
            AjaxCommon.getLogger().severe("AjaxCommon error loading global types: " + (Object)((Object)je));
        }
        int counter = 0;
        Integer counterI = (Integer)ajx.getAttribute(COUNTER);
        if (counterI != null) {
            counter = counterI;
        }
        String uuid = ajx.getString("uuid");
        String name = ajx.getString("name");
        if (uuid == null) {
            uuid = name + "" + counter++;
            uuid = uuid.replace('.', '_');
        }
        ajx.setAttribute(COUNTER, new Integer(counter));
        try {
            String args;
            String valueCallback;
            String service;
            boolean wroteScript;
            boolean wroteStyle;
            JSONObject jType;
            int start;
            HashMap<String, Boolean> styles;
            HashMap<String, Boolean> libs;
            HashMap<String, Boolean> jsLibs;
            boolean wroteBootstrapScript;
            boolean bl = wroteBootstrapScript = ajx.getRequestAttribute(WROTE_BOOTSTRAP) != null;
            if (!wroteBootstrapScript) {
                AjaxCommon.writeBootstrapScript(ajx, globalConfig);
            }
            if ((jsLibs = (HashMap<String, Boolean>)ajx.getRequestAttribute(JS_LIBS)) == null) {
                jsLibs = new HashMap<String, Boolean>();
                ajx.setRequestAttribute(JS_LIBS, jsLibs);
            }
            if ((libs = (HashMap<String, Boolean>)ajx.getRequestAttribute(WROTE_TYPES)) == null) {
                libs = new HashMap<String, Boolean>();
                ajx.setRequestAttribute(WROTE_TYPES, libs);
            }
            if ((styles = (HashMap<String, Boolean>)ajx.getRequestAttribute(WROTE_STYLES)) == null) {
                styles = new HashMap<String, Boolean>();
                ajx.setRequestAttribute(WROTE_STYLES, styles);
            }
            boolean useClasspath = false;
            String compBase = null;
            String script = ajx.getString("script");
            if (script == null) {
                URL url;
                String urlString = "/" + workingDir + name.replace('.', '/') + "/";
                script = AjaxCommon.getResourceNameByType(urlString, 3, ajx);
                if (script == null) {
                    urlString = "/" + resourcesDir + "/" + name.replace('.', '/') + "/";
                    script = AjaxCommon.getResourceNameByType(urlString, 3, ajx);
                    if (script != null) {
                        compBase = "/" + resourcesDir + "/" + name.replace('.', '/') + "/";
                    }
                } else {
                    compBase = "/" + workingDir + name.replace('.', '/') + "/";
                }
                if (script == null && (url = AjaxCommon.checkForResource(CLASSPATH_ROOT + "/" + resourcesDir + "/" + name.replace('.', '/') + "/component.js", ajx, false)) != null) {
                    script = ajx.getString("jsfRoot") + "/" + resourcesDir + "/" + name.replace('.', '/') + "/component.js";
                    compBase = "/" + resourcesDir + "/" + name.replace('.', '/') + "/";
                    useClasspath = true;
                }
                script = webRoot + script;
            } else {
                String scriptURL = script;
                if (scriptURL.startsWith("/")) {
                    scriptURL = webRoot + scriptURL;
                } else if (!scriptURL.startsWith("http")) {
                    scriptURL = webRoot + "/" + workingDir + scriptURL;
                }
            }
            String type = null;
            if (type == null && globalTypes != null && globalTypes.has(name)) {
                type = name;
            } else if (type == null && name.indexOf(".") != -1 && (start = name.indexOf(".")) > 0) {
                type = name.substring(0, start);
            }
            JSONObject cfg = AjaxCommon.getWidgetConfig(ajx, compBase, useClasspath);
            if (ajx.getBoolean("useClasspath")) {
                useClasspath = ajx.getBoolean("useClasspath");
            }
            if (cfg != null) {
                try {
                    jType = cfg.getJSONObject("type");
                    String sType = jType.getString("id");
                    if (!libs.containsKey(sType)) {
                        String wr = webRoot;
                        if (useClasspath && ajx.getString("jsfRoot") != null) {
                            wr = wr + ajx.getString("jsfRoot");
                        }
                        if (jType.has("styles")) {
                            AjaxCommon.writeStyles(out, jType, styles, http, wr, compBase);
                        }
                        AjaxCommon.writeLibs(out, jType, cfg, jsLibs, http, wr, compBase);
                        libs.put(sType, new Boolean(true));
                    }
                }
                catch (JSONException jx) {
                    AjaxCommon.getLogger().severe("AjaxCommon JSON Error: " + (Object)((Object)jx));
                }
            } else if (globalTypes != null) {
                try {
                    if (globalTypes.has(type) && !libs.containsKey(type)) {
                        jType = globalTypes.getJSONObject(type);
                        String wr = webRoot;
                        if (useClasspath && ajx.getString("jsfRoot") != null) {
                            wr = wr + ajx.getString("jsfRoot");
                        }
                        if (jType.has("styles")) {
                            AjaxCommon.writeStyles(out, jType, styles, http, wr, null);
                        }
                        AjaxCommon.writeLibs(out, jType, globalConfig, jsLibs, http, wr, null);
                        libs.put(type, new Boolean(true));
                    }
                }
                catch (JSONException jsx) {
                    AjaxCommon.getLogger().severe("AjaxCommon error processing types" + (Object)((Object)jsx));
                }
            }
            String style = ajx.getString("style");
            boolean bl2 = wroteStyle = styles.get(name) != null;
            if (!wroteStyle) {
                String styleURL;
                if (style == null) {
                    styleURL = null;
                    if (!useClasspath) {
                        styleURL = AjaxCommon.getResourceNameByType(compBase, 2, ajx);
                    } else {
                        URL url = AjaxCommon.checkForResource(CLASSPATH_ROOT + compBase + "component.css", ajx, false);
                        if (url != null) {
                            styleURL = ajx.getString("jsfRoot") != null ? ajx.getString("jsfRoot") + compBase + "component.css" : compBase + "component.css";
                        }
                    }
                    if (styleURL != null) {
                        style = webRoot + styleURL;
                        out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + style + "\"></link>\n");
                    }
                } else if (style != null) {
                    styleURL = style;
                    if (styleURL.startsWith("/")) {
                        styleURL = webRoot + styleURL;
                    } else if (!styleURL.startsWith("http")) {
                        styleURL = webRoot + "/" + workingDir + styleURL;
                    }
                    out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + styleURL + "\"></link>\n");
                }
                styles.put(name, new Boolean(true));
            }
            boolean bl3 = wroteScript = libs.get(name) != null;
            if (script != null && !jsLibs.containsKey(script)) {
                out.write("<script type=\"text/javascript\" src=\"" + script + "\"></script>\n");
                jsLibs.put(script, new Boolean(true));
            }
            StringBuffer template = ajx.getTemplate();
            String templateURL = "";
            if (template == null) {
                templateURL = ajx.getString("template");
                if (templateURL != null) {
                    try {
                        template = AjaxCommon.getResource(ajx.getResource(templateURL).openStream());
                    }
                    catch (Exception ex) {
                        AjaxCommon.getLogger().severe("AjaxCommon URL error loading template  + : " + templateURL);
                    }
                } else {
                    if (!useClasspath) {
                        StringBuffer buff;
                        templateURL = AjaxCommon.getResourceNameByType(compBase, 1, ajx);
                        if (templateURL != null && (buff = AjaxCommon.getResource(templateURL, ajx)) != null) {
                            template = new StringBuffer(buff.toString());
                        }
                    } else {
                        StringBuffer buff;
                        URL url = AjaxCommon.checkForResource(CLASSPATH_ROOT + compBase + "component.htm", ajx, false);
                        if (url == null) {
                            url = AjaxCommon.checkForResource(CLASSPATH_ROOT + compBase + "component.html", ajx, false);
                        }
                        if (url != null && (buff = AjaxCommon.getResource(url.openStream())) != null) {
                            template = new StringBuffer(buff.toString());
                        }
                    }
                    if (templateURL != null && compBase == null) {
                        templateURL = !templateURL.startsWith("/") ? webRoot + "/" + workingDir + "/" + templateURL : webRoot + templateURL;
                    }
                }
            }
            String widgetDir = webRoot;
            if (useClasspath) {
                widgetDir = widgetDir + ajx.getString("jsfRoot");
            }
            if (widgetDir != null && widgetDir.endsWith("/") && widgetDir.length() > 0) {
                widgetDir = widgetDir.substring(0, widgetDir.length() - 1);
            }
            if (compBase != null && compBase.length() > 0) {
                widgetDir = widgetDir + compBase.substring(0, compBase.length() - 1);
            }
            if ((service = ajx.getString("service")) != null && !service.startsWith("http") && service.startsWith("/")) {
                service = webRoot + service;
            } else if (service != null && !service.startsWith("http")) {
                service = webRoot + "/" + workingDir + service;
            }
            String value = ajx.getString("value");
            if (template == null) {
                out.write("<h2>Error</h2> <p>Unable to locate the template file for widget " + name + ". Please make sure the widget is available.</p>");
                return;
            }
            AjaxCommon.replace(template, "${uuid}", uuid);
            if (service != null) {
                AjaxCommon.replace(template, "${service}", service);
            }
            if (value != null && !value.startsWith("@{")) {
                AjaxCommon.replace(template, "${value}", value);
            } else if (value != null && value.startsWith("@{")) {
                AjaxCommon.replace(template, "${value}", "");
            }
            AjaxCommon.replace(template, "${contextPath}", webRoot);
            AjaxCommon.replace(template, "${widgetDir}", widgetDir);
            out.write(template.toString());
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("uuid", uuid);
            props.put("name", name);
            props.put("widgetDir", widgetDir);
            props.put("script", script);
            String selected = ajx.getString("selected");
            if (selected != null) {
                props.put("selected", selected);
            }
            if (service != null) {
                props.put("service", service);
            }
            if ((valueCallback = ajx.getString("valueCallback")) != null) {
                props.put("valueCallback", valueCallback);
            }
            if (value != null) {
                props.put("value", value);
            }
            if ((args = ajx.getString("args")) != null) {
                props.put("args", args);
            }
            out.write("<script type=\"text/javascript\">\n");
            out.write(" jmaki.addWidget(" + AjaxCommon.createJavaScriptObject(props).toString() + ");");
            out.write("</script>\n");
            props = null;
        }
        catch (IOException iox) {
            AjaxCommon.getLogger().severe("AjaxCommon IO Error: " + iox);
        }
    }

    private static void writeBootstrapScript(AjaxContext ajx, JSONObject globalConfig) {
        Writer out = ajx.getWriter();
        String resourcesDir = ajx.getString("resourcesDir");
        String glueRoot = "";
        String webRoot = ajx.getString("webRoot");
        boolean embedBootstrap = false;
        String urlString = null;
        try {
            urlString = "/jmaki.js";
            URL url = ajx.getResource(urlString);
            if (url == null) {
                urlString = "/" + resourcesDir + "/jmaki.js";
                url = ajx.getResource(urlString);
            }
            if (url == null) {
                if (AjaxCommon.checkForResource(CLASSPATH_ROOT + "/" + resourcesDir + "/jmaki.js", ajx, false) != null) {
                    urlString = ajx.getString("jsfRoot") + "/" + resourcesDir + "/jmaki.js";
                    glueRoot = ajx.getString("jsfRoot");
                } else {
                    embedBootstrap = true;
                }
            }
            if (embedBootstrap) {
                StringBuffer bootstrapper = AjaxCommon.getResource("jmaki.js", ajx);
                if (bootstrapper != null) {
                    out.write("<script type=\"text/javascript\">" + bootstrapper.toString() + "</script>\n");
                    out.write("<script type=\"text/javascript\">jmaki.webRoot='" + webRoot + "';");
                    out.write("jmaki.resourcesRoot ='/" + resourcesDir + "';jmaki.xhp ='" + ajx.getString("xhpMapping") + "';</script>\n");
                    AjaxCommon.writeGlueIncludes(ajx, globalConfig, out, webRoot + glueRoot);
                } else {
                    out.write("<h2>Error</h2> <p>Unable to locate the jmaki.js in the component jar or web root. Please check to make sure the file is available.</p>");
                    AjaxCommon.getLogger().severe("AjaxTag error: Unable to locate the jmaki.js in the component jar or web root.");
                }
                ajx.setRequestAttribute(WROTE_BOOTSTRAP, new Boolean(true));
            } else {
                out.write("<script type=\"text/javascript\" src=\"" + webRoot + urlString + "\"></script>\n");
                out.write("<script type=\"text/javascript\">jmaki.webRoot='" + webRoot + "';");
                out.write("jmaki.resourcesRoot ='/" + resourcesDir + "';jmaki.xhp ='" + ajx.getString("xhpMapping") + "';</script>\n");
                AjaxCommon.writeGlueIncludes(ajx, globalConfig, out, webRoot + glueRoot);
                ajx.setRequestAttribute(WROTE_BOOTSTRAP, new Boolean(true));
            }
        }
        catch (IOException e) {
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private static Iterator loadGlueIncludes(JSONArray nA) throws JSONException {
        ArrayList<GlueInclude> gi = new ArrayList<GlueInclude>();
        for (int il = 0; il < nA.length(); ++il) {
            Object obj = nA.get(il);
            if (obj instanceof JSONObject) {
                JSONObject jo = (JSONObject)obj;
                GlueInclude gli = new GlueInclude();
                gli.url = jo.getString("url");
                gli.lib = jo.getString("lib");
                gi.add(gli);
                continue;
            }
            if (!(obj instanceof String)) continue;
            GlueInclude gli = new GlueInclude();
            gli.url = "*";
            gli.lib = (String)obj;
            gi.add(gli);
        }
        return gi.iterator();
    }

    private static void writeGlueIncludes(AjaxContext ajx, JSONObject globalConfig, Writer out, String root) throws IOException, JSONException {
        if (globalConfig == null || !globalConfig.has("glue") && globalConfig.getJSONObject("glue").has("includes")) {
            return;
        }
        Iterator i = AjaxCommon.loadGlueIncludes(globalConfig.getJSONObject("glue").getJSONArray("includes"));
        while (i.hasNext()) {
            GlueInclude gi = (GlueInclude)i.next();
            if (!gi.url.equals("*") && !gi.url.equals(ajx.getCurrentURI())) continue;
            out.write("<script type=\"text/javascript\" src=\"" + root + gi.lib + "\"></script>\n");
        }
    }

    private static JSONObject getWidgetConfig(AjaxContext ajx, String compBase, boolean useClasspath) {
        JSONObject cfg = null;
        JSONObject wf = null;
        try {
            URL url = null;
            String urlString = null;
            if (!useClasspath) {
                url = ajx.getResource(compBase + "widget.json");
                if (url != null) {
                    urlString = compBase + "widget.json";
                }
            } else {
                url = ajx.getClass().getResource("/" + CLASSPATH_ROOT + compBase + "widget.json");
                if (url != null) {
                    urlString = "/" + CLASSPATH_ROOT + compBase + "widget.json";
                }
                ajx.getProperties().put("useClasspath", new Boolean(true));
            }
            if (urlString == null) {
                return null;
            }
            StringBuffer buff = AjaxCommon.getResource(urlString, true, null, ajx);
            if (buff == null) {
                return null;
            }
            try {
                wf = new JSONObject(buff.toString());
            }
            catch (JSONException jx) {
                AjaxCommon.getLogger().severe("AjaxCommon JSON Error: " + (Object)((Object)jx));
            }
            if (wf == null || !wf.has("config")) {
                return null;
            }
            cfg = wf.getJSONObject("config");
            if (cfg.has("apikeys")) {
                JSONArray nA = cfg.getJSONArray("apikeys");
                JSONObject apikeys = new JSONObject();
                for (int l = 0; l < nA.length(); ++l) {
                    JSONObject value = nA.getJSONObject(l);
                    String key = value.getString("id");
                    apikeys.put(key, (Object)value);
                }
                cfg.put("apikeys", (Object)apikeys);
            }
        }
        catch (JSONException jx) {
            AjaxCommon.getLogger().severe("AjaxCommon JSON Error: " + (Object)((Object)jx));
        }
        catch (IOException e) {
            AjaxCommon.getLogger().severe("AjaxCommon error loading configuration: " + e);
        }
        return cfg;
    }

    private static void writeStyles(Writer out, JSONObject jType, HashMap styles, String http, String webRoot, String widgetRoot) throws JSONException, IOException {
        JSONArray lA = jType.getJSONArray("styles");
        for (int l = 0; l < lA.length(); ++l) {
            String lStyle = lA.getString(l);
            if (lStyle == null) continue;
            if (!lStyle.startsWith(http) && widgetRoot == null) {
                lStyle = webRoot + lStyle;
            } else if (!lStyle.startsWith(http)) {
                lStyle = lStyle.startsWith("/") ? webRoot + lStyle : webRoot + widgetRoot + lStyle;
            }
            out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + lStyle + "\"></link>\n");
            styles.put(lStyle, new Boolean(true));
        }
    }

    private static void writeLibs(Writer out, JSONObject jType, JSONObject cfg, HashMap jsLibs, String http, String webRoot, String widgetRoot) throws JSONException, IOException {
        JSONArray sA = jType.getJSONArray("libs");
        if (sA == null) {
            return;
        }
        for (int l = 0; l < sA.length(); ++l) {
            String library = "";
            String jlib = sA.getString(l);
            if (jType.has("apikey")) {
                String apiKey = jType.getString("apikey");
                JSONObject globalAPIKeys = cfg.getJSONObject("apikeys");
                if (globalAPIKeys.has(apiKey)) {
                    JSONObject targetKey = globalAPIKeys.getJSONObject(apiKey);
                    JSONArray targetKeys = targetKey.getJSONArray("keys");
                    for (int al = 0; al < targetKeys.length(); ++al) {
                        JSONObject apiJSONObject = targetKeys.getJSONObject(al);
                        String targetURL = apiJSONObject.getString("url");
                        if ((targetURL == null || !targetURL.equals(webRoot)) && !targetURL.equals(webRoot + "/") && !targetURL.equals("*")) continue;
                        jlib = jlib + apiJSONObject.getString("key");
                    }
                }
            }
            if (jlib != null && jlib.startsWith(http)) {
                library = jlib;
            } else if (widgetRoot == null) {
                if (!jlib.startsWith("/")) {
                    library = "/";
                }
                library = webRoot + jlib;
            } else {
                library = jlib.startsWith("/") ? webRoot + jlib : webRoot + widgetRoot + jlib;
            }
            if (jType.has("preload")) {
                out.write("<script type=\"text/javascript\">" + jType.getString("preload") + "</script>\n");
            }
            if (!jsLibs.containsKey(library)) {
                out.write("<script type=\"text/javascript\" src=\"" + library + "\"></script>\n");
                jsLibs.put(library, new Boolean(true));
            }
            if (!jType.has("postload")) continue;
            out.write("<script type=\"text/javascript\">" + jType.getString("postload") + "</script>\n");
        }
    }

    public static StringBuffer getResource(String resource, AjaxContext ajx) {
        StringBuffer buffer = AjaxCommon.getResource(resource, true, DEFAULT_RESOURCE_ROOT, ajx);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForUpdate(String resourceRoot, String resource, AjaxContext ajx) {
        URL url = AjaxCommon.class.getResource(resourceRoot + resource);
        try {
            if (url == null) {
                url = ajx.getResource(resourceRoot + resource);
            }
            if (url == null) {
                return false;
            }
            URLConnection con = url.openConnection();
            HashMap cache = (HashMap)ajx.getAttribute(CACHE);
            HashMap<String, Long> cacheTimes = (HashMap<String, Long>)ajx.getAttribute(CACHE_TIMES);
            if (cache == null) {
                cache = new HashMap();
                cacheTimes = new HashMap<String, Long>();
                ajx.setAttribute(CACHE, cache);
                ajx.setAttribute(CACHE_TIMES, cacheTimes);
            }
            long lastModified = con.getLastModified();
            long cacheModified = 0L;
            if (cacheTimes.get(resourceRoot + resource) != null) {
                cacheModified = (Long)cacheTimes.get(resourceRoot + resource);
            }
            if (cacheModified < lastModified) {
                HashMap<String, Long> hashMap = cacheTimes;
                synchronized (hashMap) {
                    cacheTimes.put(resourceRoot + resource, new Long(lastModified));
                    return true;
                }
            }
        }
        catch (IOException e) {
            AjaxCommon.getLogger().severe("AjaxCommon IO error loading properties: " + e);
        }
        catch (Exception ex) {
            AjaxCommon.getLogger().severe("AjaxCommon error loading properties: " + ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer getResource(String resource, boolean cacheContent, String resourceRoot, AjaxContext ajx) {
        InputStream stream = null;
        try {
            URL url = ajx.getResource(resource);
            if (url == null) {
                url = AjaxCommon.class.getResource(resource);
            }
            if (url == null) {
                url = AjaxCommon.class.getResource(CLASSPATH_ROOT + resource);
            }
            if (url == null) {
                return null;
            }
            try {
                URLConnection con = url.openConnection();
                String fileEncoding = "UTF-8";
                if (cacheContent) {
                    HashMap<String, StringBuffer> cache = (HashMap<String, StringBuffer>)ajx.getAttribute(CACHE);
                    HashMap<String, Long> cacheTimes = (HashMap<String, Long>)ajx.getAttribute(CACHE_TIMES);
                    if (cache == null) {
                        cache = new HashMap<String, StringBuffer>();
                        cacheTimes = new HashMap<String, Long>();
                        ajx.setAttribute(CACHE, cache);
                        ajx.setAttribute(CACHE_TIMES, cacheTimes);
                    }
                    long lastModified = con.getLastModified();
                    long cacheModified = 0L;
                    if (cacheTimes.get(resource) != null) {
                        cacheModified = (Long)cacheTimes.get(resource);
                    }
                    if (cacheModified < lastModified) {
                        stream = con.getInputStream();
                        StringBuffer buffer = AjaxCommon.getResource(stream, "UTF-8");
                        Serializable serializable = cacheTimes;
                        synchronized (serializable) {
                            cacheTimes.put(resource, new Long(lastModified));
                        }
                        serializable = cache;
                        synchronized (serializable) {
                            cache.put(resource, buffer);
                        }
                        serializable = buffer;
                        return serializable;
                    }
                    StringBuffer stringBuffer = (StringBuffer)cache.get(resource);
                    return stringBuffer;
                }
                stream = con.getInputStream();
                StringBuffer stringBuffer = AjaxCommon.getResource(stream, "UTF-8");
                return stringBuffer;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            AjaxCommon.getLogger().info("AjaxCommon : Could not load " + resource);
            return null;
        }
    }

    public static String getResourceNameByType(String compBase, int type, AjaxContext ajx) {
        String urlName;
        URL url;
        if (compBase == null) {
            AjaxCommon.getLogger().info("AjaxCommon:getResourceByType: compBase is null.");
            return null;
        }
        String extension = null;
        switch (type) {
            case 2: {
                extension = ".css";
                break;
            }
            case 3: {
                extension = ".js";
                break;
            }
            case 1: {
                extension = ".htm";
            }
        }
        if (extension == null) {
            AjaxCommon.getLogger().severe("AjaxCommon:getResourceByType: type " + type + " not supported.");
        }
        if ((url = AjaxCommon.checkForResource(urlName = compBase + COMPONENT_NAME + extension, ajx, true)) == null && type == 1) {
            urlName = urlName + "l";
            url = AjaxCommon.checkForResource(urlName, ajx, true);
        }
        if (url != null) {
            return urlName;
        }
        return null;
    }

    public static URL checkForResource(String resource, AjaxContext ajx, boolean fromWeb) {
        Object url = null;
        try {
            if (!fromWeb) {
                return AjaxCommon.class.getClassLoader().getResource(resource);
            }
            return ajx.getResource(resource);
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    public static StringBuffer getResource(InputStream stream) {
        return AjaxCommon.getResource(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer getResource(InputStream stream, String encoding) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader bufReader = null;
        String curLine = null;
        try {
            try {
                InputStreamReader inputStreamReader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
                bufReader = new BufferedReader(inputStreamReader);
                while (null != (curLine = bufReader.readLine())) {
                    buffer.append(curLine + "\n");
                }
            }
            finally {
                if (bufReader != null) {
                    bufReader.close();
                }
            }
        }
        catch (Exception e) {
            AjaxCommon.getLogger().severe("AjaxCommon:loadResource from stream error:" + e);
        }
        return buffer;
    }

    public static void replace(StringBuffer buff, String target, String replacement) {
        if (buff == null || target == null || replacement == null) {
            return;
        }
        for (int index = 0; index < buff.length() && (index = buff.indexOf(target)) != -1; index += replacement.length() + 1) {
            buff.replace(index, index + target.length(), replacement);
        }
    }

    public static StringBuffer createJavaScriptObject(Map p) {
        return AjaxCommon.createJavaScriptObject(p, false);
    }

    public static StringBuffer createJavaScriptObject(Map p, boolean json) {
        StringBuffer buff = new StringBuffer("{");
        Iterator it = p.entrySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next().getKey();
            Object val = p.get(key);
            if (val != null && val instanceof Map) {
                val = AjaxCommon.createJavaScriptObject((Map)val);
            }
            if (json) {
                buff.append("'" + key + "':");
            } else {
                buff.append(key + ":");
            }
            if (val == null) {
                buff.append("null");
            } else if (val instanceof Float || val instanceof Long || val instanceof Integer || val instanceof StringBuffer) {
                buff.append(val.toString());
            } else if (val instanceof String && ((String)val).trim().startsWith("{") || ((String)val).trim().startsWith("[")) {
                buff.append(val.toString());
            } else {
                buff.append("'" + val.toString() + "'");
            }
            if (!it.hasNext()) continue;
            buff.append(",");
        }
        buff.append("}");
        return buff;
    }

    static class GlueInclude {
        String url;
        String lib;

        GlueInclude() {
        }
    }
}

