/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.util;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingRelationshipElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.util.LogHelperModel;
import com.sun.jdo.api.persistence.model.util.ModelValidationException;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.netbeans.modules.dbschema.util.SQLTypeUtil;

public class ModelValidator {
    private Model _model;
    private String _className;
    private ClassLoader _classLoader;
    private ResourceBundle _messages;

    public ModelValidator(Model model, String className, ResourceBundle bundle) {
        this(model, className, null, bundle);
    }

    public ModelValidator(Model model, String className, ClassLoader classLoader, ResourceBundle bundle) {
        this._model = model;
        this._className = className;
        this._classLoader = classLoader;
        this._messages = bundle;
    }

    public Model getModel() {
        return this._model;
    }

    public String getClassName() {
        return this._className;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    protected ResourceBundle getMessages() {
        return this._messages;
    }

    public boolean parseCheck() {
        Iterator iterator = this.getBasicValidationList().iterator();
        try {
            while (iterator.hasNext()) {
                ((ValidationComponent)iterator.next()).validate();
            }
        }
        catch (ModelValidationException e) {
            LogHelperModel.getLogger().log(400, "model.parse_error", e);
            return false;
        }
        return true;
    }

    public Collection fullValidationCheck() {
        ArrayList<ModelValidationException> list = new ArrayList<ModelValidationException>();
        Iterator iterator = this.getFullValidationList().iterator();
        while (iterator.hasNext()) {
            try {
                ((ValidationComponent)iterator.next()).validate();
            }
            catch (ModelValidationException e) {
                list.add(e);
            }
        }
        return Collections.unmodifiableCollection(list);
    }

    public Collection getBasicValidationList() {
        ArrayList<ValidationComponent> list = new ArrayList<ValidationComponent>();
        String className = this.getClassName();
        list.add(this.createClassExistenceComponent(className));
        list.add(this.createClassPersistenceComponent(className));
        list.addAll(this.getDatabaseValidationList());
        list.addAll(this.getFieldsValidationList());
        return Collections.unmodifiableCollection(list);
    }

    public Collection getFullValidationList() {
        ArrayList<ValidationComponent> list = new ArrayList<ValidationComponent>(this.getBasicValidationList());
        String className = this.getClassName();
        PersistenceClassElement persistenceClass = this.getPersistenceClass(className);
        if (persistenceClass != null) {
            PersistenceFieldElement[] fields = persistenceClass.getFields();
            int count = fields != null ? fields.length : 0;
            list.add(this.createSerializableClassComponent(className));
            list.add(this.createKeyClassComponent(persistenceClass.getKeyClass()));
            list.add(this.createClassMappingComponent(persistenceClass));
            list.add(this.createKeyColumnMappingComponent(persistenceClass));
            for (int i = 0; i < count; ++i) {
                PersistenceFieldElement field = fields[i];
                list.add(this.createFieldCardinalityComponent(field));
                list.add(this.createFieldMappingComponent(field));
                list.add(this.createFieldBlobMappingComponent(field));
                list.addAll(this.getRelatedClassValidationList(field));
            }
        }
        return Collections.unmodifiableCollection(list);
    }

    private Collection getDatabaseValidationList() {
        ArrayList<ValidationComponent> list = new ArrayList<ValidationComponent>();
        String className = this.getClassName();
        MappingClassElement mappingClass = this.getMappingClass(className);
        if (mappingClass != null) {
            ArrayList tables = mappingClass.getTables();
            int count = tables != null ? tables.size() : 0;
            MappingTableElement primaryTable = null;
            Iterator iterator = null;
            list.add(this.createSchemaExistenceComponent(className));
            for (int i = 0; i < count; ++i) {
                MappingTableElement nextTable = (MappingTableElement)tables.get(i);
                list.add(this.createTableExistenceComponent(nextTable.getTable()));
                if (i == 0) {
                    primaryTable = nextTable;
                    list.add(this.createPrimaryTableComponent(primaryTable));
                    continue;
                }
                MappingReferenceKeyElement referenceKey = this.findReferenceKey(primaryTable, nextTable);
                if (referenceKey == null) continue;
                iterator = referenceKey.getColumnPairNames().iterator();
                while (iterator.hasNext()) {
                    list.add(this.createColumnExistenceComponent((String)iterator.next()));
                }
            }
            list.add(this.createVersionConsistencyComponent(mappingClass));
            for (MappingFieldElement nextField : mappingClass.getFields()) {
                ArrayList allColumns = new ArrayList();
                Iterator columnIterator = null;
                if (this.isRelationship(nextField)) {
                    allColumns.addAll(((MappingRelationshipElement)nextField).getAssociatedColumns());
                }
                allColumns.addAll(nextField.getColumns());
                columnIterator = allColumns.iterator();
                while (columnIterator.hasNext()) {
                    list.add(this.createColumnExistenceComponent((String)columnIterator.next(), nextField));
                }
            }
        }
        return list;
    }

    private Collection getFieldsValidationList() {
        ArrayList<ValidationComponent> list = new ArrayList<ValidationComponent>();
        Model model = this.getModel();
        String className = this.getClassName();
        PersistenceClassElement persistenceClass = this.getPersistenceClass(className);
        if (persistenceClass != null) {
            Comparable field;
            PersistenceFieldElement[] fields = persistenceClass.getFields();
            int count = fields != null ? fields.length : 0;
            Iterator iterator = this.getMappingClass(className).getFields().iterator();
            for (int i = 0; i < count; ++i) {
                field = fields[i];
                list.add(this.createFieldExistenceComponent(field));
                if (!model.hasField(className, ((PersistenceElement)field).getName())) continue;
                list.add(this.createFieldPersistenceComponent((PersistenceFieldElement)field));
                list.add(this.createFieldPersistenceTypeComponent((PersistenceFieldElement)field));
                list.add(this.createFieldConsistencyComponent((PersistenceFieldElement)field));
                if (!this.isLegalRelationship((PersistenceFieldElement)field)) continue;
                RelationshipElement rel = (RelationshipElement)field;
                list.add(this.createElementClassComponent(rel));
                list.add(this.createRelatedClassMatchesComponent(rel));
            }
            while (iterator.hasNext()) {
                field = (MappingFieldElement)iterator.next();
                String fieldName = field.getName();
                if (persistenceClass.getField(fieldName) == null) {
                    list.add(this.createFieldExistenceComponent(field));
                    if (model.hasField(className, fieldName)) {
                        list.add(this.createFieldConsistencyComponent((MappingFieldElement)field));
                    }
                }
                if (!this.isRelationship(field)) {
                    list.add(this.createColumnOverlapComponent((MappingFieldElement)field));
                }
                if (Boolean.getBoolean("AllowManagedFieldsInDefaultFetchGroup")) continue;
                list.add(this.createFieldDefaultFetchGroupComponent((MappingFieldElement)field));
            }
        }
        return list;
    }

    private Collection getRelatedClassValidationList(PersistenceFieldElement field) {
        String relatedClass = this.getRelatedClass(field);
        ArrayList<ValidationComponent> list = new ArrayList<ValidationComponent>();
        if (relatedClass != null && this.getModel().hasField(this.getClassName(), field.getName())) {
            MappingClassElement relatedClassElement = this.getMappingClass(relatedClass);
            list.add(this.createClassExistenceComponent(relatedClass, field));
            list.add(this.createClassPersistenceComponent(relatedClass, field));
            list.add(this.createSchemaExistenceComponent(relatedClass, field));
            list.add(this.createRelatedSchemaMatchesComponent(relatedClass, field));
            if (relatedClassElement != null) {
                boolean hasTables;
                ArrayList tables = relatedClassElement.getTables();
                MappingTableElement primaryTable = null;
                boolean bl = hasTables = tables != null && tables.size() > 0;
                if (hasTables) {
                    primaryTable = (MappingTableElement)tables.get(0);
                    list.add(this.createTableExistenceComponent(primaryTable.getTable(), field));
                }
                if (this.isRelationship(field)) {
                    RelationshipElement relElement = (RelationshipElement)field;
                    MappingFieldElement rel = this.getMappingClass(this.getClassName()).getField(field.getName());
                    list.add(this.createInverseFieldComponent(relElement));
                    list.add(this.createInverseMappingComponent(relElement));
                    if (rel != null && this.isRelationship(rel)) {
                        MappingRelationshipElement relationship = (MappingRelationshipElement)rel;
                        ArrayList columns = relationship.getAssociatedColumns();
                        Iterator iterator = null;
                        if (columns == null || columns.size() == 0) {
                            columns = relationship.getColumns();
                        }
                        if (columns != null) {
                            ArrayList<String> tableNames = new ArrayList<String>();
                            if (hasTables) {
                                Iterator tableIterator = tables.iterator();
                                while (tableIterator.hasNext()) {
                                    tableNames.add(((MappingTableElement)tableIterator.next()).getName());
                                }
                            }
                            iterator = columns.iterator();
                            while (iterator.hasNext()) {
                                list.add(this.createRelatedTableMatchesComponent(relatedClass, field, tableNames, (String)iterator.next()));
                            }
                        }
                    }
                }
            }
        }
        return list;
    }

    protected ValidationComponent createClassExistenceComponent(final String className, final PersistenceFieldElement relatedField) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (className == null || !ModelValidator.this.getModel().hasClass(className, ModelValidator.this.getClassLoader())) {
                    throw ModelValidator.this.constructClassException(className, relatedField, "util.validation.class_not_found");
                }
            }
        };
    }

    protected ValidationComponent createClassExistenceComponent(String className) {
        return this.createClassExistenceComponent(className, null);
    }

    protected ValidationComponent createClassPersistenceComponent(final String className, final PersistenceFieldElement relatedField) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                if (className != null && model.hasClass(className, ModelValidator.this.getClassLoader())) {
                    String key = null;
                    if (!ModelValidator.this.isPersistent(className)) {
                        key = "util.validation.class_not_persistence_capable";
                    } else if (!model.isPersistenceCapableAllowed(className)) {
                        key = "util.validation.class_not_allowed";
                    }
                    if (key != null) {
                        throw ModelValidator.this.constructClassException(className, relatedField, key);
                    }
                }
            }
        };
    }

    protected ValidationComponent createClassPersistenceComponent(String className) {
        return this.createClassPersistenceComponent(className, null);
    }

    protected ValidationComponent createFieldExistenceComponent(final String fieldName) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (!ModelValidator.this.getModel().hasField(ModelValidator.this.getClassName(), fieldName)) {
                    throw ModelValidator.this.constructFieldException(fieldName, "util.validation.field_not_found");
                }
            }
        };
    }

    protected ValidationComponent createFieldExistenceComponent(Object field) {
        return this.createFieldExistenceComponent(field.toString());
    }

    protected ValidationComponent createFieldPersistenceComponent(final PersistenceFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                boolean isPersistent = 0 == field.getPersistenceType();
                String fieldName = field.getName();
                if (isPersistent && !ModelValidator.this.isPersistentAllowed(ModelValidator.this.getClassName(), fieldName)) {
                    throw ModelValidator.this.constructFieldException(fieldName, "util.validation.field_persistent_not_allowed");
                }
            }
        };
    }

    protected ValidationComponent createFieldConsistencyComponent(final PersistenceFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String fieldName = field.getName();
                String className = ModelValidator.this.getClassName();
                boolean isLegallyPersistent = ModelValidator.this.isPersistentAllowed(className, fieldName);
                if (isLegallyPersistent) {
                    boolean jdoIsRelationship;
                    MappingFieldElement mappingElement;
                    MappingClassElement mappingClass = ModelValidator.this.getMappingClass(className);
                    MappingFieldElement mappingFieldElement = mappingElement = mappingClass != null ? mappingClass.getField(fieldName) : null;
                    if (mappingElement != null && (jdoIsRelationship = ModelValidator.this.isLegalRelationship(field)) != ModelValidator.this.isRelationship(mappingElement)) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.field_type_inconsistent");
                    }
                }
            }
        };
    }

    protected ValidationComponent createFieldConsistencyComponent(final MappingFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (field != null) {
                    PersistenceFieldElement persistenceElement;
                    String fieldName = field.getName();
                    PersistenceClassElement persistenceClass = ModelValidator.this.getPersistenceClass(ModelValidator.this.getClassName());
                    PersistenceFieldElement persistenceFieldElement = persistenceElement = persistenceClass != null ? persistenceClass.getField(fieldName) : null;
                    if (persistenceElement == null) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.field_model_inconsistent");
                    }
                }
            }
        };
    }

    protected ValidationComponent createFieldPersistenceTypeComponent(final PersistenceFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String fieldName = field.getName();
                String className = ModelValidator.this.getClassName();
                boolean isLegallyPersistent = ModelValidator.this.isPersistentAllowed(className, fieldName);
                if (isLegallyPersistent) {
                    boolean isRelationship = ModelValidator.this.isRelationship(field);
                    boolean mustBeRelationship = ModelValidator.this.shouldBeRelationship(field);
                    if (isRelationship && !mustBeRelationship) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.field_relationship_not_allowed");
                    }
                    if (!isRelationship && mustBeRelationship) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.field_type_not_allowed");
                    }
                }
            }
        };
    }

    protected ValidationComponent createFieldCardinalityComponent(final PersistenceFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (ModelValidator.this.isLegalRelationship(field)) {
                    ForeignKeyElement fk;
                    RelationshipElement relationship = (RelationshipElement)field;
                    String fieldName = field.getName();
                    boolean nonCollectionRelationship = !ModelValidator.this.isCollection(ModelValidator.this.getClassName(), fieldName);
                    int upperBound = nonCollectionRelationship ? 1 : relationship.getUpperBound();
                    int lowerBound = relationship.getLowerBound();
                    MappingRelationshipElement mapping = null;
                    if (lowerBound < 0 || upperBound <= 0 || lowerBound > upperBound) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.cardinality_invalid");
                    }
                    mapping = ModelValidator.this.getMappingRelationship(relationship);
                    if (nonCollectionRelationship && lowerBound != 1 && mapping != null && !ModelValidator.this.isJoin(mapping) && (fk = this.getMatchingFK(mapping)) != null && this.hasNonNullableColumn(fk)) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.lower_bound_invalid");
                    }
                }
            }

            private boolean hasNonNullableColumn(ForeignKeyElement fk) {
                ColumnElement[] localColumns = fk.getLocalColumns();
                int count = localColumns != null ? localColumns.length : 0;
                for (int i = 0; i < count; ++i) {
                    if (localColumns[i].isNullable()) continue;
                    return true;
                }
                return false;
            }

            private ForeignKeyElement getMatchingFK(MappingRelationshipElement mapping) {
                MappingClassElement mappingClass = mapping.getDeclaringClass();
                String databaseRoot = ModelValidator.this.getSchemaForClass(ModelValidator.this.getClassName());
                ArrayList pairNames = mapping.getColumns();
                ArrayList tables = mappingClass.getTables();
                if (tables != null) {
                    Iterator i = tables.iterator();
                    while (i.hasNext()) {
                        String tableName = ((MappingTableElement)i.next()).getName();
                        TableElement table = ModelValidator.this.getTable(tableName, databaseRoot);
                        ForeignKeyElement fk = this.getMatchingFK(pairNames, table);
                        if (fk == null) continue;
                        return fk;
                    }
                }
                return null;
            }

            private ForeignKeyElement getMatchingFK(List pairNames, TableElement table) {
                ForeignKeyElement[] foreignKeys = table != null ? table.getForeignKeys() : null;
                int count = foreignKeys != null ? foreignKeys.length : 0;
                for (int i = 0; i < count; ++i) {
                    if (!this.matchesFK(pairNames, foreignKeys[i])) continue;
                    return foreignKeys[i];
                }
                return null;
            }

            private boolean matchesFK(List pairNames, ForeignKeyElement foreignKey) {
                int count;
                ColumnPairElement[] fkPairs = foreignKey.getColumnPairs();
                int fkCount = fkPairs != null ? fkPairs.length : 0;
                int n = count = pairNames != null ? pairNames.size() : 0;
                if (fkCount == count) {
                    for (int i = 0; i < fkCount; ++i) {
                        String fkPairName = NameUtil.getRelativeMemberName((String)fkPairs[i].getName().getFullName());
                        if (pairNames.contains(fkPairName)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected ValidationComponent createFieldMappingComponent(final PersistenceFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                MappingFieldElement mappingField;
                String fieldName = field.getName();
                MappingClassElement mappingClass = ModelValidator.this.getMappingClass(ModelValidator.this.getClassName());
                if (mappingClass != null && mappingClass.getTables().size() > 0 && ((mappingField = mappingClass.getField(fieldName)) == null || mappingField.getColumns().size() == 0)) {
                    throw ModelValidator.this.constructFieldException(1, fieldName, "util.validation.field_not_mapped");
                }
            }
        };
    }

    protected ValidationComponent createFieldBlobMappingComponent(final PersistenceFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                boolean isKey;
                MappingFieldElement mappingField;
                String className = ModelValidator.this.getClassName();
                String fieldName = field.getName();
                MappingClassElement mappingClass = ModelValidator.this.getMappingClass(className);
                MappingFieldElement mappingFieldElement = mappingField = mappingClass != null ? mappingClass.getField(fieldName) : null;
                if (mappingField != null && ((isKey = field.isKey()) || 1 == mappingField.getFetchGroup()) && this.isMappedToBlob(mappingField, ModelValidator.this.getSchemaForClass(className))) {
                    throw ModelValidator.this.constructFieldException(fieldName, isKey ? "util.validation.field_key_field_not_allowed" : "util.validation.field_fetch_group_not_allowed");
                }
            }

            private boolean isMappedToBlob(MappingFieldElement mappingField, String schema) {
                if (mappingField instanceof MappingRelationshipElement) {
                    return this.isMappedToBlob((MappingRelationshipElement)mappingField, schema);
                }
                Iterator iterator = mappingField.getColumns().iterator();
                while (iterator.hasNext()) {
                    String absoluteName = NameUtil.getAbsoluteMemberName((String)schema, (String)((String)iterator.next()));
                    TableElement table = TableElement.forName((String)NameUtil.getTableName((String)absoluteName));
                    ColumnElement columnElement = table != null ? (ColumnElement)table.getMember(DBIdentifier.create((String)absoluteName)) : null;
                    if (!this.isMappedToBlob(columnElement)) continue;
                    return true;
                }
                return false;
            }

            private boolean isMappedToBlob(MappingRelationshipElement rel, String schema) {
                ColumnPairElement pair;
                Iterator iterator = rel.getColumns().iterator();
                while (iterator.hasNext()) {
                    pair = ModelValidator.this.getPair((String)iterator.next(), schema);
                    if (!this.isMappedToBlob(pair)) continue;
                    return true;
                }
                iterator = rel.getAssociatedColumns().iterator();
                while (iterator.hasNext()) {
                    pair = ModelValidator.this.getPair((String)iterator.next(), schema);
                    if (!this.isMappedToBlob(pair)) continue;
                    return true;
                }
                return false;
            }

            private boolean isMappedToBlob(ColumnPairElement pair) {
                return pair == null ? false : this.isMappedToBlob(pair.getLocalColumn()) && this.isMappedToBlob(pair.getReferencedColumn());
            }

            private boolean isMappedToBlob(ColumnElement column) {
                return column != null && SQLTypeUtil.isBlob((int)column.getType());
            }
        };
    }

    protected ValidationComponent createCollectionClassComponent(final RelationshipElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String fieldName;
                String className = ModelValidator.this.getClassName();
                if (ModelValidator.this.isCollection(className, fieldName = field.getName())) {
                    Model model = ModelValidator.this.getModel();
                    String collectionClass = field.getCollectionClass();
                    String fieldType = model.getFieldType(className, fieldName);
                    boolean missingCollectionClass = StringHelper.isEmpty(collectionClass);
                    if (!missingCollectionClass && !model.getSupportedCollectionClasses(fieldType).contains(collectionClass)) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.collection_class_invalid");
                    }
                }
            }
        };
    }

    protected ValidationComponent createElementClassComponent(final RelationshipElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String elementClass;
                String fieldName;
                String className = ModelValidator.this.getClassName();
                if (ModelValidator.this.isCollection(className, fieldName = field.getName()) && StringHelper.isEmpty(elementClass = field.getElementClass())) {
                    MappingFieldElement mappingElement;
                    MappingClassElement mappingClass = ModelValidator.this.getMappingClass(className);
                    MappingFieldElement mappingFieldElement = mappingElement = mappingClass != null ? mappingClass.getField(fieldName) : null;
                    if (mappingElement != null && mappingElement.getColumns().size() > 0) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.element_class_not_found");
                    }
                }
            }
        };
    }

    protected ValidationComponent createVersionConsistencyComponent(final MappingClassElement mappingClass) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (16 == mappingClass.getConsistencyLevel()) {
                    MappingFieldElement versionField = this.validateVersionFieldExistence();
                    String className = mappingClass.getName();
                    String fieldName = versionField.getName();
                    String columnName = null;
                    ColumnElement column = null;
                    if (versionField instanceof MappingRelationshipElement) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.version_field_relationship_not_allowed");
                    }
                    if (1 != versionField.getFetchGroup()) {
                        throw ModelValidator.this.constructFieldException(fieldName, "util.validation.version_field_fetch_group_invalid");
                    }
                    this.validatePersistenceFieldAttributes(className, fieldName);
                    columnName = this.validateVersionFieldMapping(versionField);
                    column = this.validateTableMatch(className, fieldName, columnName);
                    this.validateColumnAttributes(className, fieldName, column);
                }
            }

            private MappingFieldElement validateVersionFieldExistence() throws ModelValidationException {
                List versionFields = mappingClass.getVersionFields();
                if (versionFields.size() != 1) {
                    throw ModelValidator.this.constructClassException(mappingClass.getName(), null, "util.validation.version_field_cardinality");
                }
                return (MappingFieldElement)versionFields.get(0);
            }

            private void validatePersistenceFieldAttributes(String className, String fieldName) throws ModelValidationException {
                Class fieldType = JavaTypeHelper.getPrimitiveClass(ModelValidator.this.getModel().getFieldType(className, fieldName));
                String keyName = null;
                if (ModelValidator.this.getPersistenceClass(className).getField(fieldName).isKey()) {
                    keyName = "util.validation.version_field_key_field_not_allowed";
                } else if (Long.TYPE != fieldType) {
                    keyName = "util.validation.version_field_type_not_allowed";
                }
                if (keyName != null) {
                    throw ModelValidator.this.constructFieldException(fieldName, keyName);
                }
            }

            private String validateVersionFieldMapping(MappingFieldElement versionField) throws ModelValidationException {
                ArrayList columns = versionField.getColumns();
                if (columns.size() != 1) {
                    throw ModelValidator.this.constructFieldException(versionField.getName(), "util.validation.version_field_not_mapped");
                }
                return (String)columns.get(0);
            }

            private ColumnElement validateTableMatch(String className, String fieldName, String columnName) throws ModelValidationException {
                String primaryName;
                TableElement pTable;
                String schema = ModelValidator.this.getSchemaForClass(className);
                String absoluteName = NameUtil.getAbsoluteMemberName((String)schema, (String)columnName);
                TableElement table = TableElement.forName((String)NameUtil.getTableName((String)absoluteName));
                if (table != (pTable = ModelValidator.this.getTable(primaryName = ((MappingTableElement)mappingClass.getTables().get(0)).getName(), schema))) {
                    throw new ModelValidationException(ModelValidator.this.getModel().getField(className, fieldName), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.version_field_table_mismatch", new Object[]{columnName, fieldName, className}));
                }
                return table != null ? (ColumnElement)table.getMember(DBIdentifier.create((String)absoluteName)) : null;
            }

            private void validateColumnAttributes(String className, String fieldName, ColumnElement column) throws ModelValidationException {
                String keyName = null;
                if (column.isNullable() || !column.isNumericType()) {
                    keyName = "util.validation.version_field_column_type_invalid";
                } else {
                    int i;
                    TableElement table = column.getDeclaringTable();
                    UniqueKeyElement[] uks = table.getUniqueKeys();
                    ForeignKeyElement[] fks = table.getForeignKeys();
                    int count = uks != null ? uks.length : 0;
                    for (i = 0; i < count; ++i) {
                        UniqueKeyElement uk = uks[i];
                        if (!uk.isPrimaryKey() || !Arrays.asList(uk.getColumns()).contains(column)) continue;
                        keyName = "util.validation.version_field_column_pk_invalid";
                        break;
                    }
                    count = fks != null ? fks.length : 0;
                    for (i = 0; i < count; ++i) {
                        ForeignKeyElement fk = fks[i];
                        if (!Arrays.asList(fk.getLocalColumns()).contains(column)) continue;
                        keyName = "util.validation.version_field_column_fk_invalid";
                        break;
                    }
                }
                if (keyName != null) {
                    throw new ModelValidationException(ModelValidator.this.getModel().getField(className, fieldName), I18NHelper.getMessage(ModelValidator.this.getMessages(), keyName, new Object[]{column.getName(), fieldName, className}));
                }
            }
        };
    }

    protected ValidationComponent createInverseFieldComponent(final RelationshipElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                RelationshipElement inverseInverse;
                Model model = ModelValidator.this.getModel();
                RelationshipElement inverse = field.getInverseRelationship(model);
                RelationshipElement relationshipElement = inverseInverse = inverse != null ? inverse.getInverseRelationship(model) : null;
                if (!(inverse == null || field.equals(inverseInverse) && inverseInverse != null)) {
                    String fieldName = field.getName();
                    throw new ModelValidationException(model.getField(ModelValidator.this.getClassName(), fieldName), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.inverse_field_invalid", new Object[]{fieldName, inverse.getName()}));
                }
            }
        };
    }

    protected ValidationComponent createRelatedClassMatchesComponent(final RelationshipElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                Model model;
                RelationshipElement inverse;
                String inverseName = field.getInverseRelationshipName();
                if (!StringHelper.isEmpty(inverseName) && (inverse = field.getInverseRelationship(model = ModelValidator.this.getModel())) == null) {
                    Object[] objectArray;
                    String key;
                    String relatedClass = ModelValidator.this.getRelatedClass(field);
                    String fieldName = field.getName();
                    String string = key = relatedClass != null ? "util.validation.related_class_mismatch" : "util.validation.related_class_not_found";
                    if (relatedClass != null) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = fieldName;
                        objectArray2[1] = inverseName;
                        objectArray = objectArray2;
                        objectArray2[2] = relatedClass;
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = fieldName;
                        objectArray = objectArray3;
                        objectArray3[1] = inverseName;
                    }
                    Object[] args = objectArray;
                    throw new ModelValidationException(model.getField(ModelValidator.this.getClassName(), fieldName), I18NHelper.getMessage(ModelValidator.this.getMessages(), key, args));
                }
            }
        };
    }

    protected ValidationComponent createInverseMappingComponent(final RelationshipElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                RelationshipElement inverse = field.getInverseRelationship(model);
                if (inverse != null && !this.isInverseMapping(field, inverse)) {
                    String fieldName = field.getName();
                    throw new ModelValidationException(model.getField(ModelValidator.this.getClassName(), fieldName), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.inverse_mapping_mismatch", new Object[]{fieldName, inverse.getName()}));
                }
            }

            private boolean hasMappingRows(MappingRelationshipElement field2) {
                if (field2 != null) {
                    ArrayList columns = field2.getColumns();
                    return columns != null && !columns.isEmpty();
                }
                return false;
            }

            private boolean isInverseMapping(RelationshipElement jdoField1, RelationshipElement jdoField2) {
                MappingRelationshipElement field1 = ModelValidator.this.getMappingRelationship(jdoField1);
                MappingRelationshipElement field2 = ModelValidator.this.getMappingRelationship(jdoField2);
                boolean field1HasMapping = this.hasMappingRows(field1);
                boolean field2HasMapping = this.hasMappingRows(field2);
                if (field1HasMapping && field2HasMapping) {
                    boolean field1IsJoin = ModelValidator.this.isJoin(field1);
                    if (field1IsJoin == ModelValidator.this.isJoin(field2)) {
                        ArrayList pairs1 = field1.getColumns();
                        ArrayList pairs2 = field2.getColumns();
                        return !field1IsJoin ? this.isInverse(pairs1, pairs2) : this.isInverse(pairs1, field2.getAssociatedColumns()) && this.isInverse(field1.getAssociatedColumns(), pairs2);
                    }
                    return false;
                }
                return field1HasMapping == field2HasMapping;
            }

            private boolean isInverse(ArrayList pairs1, ArrayList pairs2) {
                int size2;
                int size1 = pairs1.size();
                if (size1 == (size2 = pairs2.size())) {
                    for (int i = 0; i < size1; ++i) {
                        String nextPair = (String)pairs1.get(i);
                        String inversePair = (String)pairs2.get(i);
                        int semicolonIndex1 = nextPair.indexOf(59);
                        int semicolonIndex2 = inversePair.indexOf(59);
                        if (semicolonIndex1 != -1 && semicolonIndex2 != -1 && nextPair.substring(0, semicolonIndex1).equals(inversePair.substring(semicolonIndex2 + 1)) && nextPair.substring(semicolonIndex1 + 1).equals(inversePair.substring(0, semicolonIndex2))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected ValidationComponent createFieldDefaultFetchGroupComponent(final MappingFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (field != null) {
                    PersistenceFieldElement pElement;
                    String fieldName = field.getName();
                    PersistenceClassElement persistenceClass = ModelValidator.this.getPersistenceClass(ModelValidator.this.getClassName());
                    PersistenceFieldElement persistenceFieldElement = pElement = persistenceClass != null ? persistenceClass.getField(fieldName) : null;
                    if (pElement != null && !pElement.isKey() && 1 == field.getFetchGroup()) {
                        String exceptionKey;
                        MappingClassElement mappingClass = field.getDeclaringClass();
                        boolean isVersionField = 16 == mappingClass.getConsistencyLevel() && field.isVersion();
                        Iterator iterator = mappingClass.getFields().iterator();
                        String string = exceptionKey = !isVersionField ? "util.validation.field_fetch_group_invalid" : "util.validation.version_field_column_invalid";
                        while (iterator.hasNext()) {
                            MappingFieldElement testField = (MappingFieldElement)iterator.next();
                            if (this.isManaged(field, testField) || this.isManaged(testField, field)) {
                                throw ModelValidator.this.constructFieldException(fieldName, exceptionKey);
                            }
                            if (testField.equals(field) || !this.isExactMatch(field, testField)) continue;
                            throw ModelValidator.this.constructFieldException(fieldName, exceptionKey);
                        }
                    }
                }
            }

            private boolean isManaged(MappingFieldElement primField, MappingFieldElement relField) {
                String className = ModelValidator.this.getClassName();
                if (!ModelValidator.this.isRelationship(primField) && ModelValidator.this.isRelationship(relField) && !ModelValidator.this.isCollection(className, relField.getName())) {
                    ArrayList columns = primField.getColumns();
                    Iterator iterator = relField.getColumns().iterator();
                    String databaseRoot = ModelValidator.this.getSchemaForClass(className);
                    while (iterator.hasNext()) {
                        if (this.testColumn(this.getLocalColumn((String)iterator.next(), databaseRoot), columns)) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean testColumn(ColumnElement column, ArrayList masterList) {
                if (column != null && !this.isPrimaryKeyColumn(column)) {
                    return !masterList.contains(NameUtil.getRelativeMemberName((String)column.getName().getFullName()));
                }
                return true;
            }

            private ColumnElement getLocalColumn(String pairName, String databaseRoot) {
                ColumnPairElement pair = ModelValidator.this.getPair(pairName, databaseRoot);
                return pair != null ? pair.getLocalColumn() : null;
            }

            private boolean isPrimaryKeyColumn(ColumnElement column) {
                if (column != null) {
                    UniqueKeyElement key = column.getDeclaringTable().getPrimaryKey();
                    return key != null && key.getColumn(column.getName()) != null;
                }
                return false;
            }

            private boolean isExactMatch(ArrayList columns1, ArrayList columns2) {
                int count = columns1.size();
                if (count > 0 && count == columns2.size()) {
                    return ModelValidator.this.getDifference(columns1, columns2).isEmpty();
                }
                return false;
            }

            private boolean isExactMatch(MappingFieldElement field1, MappingFieldElement field2) {
                boolean field1IsRel = ModelValidator.this.isRelationship(field1);
                boolean match = false;
                if (field1IsRel == ModelValidator.this.isRelationship(field2) && (match = this.isExactMatch(field1.getColumns(), field2.getColumns())) && field1IsRel) {
                    MappingRelationshipElement rel1 = (MappingRelationshipElement)field1;
                    MappingRelationshipElement rel2 = (MappingRelationshipElement)field2;
                    boolean field1IsJoin = ModelValidator.this.isJoin(rel1);
                    if (field1IsJoin == ModelValidator.this.isJoin(rel2)) {
                        if (field1IsJoin) {
                            match = this.isExactMatch(rel1.getAssociatedColumns(), rel2.getAssociatedColumns());
                        }
                    } else {
                        match = false;
                    }
                }
                return match;
            }
        };
    }

    protected ValidationComponent createRelatedSchemaMatchesComponent(final String relatedClass, final PersistenceFieldElement relatedField) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (relatedClass != null) {
                    String className = ModelValidator.this.getClassName();
                    String mySchema = ModelValidator.this.getSchemaForClass(className);
                    String relatedSchema = ModelValidator.this.getSchemaForClass(relatedClass);
                    if (mySchema != null && relatedSchema != null && !relatedSchema.equals(mySchema)) {
                        String fieldName = relatedField.getName();
                        throw new ModelValidationException(ModelValidator.this.getModel().getField(className, fieldName), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.schema_mismatch", new Object[]{className, relatedClass, fieldName}));
                    }
                }
            }
        };
    }

    protected ValidationComponent createRelatedTableMatchesComponent(final String relatedClass, final PersistenceFieldElement relatedField, final List tableNames, final String pairName) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                ColumnElement column;
                ColumnPairElement pair = ModelValidator.this.getPair(pairName, ModelValidator.this.getSchemaForClass(relatedClass));
                if (pair != null && !ModelValidator.this.matchesTable(tableNames, column = pair.getReferencedColumn())) {
                    String fieldName = relatedField.getName();
                    throw new ModelValidationException(ModelValidator.this.getModel().getField(ModelValidator.this.getClassName(), fieldName), I18NHelper.getMessage(ModelValidator.this.getMessages(), ModelValidator.this.getKey("util.validation.table_mismatch", relatedField), new Object[]{column.getName().getFullName(), fieldName, relatedClass}));
                }
            }
        };
    }

    protected ValidationComponent createSchemaExistenceComponent(String className) {
        return this.createSchemaExistenceComponent(className, null);
    }

    protected ValidationComponent createSchemaExistenceComponent(final String className, final PersistenceFieldElement relatedField) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String schemaName = ModelValidator.this.getSchemaForClass(className);
                if (schemaName != null && SchemaElement.forName((String)schemaName) == null) {
                    Object[] objectArray;
                    if (relatedField == null) {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = schemaName;
                        objectArray = objectArray2;
                        objectArray2[1] = className;
                    } else {
                        Object[] objectArray3 = new Object[3];
                        objectArray3[0] = schemaName;
                        objectArray3[1] = className;
                        objectArray = objectArray3;
                        objectArray3[2] = relatedField;
                    }
                    Object[] args = objectArray;
                    throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(relatedField), I18NHelper.getMessage(ModelValidator.this.getMessages(), ModelValidator.this.getKey("util.validation.schema_not_found", relatedField), args));
                }
            }
        };
    }

    protected ValidationComponent createPrimaryTableComponent(final MappingTableElement primaryTable) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (primaryTable != null) {
                    String className = ModelValidator.this.getClassName();
                    String schemaName = ModelValidator.this.getSchemaForClass(className);
                    if (schemaName == null) {
                        throw ModelValidator.this.constructClassException(className, null, "util.validation.schema_not_set");
                    }
                    String tableName = primaryTable.getName();
                    TableElement table = ModelValidator.this.getTable(tableName, schemaName);
                    if (table != null && table.getPrimaryKey() == null) {
                        throw new ModelValidationException(ModelValidator.this.getOffendingObject(null), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.table_no_primarykey", new Object[]{tableName, className}));
                    }
                }
            }
        };
    }

    protected ValidationComponent createTableExistenceComponent(String tableName) {
        return this.createTableExistenceComponent(tableName, null);
    }

    protected ValidationComponent createTableExistenceComponent(final String tableName, final PersistenceFieldElement relatedField) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (tableName != null) {
                    String className = ModelValidator.this.getClassName();
                    boolean noRelated = relatedField == null;
                    TableElement table = ModelValidator.this.getTable(tableName, ModelValidator.this.getSchemaForClass(noRelated ? className : ModelValidator.this.getRelatedClass(relatedField)));
                    if (table == null) {
                        Object[] objectArray;
                        if (noRelated) {
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = tableName;
                            objectArray = objectArray2;
                            objectArray2[1] = className;
                        } else {
                            Object[] objectArray3 = new Object[2];
                            objectArray3[0] = tableName;
                            objectArray = objectArray3;
                            objectArray3[1] = relatedField;
                        }
                        Object[] args = objectArray;
                        throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(relatedField), I18NHelper.getMessage(ModelValidator.this.getMessages(), ModelValidator.this.getKey("util.validation.table_not_found", relatedField), args));
                    }
                }
            }
        };
    }

    protected ValidationComponent createColumnExistenceComponent(String columnName) {
        return this.createColumnExistenceComponent(columnName, null);
    }

    protected ValidationComponent createColumnExistenceComponent(final String columnName, final MappingFieldElement relatedField) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                if (columnName != null) {
                    boolean noRelated;
                    String className = ModelValidator.this.getClassName();
                    String absoluteName = NameUtil.getAbsoluteMemberName((String)ModelValidator.this.getSchemaForClass(className), (String)columnName);
                    TableElement table = TableElement.forName((String)NameUtil.getTableName((String)absoluteName));
                    boolean foundTable = table != null;
                    DBMemberElement columnElement = foundTable ? table.getMember(DBIdentifier.create((String)absoluteName)) : null;
                    boolean bl = noRelated = relatedField == null;
                    if (foundTable) {
                        boolean noColumn;
                        boolean isRelationship = !noRelated && ModelValidator.this.isRelationship(relatedField);
                        boolean bl2 = noColumn = columnElement == null;
                        if (!isRelationship && noColumn) {
                            Object[] objectArray;
                            if (noRelated) {
                                Object[] objectArray2 = new Object[2];
                                objectArray2[0] = columnName;
                                objectArray = objectArray2;
                                objectArray2[1] = className;
                            } else {
                                Object[] objectArray3 = new Object[3];
                                objectArray3[0] = columnName;
                                objectArray3[1] = relatedField;
                                objectArray = objectArray3;
                                objectArray3[2] = className;
                            }
                            Object[] args = objectArray;
                            throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(relatedField), I18NHelper.getMessage(ModelValidator.this.getMessages(), ModelValidator.this.getKey("util.validation.column_not_found", relatedField), args));
                        }
                        if (isRelationship && (noColumn || !this.isPairComplete(columnElement))) {
                            throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(relatedField), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.column_invalid", new Object[]{columnName, relatedField, className}));
                        }
                    }
                }
            }

            private boolean isPairComplete(DBMemberElement member) {
                return member instanceof ColumnPairElement && ((ColumnPairElement)member).getLocalColumn() != null && ((ColumnPairElement)member).getReferencedColumn() != null;
            }
        };
    }

    protected ValidationComponent createColumnOverlapComponent(final MappingFieldElement field) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                MappingClassElement mappingClass = field.getDeclaringClass();
                Iterator iterator = mappingClass.getFields().iterator();
                ArrayList myColumns = field.getColumns();
                while (iterator.hasNext()) {
                    MappingFieldElement testField = (MappingFieldElement)iterator.next();
                    if (testField.equals(field) || ModelValidator.this.isRelationship(testField) || !this.isPartialMatch(myColumns, testField.getColumns())) continue;
                    String fieldName = field.getName();
                    throw new ModelValidationException(ModelValidator.this.getModel().getField(ModelValidator.this.getClassName(), fieldName), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.field_mapping_invalid", new Object[]{fieldName, testField.getName()}));
                }
            }

            private boolean isPartialMatch(ArrayList columns1, ArrayList columns2) {
                int count = columns1.size();
                if (count > 0) {
                    ArrayList difference = ModelValidator.this.getDifference(columns1, columns2);
                    return !difference.isEmpty() && columns2.size() != difference.size();
                }
                return false;
            }
        };
    }

    protected ValidationComponent createKeyClassComponent(final String className) {
        return new ValidationComponent(){
            private Object keyClass;
            private String keyClassName;

            public void validate() throws ModelValidationException {
                this.keyClassName = this.validateKeyClassName(className);
                this.keyClass = ModelValidator.this.getModel().getClass(this.keyClassName, ModelValidator.this.getClassLoader());
                this.validateClass();
                this.validateConstructor();
                this.validateFields();
                this.validateMethods();
            }

            private void validateClass() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                int modifiers = model.getModifiersForClass(this.keyClassName);
                boolean hasKeyClassName = !StringHelper.isEmpty(this.keyClassName);
                boolean isInnerClass = hasKeyClassName && this.keyClassName.indexOf(36) != -1;
                String pcClassName = ModelValidator.this.getClassName();
                if (this.keyClass == null) {
                    throw new ModelValidationException(1, model.getClass(pcClassName), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_missing", this.keyClassName, pcClassName));
                }
                if (!Modifier.isPublic(modifiers)) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_public", this.keyClassName, pcClassName));
                }
                if (isInnerClass && !Modifier.isStatic(modifiers)) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_static", this.keyClassName, pcClassName));
                }
            }

            private void validateFields() throws ModelValidationException {
                String pcClassName = ModelValidator.this.getClassName();
                Model model = ModelValidator.this.getModel();
                List keyClassFieldNames = model.getAllFields(this.keyClassName);
                Map keyFields = this.getKeyFields();
                for (String keyClassFieldName : keyClassFieldNames) {
                    Object keyClassField = this.getKeyClassField(this.keyClassName, keyClassFieldName);
                    int keyClassFieldModifiers = model.getModifiers(keyClassField);
                    String keyClassFieldType = model.getType(keyClassField);
                    Object keyField = keyFields.get(keyClassFieldName);
                    if (Modifier.isStatic(keyClassFieldModifiers)) continue;
                    if (!model.isValidKeyType(this.keyClassName, keyClassFieldName)) {
                        throw new ModelValidationException(keyClassField, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_field_type_invalid", keyClassFieldName, this.keyClassName));
                    }
                    if (!Modifier.isPublic(keyClassFieldModifiers)) {
                        throw new ModelValidationException(keyClassField, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_field_public", keyClassFieldName, this.keyClassName));
                    }
                    if (keyField == null) continue;
                    if (!keyClassFieldType.equals(model.getType(keyField))) {
                        throw new ModelValidationException(keyClassField, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_field_type_mismatch", keyClassFieldName, this.keyClassName, pcClassName));
                    }
                    keyFields.remove(keyClassFieldName);
                }
                if (!keyFields.isEmpty()) {
                    Object pcClass = model.getClass(pcClassName);
                    String fieldNames = StringHelper.arrayToSeparatedList(new ArrayList(keyFields.keySet()));
                    throw new ModelValidationException(pcClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_field_missing", pcClassName, this.keyClassName, fieldNames));
                }
            }

            private void validateConstructor() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                boolean hasConstr = model.hasConstructor(this.keyClassName);
                Object noArgConstr = model.getConstructor(this.keyClassName, Model.NO_ARGS);
                int modifiers = model.getModifiers(noArgConstr);
                if (hasConstr && (noArgConstr == null || !Modifier.isPublic(modifiers))) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_constructor", this.keyClassName, ModelValidator.this.getClassName()));
                }
            }

            private void validateMethods() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                Object equalsMethod = this.getNonObjectMethod(this.keyClassName, "equals", Model.EQUALS_ARGS);
                Object hashCodeMethod = this.getNonObjectMethod(this.keyClassName, "hashCode", Model.NO_ARGS);
                if (!ModelValidator.this.matchesMethod(equalsMethod, 1, 0, "boolean")) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_equals", this.keyClassName, ModelValidator.this.getClassName()));
                }
                if (!ModelValidator.this.matchesMethod(hashCodeMethod, 1, 0, "int")) {
                    throw new ModelValidationException(this.keyClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_hashcode", this.keyClassName, ModelValidator.this.getClassName()));
                }
            }

            private String validateKeyClassName(String keyClassName) throws ModelValidationException {
                boolean isOIDNameSuffix;
                boolean hasKeyClassName;
                String pcClassName = ModelValidator.this.getClassName();
                Model model = ModelValidator.this.getModel();
                boolean bl = hasKeyClassName = !StringHelper.isEmpty(keyClassName);
                if (!hasKeyClassName) {
                    throw new ModelValidationException(1, model.getClass(pcClassName), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_unset", pcClassName));
                }
                boolean hasPrefix = (keyClassName = keyClassName.trim()).startsWith(pcClassName);
                String nameSuffix = hasPrefix ? keyClassName.substring(pcClassName.length()) : keyClassName;
                boolean bl2 = isOIDNameSuffix = nameSuffix.equalsIgnoreCase(".OID") || nameSuffix.equalsIgnoreCase("$OID");
                if (!hasPrefix || !nameSuffix.equalsIgnoreCase("Key") && !isOIDNameSuffix) {
                    Object pcClass = ModelValidator.this.getModel().getClass(pcClassName);
                    throw new ModelValidationException(pcClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.key_class_invalid", keyClassName, pcClassName));
                }
                if (isOIDNameSuffix) {
                    StringBuffer buf = new StringBuffer(keyClassName);
                    buf.setCharAt(keyClassName.length() - 4, '$');
                    return buf.toString();
                }
                return keyClassName;
            }

            private Object getKeyClassField(String keyClassName, String keyClassFieldName) {
                Model model = ModelValidator.this.getModel();
                Object keyClassField = model.getField(keyClassName, keyClassFieldName);
                if (keyClassField == null) {
                    keyClassField = model.getInheritedField(keyClassName, keyClassFieldName);
                }
                return keyClassField;
            }

            private Map getKeyFields() {
                Model model = ModelValidator.this.getModel();
                String pcClassName = ModelValidator.this.getClassName();
                PersistenceClassElement pce = model.getPersistenceClass(pcClassName);
                PersistenceFieldElement[] fields = pce.getFields();
                HashMap<String, Object> keyFields = new HashMap<String, Object>();
                if (fields != null) {
                    for (int i = 0; i < fields.length; ++i) {
                        PersistenceFieldElement pfe = fields[i];
                        if (!pfe.isKey()) continue;
                        String name = pfe.getName();
                        keyFields.put(name, model.getField(pcClassName, name));
                    }
                }
                return keyFields;
            }

            private Object getNonObjectMethod(String className2, String methodName, String[] argTypeNames) {
                Model model = ModelValidator.this.getModel();
                Object method = model.getMethod(className2, methodName, argTypeNames);
                if (method == null && (method = model.getInheritedMethod(className2, methodName, argTypeNames)) != null && model.getDeclaringClass(method).equals("java.lang.Object")) {
                    method = null;
                }
                return method;
            }
        };
    }

    protected ValidationComponent createSerializableClassComponent(final String className) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                Model model = ModelValidator.this.getModel();
                Object pcClass = null;
                if (className == null) {
                    return;
                }
                pcClass = model.getClass(className);
                if (pcClass == null) {
                    return;
                }
                if (model.implementsInterface(pcClass, "java.io.Serializable")) {
                    Object readMethod = model.getMethod(className, "readObject", Model.READ_OBJECT_ARGS);
                    if (!ModelValidator.this.matchesMethod(readMethod, 2, 32, "void")) {
                        throw new ModelValidationException(pcClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.class_readobject", className));
                    }
                    Object writeMethod = model.getMethod(className, "writeObject", Model.WRITE_OBJECT_ARGS);
                    if (!ModelValidator.this.matchesMethod(writeMethod, 2, 32, "void")) {
                        throw new ModelValidationException(pcClass, I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.class_writeobject", className));
                    }
                }
            }
        };
    }

    protected ValidationComponent createClassMappingComponent(final PersistenceClassElement persistenceClass) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                PersistenceFieldElement[] fields = persistenceClass.getFields();
                String className = ModelValidator.this.getClassName();
                if (fields == null || fields.length == 0) {
                    throw ModelValidator.this.constructClassException(1, className, null, "util.validation.class_no_fields");
                }
                MappingClassElement mappingClass = ModelValidator.this.getMappingClass(className);
                if (mappingClass == null || mappingClass.getTables().size() == 0) {
                    throw ModelValidator.this.constructClassException(1, className, null, "util.validation.class_not_mapped");
                }
            }
        };
    }

    protected ValidationComponent createKeyColumnMappingComponent(final PersistenceClassElement persistenceClass) {
        return new ValidationComponent(){

            public void validate() throws ModelValidationException {
                String tableName;
                TableElement table;
                List columns;
                ArrayList tables;
                String className = ModelValidator.this.getClassName();
                MappingClassElement mappingClass = ModelValidator.this.getMappingClass(className);
                if (mappingClass != null && (tables = mappingClass.getTables()).size() > 0 && (columns = this.getUnmappedColumnNames((KeyElement)((table = ModelValidator.this.getTable(tableName = ((MappingTableElement)tables.get(0)).getName(), ModelValidator.this.getSchemaForClass(className))) != null ? table.getPrimaryKey() : null), mappingClass)) != null && columns.size() > 0) {
                    throw new ModelValidationException(1, ModelValidator.this.getOffendingObject(null), I18NHelper.getMessage(ModelValidator.this.getMessages(), "util.validation.class_key_column_missing", className, tableName, StringHelper.arrayToSeparatedList(columns)));
                }
            }

            private List getUnmappedColumnNames(KeyElement primaryKey, MappingClassElement mappingClass) {
                List unmappedColumns = null;
                if (primaryKey != null) {
                    int count;
                    ColumnElement[] columns = primaryKey.getColumns();
                    int n = count = columns != null ? columns.length : 0;
                    if (count > 0) {
                        ArrayList mappingFields = mappingClass.getFields();
                        Iterator iterator = mappingFields.iterator();
                        unmappedColumns = this.getRelativeColumnNames(columns);
                        while (iterator.hasNext()) {
                            MappingFieldElement field = (MappingFieldElement)iterator.next();
                            if (!this.isKeyField(field)) continue;
                            unmappedColumns.removeAll(field.getColumns());
                        }
                    }
                }
                return unmappedColumns;
            }

            private List getRelativeColumnNames(ColumnElement[] columns) {
                int count = columns != null ? columns.length : 0;
                ArrayList<String> columnNames = new ArrayList<String>(count);
                for (int i = 0; i < count; ++i) {
                    columnNames.add(NameUtil.getRelativeMemberName((String)columns[i].getName().getFullName()));
                }
                return columnNames;
            }

            private boolean isKeyField(MappingFieldElement field) {
                PersistenceFieldElement persistenceField = persistenceClass.getField(field.getName());
                return persistenceField != null && persistenceField.isKey();
            }
        };
    }

    private Object getOffendingObject(Object field) {
        return field == null ? this.getModel().getClass(this.getClassName(), this.getClassLoader()) : this.getModel().getField(this.getClassName(), field.toString());
    }

    private String getKey(String keyBase, Object field) {
        return field == null ? keyBase : keyBase + "_related";
    }

    private Object[] getArguments(String className, Object field) {
        Object[] objectArray;
        if (field == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = className;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = className;
            objectArray = objectArray3;
            objectArray3[1] = field;
        }
        return objectArray;
    }

    private ModelValidationException constructClassException(String className, Object relatedField, String keyBase) {
        return this.constructClassException(0, className, relatedField, keyBase);
    }

    private ModelValidationException constructClassException(int errorType, String className, Object relatedField, String keyBase) {
        return new ModelValidationException(errorType, this.getOffendingObject(relatedField), I18NHelper.getMessage(this.getMessages(), this.getKey(keyBase, relatedField), this.getArguments(className, relatedField)));
    }

    private ModelValidationException constructFieldException(String fieldName, String key) {
        return this.constructFieldException(0, fieldName, key);
    }

    private ModelValidationException constructFieldException(int errorType, String fieldName, String key) {
        return new ModelValidationException(errorType, this.getModel().getField(this.getClassName(), fieldName), I18NHelper.getMessage(this.getMessages(), key, fieldName));
    }

    private boolean matchesMethod(Object method, int expectedModifiers, int optionalModifiers, String expectedReturnType) {
        boolean matches = false;
        if (method != null) {
            Model model = this.getModel();
            int modifiers = model.getModifiers(method);
            matches = (modifiers == expectedModifiers || modifiers == (expectedModifiers | optionalModifiers)) && expectedReturnType.equals(model.getType(method));
        }
        return matches;
    }

    private boolean matchesTable(List tableNames, ColumnElement column) {
        return column == null ? true : tableNames.contains(column.getDeclaringTable().getName().getName());
    }

    private boolean isRelationship(Object field) {
        return field instanceof RelationshipElement || field instanceof MappingRelationshipElement;
    }

    private boolean shouldBeRelationship(PersistenceFieldElement field) {
        Model model = this.getModel();
        String fieldType = model.getFieldType(this.getClassName(), field.getName());
        return this.isPersistent(fieldType) || model.isCollection(fieldType);
    }

    private boolean isLegalRelationship(PersistenceFieldElement field) {
        return this.isRelationship(field) ? this.shouldBeRelationship(field) : false;
    }

    private boolean isCollection(String className, String fieldName) {
        Model model = this.getModel();
        return model.isCollection(model.getFieldType(className, fieldName));
    }

    private String getRelatedClass(PersistenceFieldElement field) {
        if (this.isLegalRelationship(field)) {
            return this.getModel().getRelatedClass((RelationshipElement)field);
        }
        return null;
    }

    private String getSchemaForClass(String className) {
        MappingClassElement mappingClass = this.getMappingClass(className);
        String schema = mappingClass != null ? mappingClass.getDatabaseRoot() : null;
        return StringHelper.isEmpty(schema) ? null : schema.trim();
    }

    private MappingRelationshipElement getMappingRelationship(RelationshipElement jdoElement) {
        MappingFieldElement fieldElement;
        MappingClassElement mappingClass;
        MappingRelationshipElement mappingElement = null;
        if (jdoElement != null && (mappingClass = this.getMappingClass(jdoElement.getDeclaringClass().getName())) != null && this.isRelationship(fieldElement = mappingClass.getField(jdoElement.getName()))) {
            mappingElement = (MappingRelationshipElement)fieldElement;
        }
        return mappingElement;
    }

    private boolean isJoin(MappingRelationshipElement field) {
        if (field != null) {
            ArrayList columns = field.getAssociatedColumns();
            return columns != null && !columns.isEmpty();
        }
        return false;
    }

    private MappingReferenceKeyElement findReferenceKey(MappingTableElement primaryTable, MappingTableElement secondaryTable) {
        if (primaryTable != null && secondaryTable != null) {
            for (MappingReferenceKeyElement testKey : primaryTable.getReferencingKeys()) {
                if (!testKey.getTable().equals(secondaryTable)) continue;
                return testKey;
            }
        }
        return null;
    }

    private TableElement getTable(String tableName, String databaseRoot) {
        String absoluteName = NameUtil.getAbsoluteTableName((String)databaseRoot, (String)tableName);
        return TableElement.forName((String)absoluteName);
    }

    private ColumnPairElement getPair(String pairName, String databaseRoot) {
        String absoluteName = NameUtil.getAbsoluteMemberName((String)databaseRoot, (String)pairName);
        TableElement tableElement = TableElement.forName((String)NameUtil.getTableName((String)absoluteName));
        DBMemberElement pair = tableElement == null ? null : tableElement.getMember(DBIdentifier.create((String)absoluteName));
        return pair instanceof ColumnPairElement ? (ColumnPairElement)pair : null;
    }

    private ArrayList getDifference(ArrayList columns1, ArrayList columns2) {
        ArrayList differenceColumns = new ArrayList(columns2);
        differenceColumns.removeAll(columns1);
        return differenceColumns;
    }

    private MappingClassElement getMappingClass(String className) {
        return this.getModel().getMappingClass(className, this.getClassLoader());
    }

    private PersistenceClassElement getPersistenceClass(String className) {
        return this.getModel().getPersistenceClass(className, this.getClassLoader());
    }

    private boolean isPersistent(String className) {
        return this.getModel().isPersistent(className, this.getClassLoader());
    }

    private boolean isPersistentAllowed(String className, String fieldName) {
        return this.getModel().isPersistentAllowed(className, this.getClassLoader(), fieldName);
    }

    static abstract class ValidationComponent {
        public abstract void validate() throws ModelValidationException;
    }
}

