/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DBElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.DBElementsCollection;
import org.netbeans.modules.dbschema.jdbcimpl.DDLBridge;
import org.netbeans.modules.dbschema.jdbcimpl.IndexElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.MetaDataUtil;
import org.netbeans.modules.dbschema.jdbcimpl.TableElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.UniqueKeyElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.ViewDependency;
import org.netbeans.modules.dbschema.util.IDEUtil;

public class SchemaElementImpl
extends DBElementImpl
implements SchemaElement.Impl {
    private DBElementsCollection tables;
    private DBIdentifier _schema;
    private DBIdentifier _catalog;
    private String _url;
    private String _username;
    private String _driver;
    private String _databaseProductName;
    private String _databaseProductVersion;
    private String _driverName;
    private String _driverVersion;
    private transient DatabaseMetaData dmd;
    private transient String catalog;
    private transient boolean stop;
    public transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private transient int progress;

    public SchemaElementImpl() {
        this((ConnectionProvider)null);
    }

    public SchemaElementImpl(ConnectionProvider connectionProvider) {
        this.tables = new DBElementsCollection(this, new TableElement[0]);
        String string = String.valueOf(this.tables.hashCode());
        while (DBElementsCollection.instances.contains(string)) {
            this.tables = new DBElementsCollection(this, new TableElement[0]);
            string = String.valueOf(this.tables.hashCode());
        }
        DBElementsCollection.instances.add(string);
        if (connectionProvider != null) {
            try {
                this.dmd = connectionProvider.getDatabaseMetaData();
                this._url = this.dmd.getURL();
                this._username = this.dmd.getUserName();
                String string2 = connectionProvider.getSchema();
                this._schema = string2 == null ? DBIdentifier.create("") : DBIdentifier.create(string2);
                this.catalog = connectionProvider.getConnection().getCatalog();
                this._catalog = this.catalog == null ? DBIdentifier.create("") : DBIdentifier.create(this.catalog);
                this._driver = connectionProvider.getDriver();
                this._databaseProductName = this.dmd.getDatabaseProductName().trim();
                this._databaseProductVersion = this.dmd.getDatabaseProductVersion();
                this._driverName = this.dmd.getDriverName();
                this._driverVersion = this.dmd.getDriverVersion();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.stop = false;
    }

    public void setName(DBIdentifier dBIdentifier) throws DBException {
        int n;
        String string = dBIdentifier.getFullName();
        if (string == null) {
            string = dBIdentifier.getName();
            dBIdentifier.setFullName(string);
        }
        if ((n = string.lastIndexOf("/")) != -1) {
            dBIdentifier.setName(string.substring(n + 1));
        } else if (string.indexOf(".") != -1) {
            dBIdentifier.setName(string);
        }
        this._name = dBIdentifier;
    }

    public DBIdentifier getName() {
        return this._name;
    }

    public int getStatus() {
        return 3;
    }

    public void setSchema(DBIdentifier dBIdentifier) throws DBException {
        this._schema = dBIdentifier;
    }

    public DBIdentifier getSchema() {
        return this._schema;
    }

    public void setCatalog(DBIdentifier dBIdentifier) throws DBException {
        this._catalog = dBIdentifier;
    }

    public DBIdentifier getCatalog() {
        return this._catalog;
    }

    public void changeTables(TableElement[] tableElementArray, int n) throws DBException {
        this.tables.changeElements(tableElementArray, n);
    }

    public TableElement[] getTables() {
        DBElement[] dBElementArray = this.tables.getElements();
        return Arrays.asList(dBElementArray).toArray(new TableElement[dBElementArray.length]);
    }

    public TableElement getTable(DBIdentifier dBIdentifier) {
        return (TableElement)this.tables.find(dBIdentifier);
    }

    public void initTables(ConnectionProvider connectionProvider) {
        this.initTables(connectionProvider, null, null, false);
    }

    public void initTables(ConnectionProvider connectionProvider, LinkedList linkedList, LinkedList linkedList2) {
        this.initTables(connectionProvider, linkedList, linkedList2, false);
    }

    public void initTables(ConnectionProvider connectionProvider, LinkedList linkedList, LinkedList linkedList2, boolean bl) {
        block20: {
            if (connectionProvider != null) {
                try {
                    ResultSet resultSet;
                    this.progress = 0;
                    LinkedList linkedList3 = new LinkedList();
                    LinkedList linkedList4 = new LinkedList();
                    LinkedList<String> linkedList5 = new LinkedList<String>();
                    LinkedList<String> linkedList6 = new LinkedList<String>();
                    String string = connectionProvider.getSchema();
                    DDLBridge dDLBridge = null;
                    if (IDEUtil.isIDERunning()) {
                        dDLBridge = new DDLBridge(connectionProvider.getConnection(), connectionProvider.getSchema(), this.dmd);
                    }
                    if (dDLBridge != null) {
                        dDLBridge.getDriverSpecification().getTables("%", new String[]{"TABLE"});
                        resultSet = dDLBridge.getDriverSpecification().getResultSet();
                    } else {
                        resultSet = this.dmd.getTables(this.catalog, string, "%", new String[]{"TABLE"});
                    }
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            if (this.isStop()) {
                                resultSet.close();
                                return;
                            }
                            if (dDLBridge != null) {
                                linkedList5.add((String)dDLBridge.getDriverSpecification().getRow().get(new Integer(3)));
                                continue;
                            }
                            linkedList5.add(resultSet.getString("TABLE_NAME").trim());
                        }
                        resultSet.close();
                    }
                    resultSet = null;
                    if (dDLBridge != null) {
                        if (dDLBridge.getDriverSpecification().areViewsSupported()) {
                            dDLBridge.getDriverSpecification().getTables("%", new String[]{"VIEW"});
                            resultSet = dDLBridge.getDriverSpecification().getResultSet();
                        } else if (MetaDataUtil.areViewsSupported(this.dmd.getDatabaseProductName())) {
                            resultSet = this.dmd.getTables(this.catalog, string, "%", new String[]{"VIEW"});
                        }
                    }
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            if (this.isStop()) {
                                resultSet.close();
                                return;
                            }
                            if (dDLBridge != null) {
                                linkedList6.add((String)dDLBridge.getDriverSpecification().getRow().get(new Integer(3)));
                                continue;
                            }
                            linkedList6.add(resultSet.getString("TABLE_NAME").trim());
                        }
                        resultSet.close();
                    }
                    if (linkedList == null && linkedList2 == null) {
                        linkedList3 = linkedList5;
                        linkedList4 = linkedList6;
                    } else {
                        linkedList = this.checkNames(linkedList, linkedList5);
                        linkedList2 = this.checkNames(linkedList2, linkedList6);
                        linkedList3 = bl ? linkedList : this.checkReferences(linkedList, dDLBridge, string);
                        linkedList4 = linkedList2;
                    }
                    this.propertySupport.firePropertyChange("totalCount", null, new Integer(linkedList3.size() + linkedList4.size()));
                    this.initTables(connectionProvider, linkedList3);
                    this.initViews(connectionProvider, linkedList4, dDLBridge);
                }
                catch (Exception exception) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block20;
                    exception.printStackTrace();
                }
            }
        }
    }

    private LinkedList checkNames(LinkedList linkedList, LinkedList linkedList2) {
        LinkedList linkedList3 = new LinkedList();
        for (int i = 0; i < linkedList.size(); ++i) {
            Object e = linkedList.get(i);
            if (linkedList2.contains(e)) {
                linkedList3.add(e);
                continue;
            }
            if (!Boolean.getBoolean("netbeans.debug.exceptions")) continue;
            System.out.println("Cannot find " + e + " table in the database.");
        }
        return linkedList3;
    }

    private LinkedList checkReferences(LinkedList linkedList, DDLBridge dDLBridge, String string) throws SQLException {
        for (int i = 0; i < linkedList.size(); ++i) {
            ResultSet resultSet;
            if (dDLBridge != null) {
                dDLBridge.getDriverSpecification().getImportedKeys(linkedList.get(i).toString());
                resultSet = dDLBridge.getDriverSpecification().getResultSet();
            } else {
                resultSet = this.dmd.getImportedKeys(this.catalog, string, linkedList.get(i).toString());
            }
            if (resultSet == null) continue;
            HashMap hashMap = new HashMap();
            while (resultSet.next()) {
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                if (dDLBridge != null) {
                    hashMap = dDLBridge.getDriverSpecification().getRow();
                    string8 = (String)hashMap.get(new Integer(1));
                    string7 = (String)hashMap.get(new Integer(2));
                    string6 = (String)hashMap.get(new Integer(5));
                    string5 = (String)hashMap.get(new Integer(6));
                    if (!this.comp(string8, string6) || !this.comp(string7, string5)) continue;
                    string4 = (String)hashMap.get(new Integer(2));
                    if ((string4 == (string3 = (String)hashMap.get(new Integer(6))) || string4.equals(string3)) && !linkedList.contains(string2 = (String)hashMap.get(new Integer(3)))) {
                        linkedList.add(string2);
                    }
                    hashMap.clear();
                    continue;
                }
                string8 = resultSet.getString("PKTABLE_CAT");
                string7 = resultSet.getString("PKTABLE_SCHEM");
                string6 = resultSet.getString("FKTABLE_CAT");
                string5 = resultSet.getString("FKTABLE_SCHEM");
                if (!this.comp(string8, string6) || !this.comp(string7, string5)) continue;
                string4 = resultSet.getString("PKTABLE_SCHEM");
                if (string4 != null) {
                    string4 = string4.trim();
                }
                if ((string3 = resultSet.getString("FKTABLE_SCHEM")) != null) {
                    string3 = string3.trim();
                }
                if (string4 != string3 && !string4.equals(string3) || linkedList.contains(string2 = resultSet.getString("PKTABLE_NAME").trim())) continue;
                linkedList.add(string2);
            }
            resultSet.close();
        }
        return linkedList;
    }

    private void initTables(ConnectionProvider connectionProvider, LinkedList linkedList) throws DBException {
        Object object;
        for (int i = 0; i < linkedList.size(); ++i) {
            if (this.isStop()) {
                return;
            }
            String string = linkedList.get(i).toString();
            this.propertySupport.firePropertyChange("tableName", null, string);
            object = new TableElementImpl(string);
            ((TableElementImpl)object).setTableOrView(true);
            TableElement[] tableElementArray = new TableElement[]{new TableElement((TableElement.Impl)object, (SchemaElement)this.element)};
            ((TableElementImpl)object).initColumns(connectionProvider);
            ((TableElementImpl)object).initIndexes(connectionProvider);
            this.changeTables(tableElementArray, 1);
            ++this.progress;
            this.propertySupport.firePropertyChange("progress", null, new Integer(this.progress));
        }
        for (int i = 0; i < linkedList.size(); ++i) {
            if (this.isStop()) {
                return;
            }
            object = linkedList.get(i).toString();
            TableElement tableElement = this.getTable(DBIdentifier.create((String)object));
            if (tableElement == null) continue;
            this.propertySupport.firePropertyChange("FKt", null, object);
            ((TableElementImpl)tableElement.getElementImpl()).initKeys(connectionProvider, 0, (String)object);
        }
    }

    private void initViews(ConnectionProvider connectionProvider, LinkedList linkedList, DDLBridge dDLBridge) throws DBException, SQLException {
        for (int i = 0; i < linkedList.size(); ++i) {
            if (this.isStop()) {
                return;
            }
            String string = linkedList.get(i).toString();
            this.propertySupport.firePropertyChange("viewName", null, string);
            TableElementImpl tableElementImpl = new TableElementImpl(string);
            tableElementImpl.setTableOrView(false);
            TableElement tableElement = new TableElement(tableElementImpl, (SchemaElement)this.element);
            tableElementImpl.initColumns(connectionProvider);
            String string2 = this.dmd.getDatabaseProductName();
            string2 = string2 != null ? string2.trim() : "";
            if (string2.equalsIgnoreCase("Oracle") || string2.equalsIgnoreCase("Microsoft SQL Server")) {
                this.propertySupport.firePropertyChange("FKv", null, string);
                ViewDependency viewDependency = new ViewDependency(connectionProvider, connectionProvider.getSchema(), string);
                LinkedList linkedList2 = new LinkedList();
                LinkedList linkedList3 = new LinkedList();
                linkedList2.clear();
                linkedList3.clear();
                viewDependency.constructPK();
                linkedList2 = viewDependency.getTables();
                linkedList3 = viewDependency.getColumns();
                if (!linkedList3.isEmpty()) {
                    int n;
                    KeyElement[] keyElementArray;
                    int n2;
                    Object object;
                    IndexElement[] indexElementArray;
                    Object object2;
                    Object object3;
                    ResultSet resultSet;
                    int n3;
                    int n4;
                    boolean bl = false;
                    for (n4 = 0; n4 < linkedList3.size(); ++n4) {
                        if (!((String)linkedList3.get(n4)).trim().endsWith("*")) continue;
                        bl = true;
                        break;
                    }
                    n4 = 1;
                    LinkedList<String> linkedList4 = new LinkedList<String>();
                    for (n3 = 0; n3 < linkedList2.size(); ++n3) {
                        if (this.isStop()) {
                            return;
                        }
                        if (dDLBridge != null) {
                            dDLBridge.getDriverSpecification().getPrimaryKeys(linkedList2.get(n3).toString());
                            resultSet = dDLBridge.getDriverSpecification().getResultSet();
                        } else {
                            resultSet = connectionProvider.getDatabaseMetaData().getPrimaryKeys(connectionProvider.getConnection().getCatalog(), connectionProvider.getSchema(), linkedList2.get(n3).toString());
                        }
                        if (resultSet == null) continue;
                        if (!bl) {
                            object3 = new HashMap();
                            while (resultSet.next()) {
                                if (dDLBridge != null) {
                                    object3 = dDLBridge.getDriverSpecification().getRow();
                                    object2 = (String)((HashMap)object3).get(new Integer(4));
                                    ((HashMap)object3).clear();
                                } else {
                                    object2 = resultSet.getString("COLUMN_NAME").trim();
                                }
                                if (linkedList3.contains(((String)object2).toLowerCase()) || linkedList3.contains(linkedList2.get(n3).toString().toLowerCase() + "." + ((String)object2).toLowerCase())) continue;
                                n4 = 0;
                                break;
                            }
                        }
                        if (n4 != 0) {
                            linkedList4.add(linkedList2.get(n3).toString());
                        }
                        resultSet.close();
                    }
                    if (n4 != 0) {
                        for (n3 = 0; n3 < linkedList4.size(); ++n3) {
                            int n5;
                            tableElementImpl.initIndexes(connectionProvider, linkedList4.get(n3).toString());
                            tableElementImpl.initKeys(connectionProvider, 1, linkedList4.get(n3).toString());
                            object2 = new LinkedList();
                            object3 = tableElement.getUniqueKeys();
                            for (n5 = 0; n5 < ((UniqueKeyElement[])object3).length; ++n5) {
                                if (!object3[n5].isPrimaryKey()) continue;
                                ((LinkedList)object2).add(object3[n5]);
                            }
                            object3 = new UniqueKeyElement[((LinkedList)object2).size()];
                            for (n5 = 0; n5 < ((LinkedList)object2).size(); ++n5) {
                                object3[n5] = (UniqueKeyElement)((LinkedList)object2).get(n5);
                            }
                            tableElement.setKeys((KeyElement[])object3);
                            indexElementArray = new IndexElement[((Object)object3).length];
                            for (int j = 0; j < ((Object)object3).length; ++j) {
                                indexElementArray[j] = ((UniqueKeyElement)object3[j]).getAssociatedIndex();
                            }
                            tableElement.setIndexes(indexElementArray);
                        }
                    }
                    if (tableElement.getUniqueKeys().length > 1) {
                        IndexElementImpl indexElementImpl = new IndexElementImpl(tableElementImpl, "GENERATED_PK_" + tableElementImpl.getName().getName(), true);
                        object2 = new IndexElement[]{new IndexElement(indexElementImpl, tableElement)};
                        object3 = tableElement.getIndexes();
                        for (int j = 0; j < ((Object)object3).length; ++j) {
                            indexElementImpl.changeColumns(((IndexElement)object3[j]).getColumns(), 1);
                        }
                        tableElement.setIndexes((IndexElement[])object2);
                        indexElementArray = tableElement.getIndexes()[0];
                        UniqueKeyElementImpl uniqueKeyElementImpl = new UniqueKeyElementImpl(indexElementArray.getName().getName(), true);
                        object = new UniqueKeyElement(uniqueKeyElementImpl, tableElement, (IndexElement)indexElementArray);
                        ((KeyElement)object).setColumns(indexElementArray.getColumns());
                        tableElementImpl.changeKeys(new UniqueKeyElement[]{object}, 0);
                    }
                    LinkedList<String> linkedList5 = new LinkedList<String>();
                    object2 = new LinkedList();
                    object3 = new LinkedList();
                    for (n2 = 0; n2 < linkedList2.size(); ++n2) {
                        int n6;
                        String string3;
                        if (this.isStop()) {
                            return;
                        }
                        if (dDLBridge != null) {
                            dDLBridge.getDriverSpecification().getImportedKeys(linkedList2.get(n2).toString());
                            resultSet = dDLBridge.getDriverSpecification().getResultSet();
                        } else {
                            resultSet = connectionProvider.getDatabaseMetaData().getImportedKeys(connectionProvider.getConnection().getCatalog(), connectionProvider.getSchema(), linkedList2.get(n2).toString());
                        }
                        if (resultSet == null) continue;
                        HashMap hashMap = new HashMap();
                        object = new LinkedList();
                        keyElementArray = new LinkedList();
                        LinkedList<String> linkedList6 = new LinkedList<String>();
                        while (resultSet.next()) {
                            String string4;
                            String string5;
                            String string6;
                            String string7;
                            if (dDLBridge != null) {
                                hashMap = dDLBridge.getDriverSpecification().getRow();
                                string7 = (String)hashMap.get(new Integer(1));
                                string6 = (String)hashMap.get(new Integer(2));
                                string5 = (String)hashMap.get(new Integer(5));
                                string4 = (String)hashMap.get(new Integer(6));
                                if (!this.comp(string7, string5) || !this.comp(string6, string4) || (string3 = (String)hashMap.get(new Integer(12))) == null) continue;
                                string3 = string3.trim();
                                ((LinkedList)object).add(string3 + "." + (String)hashMap.get(new Integer(7)) + "." + (String)hashMap.get(new Integer(8)));
                                keyElementArray.add(string3 + "." + (String)hashMap.get(new Integer(3)) + "." + (String)hashMap.get(new Integer(4)));
                                if (!linkedList6.contains(string3)) {
                                    linkedList6.add(string3);
                                }
                                hashMap.clear();
                                continue;
                            }
                            string7 = resultSet.getString("PKTABLE_CAT");
                            string6 = resultSet.getString("PKTABLE_SCHEM");
                            string5 = resultSet.getString("FKTABLE_CAT");
                            string4 = resultSet.getString("FKTABLE_SCHEM");
                            if (!this.comp(string7, string5) || !this.comp(string6, string4) || (string3 = resultSet.getString("FK_NAME")) == null) continue;
                            string3 = string3.trim();
                            ((LinkedList)object).add(string3 + "." + resultSet.getString("FKTABLE_NAME").trim() + "." + resultSet.getString("FKCOLUMN_NAME").trim());
                            keyElementArray.add(string3 + "." + resultSet.getString("PKTABLE_NAME").trim() + "." + resultSet.getString("PKCOLUMN_NAME").trim());
                            if (linkedList6.contains(string3)) continue;
                            linkedList6.add(string3);
                        }
                        resultSet.close();
                        block11: for (int j = 0; j < linkedList6.size(); ++j) {
                            String string8;
                            string3 = linkedList6.get(j).toString();
                            for (n6 = 0; n6 < ((LinkedList)object).size(); ++n6) {
                                string8 = ((LinkedList)object).get(n6).toString();
                                if (!string8.startsWith(string3)) continue;
                                string8 = string8.substring(string8.lastIndexOf(".") + 1).toLowerCase();
                                if (bl || linkedList3.contains(string8) || linkedList3.contains(linkedList2.get(n2).toString().toLowerCase() + "." + string8)) continue;
                                linkedList6.set(j, null);
                                break;
                            }
                            if (linkedList6.get(j) == null) continue;
                            for (n6 = 0; n6 < keyElementArray.size(); ++n6) {
                                string8 = keyElementArray.get(n6).toString();
                                if (!string8.startsWith(string3)) continue;
                                if (this.getTable(DBIdentifier.create(string8 = string8.substring(string8.indexOf(".") + 1, string8.lastIndexOf(".")))) != null) continue block11;
                                linkedList5.add(string8);
                                continue block11;
                            }
                        }
                        String string9 = linkedList2.get(n2).toString();
                        for (n6 = 0; n6 < linkedList6.size(); ++n6) {
                            Object e = linkedList6.get(n6);
                            if (e == null) continue;
                            ((LinkedList)object2).add(e);
                            if (((LinkedList)object3).contains(string9)) continue;
                            ((LinkedList)object3).add(string9);
                        }
                    }
                    this.initTables(connectionProvider, this.checkReferences(linkedList5, dDLBridge, connectionProvider.getSchema()));
                    for (n2 = 0; n2 < ((LinkedList)object3).size(); ++n2) {
                        tableElementImpl.initKeys(connectionProvider, 2, ((LinkedList)object3).get(n2).toString());
                    }
                    indexElementArray = new LinkedList();
                    ForeignKeyElement[] foreignKeyElementArray = tableElement.getForeignKeys();
                    object = tableElement.getUniqueKeys();
                    for (int j = 0; j < foreignKeyElementArray.length; ++j) {
                        if (!((LinkedList)object2).contains(foreignKeyElementArray[j].getName().getName())) continue;
                        indexElementArray.add(foreignKeyElementArray[j]);
                    }
                    keyElementArray = new KeyElement[((UniqueKeyElement[])object).length + indexElementArray.size()];
                    for (n = 0; n < ((UniqueKeyElement[])object).length; ++n) {
                        keyElementArray[n] = object[n];
                    }
                    n = ((Object)object).length;
                    for (int j = 0; j < indexElementArray.size(); ++j) {
                        keyElementArray[j + n] = (ForeignKeyElement)indexElementArray.get(j);
                    }
                    tableElement.setKeys(keyElementArray);
                }
            }
            this.changeTables(new TableElement[]{tableElement}, 1);
            ++this.progress;
            this.propertySupport.firePropertyChange("progress", null, new Integer(this.progress));
        }
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String string) throws DBException {
        this._url = string;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String string) throws DBException {
        this._username = string;
    }

    public String getDriver() {
        return this._driver;
    }

    public void setDriver(String string) {
        this._driver = string;
    }

    public String getDatabaseProductName() {
        return this._databaseProductName;
    }

    public void setDatabaseProductName(String string) throws DBException {
        this._databaseProductName = string;
    }

    public String getDatabaseProductVersion() {
        return this._databaseProductVersion;
    }

    public void setDatabaseProductVersion(String string) throws DBException {
        this._databaseProductVersion = string;
    }

    public String getDriverName() {
        return this._driverName;
    }

    public void setDriverName(String string) throws DBException {
        this._driverName = string;
    }

    public String getDriverVersion() {
        return this._driverVersion;
    }

    public void setDriverVersion(String string) throws DBException {
        this._driverVersion = string;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean bl) {
        this.stop = bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public DBElementsCollection getTableCollection() {
        return this.tables;
    }

    public void setTableCollection(DBElementsCollection dBElementsCollection) {
        this.tables = dBElementsCollection;
    }
}

