/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.servlet;

import com.sun.enterprise.tools.admingui.servlet.DownloadServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.compiler.JspUtil;

public class LockhartContentSource
implements DownloadServlet.ContentSource {
    private static final String PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    private static final String SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    private static final String JSP_CLASS_PREFIX = "org.apache.jsp.";
    static final long DEFAULT_MODIFIED_DATE = new Date().getTime();

    public String getId() {
        return "Lockhart";
    }

    public InputStream getInputStream(DownloadServlet.Context ctx) {
        HttpServletRequest request = (HttpServletRequest)ctx.getServletRequest();
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.length() == 0) {
            return null;
        }
        ServletContext sc = ctx.getServletConfig().getServletContext();
        String servletPath = request.getServletPath();
        String realPath = sc.getRealPath(servletPath);
        File file = new File(realPath + pathInfo);
        InputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            is = this.getClass().getClassLoader().getResourceAsStream(servletPath.substring(1) + pathInfo);
        }
        int index = pathInfo.lastIndexOf(46);
        String extnsn = pathInfo.substring(index + 1);
        ctx.setAttribute("extension", extnsn);
        ctx.setAttribute("filePath", is);
        ctx.setAttribute("JSP_PAGE_SERVED", "false");
        return is;
    }

    public boolean isJSP(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String pathInfo = request.getPathInfo();
        return uri.indexOf("jsp") > -1 && pathInfo.endsWith(".jsp");
    }

    public void cleanUp(DownloadServlet.Context ctx) {
        InputStream is = (InputStream)ctx.getAttribute("filePath");
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ctx.removeAttribute("filePath");
    }

    public long getLastModified(DownloadServlet.Context context) {
        if (this.isJSP((HttpServletRequest)context.getServletRequest())) {
            return -1L;
        }
        return DEFAULT_MODIFIED_DATE;
    }

    private void serveJSPPage(DownloadServlet.Context ctx) {
        HttpServletRequest request = (HttpServletRequest)ctx.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)ctx.getServletResponse();
        String pathInfo = (String)request.getAttribute(PATH_INFO_ATTRIBUTE);
        String servletPath = (String)request.getAttribute(SERVLET_PATH_ATTRIBUTE);
        if (servletPath == null) {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        String className = this.getClassName(servletPath, pathInfo);
        try {
            Class<?> cls = Class.forName(className);
            Object obj = cls.newInstance();
            ((HttpServlet)obj).init(ctx.getServletConfig());
            ((HttpServlet)obj).service((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected String getClassName(String servletPath, String jspName) {
        return this.getClassName(servletPath + jspName);
    }

    protected String getClassName(String fullPath) {
        int lastSlash = (fullPath = fullPath.trim()).lastIndexOf(47);
        if (lastSlash == -1) {
            return JSP_CLASS_PREFIX + JspUtil.makeJavaIdentifier((String)fullPath);
        }
        String packageName = fullPath.substring(0, ++lastSlash);
        String jspName = fullPath.substring(lastSlash);
        int loc = packageName.indexOf("//");
        while (loc != -1) {
            packageName = packageName.replaceAll("//", "/");
            loc = packageName.indexOf("//");
        }
        if (packageName.startsWith("/")) {
            packageName = packageName.substring(1);
        }
        StringTokenizer tok = new StringTokenizer(packageName, "/");
        StringBuffer className = new StringBuffer(JSP_CLASS_PREFIX);
        while (tok.hasMoreTokens()) {
            className.append(JspUtil.makeJavaIdentifier((String)tok.nextToken()));
            className.append('.');
        }
        className.append(JspUtil.makeJavaIdentifier((String)jspName));
        return className.toString();
    }
}

