/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.HealthCheckerConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.enterprise.tools.admingui.handlers.ApplicationHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Field;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoadBalancerHandlers {
    public static void getLoadBalancersList(HandlerContext handlerCtx) {
        Map loadBalancerConfigMap = AMXUtil.getDomainConfig().getLoadBalancerConfigMap();
        ArrayList result = new ArrayList();
        for (String key : loadBalancerConfigMap.keySet()) {
            try {
                String status = GuiUtil.getMessage("loadBalancer.unknown");
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("name", key);
                LoadBalancer lb = (LoadBalancer)AMXUtil.getDomainRoot().getLoadBalancerMap().get(key);
                if (lb != null) {
                    status = GuiUtil.getMessage(lb.isApplyChangeRequired() ? "loadBalancer.needApply" : "loadBalancer.upToDate");
                }
                oneRow.put("status", status);
                oneRow.put("selected", false);
                result.add(oneRow);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getLbTargets(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        try {
            String lbName = (String)handlerCtx.getInputValue("lbName");
            LoadBalancerConfig loadBalancer = (LoadBalancerConfig)AMXUtil.getDomainConfig().getLoadBalancerConfigMap().get(lbName);
            String lbConfigName = loadBalancer.getLbConfigName();
            if (GuiUtil.isEmpty(lbConfigName)) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            LBConfig lbConfig = (LBConfig)AMXUtil.getDomainConfig().getLBConfigMap().get(lbConfigName);
            if (lbConfig == null) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            Map serverRefMap = lbConfig.getServerRefConfigMap();
            Set targets = serverRefMap.keySet();
            Boolean isCluster = false;
            if (serverRefMap.isEmpty()) {
                Map clusterRefMap = lbConfig.getClusterRefConfigMap();
                if (clusterRefMap.isEmpty()) {
                    handlerCtx.setOutputValue("isCluster", (Object)isCluster);
                    handlerCtx.setOutputValue("result", result);
                    return;
                }
                isCluster = true;
                targets = clusterRefMap.keySet();
            }
            handlerCtx.setOutputValue("isCluster", (Object)isCluster);
            for (String key : targets) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                oneRow.put("name", key);
                if (isCluster.booleanValue()) {
                    oneRow.put("url", "/cluster/clusterGeneral.jsf?clusterName=" + key);
                } else {
                    oneRow.put("url", "/standalone/standaloneInstanceGeneral.jsf?instanceName=" + key);
                }
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void deleteSelectedLoadBalancers(HandlerContext handlerCtx) {
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                LoadBalancerHandlers.removeLoadbalancer((String)oneRow.get("name"));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void removeLoadbalancer(String loadbalancerName) {
        LoadBalancerConfig loadBalancerConfig = (LoadBalancerConfig)AMXUtil.getDomainConfig().getLoadBalancerConfigMap().get(loadbalancerName);
        if (loadBalancerConfig == null) {
            return;
        }
        String lbConfigName = loadBalancerConfig.getLbConfigName();
        AMXUtil.getDomainConfig().removeLoadBalancerConfig(loadbalancerName);
        Map lbMap = AMXUtil.getDomainConfig().getLoadBalancerConfigMap();
        if (lbMap == null || lbMap.isEmpty()) {
            AMXUtil.getDomainConfig().removeLBConfig(lbConfigName);
            return;
        }
        for (LoadBalancerConfig lbConfig : lbMap.values()) {
            if (!lbConfig.getLbConfigName().equals(lbConfigName)) continue;
            return;
        }
        AMXUtil.getDomainConfig().removeLBConfig(lbConfigName);
    }

    public static void createLoadBalancer(HandlerContext handlerCtx) {
        Boolean enableAllApps;
        Boolean enableAllInstances;
        String lbName = (String)handlerCtx.getInputValue("lbName");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        Boolean autoApply = (Boolean)handlerCtx.getInputValue("autoApply");
        if (autoApply == null) {
            autoApply = false;
        }
        if ((enableAllInstances = (Boolean)handlerCtx.getInputValue("enableAllInstances")) == null) {
            enableAllInstances = false;
        }
        if ((enableAllApps = (Boolean)handlerCtx.getInputValue("enableAllApps")) == null) {
            enableAllApps = false;
        }
        String deviceHost = (String)handlerCtx.getInputValue("deviceHost");
        String devicePort = (String)handlerCtx.getInputValue("devicePort");
        String proxyHost = (String)handlerCtx.getInputValue("proxyHost");
        String proxyPort = (String)handlerCtx.getInputValue("proxyPort");
        try {
            LoadBalancerConfig loadBalancerConfig = AMXUtil.getLBConfigHelper().createLoadbalancer(lbName, autoApply.booleanValue(), targets, null);
            loadBalancerConfig.createProperty("device-host", deviceHost);
            loadBalancerConfig.createProperty("device-admin-port", devicePort);
            if (!GuiUtil.isEmpty(proxyHost)) {
                loadBalancerConfig.createProperty("ssl-proxy-host", proxyHost);
            }
            if (!GuiUtil.isEmpty(proxyPort)) {
                loadBalancerConfig.createProperty("ssl-proxy-port", proxyPort);
            }
            if (targets != null) {
                int i;
                if (enableAllInstances.booleanValue()) {
                    for (i = 0; i < targets.length; ++i) {
                        AMXUtil.getLBConfigHelper().enableServer(targets[i], true);
                    }
                }
                if (enableAllApps.booleanValue()) {
                    for (i = 0; i < targets.length; ++i) {
                        AMXUtil.getLBConfigHelper().enableAllApplications(targets[i]);
                    }
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLoadBalancerInfo(HandlerContext handlerCtx) {
        String lbName = (String)handlerCtx.getInputValue("lbName");
        LoadBalancerConfig loadBalancerConfig = (LoadBalancerConfig)AMXUtil.getDomainConfig().getLoadBalancerConfigMap().get(lbName);
        if (loadBalancerConfig == null) {
            handlerCtx.setOutputValue("applyEnable", (Object)false);
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchLB", new Object[]{lbName}));
            return;
        }
        handlerCtx.setOutputValue("autoApply", (Object)loadBalancerConfig.getAutoApplyEnabled());
        handlerCtx.setOutputValue("mbean", (Object)loadBalancerConfig);
    }

    public static void saveLoadBalancer(HandlerContext handlerCtx) {
        try {
            String lbName = (String)handlerCtx.getInputValue("lbName");
            Boolean autoApply = (Boolean)handlerCtx.getInputValue("autoApply");
            LoadBalancerConfig loadBalancerConfig = (LoadBalancerConfig)AMXUtil.getDomainConfig().getLoadBalancerConfigMap().get(lbName);
            if (loadBalancerConfig == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.loadBalancer.NoSuchLB", new Object[]{lbName}));
                return;
            }
            loadBalancerConfig.setAutoApplyEnabled(autoApply == null ? false : autoApply);
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)loadBalancerConfig);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void testLoadBalancerConnection(HandlerContext handlerCtx) {
        String lbName = (String)handlerCtx.getInputValue("lbName");
        Map lbMap = AMXUtil.getDomainRoot().getLoadBalancerMap();
        if (lbMap == null) {
            System.out.println("testLoadBalancerConnection(): AMX getLoadBalancerMap() returns null");
            GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.loadBalancer.NoSuchLB", new Object[]{lbName}), null);
            return;
        }
        LoadBalancer loadBalancer = (LoadBalancer)lbMap.get(lbName);
        try {
            if (loadBalancer == null) {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.loadBalancer.NoSuchLB", new Object[]{lbName}), null);
                System.out.println("testLoadBalancerConnection(): lbMap.get(" + lbName + ")returns null");
                System.out.println("loadbalancer map returned from getLoadBalancerMap() : " + lbMap);
            } else {
                Boolean ok = loadBalancer.testConnection();
                if (ok.booleanValue()) {
                    GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.loadBalancer.TestConnectionSuccess"), null);
                } else {
                    GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.loadBalancer.TestConnectionFailed"), null);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLBConfigInfo(HandlerContext handlerCtx) {
        String lbName = (String)handlerCtx.getInputValue("lbName");
        LBConfig lbConfig = LoadBalancerHandlers.getLBConfigOfLoadBalancer(lbName);
        if (lbConfig == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchLB", new Object[]{lbName}));
            return;
        }
        String lbConfigName = lbConfig.getName();
        HashMap<String, Object> advance = new HashMap<String, Object>();
        handlerCtx.setOutputValue("lbConfigName", (Object)lbConfigName);
        advance.put("responseTimeoutInSeconds", lbConfig.getResponseTimeoutInSeconds());
        advance.put("reloadPollIntervalInSeconds", lbConfig.getReloadPollIntervalInSeconds());
        advance.put("httpsRouting", lbConfig.getHttpsRouting());
        advance.put("monitoringEnabled", lbConfig.getMonitoringEnabled());
        advance.put("routeCookieEnabled", lbConfig.getRouteCookieEnabled());
        handlerCtx.setOutputValue("advance", advance);
        Map props = lbConfig.getProperties();
        handlerCtx.setOutputValue("props", (Object)props);
    }

    public static void getLBConfigDefault(HandlerContext handlerCtx) {
        HashMap advance = new HashMap();
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-LBConfig");
        advance.put("responseTimeoutInSeconds", defaultMap.get("response-timeout-in-seconds"));
        advance.put("reloadPollIntervalInSeconds", defaultMap.get("reload-poll-interval-in-seconds"));
        advance.put("httpsRouting", Boolean.parseBoolean((String)defaultMap.get("https-routing")));
        advance.put("monitoringEnabled", Boolean.parseBoolean((String)defaultMap.get("monitoring-enabled")));
        advance.put("routeCookieEnabled", Boolean.parseBoolean((String)defaultMap.get("route-cookie-enabled")));
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void saveLBConfig(HandlerContext handlerCtx) {
        String lbConfigName = (String)handlerCtx.getInputValue("lbConfigName");
        Map advance = (Map)handlerCtx.getInputValue("advance");
        try {
            LBConfig lbConfig = (LBConfig)AMXUtil.getDomainConfig().getLBConfigMap().get(lbConfigName);
            if (lbConfig == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("loadBalancer.noSuchLBError"));
                return;
            }
            lbConfig.setResponseTimeoutInSeconds((String)advance.get("responseTimeoutInSeconds"));
            lbConfig.setReloadPollIntervalInSeconds((String)advance.get("reloadPollIntervalInSeconds"));
            Boolean temp = (Boolean)advance.get("httpsRouting");
            lbConfig.setHttpsRouting(temp == null ? false : temp);
            temp = (Boolean)advance.get("monitoringEnabled");
            lbConfig.setMonitoringEnabled(temp == null ? false : temp);
            temp = (Boolean)advance.get("routeCookieEnabled");
            lbConfig.setRouteCookieEnabled(temp == null ? false : temp);
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)lbConfig);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLoadBalancerTargetTableList(HandlerContext handlerCtx) {
        String lbName = (String)handlerCtx.getInputValue("lbName");
        LBConfig lbConfig = LoadBalancerHandlers.getLBConfigOfLoadBalancer(lbName);
        if (lbConfig == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchLB", new Object[]{lbName}));
            return;
        }
        String[] targets = AMXUtil.getLBConfigHelper().listTargets(lbName);
        ArrayList result = new ArrayList();
        boolean isCluster = true;
        if (targets.length > 0) {
            isCluster = TargetUtil.isCluster(targets[0]);
        }
        for (int i = 0; i < targets.length; ++i) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            String targetName = targets[i];
            oneRow.put("targetName", targetName);
            oneRow.put("lbConfigName", lbConfig.getName());
            oneRow.put("selected", false);
            oneRow.put("appLink", ApplicationHandlers.getNumberLBAppsByTarget(targetName));
            if (isCluster) {
                oneRow.put("policy", ((ClusterRefConfig)lbConfig.getClusterRefConfigMap().get(targetName)).getLBPolicy());
                oneRow.put("targetLink", "/cluster/clusterGeneral.jsf?clusterName=" + targetName);
                oneRow.put("clusterInstanceLink", TargetUtil.getNumberLBInstancesByTarget(targetName));
            } else {
                oneRow.put("lbEnabled", ((ServerRefConfig)lbConfig.getServerRefConfigMap().get(targetName)).getLBEnabled());
                oneRow.put("responseTimeoutInMinutes", "" + ((ServerRefConfig)lbConfig.getServerRefConfigMap().get(targetName)).getDisableTimeoutInMinutes());
                oneRow.put("targetLink", "/standalone/standaloneInstanceGeneral.jsf?instanceName=" + targetName);
            }
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("isCluster", (Object)isCluster);
        handlerCtx.setOutputValue("isInstance", (Object)(!isCluster ? 1 : 0));
    }

    public static void createLBTargets(HandlerContext handlerCtx) {
        String lbName = (String)handlerCtx.getInputValue("lbName");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        List<String> selTargets = Arrays.asList(targets);
        boolean isCluster = false;
        String[] targetsArray = AMXUtil.getLBConfigHelper().listTargets(lbName);
        List<String> associatedTargets = Arrays.asList(targetsArray);
        LoadBalancerConfig lb = (LoadBalancerConfig)AMXUtil.getDomainConfig().getLoadBalancerConfigMap().get(lbName);
        String lbConfigName = lb.getLbConfigName();
        LBConfig lbConfig = (LBConfig)AMXUtil.getDomainConfig().getLBConfigMap().get(lbConfigName);
        if (selTargets.size() > 0) {
            isCluster = TargetUtil.isCluster(selTargets.get(0));
            for (String sel : selTargets) {
                AMXConfig sc = null;
                sc = isCluster ? (AMXConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(sel) : (AMXConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(sel);
                if (sc != null) continue;
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("loadBalancer.targetHelp"));
                return;
            }
        }
        try {
            for (String targetName : associatedTargets) {
                if (selTargets.contains(targetName)) continue;
                if (TargetUtil.isCluster(targetName)) {
                    lbConfig.removeClusterRefConfig(targetName);
                    continue;
                }
                lbConfig.removeServerRefConfig(targetName);
            }
            for (String targetName : selTargets) {
                if (associatedTargets.contains(targetName)) continue;
                if (isCluster) {
                    lbConfig.createClusterRefConfig(targetName, null);
                    continue;
                }
                lbConfig.createServerRefConfig(targetName, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLBHealthAndPolicy(HandlerContext handlerCtx) {
        String lbName = (String)handlerCtx.getInputValue("lbName");
        String targetName = (String)handlerCtx.getInputValue("targetName");
        LBConfig lbConfig = LoadBalancerHandlers.getLBConfigOfLoadBalancer(lbName);
        if (lbConfig == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchLB", new Object[]{lbName}));
            return;
        }
        String lbConfigName = lbConfig.getName();
        HashMap<String, Object> advance = new HashMap<String, Object>();
        Boolean isCluster = TargetUtil.isCluster(targetName);
        handlerCtx.setOutputValue("lbConfigName", (Object)lbConfigName);
        handlerCtx.setOutputValue("isCluster", (Object)isCluster);
        handlerCtx.setOutputValue("isInstance", (Object)(isCluster == false ? 1 : 0));
        HealthCheckerConfig hcc = null;
        if (isCluster.booleanValue()) {
            ClusterRefConfig cref = (ClusterRefConfig)lbConfig.getClusterRefConfigMap().get(targetName);
            advance.put("lBPolicy", "" + cref.getLBPolicy());
            String tmp = cref.getLBPolicyModule();
            advance.put("lBPolicyModule", tmp == null ? "" : tmp);
            hcc = cref.getHealthCheckerConfig();
        } else {
            ServerRefConfig sref = (ServerRefConfig)lbConfig.getServerRefConfigMap().get(targetName);
            advance.put("lbEnabled", sref.getLBEnabled());
            advance.put("enabled", sref.getEnabled());
            advance.put("disableTimeoutInMinutes", "" + sref.getDisableTimeoutInMinutes());
            hcc = sref.getHealthCheckerConfig();
        }
        advance.put("url", hcc == null ? "" : hcc.getURL());
        advance.put("intervalInSeconds", hcc == null ? "" : hcc.getIntervalInSeconds());
        advance.put("timeoutInSeconds", hcc == null ? "" : hcc.getTimeoutInSeconds());
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void getLBHealthDefault(HandlerContext handlerCtx) {
        HashMap advance = new HashMap();
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-HealthCheckerConfig");
        Map refMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-ServerRefConfig");
        advance.put("lbEnabled", refMap.get("lb-enabled"));
        advance.put("enabled", refMap.get("enabled"));
        advance.put("disableTimeoutInMinutes", refMap.get("disable-timeout-in-minutes"));
        advance.put("url", defaultMap.get("url"));
        advance.put("intervalInSeconds", defaultMap.get("interval-in-seconds"));
        advance.put("timeoutInSeconds", defaultMap.get("timeout-in-seconds"));
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void saveLBHealthAndPolicy(HandlerContext handlerCtx) {
        String lbConfigName = (String)handlerCtx.getInputValue("lbConfigName");
        String targetName = (String)handlerCtx.getInputValue("targetName");
        Boolean isCluster = TargetUtil.isCluster(targetName);
        Map advance = (Map)handlerCtx.getInputValue("advance");
        try {
            LBConfig lbConfig = (LBConfig)AMXUtil.getDomainConfig().getLBConfigMap().get(lbConfigName);
            if (lbConfig == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("loadBalancer.noSuchLBError"));
                return;
            }
            HealthCheckerConfig hcc = null;
            ClusterRefConfig ref = null;
            if (isCluster.booleanValue()) {
                ClusterRefConfig cref = (ClusterRefConfig)lbConfig.getClusterRefConfigMap().get(targetName);
                String policy = (String)advance.get("lBPolicy");
                cref.setLBPolicy(policy);
                if ("user-defined".equals(policy)) {
                    cref.setLBPolicyModule("" + advance.get("lBPolicyModule"));
                } else {
                    cref.setLBPolicyModule("");
                }
                hcc = cref.getHealthCheckerConfig();
                ref = cref;
            } else {
                ServerRefConfig sref = (ServerRefConfig)lbConfig.getServerRefConfigMap().get(targetName);
                Boolean temp = (Boolean)advance.get("lbEnabled");
                sref.setLBEnabled(temp == null ? false : temp);
                sref.setDisableTimeoutInMinutes(Integer.parseInt("" + advance.get("disableTimeoutInMinutes")));
                hcc = sref.getHealthCheckerConfig();
                ref = sref;
            }
            String url = (String)advance.get("url");
            String intervalInSeconds = (String)advance.get("intervalInSeconds");
            String timeoutInSeconds = (String)advance.get("timeoutInSeconds");
            if (GuiUtil.isEmpty(url) && GuiUtil.isEmpty(intervalInSeconds) && GuiUtil.isEmpty(timeoutInSeconds)) {
                return;
            }
            if (url == null) {
                url = "";
            }
            if (intervalInSeconds == null) {
                intervalInSeconds = "";
            }
            if (timeoutInSeconds == null) {
                timeoutInSeconds = "";
            }
            if (hcc != null) {
                hcc.setURL(url);
                hcc.setIntervalInSeconds(intervalInSeconds);
                hcc.setTimeoutInSeconds(timeoutInSeconds);
            } else {
                ref.createHealthCheckerConfig(url, intervalInSeconds, timeoutInSeconds);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void changeLBEnabled(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        String lbName = (String)handlerCtx.getInputValue("lbName");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        List selectedRows = obj;
        try {
            LBConfig lbConfig = LoadBalancerHandlers.getLBConfigOfLoadBalancer(lbName);
            if (lbConfig == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchLB", new Object[]{lbName}));
                return;
            }
            for (int i = 0; i < selectedRows.size(); ++i) {
                Map oneRow = (Map)selectedRows.get(i);
                String target = (String)oneRow.get("targetName");
                ServerRefConfig sref = (ServerRefConfig)lbConfig.getServerRefConfigMap().get(target);
                if (sref == null) continue;
                sref.setLBEnabled(enabled);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void setDisableModuleField(HandlerContext handlerCtx) {
        String policyValue = (String)handlerCtx.getInputValue("policyValue");
        Field moduleField = (Field)handlerCtx.getInputValue("moduleField");
        if ("user-defined".equals(policyValue)) {
            moduleField.setDisabled(false);
        } else {
            moduleField.setDisabled(true);
        }
    }

    public static void changeInstanceLoadBalancing(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        String cluster = (String)handlerCtx.getInputValue("cluster");
        Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        try {
            Map lbConfigs = AMXUtil.getDomainConfig().getLBConfigMap();
            for (LBConfig lbConfig : lbConfigs.values()) {
                if (cluster != null) {
                    Map serverMap;
                    ServerRefConfig sRefConfig;
                    ClusterConfig clusterConfig = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(cluster);
                    if (clusterConfig == null || (sRefConfig = (ServerRefConfig)(serverMap = clusterConfig.getServerRefConfigMap()).get(instanceName)) == null) continue;
                    sRefConfig.setLBEnabled(enabled.booleanValue());
                    continue;
                }
                Map serverRefs = lbConfig.getServerRefConfigMap();
                ServerRefConfig sRef = (ServerRefConfig)serverRefs.get(instanceName);
                if (sRef == null) continue;
                sRef.setLBEnabled(enabled.booleanValue());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLBExportInfo(HandlerContext handlerCtx) {
        String lbName = (String)handlerCtx.getInputValue("lbName");
        LoadBalancer loadBalancer = (LoadBalancer)AMXUtil.getDomainRoot().getLoadBalancerMap().get(lbName);
        LBConfig lBConfig = LoadBalancerHandlers.getLBConfigOfLoadBalancer(lbName);
        if (loadBalancer == null || lBConfig == null) {
            GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.loadBalancer.NoSuchLB", new Object[]{lbName}), null);
        }
        try {
            Date lastApplyDate = loadBalancer.getLastApplied();
            Date lastExportDate = loadBalancer.getLastExported();
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, GuiUtil.getLocale());
            String lastApply = lastApplyDate == null ? "" : dateFormat.format(lastApplyDate);
            String lastExport = lastExportDate == null ? "" : dateFormat.format(lastExportDate);
            handlerCtx.setOutputValue("lastApply", (Object)lastApply);
            handlerCtx.setOutputValue("lastExport", (Object)lastExport);
            handlerCtx.setOutputValue("lbConfigName", (Object)lBConfig.getName());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void applyLBChanges(HandlerContext handlerCtx) {
        String lbName = (String)handlerCtx.getInputValue("lbName");
        LoadBalancer loadBalancer = (LoadBalancer)AMXUtil.getDomainRoot().getLoadBalancerMap().get(lbName);
        if (loadBalancer == null) {
            GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.loadBalancer.NoSuchLB", new Object[]{lbName}), null);
        }
        try {
            loadBalancer.applyLBChanges();
            GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.ApplyLBSuccessful"), null);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLBforTarget(HandlerContext handlerCtx) {
        String targetName = (String)handlerCtx.getInputValue("targetName");
        Boolean isCluster = (Boolean)handlerCtx.getInputValue("isCluster");
        ArrayList result = new ArrayList();
        try {
            Map lbMap = AMXUtil.getLBConfigHelper().getLoadBalancers(targetName, isCluster.booleanValue());
            for (String lbName : lbMap.keySet()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                oneRow.put("lbName", lbName);
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("hasLB", (Object)(!result.isEmpty() ? 1 : 0));
        handlerCtx.setOutputValue("result", result);
    }

    private static LBConfig getLBConfigOfLoadBalancer(String lbName) {
        LoadBalancerConfig loadBalancerConfig = (LoadBalancerConfig)AMXUtil.getDomainConfig().getLoadBalancerConfigMap().get(lbName);
        if (loadBalancerConfig == null) {
            return null;
        }
        String lbConfigName = loadBalancerConfig.getLbConfigName();
        LBConfig lbConfig = (LBConfig)AMXUtil.getDomainConfig().getLBConfigMap().get(lbConfigName);
        return lbConfig;
    }
}

