/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.CustomResourceConfig;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.JNDIResourceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.enterprise.tools.admingui.handlers.JavaMailHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.HashMap;
import java.util.Map;

public class JndiResourceHandlers {
    public static void getJndiResourceInfo(HandlerContext handlerCtx) {
        String description;
        String factoryClass;
        String resType;
        if (!((Boolean)handlerCtx.getInputValue("edit")).booleanValue()) {
            handlerCtx.setOutputValue("enabled", (Object)Boolean.TRUE);
            handlerCtx.setOutputValue("Properties", new HashMap());
            return;
        }
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        String type = (String)handlerCtx.getInputValue("type");
        if (type.equals("custom")) {
            CustomResourceConfig customRes = (CustomResourceConfig)AMXUtil.getDomainConfig().getCustomResourceConfigMap().get(jndiName);
            if (customRes == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchCustomResource"));
                return;
            }
            resType = customRes.getResType();
            factoryClass = customRes.getFactoryClass();
            description = customRes.getDescription();
            if (AMXUtil.isEE()) {
                handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)customRes, false));
            } else {
                handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isResourceEnabled((Enabled)customRes, "server"));
            }
            Map props = customRes.getProperties();
            handlerCtx.setOutputValue("Properties", (Object)props);
        } else {
            JNDIResourceConfig jndiRes = (JNDIResourceConfig)AMXUtil.getDomainConfig().getJNDIResourceConfigMap().get(jndiName);
            if (jndiRes == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchExternalResource"));
                return;
            }
            resType = jndiRes.getResType();
            factoryClass = jndiRes.getFactoryClass();
            description = jndiRes.getDescription();
            handlerCtx.setOutputValue("jndiLookupName", (Object)jndiRes.getJNDILookupName());
            if (AMXUtil.isEE()) {
                handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)jndiRes, false));
            } else {
                handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isResourceEnabled((Enabled)jndiRes, "server"));
            }
            Map props = jndiRes.getProperties();
            handlerCtx.setOutputValue("Properties", (Object)props);
        }
        handlerCtx.setOutputValue("resType", (Object)resType);
        handlerCtx.setOutputValue("factoryClass", (Object)factoryClass);
        handlerCtx.setOutputValue("description", (Object)description);
    }

    public static void saveJndiResource(HandlerContext handlerCtx) {
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
            if (!edit.booleanValue()) {
                JndiResourceHandlers.createJndiResource(handlerCtx);
                return;
            }
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            String type = (String)handlerCtx.getInputValue("type");
            CustomResourceConfig resource = null;
            if (type.equals("custom")) {
                CustomResourceConfig custom = (CustomResourceConfig)AMXUtil.getDomainConfig().getCustomResourceConfigMap().get(jndiName);
                resource = custom;
                if (resource == null) {
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchResource"));
                    return;
                }
                custom.setResType((String)handlerCtx.getInputValue("resType"));
                custom.setFactoryClass((String)handlerCtx.getInputValue("factoryClass"));
            } else {
                JNDIResourceConfig jndi = null;
                jndi = (JNDIResourceConfig)AMXUtil.getDomainConfig().getJNDIResourceConfigMap().get(jndiName);
                resource = jndi;
                if (resource == null) {
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchResource"));
                    return;
                }
                jndi.setJNDILookupName((String)handlerCtx.getInputValue("jndiLookupName"));
                jndi.setResType((String)handlerCtx.getInputValue("resType"));
                jndi.setFactoryClass((String)handlerCtx.getInputValue("factoryClass"));
            }
            resource.setDescription((String)handlerCtx.getInputValue("description"));
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)resource);
            if (!AMXUtil.isEE()) {
                Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                TargetUtil.setResourceEnabled((Enabled)resource, "server", enabled);
            }
            GuiUtil.prepareSuccessful(handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void createJndiResource(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            String type = (String)handlerCtx.getInputValue("type");
            String resType = (String)handlerCtx.getInputValue("resType");
            String factoryClass = (String)handlerCtx.getInputValue("factoryClass");
            Object resource = null;
            Map optionalMap = AMXUtil.convertToPropertiesOptionMap((Map)handlerCtx.getInputValue("AddProps"), null);
            resource = type.equals("custom") ? AMXUtil.getDomainConfig().createCustomResourceConfig(jndiName, resType, factoryClass, optionalMap) : AMXUtil.getDomainConfig().createJNDIResourceConfig(jndiName, (String)handlerCtx.getInputValue("jndiLookupName"), resType, factoryClass, optionalMap);
            JavaMailHandlers.createNewTargets(handlerCtx, jndiName);
            resource.setDescription((String)handlerCtx.getInputValue("description"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }
}

