/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.GroupManagementServiceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.HashMap;
import java.util.Map;

public class GmsHandler {
    public static void getGmsInfo(HandlerContext handlerCtx) {
        GroupManagementServiceConfig gms = null;
        String configName = (String)handlerCtx.getInputValue("configName");
        ConfigConfig config = (ConfigConfig)AMXUtil.getDomainConfig().getConfigConfigMap().get(configName);
        if (config != null) {
            gms = config.getGroupManagementServiceConfig();
        }
        if (gms == null) {
            handlerCtx.setOutputValue("Properties", new HashMap());
            return;
        }
        handlerCtx.setOutputValue("fdMax", (Object)gms.getFDProtocolMaxTries());
        handlerCtx.setOutputValue("fdTimeout", (Object)gms.getFDProtocolTimeoutMillis());
        handlerCtx.setOutputValue("mergeMax", (Object)gms.getMergeProtocolMaxIntervalMillis());
        handlerCtx.setOutputValue("mergeMin", (Object)gms.getMergeProtocolMinIntervalMillis());
        handlerCtx.setOutputValue("pingTimeout", (Object)gms.getPingProtocolTimeoutMillis());
        handlerCtx.setOutputValue("vsTimeout", (Object)gms.getVSProtocolTimeoutMillis());
        handlerCtx.setOutputValue("Properties", (Object)gms.getProperties());
    }

    public static void saveGmsSettings(HandlerContext handlerCtx) {
        GroupManagementServiceConfig gms = null;
        String configName = (String)handlerCtx.getInputValue("configName");
        try {
            ConfigConfig config = (ConfigConfig)AMXUtil.getDomainConfig().getConfigConfigMap().get(configName);
            if (config != null) {
                gms = config.getGroupManagementServiceConfig();
            }
            if (gms == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoAMXGmsSupport"));
                return;
            }
            gms.setFDProtocolMaxTries(GmsHandler.getAttrString(handlerCtx, "fdMax"));
            gms.setFDProtocolTimeoutMillis(GmsHandler.getAttrString(handlerCtx, "fdTimeout"));
            gms.setMergeProtocolMaxIntervalMillis(GmsHandler.getAttrString(handlerCtx, "mergeMax"));
            gms.setMergeProtocolMinIntervalMillis(GmsHandler.getAttrString(handlerCtx, "mergeMin"));
            gms.setPingProtocolTimeoutMillis(GmsHandler.getAttrString(handlerCtx, "pingTimeout"));
            gms.setVSProtocolTimeoutMillis(GmsHandler.getAttrString(handlerCtx, "vsTimeout"));
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)gms);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String getAttrString(HandlerContext handlerCtx, String nm) {
        String value = (String)handlerCtx.getInputValue(nm);
        return value == null ? "" : value;
    }

    public static void getGmsDefaultSettings(HandlerContext handlerCtx) {
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-GroupManagementServiceConfig");
        handlerCtx.setOutputValue("fdMax", (Object)((String)defaultMap.get("fd-protocol-max-tries")));
        handlerCtx.setOutputValue("fdTimeout", (Object)((String)defaultMap.get("fd-protocol-timeout-in-millis")));
        handlerCtx.setOutputValue("mergeMax", (Object)((String)defaultMap.get("merge-protocol-max-interval-in-millis")));
        handlerCtx.setOutputValue("mergeMin", (Object)((String)defaultMap.get("merge-protocol-min-interval-in-millis")));
        handlerCtx.setOutputValue("pingTimeout", (Object)((String)defaultMap.get("ping-protocol-timeout-in-millis")));
        handlerCtx.setOutputValue("vsTimeout", (Object)((String)defaultMap.get("vs-protocol-timeout-in-millis")));
    }
}

