/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.enterprise.tools.admingui.handlers.ConnectorsHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.layout.LayoutViewHandler;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class EESupportHandlers {
    public static void checkSupport(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("supportCluster", (Object)AMXUtil.supportCluster());
        handlerCtx.setOutputValue("supportHADB", (Object)false);
    }

    public static void getClustersList(HandlerContext handlerCtx) {
        Set clusterSet = AMXUtil.getDomainConfig().getClusterConfigMap().keySet();
        ArrayList sortedClusterList = new ArrayList(new TreeSet(clusterSet));
        handlerCtx.setOutputValue("clusterList", sortedClusterList);
        handlerCtx.setOutputValue("hasCluster", (Object)(sortedClusterList.size() > 0 ? 1 : 0));
    }

    public static void getStandaloneServerList(HandlerContext handlerCtx) {
        Set serverSet = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().keySet();
        ArrayList sortedServerList = new ArrayList(new TreeSet(serverSet));
        handlerCtx.setOutputValue("serverList", sortedServerList);
    }

    public static void getAllServerList(HandlerContext handlerCtx) {
        Set standaloneSet = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().keySet();
        Set clusteredSet = AMXUtil.getDomainConfig().getClusteredServerConfigMap().keySet();
        ArrayList serverList = new ArrayList(standaloneSet);
        serverList.addAll(clusteredSet);
        handlerCtx.setOutputValue("serverList", serverList);
    }

    public static void getAllVSList(HandlerContext handlerCtx) {
        String targetName = (String)handlerCtx.getInputValue("targetName");
        Boolean PE = (Boolean)handlerCtx.getInputValue("PE");
        Set vsList = TargetUtil.getVirtualServers(targetName);
        ArrayList<String> serverList = new ArrayList<String>(vsList);
        if (PE != null && PE.booleanValue()) {
            String noneSelected = GuiUtil.getMessage("deploy.option.NoneSelected");
            serverList.add(0, noneSelected);
        }
        boolean remove = serverList.remove("__asadmin");
        handlerCtx.setOutputValue("serverList", serverList);
    }

    public static void getAllTargetList(HandlerContext handlerCtx) {
        Set standaloneSet = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().keySet();
        Set clusterSet = AMXUtil.getDomainConfig().getClusterConfigMap().keySet();
        TreeSet allTargets = new TreeSet();
        allTargets.addAll(standaloneSet);
        allTargets.addAll(clusterSet);
        ArrayList targetList = new ArrayList(allTargets);
        handlerCtx.setOutputValue("allTargetList", targetList);
    }

    public static void getServersOfCluster(HandlerContext handlerCtx) {
        String clusterName = (String)handlerCtx.getInputValue("clusterName");
        ArrayList servers = new ArrayList();
        if (GuiUtil.isEmpty(clusterName)) {
            System.out.println("getServerOfCluster:  clusterName is empty, no server is returned.");
            handlerCtx.setOutputValue("serverList", servers);
            return;
        }
        ClusterConfig cluster = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName);
        if (cluster == null) {
            System.out.println("getServerofCluster:  cluster does not exist --  " + clusterName);
            handlerCtx.setOutputValue("serverList", servers);
            return;
        }
        Set serverSet = cluster.getClusteredServerConfigMap().keySet();
        ArrayList sortedServerList = new ArrayList(new TreeSet(serverSet));
        handlerCtx.setOutputValue("serverList", sortedServerList);
    }

    public static void getConfigurationsList(HandlerContext handlerCtx) {
        Set configSet = AMXUtil.getDomainConfig().getConfigConfigMap().keySet();
        ArrayList sortedConfigList = new ArrayList(new TreeSet(configSet));
        handlerCtx.setOutputValue("configList", sortedConfigList);
    }

    public static void buildAllClusters(HandlerContext handlerCtx) {
        List clusterList = (List)handlerCtx.getInputValue("clusterList");
        UIComponent parent = (UIComponent)handlerCtx.getInputValue("parent");
        LayoutElement elt = (LayoutElement)handlerCtx.getInputValue("layoutElement");
        if (clusterList == null || clusterList.size() <= 1) {
            return;
        }
        Map reqMap = handlerCtx.getFacesContext().getExternalContext().getRequestMap();
        for (int index = 1; index < clusterList.size(); ++index) {
            reqMap.put("clusterId", "cluster" + index);
            reqMap.put("ignored", "false");
            reqMap.put("clusterName", clusterList.get(index));
            LayoutViewHandler.buildUIComponentTree((FacesContext)handlerCtx.getFacesContext(), (UIComponent)parent, (LayoutElement)elt);
        }
    }

    public static void buildAllConfiguration(HandlerContext handlerCtx) {
        List configList = (List)handlerCtx.getInputValue("configList");
        UIComponent parent = (UIComponent)handlerCtx.getInputValue("parent");
        LayoutElement elt = (LayoutElement)handlerCtx.getInputValue("layoutElement");
        if (configList == null || configList.size() <= 1) {
            return;
        }
        Map reqMap = handlerCtx.getFacesContext().getExternalContext().getRequestMap();
        for (int index = 1; index < configList.size(); ++index) {
            reqMap.put("configId", "configuration" + index);
            reqMap.put("configName", configList.get(index));
            LayoutViewHandler.buildUIComponentTree((FacesContext)handlerCtx.getFacesContext(), (UIComponent)parent, (LayoutElement)elt);
        }
    }

    public static void createVSReferences(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        String targetName = (String)handlerCtx.getInputValue("targetName");
        String[] selTargets = (String[])handlerCtx.getInputValue("vsTargets");
        String noneSelected = GuiUtil.getMessage("deploy.option.NoneSelected");
        String targets = null;
        if (selTargets.length > 0 && !noneSelected.equals(selTargets[0])) {
            targets = GuiUtil.arrayToString(selTargets, ",");
        }
        TargetUtil.setVirtualServers(name, targetName, targets);
    }

    public static void createResourceReferences(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        String[] selTargets = (String[])handlerCtx.getInputValue("targets");
        try {
            List<String> targets = Arrays.asList(selTargets);
            List<String> associatedTargets = TargetUtil.getDeployedTargets(name, false);
            for (String targetName : targets) {
                if (associatedTargets.contains(targetName)) continue;
                TargetUtil.createResourceRef(name, targetName);
            }
            for (String targetName : associatedTargets) {
                if (targets.contains(targetName)) continue;
                TargetUtil.removeResourceRef(name, targetName);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getTargetsOptionsList(HandlerContext handlerCtx) {
        String defaultTarget;
        Set standaloneSet = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().keySet();
        Set clusteredSet = AMXUtil.getDomainConfig().getClusterConfigMap().keySet();
        ArrayList serverList = new ArrayList(standaloneSet);
        serverList.addAll(clusteredSet);
        Option[] availableOptions = null;
        if (serverList != null) {
            availableOptions = new Option[serverList.size()];
            List<String> strList = GuiUtil.convertListOfStrings(serverList);
            availableOptions = GuiUtil.getSunOptions(strList);
        }
        if ((defaultTarget = (String)handlerCtx.getInputValue("defaultTarget")) == null) {
            defaultTarget = "server";
        }
        String[] selected = new String[]{defaultTarget};
        if (defaultTarget.trim().equals("")) {
            selected = new String[]{};
        }
        handlerCtx.setOutputValue("SelectedTargets", (Object)selected);
        handlerCtx.setOutputValue("AvailableTargets", (Object)availableOptions);
    }

    public static void getTargetOptions(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        String name = (String)handlerCtx.getInputValue("name");
        List targets = (List)handlerCtx.getInputValue("allTargets");
        List<Object> associatedTargets = new ArrayList();
        if (type.equals("loadBalancer")) {
            String[] targetsArray = AMXUtil.getLBConfigHelper().listTargets(name);
            if (targetsArray != null) {
                for (int i = 0; i < targetsArray.length; ++i) {
                    associatedTargets.add(targetsArray[i]);
                }
            }
        } else {
            boolean isApp = type.equals("application");
            associatedTargets = TargetUtil.getDeployedTargets(name, isApp);
        }
        Option[] availableOptions = null;
        String[] selectedOptions = null;
        if (targets != null) {
            availableOptions = new Option[targets.size()];
            List<String> strList = GuiUtil.convertListOfStrings(targets);
            availableOptions = GuiUtil.getSunOptions(strList);
            selectedOptions = associatedTargets.toArray(new String[associatedTargets.size()]);
        }
        handlerCtx.setOutputValue("availableTargets", (Object)availableOptions);
        handlerCtx.setOutputValue("selectedTargets", selectedOptions);
    }

    public static void getVSOptions(HandlerContext handlerCtx) {
        String targetName = (String)handlerCtx.getInputValue("targetName");
        Boolean pe = (Boolean)handlerCtx.getInputValue("PE");
        String name = (String)handlerCtx.getInputValue("name");
        List vsList = (List)handlerCtx.getInputValue("vsList");
        String associatedVS = TargetUtil.getAssociatedVS(name, targetName);
        Option[] availableOptions = null;
        String[] selectedOptions = null;
        if (vsList != null) {
            availableOptions = new Option[vsList.size()];
            availableOptions = GuiUtil.getSunOptions(vsList);
            selectedOptions = GuiUtil.stringToArray(associatedVS, ",");
            if (pe != null && pe.booleanValue() && selectedOptions != null && selectedOptions.length <= 0) {
                selectedOptions = new String[]{(String)vsList.get(0)};
            }
        }
        handlerCtx.setOutputValue("availableVS", (Object)availableOptions);
        handlerCtx.setOutputValue("selectedVS", selectedOptions);
    }

    public static void getConfigurationsTableList(HandlerContext handlerCtx) {
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        Iterator iter = AMXUtil.getDomainConfig().getConfigConfigMap().values().iterator();
        ArrayList result = new ArrayList();
        if (iter != null) {
            while (iter.hasNext()) {
                ConfigConfig config = (ConfigConfig)iter.next();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = config.getName();
                oneRow.put("name", name);
                oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("Result", result);
    }

    public static void getConfigurationTargets(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ArrayList result = new ArrayList();
        try {
            if (configName != null) {
                Vector targets = EESupportHandlers.getReferencedInstances(configName);
                for (int i = 0; i < targets.size(); ++i) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    ServerConfig servConfig = (ServerConfig)targets.get(i);
                    String name = servConfig.getName();
                    oneRow.put("targetname", name);
                    oneRow.put("image", AMXUtil.getStatusForDisplay((AMX)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name), false));
                    if (servConfig instanceof StandaloneServerConfig) {
                        oneRow.put("isCluster", false);
                    } else {
                        oneRow.put("isCluster", true);
                    }
                    result.add(oneRow);
                }
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static Vector getReferencedInstances(String configName) {
        String config;
        Vector<StandaloneServerConfig> targets = new Vector<StandaloneServerConfig>();
        Map standaloneMap = AMXUtil.getDomainConfig().getStandaloneServerConfigMap();
        Map clusteredMap = AMXUtil.getDomainConfig().getClusteredServerConfigMap();
        for (StandaloneServerConfig server : standaloneMap.values()) {
            config = server.getReferencedConfigName();
            if (!config.equalsIgnoreCase(configName)) continue;
            targets.add(server);
        }
        for (StandaloneServerConfig server : clusteredMap.values()) {
            config = server.getReferencedConfigName();
            if (!config.equalsIgnoreCase(configName)) continue;
            targets.add(server);
        }
        return targets;
    }

    public static void getSystemProperties(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXUtil.getDomainConfig().getConfigConfigMap().get(configName);
        handlerCtx.setOutputValue("DynamicReconfig", (Object)config.getDynamicReconfigurationEnabled());
        ArrayList data = new ArrayList();
        Map props = config.getSystemProperties();
        if (props != null) {
            for (String key : props.keySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                Object value = props.get(key);
                String valString = value == null ? "" : value.toString();
                oneRow.put("name", key);
                oneRow.put("value", valString);
                oneRow.put("selected", false);
                data.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("Properties", (Object)props);
        handlerCtx.setOutputValue("TableList", data);
    }

    public static void saveSystemProperties(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXUtil.getDomainConfig().getConfigConfigMap().get(configName);
        config.setDynamicReconfigurationEnabled(((Boolean)handlerCtx.getInputValue("DynamicReconfig")).booleanValue());
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        if (removeProps != null) {
            String[] remove = removeProps.toArray(new String[removeProps.size()]);
            for (int i = 0; i < remove.length; ++i) {
                config.removeSystemProperty(remove[i]);
            }
        }
        if (addProps != null) {
            for (String key : addProps.keySet()) {
                String value = (String)addProps.get(key);
                if (GuiUtil.isEmpty(value)) continue;
                if (config.existsSystemProperty(key)) {
                    config.setSystemPropertyValue(key, value);
                    continue;
                }
                config.createSystemProperty(key, value);
            }
        }
    }

    public static void getInstancevalues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = (ConfigConfig)AMXUtil.getDomainConfig().getConfigConfigMap().get(configName);
        String propName = (String)handlerCtx.getInputValue("PropertyName");
        Vector instances = EESupportHandlers.getReferencedInstances(configName);
        ArrayList data = new ArrayList();
        for (int i = 0; i < instances.size(); ++i) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            ServerConfig servConfig = (ServerConfig)instances.get(i);
            String name = servConfig.getName();
            String propValue = "";
            if (Arrays.asList(servConfig.getSystemPropertyNames()).contains(propName)) {
                propValue = servConfig.getSystemPropertyValue(propName);
            }
            if (servConfig instanceof ClusteredServerConfig) {
                ClusteredServerConfig conf = (ClusteredServerConfig)servConfig;
                String clusterName = EESupportHandlers.getClusterForServer(name);
                oneRow.put("clusterName", clusterName);
                oneRow.put("isCluster", true);
            } else {
                oneRow.put("clusterName", "");
                oneRow.put("isCluster", false);
            }
            oneRow.put("name", name);
            oneRow.put("value", propValue);
            data.add(oneRow);
        }
        handlerCtx.setOutputValue("InstancesList", data);
    }

    public static void saveInstanceValues(HandlerContext handlerCtx) {
        String propName = (String)handlerCtx.getInputValue("PropertyName");
        try {
            List obj;
            List newRows = obj = (List)handlerCtx.getInputValue("PropsList");
            for (Map oneRow : newRows) {
                String instanceName = (String)oneRow.get("name");
                boolean isCluster = (Boolean)oneRow.get("isCluster");
                String propValue = (String)oneRow.get("value");
                if (isCluster) {
                    ClusteredServerConfig clusterConfig = (ClusteredServerConfig)AMXUtil.getDomainConfig().getClusteredServerConfigMap().get(instanceName);
                    if (Arrays.asList(clusterConfig.getSystemPropertyNames()).contains(propName)) {
                        clusterConfig.setSystemPropertyValue(propName, propValue);
                        continue;
                    }
                    clusterConfig.createSystemProperty(propName, propValue);
                    continue;
                }
                StandaloneServerConfig serverConfig = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(instanceName);
                if (Arrays.asList(serverConfig.getSystemPropertyNames()).contains(propName)) {
                    serverConfig.setSystemPropertyValue(propName, propValue);
                    continue;
                }
                serverConfig.createSystemProperty(propName, propValue);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void createConfiguration(HandlerContext handlerCtx) {
        String configurationName = (String)handlerCtx.getInputValue("Name");
        String copyFromConfigName = (String)handlerCtx.getInputValue("Config");
        try {
            HashMap<String, String> configMap = new HashMap<String, String>();
            if ("default-config".equals(copyFromConfigName)) {
                AMXUtil.getDomainConfig().createConfigConfig(configurationName, configMap);
            } else {
                configMap.put("SrcConfigKey", copyFromConfigName);
                AMXUtil.getDomainConfig().createConfigConfig(configurationName, configMap);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteConfigurations(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                AMXUtil.getDomainConfig().removeConfigConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static String getClusterForServer(String clusteredInstance) {
        Map clusterConfMap = AMXUtil.getDomainConfig().getClusterConfigMap();
        String clusterName = "";
        for (ClusterConfig clusterConf : clusterConfMap.values()) {
            clusterName = clusterConf.getName();
            if (!clusterConf.getClusteredServerConfigMap().containsKey(clusteredInstance)) continue;
            return clusterName;
        }
        return clusterName;
    }
}

