/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.DASConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Calendar;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CommonHandlers {
    private static final String CHARTING_COOKIE_NAME = "as91-doCharting";
    private static final int INDEX = 0;
    private static final String UPDATE_CENTER_NUM_UPDATES = "updateCenterNumUpdates";
    private static final String UPDATE_CENTER_NUM_SOFTWARES = "updateCenterNumSoftwares";

    public static void isEE(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("isEE", (Object)AMXUtil.isEE());
    }

    public static void initClusterSessionAttribute(HandlerContext handlerCtx) {
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        sessionMap.put("appSummaryView", true);
        sessionMap.put("webSummaryView", true);
        sessionMap.put("ejbSummaryView", true);
        sessionMap.put("appclientSummaryView", true);
        sessionMap.put("rarSummaryView", true);
        sessionMap.put("lifecycleSummaryView", true);
        sessionMap.put("adminObjectSummaryView", true);
        sessionMap.put("connectorResSummaryView", true);
        sessionMap.put("customResSummaryView", true);
        sessionMap.put("externalResSummaryView", true);
        sessionMap.put("javaMailSessionSummaryView", true);
        sessionMap.put("jdbcResSummaryView", true);
        sessionMap.put("jmsConnectionSummaryView", true);
        sessionMap.put("jmsDestinationSummaryView", true);
    }

    public static void initSessionAttributes(HandlerContext handlerCtx) {
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        Object initialized = sessionMap.get("_SESSION_INITIALIZED");
        if (initialized != null) {
            return;
        }
        try {
            int numUpdates = AMXUtil.getDomainRoot().getUpdateStatus().getNumModules();
            GuiUtil.setSessionValue(UPDATE_CENTER_NUM_UPDATES, "" + numUpdates);
            int numNewModules = AMXUtil.getDomainRoot().getUpdateStatus().getNumNewSoftware();
            GuiUtil.setSessionValue(UPDATE_CENTER_NUM_SOFTWARES, "" + numNewModules);
            String msg = GuiUtil.getMessage("updateCenter.commonTask.noNewUpdates");
            if (numNewModules != 0) {
                msg = GuiUtil.getMessage("updateCenter.commonTask.hasNewModules", new Object[]{numNewModules});
            } else if (numUpdates != 0) {
                msg = GuiUtil.getMessage("updateCenter.commonTask.hasNewUpdates", new Object[]{numUpdates});
            }
            GuiUtil.setSessionValue("updateCenterTaskName", msg);
        }
        catch (Exception ex) {
            sessionMap.put(UPDATE_CENTER_NUM_UPDATES, "0");
            sessionMap.put(UPDATE_CENTER_NUM_SOFTWARES, "0");
        }
        try {
            Object domain = JMXUtil.invoke("com.sun.appserv:type=domain,category=config", "getName", null, null);
            sessionMap.put("domainName", domain.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sessionMap.put("domainName", "");
        }
        String user = handlerCtx.getFacesContext().getExternalContext().getRemoteUser();
        sessionMap.put("userName", user == null ? "" : user);
        Object request = handlerCtx.getFacesContext().getExternalContext().getRequest();
        if (request instanceof ServletRequest) {
            String serverName = ((ServletRequest)request).getServerName();
            sessionMap.put("serverName", serverName);
        } else {
            sessionMap.put("serverName", "");
        }
        sessionMap.put("reqMsg", GuiUtil.getMessage("msg.JS.enterValue"));
        sessionMap.put("reqMsgSelect", GuiUtil.getMessage("msg.JS.selectValue"));
        sessionMap.put("reqInt", GuiUtil.getMessage("msg.JS.enterIntegerValue"));
        sessionMap.put("reqNum", GuiUtil.getMessage("msg.JS.enterNumericValue"));
        sessionMap.put("reqPort", GuiUtil.getMessage("msg.JS.enterPortValue"));
        sessionMap.put("_SESSION_INITIALIZED", "TRUE");
        ConfigConfig config = AMXUtil.getConfig("server-config");
        DASConfig dConfig = config.getAdminServiceConfig().getDASConfig();
        String timeOut = dConfig.getAdminSessionTimeoutInMinutes();
        if (timeOut != null && !timeOut.equals("")) {
            try {
                int time = new Integer(timeOut);
                if (time == 0) {
                    ((HttpServletRequest)request).getSession().setMaxInactiveInterval(-1);
                } else {
                    ((HttpServletRequest)request).getSession().setMaxInactiveInterval(time * 60);
                }
            }
            catch (NumberFormatException nfe) {
                ((HttpServletRequest)request).getSession().setMaxInactiveInterval(-1);
            }
        }
    }

    public static void getAppServerVersion(HandlerContext handlerCtx) {
        J2EEServer server = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get("server");
        handlerCtx.setOutputValue("version", (Object)server.getserverVersion());
    }

    public static void getListElement(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        Integer selectedIndex = (Integer)handlerCtx.getInputValue("index");
        String[] listItem = null;
        if (list != null) {
            if (selectedIndex == null) {
                selectedIndex = new Integer(0);
            }
            listItem = new String[]{(String)list.get(selectedIndex)};
        }
        handlerCtx.setOutputValue("selectedIndex", listItem);
    }

    public static void getAppServerFullVersion(HandlerContext handlerCtx) {
        String fullVersion = (String)JMXUtil.getAttribute("com.sun.appserv:j2eeType=J2EEDomain,name=com.sun.appserv,category=runtime", "applicationServerFullVersion");
        handlerCtx.setOutputValue("fullVersion", (Object)fullVersion);
    }

    public static void getConfigName(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        String configName = AMXUtil.getConfigName(target);
        handlerCtx.setOutputValue("configName", (Object)configName);
    }

    public static void selectiveEncode(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String delim = (String)handlerCtx.getInputValue("delim");
        String encType = (String)handlerCtx.getInputValue("type");
        String encodedString = GuiUtil.encode(value, delim, encType);
        handlerCtx.setOutputValue("value", (Object)encodedString);
    }

    public static void logout(HandlerContext handlerCtx) {
        ExternalContext extContext = handlerCtx.getFacesContext().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        request.getSession().invalidate();
    }

    public static void setComponentRequired(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        String required = (String)handlerCtx.getInputValue("required");
        UIViewRoot viewRoot = handlerCtx.getFacesContext().getViewRoot();
        if (viewRoot == null) {
            return;
        }
        try {
            UIInput targetComponent = (UIInput)viewRoot.findComponent(id);
            if (targetComponent != null) {
                targetComponent.setRequired(Boolean.valueOf(required).booleanValue());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void testExists(HandlerContext handlerCtx) {
        String attr = (String)handlerCtx.getInputValue("attr");
        if (GuiUtil.isEmpty(attr)) {
            handlerCtx.setOutputValue("defined", (Object)false);
        } else {
            handlerCtx.setOutputValue("defined", (Object)true);
        }
    }

    public static void getDatePattern(HandlerContext handlerCtx) {
        Calendar calendar = (Calendar)handlerCtx.getInputValue("calendarComponent");
        String pattern = calendar.getDateFormatPattern();
        if (!(pattern != null && pattern.length() != 0 || (pattern = calendar.getDatePicker().getDateFormatPattern()) != null && pattern.length() != 0)) {
            pattern = "MM/dd/yyyy";
        }
        handlerCtx.setOutputValue("pattern", (Object)pattern);
    }

    public static void getRequestValue(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        Object defaultValue = handlerCtx.getInputValue("default");
        Object value = handlerCtx.getFacesContext().getExternalContext().getRequestParameterMap().get(key);
        if (value == null) {
            value = handlerCtx.getFacesContext().getExternalContext().getRequestMap().get(key);
            if (value == null && defaultValue != null) {
                value = defaultValue;
            }
        } else if (value instanceof String && "".equals(value)) {
            value = handlerCtx.getFacesContext().getExternalContext().getRequestMap().get(key);
        }
        handlerCtx.setOutputValue("value", value);
    }

    public void longAdd(HandlerContext handlerCtx) {
        Long long1 = (Long)handlerCtx.getInputValue("Long1");
        Long long2 = (Long)handlerCtx.getInputValue("Long2");
        Long result = new Long(long1 + long2);
        handlerCtx.setOutputValue("LongResult", (Object)result);
    }

    public void getCurrentTime(HandlerContext handlerCtx) {
        Date d = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, handlerCtx.getFacesContext().getViewRoot().getLocale());
        String currentTime = dateFormat.format(d);
        handlerCtx.setOutputValue("CurrentTime", (Object)currentTime);
    }

    public void checkRestart(HandlerContext handlerCtx) {
        Boolean restartRequired = (Boolean)JMXUtil.getAttribute("com.sun.appserv:j2eeType=J2EEServer,name=server,category=runtime", "restartRequired");
        handlerCtx.setOutputValue("RestartRequired", (Object)restartRequired);
    }

    public void getPropsValue(HandlerContext handlerCtx) {
        PropertiesAccess mbean = (PropertiesAccess)handlerCtx.getInputValue("mbean");
        List propsName = (List)handlerCtx.getInputValue("propsName");
        if (mbean == null && propsName != null) {
            handlerCtx.setOutputValue("propsValue", new ArrayList(propsName.size()));
        }
        Map mbeanProps = mbean.getProperties();
        ArrayList<String> propsValue = new ArrayList<String>(propsName.size());
        for (String nm : propsName) {
            String value = (String)mbeanProps.get(nm);
            propsValue.add(value == null ? "" : value);
        }
        handlerCtx.setOutputValue("propsValue", propsValue);
    }

    public void savePropsValue(HandlerContext handlerCtx) {
        PropertiesAccess mbean = (PropertiesAccess)handlerCtx.getInputValue("mbean");
        List propsName = (List)handlerCtx.getInputValue("propsName");
        List propsValue = (List)handlerCtx.getInputValue("propsValue");
        if (mbean == null) {
            return;
        }
        Map mbeanProps = mbean.getProperties();
        for (int i = 0; i < propsName.size(); ++i) {
            String newValue = (String)propsValue.get(i);
            String nm = (String)propsName.get(i);
            AMXUtil.changeProperty(mbean, nm, newValue);
        }
    }

    public void getMbeanProperties(HandlerContext handlerCtx) {
        PropertiesAccess mbean = (PropertiesAccess)handlerCtx.getInputValue("mbean");
        List ignoreProps = (List)handlerCtx.getInputValue("ignoreProps");
        Map allProps = mbean.getProperties();
        if (ignoreProps != null) {
            for (String nm : ignoreProps) {
                if (allProps.get(nm) == null) continue;
                allProps.remove(nm);
            }
        }
        handlerCtx.setOutputValue("result", (Object)allProps);
    }

    public void getChartingCookieName(HandlerContext handlerCtx) {
        String userName = (String)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("userName");
        handlerCtx.setOutputValue("cookieName", (Object)(userName + "." + CHARTING_COOKIE_NAME));
    }

    public void getChartingCookieInfo(HandlerContext handlerCtx) {
        String userName = (String)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("userName");
        String cookieName = userName + "." + CHARTING_COOKIE_NAME;
        Map cookies = handlerCtx.getFacesContext().getExternalContext().getRequestCookieMap();
        Cookie cookie = (Cookie)cookies.get(cookieName);
        String value = cookie == null ? "" : cookie.getValue();
        handlerCtx.setOutputValue("name", (Object)cookieName);
        handlerCtx.setOutputValue("doCharting", (Object)value.equals("true"));
        handlerCtx.setOutputValue("setCookieTo", (Object)(value.equals("true") ? "false" : "true"));
    }

    public void getUpdateCenterInfo(HandlerContext handlerCtx) {
        String numUpdates = (String)GuiUtil.getSessionValue(UPDATE_CENTER_NUM_UPDATES);
        String numNewModules = (String)GuiUtil.getSessionValue(UPDATE_CENTER_NUM_SOFTWARES);
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        if (installRoot == null) {
            installRoot = "install-root";
        }
        String updateTool = installRoot + File.separator + "updatecenter" + File.separator + "bin" + File.separator + "updatetool";
        updateTool = updateTool.replace('\\', '/');
        handlerCtx.setOutputValue("updates", (Object)numUpdates);
        handlerCtx.setOutputValue("modules", (Object)numNewModules);
        handlerCtx.setOutputValue("tool", (Object)updateTool);
        handlerCtx.setOutputValue("wiki", (Object)"http://wiki.updatecenter.java.net/Wiki.jsp?page=GettingStarted");
    }

    public static void setValueExpression(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("keyObjectName");
        String value = (String)handlerCtx.getInputValue("objectValue");
        Boolean hasBoolean = (Boolean)handlerCtx.getInputValue("hasBoolean");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elcontext = facesContext.getELContext();
        ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{" + name + "}", Object.class);
        if (hasBoolean == null) {
            ve.setValue(facesContext.getELContext(), (Object)value);
        } else if (hasBoolean.booleanValue()) {
            if (value.equals("true")) {
                ve.setValue(facesContext.getELContext(), (Object)Boolean.TRUE);
            } else {
                ve.setValue(facesContext.getELContext(), (Object)Boolean.FALSE);
            }
        } else {
            ve.setValue(facesContext.getELContext(), (Object)value);
        }
    }

    private static String getUpdateMessage() {
        int numUpdates = AMXUtil.getDomainRoot().getUpdateStatus().getNumModules();
        int numNewModules = AMXUtil.getDomainRoot().getUpdateStatus().getNumNewSoftware();
        String updateMessage = "";
        if (numUpdates > 0 && numNewModules > 0) {
            updateMessage = numUpdates == 1 ? GuiUtil.getMessage("msg.updateAndNewModulesAvailable", new Object[]{numNewModules}) : GuiUtil.getMessage("msg.updatesAndNewModulesAvailable", new Object[]{numUpdates, numNewModules});
        } else if (numUpdates <= 0 && numNewModules <= 0) {
            updateMessage = "";
        } else if (numUpdates > 0) {
            updateMessage = numUpdates == 1 ? GuiUtil.getMessage("msg.updateAvailable") : GuiUtil.getMessage("msg.updatesAvailable", new Object[]{numUpdates});
        } else {
            String string = updateMessage = numNewModules == 1 ? GuiUtil.getMessage("msg.newModuleAvailable") : GuiUtil.getMessage("msg.newModulesAvailable", new Object[]{numNewModules});
        }
        if (!updateMessage.equals("")) {
            String installRoot = System.getProperty("com.sun.aas.installRoot");
            if (installRoot == null) {
                installRoot = "install-root";
            }
            String updateTool = installRoot + File.separator + "updatecenter" + File.separator + "bin" + File.separator + "updatetool";
            updateTool = updateTool.replace('\\', '/');
            updateMessage = updateMessage + "  " + GuiUtil.getMessage("msg.runUpdateCenter", new Object[]{updateTool});
        }
        return updateMessage;
    }
}

