/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AppClientModuleConfig;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.DeployedItemRefConfigCR;
import com.sun.appserv.management.config.EJBModuleConfig;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.Libraries;
import com.sun.appserv.management.config.LifecycleModuleConfig;
import com.sun.appserv.management.config.ModuleConfig;
import com.sun.appserv.management.config.ObjectType;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.RARModuleConfig;
import com.sun.appserv.management.config.ResourceAdapterConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.enterprise.appclient.jws.NamingConventions;
import com.sun.enterprise.tools.admingui.handlers.DeploymentHandler;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.component.dataprovider.MultipleListDataProvider;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.TableRowGroup;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ApplicationHandlers {
    private static Map<String, String> displayMap = new HashMap<String, String>();
    private static Map<String, String> editMap = new HashMap<String, String>();
    private static Map<String, String> typeMap = new HashMap<String, String>();

    public static void getApplicationInfo(HandlerContext handlerCtx) {
        String[] libArray;
        ResourceAdapterConfig adapter;
        String name = (String)handlerCtx.getInputValue("name");
        String appType = (String)handlerCtx.getInputValue("appType");
        ModuleConfig module = null;
        if ("application".equals(appType)) {
            module = (ModuleConfig)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(name);
            if (module != null) {
                J2EEApplicationConfig j2eeApp = (J2EEApplicationConfig)module;
                handlerCtx.setOutputValue("javaWebStart", (Object)j2eeApp.getJavaWebStartEnabled());
                handlerCtx.setOutputValue("availEnabled", (Object)j2eeApp.getAvailabilityEnabled());
                if (!AMXUtil.supportCluster()) {
                    handlerCtx.setOutputValue("vs", (Object)TargetUtil.getAssociatedVS(name, "server"));
                }
            }
        } else if ("ejbModule".equals(appType)) {
            module = (ModuleConfig)AMXUtil.getDomainConfig().getEJBModuleConfigMap().get(name);
            if (module != null) {
                EJBModuleConfig ejbModule = (EJBModuleConfig)module;
                handlerCtx.setOutputValue("availEnabled", (Object)ejbModule.getAvailabilityEnabled());
            }
        } else if ("webApp".equals(appType)) {
            module = (ModuleConfig)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(name);
            if (module != null) {
                WebModuleConfig webModule = (WebModuleConfig)module;
                handlerCtx.setOutputValue("contextRoot", (Object)webModule.getContextRoot());
                handlerCtx.setOutputValue("availEnabled", (Object)webModule.getAvailabilityEnabled());
                if (!AMXUtil.supportCluster()) {
                    handlerCtx.setOutputValue("vs", (Object)TargetUtil.getAssociatedVS(name, "server"));
                }
            }
        } else if ("connector".equals(appType) && (module = (ModuleConfig)AMXUtil.getDomainConfig().getRARModuleConfigMap().get(name)) != null && (adapter = (ResourceAdapterConfig)AMXUtil.getDomainConfig().getResourceAdapterConfigMap().get(name)) != null) {
            handlerCtx.setOutputValue("threadPool", (Object)adapter.getThreadPoolIDs());
        }
        if (module == null) {
            return;
        }
        handlerCtx.setOutputValue("location", (Object)module.getLocation());
        handlerCtx.setOutputValue("description", (Object)module.getDescription());
        handlerCtx.setOutputValue("objectType", (Object)module.getObjectType());
        if (AMXUtil.isEE()) {
            handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)module, true));
        } else {
            handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isApplicationEnabled((Enabled)module, "server"));
        }
        if (!"connector".equals(appType) && (libArray = ((Libraries)module).getLibraries()) != null) {
            StringBuffer libs = new StringBuffer();
            for (int i = 0; i < libArray.length; ++i) {
                libs.append("<br/>");
                libs.append(libArray[i]);
            }
            if (libs.length() > 1) {
                handlerCtx.setOutputValue("libraries", (Object)libs.substring(5));
            }
        }
    }

    public static void saveApplicationInfo(HandlerContext handlerCtx) {
        String target = "server";
        String name = (String)handlerCtx.getInputValue("name");
        String appType = (String)handlerCtx.getInputValue("appType");
        try {
            ModuleConfig module = null;
            if ("application".equals(appType)) {
                module = (ModuleConfig)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(name);
                if (module != null) {
                    J2EEApplicationConfig j2eeApp = (J2EEApplicationConfig)module;
                    j2eeApp.setJavaWebStartEnabled(((Boolean)handlerCtx.getInputValue("javaWebStart")).booleanValue());
                    if (AMXUtil.isEE()) {
                        Boolean ae = (Boolean)handlerCtx.getInputValue("availEnabled");
                        if (ae != null) {
                            j2eeApp.setAvailabilityEnabled(ae.booleanValue());
                        }
                    } else {
                        String vs = (String)handlerCtx.getInputValue("vs");
                        TargetUtil.setVirtualServers(name, "server", vs);
                    }
                }
            } else if ("ejbModule".equals(appType)) {
                module = (ModuleConfig)AMXUtil.getDomainConfig().getEJBModuleConfigMap().get(name);
                if (module != null) {
                    Boolean ae;
                    EJBModuleConfig ejbModule = (EJBModuleConfig)module;
                    if (AMXUtil.isEE() && (ae = (Boolean)handlerCtx.getInputValue("availEnabled")) != null) {
                        ejbModule.setAvailabilityEnabled(ae.booleanValue());
                    }
                }
            } else if ("webApp".equals(appType)) {
                module = (ModuleConfig)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(name);
                if (module != null) {
                    WebModuleConfig webModule = (WebModuleConfig)module;
                    webModule.setContextRoot((String)handlerCtx.getInputValue("contextRoot"));
                    if (AMXUtil.isEE()) {
                        Boolean ae = (Boolean)handlerCtx.getInputValue("availEnabled");
                        if (ae != null) {
                            webModule.setAvailabilityEnabled(ae.booleanValue());
                        }
                    } else {
                        String vs = (String)handlerCtx.getInputValue("vs");
                        TargetUtil.setVirtualServers(name, "server", vs);
                    }
                }
            } else if ("connector".equals(appType) && (module = (ModuleConfig)AMXUtil.getDomainConfig().getRARModuleConfigMap().get(name)) != null) {
                ResourceAdapterConfig adapter = (ResourceAdapterConfig)AMXUtil.getDomainConfig().getResourceAdapterConfigMap().get(name);
                if (adapter == null) {
                    adapter = AMXUtil.getDomainConfig().createResourceAdapterConfig(name, null);
                }
                adapter.setThreadPoolIDs((String)handlerCtx.getInputValue("threadPool"));
            }
            if (module == null) {
                return;
            }
            module.setDescription((String)handlerCtx.getInputValue("description"));
            if (!AMXUtil.isEE()) {
                Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                TargetUtil.setApplicationEnabled((Enabled)module, "server", enabled);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getAppClientInfo(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        AppClientModuleConfig module = (AppClientModuleConfig)AMXUtil.getDomainConfig().getAppClientModuleConfigMap().get(name);
        if (module == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchAppclient"));
            return;
        }
        handlerCtx.setOutputValue("location", (Object)module.getLocation());
        handlerCtx.setOutputValue("description", (Object)module.getDescription());
        handlerCtx.setOutputValue("javaWebStart", (Object)module.getJavaWebStartEnabled());
    }

    public static void saveAppClientInfo(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        AppClientModuleConfig module = (AppClientModuleConfig)AMXUtil.getDomainConfig().getAppClientModuleConfigMap().get(name);
        if (module == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchAppclient"));
            return;
        }
        module.setJavaWebStartEnabled(((Boolean)handlerCtx.getInputValue("javaWebStart")).booleanValue());
        module.setDescription((String)handlerCtx.getInputValue("description"));
    }

    public static void getLifecycleModuleInfo(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        LifecycleModuleConfig module = (LifecycleModuleConfig)AMXUtil.getDomainConfig().getLifecycleModuleConfigMap().get(name);
        if (module == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchLifecycle"));
            return;
        }
        handlerCtx.setOutputValue("classname", (Object)module.getClassname());
        handlerCtx.setOutputValue("classpath", (Object)module.getClasspath());
        handlerCtx.setOutputValue("loadOrder", (Object)module.getLoadOrder());
        handlerCtx.setOutputValue("description", (Object)module.getDescription());
        handlerCtx.setOutputValue("isFailureFatal", (Object)module.getIsFailureFatal());
        if (AMXUtil.isEE()) {
            handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)module, true));
        } else {
            handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isApplicationEnabled((Enabled)module, "server"));
        }
        Map props = module.getProperties();
        handlerCtx.setOutputValue("properties", (Object)props);
    }

    public static void saveLifecycleModuleInfo(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        LifecycleModuleConfig module = (LifecycleModuleConfig)AMXUtil.getDomainConfig().getLifecycleModuleConfigMap().get(name);
        if (module == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchLifecycle"));
        }
        module.setDescription((String)handlerCtx.getInputValue("description"));
        module.setClassname((String)handlerCtx.getInputValue("classname"));
        module.setClasspath((String)handlerCtx.getInputValue("classpath"));
        module.setLoadOrder((String)handlerCtx.getInputValue("loadOrder"));
        module.setIsFailureFatal(((Boolean)handlerCtx.getInputValue("isFailureFatal")).booleanValue());
        if (!AMXUtil.isEE()) {
            Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
            TargetUtil.setApplicationEnabled((Enabled)module, "server", enabled);
        }
        AMXUtil.editProperties(handlerCtx, (PropertiesAccess)module);
    }

    public static void createLifecycleModule(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        Boolean isFailureFatal = (Boolean)handlerCtx.getInputValue("isFailureFatal");
        String fatal = isFailureFatal == null ? "false" : isFailureFatal.toString();
        Boolean enabledB = (Boolean)handlerCtx.getInputValue("enabled");
        String enabledStr = enabledB == null ? "false" : enabledB.toString();
        AttributeList list = new AttributeList();
        list.add(new Attribute("name", name));
        list.add(new Attribute("class-name", (String)handlerCtx.getInputValue("classname")));
        list.add(new Attribute("classpath", (String)handlerCtx.getInputValue("classpath")));
        list.add(new Attribute("description", (String)handlerCtx.getInputValue("description")));
        list.add(new Attribute("load-order", (String)handlerCtx.getInputValue("loadOrder")));
        list.add(new Attribute("is-failure-fatal", fatal));
        list.add(new Attribute("enabled", enabledStr));
        String[] types = new String[]{"javax.management.AttributeList", "java.lang.String"};
        Object[] params = new Object[]{list, AMXUtil.isEE() ? "domain" : "server"};
        try {
            Object obj = JMXUtil.invoke("com.sun.appserv:type=applications,category=config", "createLifecycleModule", params, types);
            String[] selTargets = (String[])handlerCtx.getInputValue("targets");
            DeploymentHandler.handleAppRefs(name, selTargets, handlerCtx, true, Boolean.valueOf(enabledStr));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteLifecycleModules(HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("selectedRows");
        List selectedRows = (List)obj;
        try {
            String[] types = new String[]{"java.lang.String", "java.lang.String"};
            String defaultTarget = AMXUtil.isEE() ? "domain" : "server";
            for (int i = 0; i < selectedRows.size(); ++i) {
                Map oneRow = (Map)selectedRows.get(i);
                String name = (String)oneRow.get("name");
                LifecycleModuleConfig module = (LifecycleModuleConfig)AMXUtil.getDomainConfig().getLifecycleModuleConfigMap().get(name);
                ApplicationHandlers.deleteLifecycleReferences(module);
                Object[] params = new Object[]{name, defaultTarget};
                JMXUtil.invoke("com.sun.appserv:type=applications,category=config", "removeLifecycleModuleByName", params, types);
                Thread.sleep(1000L);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void deleteLifecycleReferences(LifecycleModuleConfig lm) {
        if (!AMXUtil.isEE()) {
            return;
        }
        String appName = lm.getName();
        List<String> targetList = TargetUtil.getDeployedTargets((AMX)lm, true);
        for (String target : targetList) {
            JMXUtil.invoke("com.sun.appserv:type=applications,category=config", "removeLifecycleModuleReference", new Object[]{appName, target}, new String[]{"java.lang.String", "java.lang.String"});
        }
    }

    public static void getSubComponents(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String appType = (String)handlerCtx.getInputValue("appType");
        boolean hasAction = false;
        ArrayList result = new ArrayList();
        if ("connector".equals(appType)) {
            handlerCtx.setOutputValue("result", result);
            return;
        }
        if ("application".equals(appType)) {
            hasAction = true;
        }
        try {
            String[] types = new String[]{"java.lang.String"};
            Object[] params = new Object[]{appName};
            String[] modules = (String[])JMXUtil.invoke("com.sun.appserv:type=applications,category=config", "getModuleComponents", params, types);
            for (int i = 0; i < modules.length; ++i) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                ObjectName on = new ObjectName(modules[i]);
                oneRow.put("componentName", on.getKeyProperty("name"));
                oneRow.put("componentType", on.getKeyProperty("j2eeType"));
                if (hasAction) {
                    if ("AppClientModule".equals(on.getKeyProperty("j2eeType"))) {
                        oneRow.put("downloadText", GuiUtil.getMessage("ComponentTable.downloadClientStub"));
                        J2EEApplicationConfig appConfig = (J2EEApplicationConfig)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(appName);
                        boolean javaWebStart = appConfig.getJavaWebStartEnabled();
                        oneRow.put("javaWebStart", javaWebStart);
                    } else {
                        oneRow.put("javaWebStart", false);
                        oneRow.put("downloadText", " ");
                    }
                }
                result.add(oneRow);
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getDeployedAppInfo(HandlerContext handlerCtx) {
        Iterator iter = AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().values().iterator();
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            J2EEApplicationConfig appConfig = (J2EEApplicationConfig)iter.next();
            if (!"user".equals(appConfig.getObjectType())) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("name", appConfig.getName());
            oneRow.put("enabled", TargetUtil.getEnabledStatus((Enabled)appConfig, true));
            oneRow.put("location", appConfig.getLocation());
            oneRow.put("selected", false);
            oneRow.put("hasLaunch", false);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getDeployedWebInfo(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        Iterator iter = AMXUtil.getDomainConfig().getWebModuleConfigMap().values().iterator();
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            WebModuleConfig appConfig = (WebModuleConfig)iter.next();
            if (!"user".equals(appConfig.getObjectType())) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            String enable = TargetUtil.getEnabledStatus((Enabled)appConfig, true);
            oneRow.put("name", appConfig.getName());
            oneRow.put("enabled", enable);
            String contextRoot = appConfig.getContextRoot();
            oneRow.put("contextRoot", contextRoot);
            String port = ApplicationHandlers.getPortForApplication(appConfig.getName());
            oneRow.put("port", port);
            if (AMXUtil.isEE()) {
                if (enable.equals(GuiUtil.getMessage("deploy.allDisabled")) || enable.equals(GuiUtil.getMessage("deploy.noTarget"))) {
                    oneRow.put("hasLaunch", false);
                } else {
                    oneRow.put("hasLaunch", true);
                }
            } else {
                oneRow.put("hasLaunch", Boolean.parseBoolean(enable));
                String ctxRoot = ApplicationHandlers.calContextRoot(contextRoot);
                oneRow.put("launchLink", "http://" + serverName + ":" + port + ctxRoot);
            }
            oneRow.put("selected", false);
            List<String> targets = TargetUtil.getDeployedTargets((AMX)appConfig, true);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getDeployedEJBModuleInfo(HandlerContext handlerCtx) {
        Iterator iter = AMXUtil.getDomainConfig().getEJBModuleConfigMap().values().iterator();
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            EJBModuleConfig appConfig = (EJBModuleConfig)iter.next();
            if (!"user".equals(appConfig.getObjectType())) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("name", appConfig.getName());
            oneRow.put("enabled", TargetUtil.getEnabledStatus((Enabled)appConfig, true));
            oneRow.put("location", appConfig.getLocation());
            oneRow.put("selected", false);
            oneRow.put("hasLaunch", false);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getDeployedConnectorModuleInfo(HandlerContext handlerCtx) {
        Iterator iter = AMXUtil.getDomainConfig().getRARModuleConfigMap().values().iterator();
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            RARModuleConfig appConfig = (RARModuleConfig)iter.next();
            if (!"user".equals(appConfig.getObjectType())) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("name", appConfig.getName());
            oneRow.put("enabled", TargetUtil.getEnabledStatus((Enabled)appConfig, true));
            oneRow.put("location", appConfig.getLocation());
            oneRow.put("selected", false);
            oneRow.put("hasLaunch", false);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getDeployedLifecycleInfo(HandlerContext handlerCtx) {
        Iterator iter = AMXUtil.getDomainConfig().getLifecycleModuleConfigMap().values().iterator();
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            LifecycleModuleConfig appConfig = (LifecycleModuleConfig)iter.next();
            try {
                if (!"user".equals(appConfig.getObjectType())) continue;
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("name", appConfig.getName());
                oneRow.put("enabled", TargetUtil.getEnabledStatus((Enabled)appConfig, true));
                oneRow.put("loadOrder", GuiUtil.notNull(appConfig.getLoadOrder()));
                oneRow.put("selected", false);
                oneRow.put("hasLaunch", false);
                result.add(oneRow);
            }
            catch (Exception ex) {}
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getDeployedAppClientInfo(HandlerContext handlerCtx) {
        Iterator iter = AMXUtil.getDomainConfig().getAppClientModuleConfigMap().values().iterator();
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            AppClientModuleConfig appConfig = (AppClientModuleConfig)iter.next();
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("name", appConfig.getName());
            oneRow.put("selected", false);
            boolean javaWebStart = appConfig.getJavaWebStartEnabled();
            if (javaWebStart) {
                oneRow.put("javaWebStart", "true");
                oneRow.put("hasLaunch", true);
            } else {
                oneRow.put("javaWebStart", "false");
                oneRow.put("hasLaunch", false);
            }
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getAppTargetStatus(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        Boolean forApp = (Boolean)handlerCtx.getInputValue("forApp");
        ArrayList result = new ArrayList();
        try {
            List<String> targetList = TargetUtil.getDeployedTargets(appName, (boolean)forApp);
            for (String target : targetList) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                StandaloneServerConfig server = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(target);
                if (server != null) {
                    oneRow.put("target", target);
                    oneRow.put("image", AMXUtil.getStatusForDisplay((AMX)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(target), false));
                    oneRow.put("targetURL", "/standalone/standaloneInstanceGeneral.jsf?instanceName=" + target);
                } else {
                    oneRow.put("target", target);
                    oneRow.put("image", ApplicationHandlers.getClusterStatus(target));
                    oneRow.put("targetURL", "/cluster/clusterGeneral.jsf?clusterName=" + target);
                }
                result.add(oneRow);
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String getClusterStatus(String clusterName) {
        ClusterConfig cluster = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(clusterName);
        if (cluster == null) {
            return "";
        }
        Map serverMap = cluster.getClusteredServerConfigMap();
        if (serverMap.size() == 0) {
            return "";
        }
        for (String instance : serverMap.keySet()) {
            int state;
            J2EEServer j2eeServer = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(instance);
            if (j2eeServer == null || (state = j2eeServer.getstate()) != 1) continue;
            return AMXUtil.getStatusForDisplay((AMX)j2eeServer, false);
        }
        return AMXUtil.getStatusImage(3);
    }

    public static void changeAppStatus(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        String appType = (String)handlerCtx.getInputValue("appType");
        List selectedRows = obj;
        try {
            for (int i = 0; i < selectedRows.size(); ++i) {
                String msg;
                Map oneRow = (Map)selectedRows.get(i);
                String appName = (String)oneRow.get("name");
                Enabled appConfig = ApplicationHandlers.getModuleConfig(appName, appType);
                if (appConfig != null) {
                    List<String> targetList = TargetUtil.getDeployedTargets((AMX)appConfig, true);
                    for (String target : targetList) {
                        TargetUtil.setApplicationEnabled(appConfig, target, enabled);
                    }
                }
                if (AMXUtil.isEE()) {
                    msg = GuiUtil.getMessage(enabled ? "msg.enableSuccessful" : "msg.disableSuccessful");
                    GuiUtil.prepareAlert(handlerCtx, "success", msg, null);
                    continue;
                }
                msg = GuiUtil.getMessage(enabled ? "msg.enableSuccessfulPE" : "msg.disableSuccessfulPE");
                GuiUtil.prepareAlert(handlerCtx, "success", msg, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getApplicationTargetTableList(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String appType = (String)handlerCtx.getInputValue("appType");
        List<String> targetList = TargetUtil.getDeployedTargets(appName, true);
        ArrayList result = new ArrayList();
        for (String target : targetList) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("selected", false);
            oneRow.put("name", appName);
            oneRow.put("targetName", target);
            Enabled module = ApplicationHandlers.getModuleConfig(appName, appType);
            if (module != null) {
                oneRow.put("enabled", Boolean.toString(TargetUtil.isApplicationEnabled(module, target, false)));
                oneRow.put("lbEnabled", Boolean.toString(TargetUtil.isApplicationEnabled(module, target, true)));
                oneRow.put("vsLinkArgs", "?appName=" + appName + "&targetName=" + target);
            }
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getTargetsTableList(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        Boolean forApp = (Boolean)handlerCtx.getInputValue("forApp");
        String appType = (String)handlerCtx.getInputValue("appType");
        ArrayList result = new ArrayList();
        try {
            List<String> targetList = TargetUtil.getDeployedTargets(appName, (boolean)forApp);
            for (String target : targetList) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                StandaloneServerConfig server = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(target);
                Enabled module = ApplicationHandlers.getModuleConfig(appName, appType);
                oneRow.put("selected", false);
                oneRow.put("enabled", Boolean.toString(TargetUtil.isApplicationEnabled(module, target)));
                if (server != null) {
                    oneRow.put("targetName", target);
                    oneRow.put("image", AMXUtil.getStatusForDisplay((AMX)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(target), false));
                    oneRow.put("targetURL", "/standalone/standaloneInstanceGeneral.jsf?instanceName=" + target);
                } else {
                    oneRow.put("targetName", target);
                    oneRow.put("image", ApplicationHandlers.getClusterStatus(target));
                    oneRow.put("targetURL", "/cluster/clusterGeneral.jsf?clusterName=" + target);
                }
                result.add(oneRow);
            }
            handlerCtx.setOutputValue("result", result);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void changeTargetStatus(HandlerContext handlerCtx) {
        String appType = (String)handlerCtx.getInputValue("appType");
        String appName = (String)handlerCtx.getInputValue("appName");
        Enabled appConfig = ApplicationHandlers.getModuleConfig(appName, appType);
        if (appConfig == null) {
            return;
        }
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        Boolean LB = (Boolean)handlerCtx.getInputValue("LB");
        boolean forLB = LB == null ? false : LB;
        List selectedRows = obj;
        try {
            for (int i = 0; i < selectedRows.size(); ++i) {
                Map oneRow = (Map)selectedRows.get(i);
                String target = (String)oneRow.get("targetName");
                TargetUtil.setApplicationEnabled(appConfig, target, enabled, forLB);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getAppRefListForTarget(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        boolean isServer = (Boolean)handlerCtx.getInputValue("isServer");
        Collection<Object> refs = new ArrayList();
        ArrayList result = new ArrayList();
        if (isServer) {
            StandaloneServerConfig server = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(target);
            refs = server.getDeployedItemRefConfigMap().values();
            Map map = AMXUtil.getLBConfigHelper().getLoadBalancers(target, false);
            handlerCtx.setOutputValue("hasLB", (Object)(!map.isEmpty() ? 1 : 0));
        } else {
            ClusterConfig cluster = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(target);
            refs = cluster.getDeployedItemRefConfigMap().values();
            Map map = AMXUtil.getLBConfigHelper().getLoadBalancers(target, true);
            handlerCtx.setOutputValue("hasLB", (Object)(!map.isEmpty() ? 1 : 0));
        }
        for (DeployedItemRefConfig deployedItemRefConfig : refs) {
            String appType;
            String appName = deployedItemRefConfig.getName();
            if (!ApplicationHandlers.includeAppRef(appName, appType = AMXUtil.getAppType(appName), filterValue)) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (appType.equals("X-AppClientModuleConfig")) {
                oneRow.put("enabled", "");
                oneRow.put("lbEnabled", "");
                oneRow.put("timeout", "");
            } else {
                oneRow.put("enabled", deployedItemRefConfig.getEnabled() ? "true" : "false");
                oneRow.put("lbEnabled", deployedItemRefConfig.getLBEnabled() ? "true" : "false");
                oneRow.put("timeout", deployedItemRefConfig.getDisableTimeoutInMinutes());
            }
            oneRow.put("name", appName);
            oneRow.put("selected", false);
            oneRow.put("link", "/applications/" + editMap.get(appType) + "?appName=" + appName);
            oneRow.put("appType", typeMap.get(appType));
            oneRow.put("objectName", "" + Util.getObjectName((AMX)deployedItemRefConfig));
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static String getNumberLBAppsByTarget(String target) {
        Collection<Object> refs = new ArrayList();
        if (TargetUtil.isCluster(target)) {
            ClusterConfig cluster = (ClusterConfig)AMXUtil.getDomainConfig().getClusterConfigMap().get(target);
            refs = cluster.getDeployedItemRefConfigMap().values();
        } else {
            StandaloneServerConfig server = (StandaloneServerConfig)AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(target);
            refs = server.getDeployedItemRefConfigMap().values();
        }
        int totalEnabled = 0;
        int totalCount = 0;
        for (DeployedItemRefConfig deployedItemRefConfig : refs) {
            String appType;
            String appName = deployedItemRefConfig.getName();
            if (!ApplicationHandlers.includeAppRef(appName, appType = AMXUtil.getAppType(appName), null)) continue;
            if (deployedItemRefConfig.getLBEnabled()) {
                ++totalEnabled;
            }
            ++totalCount;
        }
        if (totalCount == 0) {
            return GuiUtil.getMessage("loadBalancer.noDeployedApp");
        }
        return GuiUtil.getMessage("loadBalancer.numLBEnabled", new Object[]{"" + totalEnabled, "" + totalCount});
    }

    public static void changeAppEnableForTarget(HandlerContext handlerCtx) {
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        boolean LB = (Boolean)handlerCtx.getInputValue("LB");
        try {
            for (Map oneRow : selectedRows) {
                String appType = (String)oneRow.get("appType");
                if (appType.equals(GuiUtil.getMessage("tree.appclientModules"))) continue;
                ObjectName objName = new ObjectName((String)oneRow.get("objectName"));
                Set appRefs = AMXUtil.getQueryMgr().queryPatternSet(objName);
                for (DeployedItemRefConfig ref : appRefs) {
                    if (LB) {
                        ref.setLBEnabled(enabled);
                        continue;
                    }
                    ref.setEnabled(enabled);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.prepareException(handlerCtx, ex);
        }
    }

    public static void removeAppTarget(HandlerContext handlerCtx) {
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                ObjectName objName = new ObjectName((String)oneRow.get("objectName"));
                Set appRefs = AMXUtil.getQueryMgr().queryPatternSet(objName);
                for (DeployedItemRefConfig ref : appRefs) {
                    DeployedItemRefConfigCR container = (DeployedItemRefConfigCR)ref.getContainer();
                    container.removeDeployedItemRefConfig(ref.getName());
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.prepareException(handlerCtx, ex);
        }
    }

    public static void saveDisableTimeout(HandlerContext handlerCtx) {
        TableRowGroup trg = (TableRowGroup)handlerCtx.getInputValue("TableRowGroup");
        try {
            MultipleListDataProvider dp = (MultipleListDataProvider)trg.getSourceData();
            List data = dp.getLists();
            Iterator i$ = data.iterator();
            while (i$.hasNext()) {
                List inner;
                List innerMap = inner = (List)i$.next();
                for (Map oneRow : innerMap) {
                    String appType = (String)oneRow.get("appType");
                    if (appType.equals(GuiUtil.getMessage("tree.appclientModules"))) continue;
                    String timeout = (String)oneRow.get("timeout");
                    ObjectName objName = new ObjectName((String)oneRow.get("objectName"));
                    Set appRefs = AMXUtil.getQueryMgr().queryPatternSet(objName);
                    for (DeployedItemRefConfig ref : appRefs) {
                        ref.setDisableTimeoutInMinutes(timeout);
                    }
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getAppFilterTypes(HandlerContext handlerCtx) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(GuiUtil.getMessage("common.showAll"));
        labels.add(GuiUtil.getMessage("tree.enterpriseApps"));
        labels.add(GuiUtil.getMessage("tree.webApps"));
        labels.add(GuiUtil.getMessage("tree.ejbModules"));
        labels.add(GuiUtil.getMessage("tree.lifecycleModules"));
        labels.add(GuiUtil.getMessage("tree.connectorResources"));
        labels.add(GuiUtil.getMessage("tree.appclientModules"));
        labels.add(GuiUtil.getMessage("tree.customMBeans"));
        ArrayList<String> values = new ArrayList<String>();
        values.add("");
        values.add("X-J2EEApplicationConfig");
        values.add("X-WebModuleConfig");
        values.add("X-EJBModuleConfig");
        values.add("X-LifecycleModuleConfig");
        values.add("X-RARModuleConfig");
        values.add("X-AppClientModuleConfig");
        values.add("X-CustomMBeanConfig");
        handlerCtx.setOutputValue("values", values);
        handlerCtx.setOutputValue("labels", labels);
    }

    public static void getAppTypeForDisplay(HandlerContext handlerCtx) {
        String appType = (String)handlerCtx.getInputValue("appType");
        handlerCtx.setOutputValue("displayType", (Object)displayMap.get(appType));
    }

    public static void setAppViewKey(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        String selectedValue = (String)handlerCtx.getInputValue("selectedValue");
        if (selectedValue.equals("summary")) {
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put(key, true);
        } else {
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put(key, false);
        }
    }

    public void getAppClientLinks(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("AppID");
        String appendUrl = (String)handlerCtx.getInputValue("AppendURL");
        if (appendUrl != null) {
            appendUrl = appendUrl.startsWith("/") ? appendUrl.substring(1) : appendUrl;
        }
        List urls = this.getURLs(id, this.getWebAppReferencees(id));
        String[] values = new String[urls.size()];
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < urls.size(); ++i) {
            values[i] = (String)urls.get(i) + "/" + appendUrl;
            list.add(values[i]);
        }
        handlerCtx.setOutputValue("AppClientLinks", list);
        handlerCtx.setOutputValue("SelectedLink", (Object)(!list.isEmpty() ? (String)list.get(0) : ""));
    }

    public void getTargetURLList(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("AppID");
        String contextRoot = (String)handlerCtx.getInputValue("contextRoot");
        String ctxRoot = ApplicationHandlers.calContextRoot(contextRoot);
        List urls = this.getURLs(id, this.getWebAppReferencees(id));
        Iterator it = urls.iterator();
        String url = null;
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            url = (String)it.next();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("url", url + ctxRoot);
            list.add(m);
        }
        handlerCtx.setOutputValue("URLList", list);
    }

    protected List getURLs(String appId, ObjectName[] serverInstances) {
        ArrayList urls = new ArrayList();
        for (int count = 0; count < serverInstances.length; ++count) {
            if (serverInstances[count].getKeyProperty("type").equals("cluster")) {
                urls.addAll(this.getURLs(appId, (ObjectName[])JMXUtil.invoke(serverInstances[count], "listServerInstances", null, null)));
                continue;
            }
            urls.addAll(this.getURLs(appId, serverInstances[count]));
        }
        return urls;
    }

    protected List getURLs(String appId, ObjectName serverInstance) {
        String configRef = (String)JMXUtil.getAttribute(serverInstance, "config-ref");
        String name = (String)JMXUtil.getAttribute(serverInstance, "name");
        String appObj = "com.sun.appserv:type=application-ref,ref=" + appId + ",server=" + name + ",category=config";
        String strVirServers = (String)JMXUtil.getAttribute(appObj, "virtual-servers");
        if (strVirServers == null || strVirServers.equals("")) {
            int count;
            ObjectName[] listeners = (ObjectName[])JMXUtil.invoke("com.sun.appserv:type=http-service,config=" + configRef + ",category=config", "getHttpListener", null, null);
            for (count = 0; count < listeners.length && !((String)JMXUtil.getAttribute(listeners[count], "enabled")).equals("true"); ++count) {
            }
            if (count == listeners.length) {
                return new ArrayList(0);
            }
            strVirServers = (String)JMXUtil.getAttribute(listeners[count], "default-virtual-server");
        }
        ArrayList<String> listenerList = new ArrayList<String>();
        for (String virServer : GuiUtil.parseStringList(strVirServers, " ,")) {
            String listeners = (String)JMXUtil.getAttribute("com.sun.appserv:type=virtual-server,id=" + virServer + ",config=" + configRef + ",category=config", "http-listeners");
            for (String listener : GuiUtil.parseStringList(listeners, " ,")) {
                if (listenerList.contains(listener)) continue;
                listenerList.add(listener);
            }
        }
        ArrayList<String> urls = new ArrayList<String>(listenerList.size());
        StringBuffer url = null;
        Iterator it = listenerList.iterator();
        while (it.hasNext()) {
            String listenerObj = "com.sun.appserv:type=http-listener,id=" + it.next() + ",config=" + configRef + ",category=config";
            url = new StringBuffer("http");
            if (JMXUtil.getAttribute(listenerObj, "security-enabled").toString().equals("true")) {
                url.append("s");
            }
            url.append("://");
            url.append(this.getHost(serverInstance));
            url.append(":");
            url.append(this.replaceTokens(serverInstance, (String)JMXUtil.getAttribute(listenerObj, "port")));
            urls.add(url.toString());
        }
        return urls;
    }

    protected String getHost(ObjectName serverInstance) {
        String nodeAgentRef = (String)JMXUtil.getAttribute(serverInstance, "node-agent-ref");
        if (nodeAgentRef == null || nodeAgentRef.equals("")) {
            return ApplicationHandlers.getDefaultHostName();
        }
        ObjectName jmxConnector = (ObjectName)JMXUtil.invoke("com.sun.appserv:type=node-agent,name=" + nodeAgentRef + ",category=config", "getJmxConnector", null, null);
        if (jmxConnector == null) {
            return ApplicationHandlers.getDefaultHostName();
        }
        AttributeList properties = (AttributeList)JMXUtil.invoke(jmxConnector, "getProperties", null, null);
        String hostName = null;
        for (Attribute att : properties) {
            if (!att.getName().equals("client-hostname")) continue;
            hostName = (String)att.getValue();
            break;
        }
        if (hostName == null || hostName.equals("") || hostName.equals("0.0.0.0")) {
            return ApplicationHandlers.getDefaultHostName();
        }
        return hostName;
    }

    protected String replaceTokens(ObjectName serverInstance, String src) {
        int idx = src.lastIndexOf("${");
        if (idx < 0) {
            return src;
        }
        Properties sysProp = (Properties)JMXUtil.invoke(serverInstance, "listSystemProperties", new Object[]{new Boolean("true")}, new String[]{"boolean"});
        while (idx > -1) {
            String newString;
            int endIdx = src.indexOf("}", idx + 2);
            src = newString = src.substring(0, idx) + sysProp.getProperty(src.substring(idx + 2, endIdx)) + src.substring(endIdx + 1);
            idx = src.lastIndexOf("${");
        }
        return src;
    }

    public static String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return defaultHostName;
    }

    protected ObjectName[] getWebAppReferencees(String appId) {
        return (ObjectName[])JMXUtil.invoke("com.sun.appserv:type=applications,category=config", "listReferencees", new Object[]{appId}, new String[]{"java.lang.String"});
    }

    public static void getLaunchURLPath(HandlerContext handlerCtx) {
        String appclientName = (String)handlerCtx.getInputValue("AppClientName");
        String applicationName = (String)handlerCtx.getInputValue("AppName");
        if (GuiUtil.isEmpty(appclientName)) {
            // empty if block
        }
        try {
            String path;
            String jwsEnabled = GuiUtil.isEmpty(applicationName) ? (String)JMXUtil.getAttribute("com.sun.appserv:type=appclient-module,category=config,name=" + appclientName, "java-web-start-enabled") : (String)JMXUtil.getAttribute("com.sun.appserv:type=j2ee-application,category=config,name=" + applicationName, "java-web-start-enabled");
            if ("false".equals(jwsEnabled)) {
                handlerCtx.setOutputValue("IsEnabled", (Object)Boolean.FALSE);
                return;
            }
            NamingConventions nc = new NamingConventions();
            String string = path = GuiUtil.isEmpty(applicationName) ? nc.getLaunchURLPath(appclientName) : nc.getLaunchURLPath(applicationName, appclientName);
            if (!GuiUtil.isEmpty(path)) {
                handlerCtx.setOutputValue("Path", (Object)path);
                handlerCtx.setOutputValue("IsEnabled", (Object)Boolean.TRUE);
            } else {
                handlerCtx.setOutputValue("IsEnabled", (Object)Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("IsEnabled", (Object)Boolean.FALSE);
        }
    }

    public static void getPortForApplication(HandlerContext ctx) {
        String appName = (String)ctx.getInputValue("AppID");
        String port = ApplicationHandlers.getPortForApplication(appName);
        ctx.setOutputValue("Port", (Object)port);
    }

    static String getPortForApplication(String appName) {
        ObjectName appRef = null;
        try {
            appRef = (ObjectName)JMXUtil.invoke("com.sun.appserv:type=server,name=server,category=config", "getApplicationRefByRef", new Object[]{appName}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            return "";
        }
        String vsId = null;
        if (appRef == null) {
            vsId = ApplicationHandlers.getNonAdminVirtualServer();
        } else {
            vsId = (String)JMXUtil.getAttribute(appRef, "virtual-servers");
            if (vsId == null || vsId.length() == 0) {
                vsId = ApplicationHandlers.getNonAdminVirtualServer();
            } else if (vsId.indexOf(",") > 0) {
                vsId = vsId.substring(0, vsId.indexOf(","));
            }
        }
        if (vsId == null) {
            return "";
        }
        String port = null;
        try {
            String listener;
            ObjectName vsObjectName = (ObjectName)JMXUtil.invoke("com.sun.appserv:type=configs,category=config", "getVirtualServer", new Object[]{vsId, null}, new String[]{"java.lang.String", "java.lang.String"});
            if (vsObjectName != null && (listener = (String)JMXUtil.getAttribute(vsObjectName, "http-listeners")) != null) {
                if (listener.indexOf(",") > 0) {
                    listener = listener.substring(0, listener.indexOf(","));
                }
                ObjectName listenerObjectName = (ObjectName)JMXUtil.invoke("com.sun.appserv:type=configs,category=config", "getHttpListener", new Object[]{listener, null}, new String[]{"java.lang.String", "java.lang.String"});
                port = (String)JMXUtil.getAttribute(listenerObjectName, "port");
            }
            return port;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private static String getNonAdminVirtualServer() {
        String vsId = null;
        ObjectName[] vsObjectNames = (ObjectName[])JMXUtil.invoke("com.sun.appserv:type=configs,category=config", "listVirtualServers", new Object[]{null}, new String[]{"java.lang.String"});
        if (vsObjectNames != null) {
            for (int i = 0; i < vsObjectNames.length; ++i) {
                String id = (String)JMXUtil.getAttribute(vsObjectNames[i], "id");
                if (id.equals("__asadmin")) continue;
                vsId = id;
                break;
            }
        }
        return vsId;
    }

    private static boolean includeAppRef(String appName, String appType, String filterValue) {
        if (!GuiUtil.isEmpty(filterValue) && !appType.equals(filterValue)) {
            return false;
        }
        if ("X-AppClientModuleConfig".equals(appType)) {
            return true;
        }
        Set configs = AMXUtil.getQueryMgr().queryJ2EETypeNameSet(appType, appName);
        ObjectType appConfig = (ObjectType)configs.iterator().next();
        String objectType = appConfig.getObjectType();
        return "user".equalsIgnoreCase(objectType);
    }

    private static String calContextRoot(String contextRoot) {
        String ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }

    private static Enabled getModuleConfig(String appName, String appType) {
        Enabled module = null;
        if ("application".equals(appType)) {
            module = (Enabled)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(appName);
        } else if ("ejbModule".equals(appType)) {
            module = (Enabled)AMXUtil.getDomainConfig().getEJBModuleConfigMap().get(appName);
        } else if ("webApp".equals(appType)) {
            module = (Enabled)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(appName);
        } else if ("connector".equals(appType)) {
            module = (Enabled)AMXUtil.getDomainConfig().getRARModuleConfigMap().get(appName);
        } else if ("lifecycle".equals(appType)) {
            module = (Enabled)AMXUtil.getDomainConfig().getLifecycleModuleConfigMap().get(appName);
        }
        if ("mbean".equals(appType)) {
            module = (Enabled)AMXUtil.getDomainConfig().getCustomMBeanConfigMap().get(appName);
        }
        return module;
    }

    static {
        editMap.put("X-J2EEApplicationConfig", "enterpriseApplicationsEdit.jsf");
        editMap.put("X-WebModuleConfig", "webApplicationsEdit.jsf");
        editMap.put("X-EJBModuleConfig", "ejbModulesEdit.jsf");
        editMap.put("X-LifecycleModuleConfig", "lifecycleModulesEdit.jsf");
        editMap.put("X-RARModuleConfig", "connectorModulesEdit.jsf");
        editMap.put("X-AppClientModuleConfig", "appclientModulesEdit.jsf");
        editMap.put("X-CustomMBeanConfig", "customMBeansEdit.jsf");
        typeMap.put("X-J2EEApplicationConfig", GuiUtil.getMessage("tree.enterpriseApps"));
        typeMap.put("X-WebModuleConfig", GuiUtil.getMessage("tree.webApps"));
        typeMap.put("X-EJBModuleConfig", GuiUtil.getMessage("tree.ejbModules"));
        typeMap.put("X-LifecycleModuleConfig", GuiUtil.getMessage("tree.lifecycleModules"));
        typeMap.put("X-RARModuleConfig", GuiUtil.getMessage("tree.connectorModules"));
        typeMap.put("X-AppClientModuleConfig", GuiUtil.getMessage("tree.appclientModules"));
        typeMap.put("X-CustomMBeanConfig", GuiUtil.getMessage("tree.customMBeans"));
        displayMap.put("application", GuiUtil.getMessage("deploy.ear"));
        displayMap.put("webApp", GuiUtil.getMessage("deploy.war"));
        displayMap.put("ejbModule", GuiUtil.getMessage("deploy.ejb"));
        displayMap.put("appclient", GuiUtil.getMessage("deploy.appClient"));
        displayMap.put("connector", GuiUtil.getMessage("deploy.rar"));
    }
}

