/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.component;

import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.component.factory.ComponentFactoryBase;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JMakiChartFactory
extends ComponentFactoryBase {
    private JSONObject savedArgs = null;
    private JSONObject savedValue = null;
    public static final String COMPONENT_TYPE = "AjaxWrapper";
    public static final String CHART_TYPE_LINE = "jmaki.charting.line";
    public static final String CHART_TYPE_BAR = "jmaki.charting.bar";

    public UIComponent create(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
        JSONObject value;
        JSONObject args;
        UIComponent comp = this.createComponent(context, COMPONENT_TYPE, descriptor, parent);
        comp.setId(descriptor.getId(context, parent));
        this.setOptions(context, descriptor, comp);
        Map attrs = comp.getAttributes();
        String name = this.getChartType(context, descriptor, comp);
        attrs.put("name", name);
        this.savedArgs = args = this.getArgs(context, descriptor, comp);
        attrs.put("args", args.toString());
        this.savedValue = value = this.getValue(context, descriptor, comp);
        attrs.put("value", value.toString());
        return comp;
    }

    private String getChartType(FacesContext context, LayoutComponent descriptor, UIComponent comp) {
        String type = (String)descriptor.getEvaluatedOption(context, "type", comp);
        if (type == null) {
            System.out.println("!!!! WARNING, type is a required attribute but not set.  Default to line chart");
            return CHART_TYPE_LINE;
        }
        if (!type.equals(CHART_TYPE_BAR) && !type.equals(CHART_TYPE_LINE)) {
            System.out.println("!!!! WARNING, type " + type + "is not supported.  Default to line chart");
            return CHART_TYPE_LINE;
        }
        return type;
    }

    private JSONObject getArgs(FacesContext context, LayoutComponent descriptor, UIComponent comp) {
        JSONObject args = new JSONObject();
        try {
            this.setJObjectStr(args, "paddingBottom", (String)descriptor.getEvaluatedOption(context, "paddingBottom", comp));
            this.setJObjectStr(args, "paddingLeft", (String)descriptor.getEvaluatedOption(context, "paddingLeft", comp));
            this.setJObjectStr(args, "paddingRight", (String)descriptor.getEvaluatedOption(context, "paddingRight", comp));
            this.setJObjectStr(args, "legend", (String)descriptor.getEvaluatedOption(context, "legend", comp));
            JSONObject xAxis = this.getXAxis(context, descriptor, comp);
            JSONObject yAxis = this.getYAxis(context, descriptor, comp);
            args.put("xAxis", (Object)xAxis);
            args.put("yAxis", (Object)yAxis);
        }
        catch (JSONException ex) {
            System.out.println("Exception in constructing XAxis");
            ex.printStackTrace();
        }
        return args;
    }

    private JSONObject getValue(FacesContext context, LayoutComponent descriptor, UIComponent comp) {
        JSONObject data = new JSONObject();
        List valueList = null;
        Object vo = descriptor.getEvaluatedOption(context, "valueList", comp);
        if (!(vo instanceof List)) {
            System.out.println("jmaki:chart  valueList is ignored, should be a List<Map> ");
            return data;
        }
        valueList = (List)vo;
        try {
            JSONArray ja = new JSONArray();
            for (Map oneSeries : valueList) {
                JSONObject oneS = new JSONObject();
                this.setJObjectStr(oneS, "color", (String)oneSeries.get("color"));
                this.setJObjectStr(oneS, "label", (String)oneSeries.get("label"));
                JSONArray sa = new JSONArray();
                List series = (List)oneSeries.get("values");
                for (Integer oneV : series) {
                    sa.put(oneV.intValue());
                }
                oneS.put("values", (Object)sa);
                ja.put((Object)oneS);
            }
            data.put("data", (Object)ja);
        }
        catch (JSONException ex) {
            System.out.println("jmaki:chart Exception in constructing data");
            ex.printStackTrace();
        }
        return data;
    }

    private JSONObject getXAxis(FacesContext context, LayoutComponent descriptor, UIComponent comp) {
        JSONObject xa = new JSONObject();
        try {
            this.setJObjectStr(xa, "title", (String)descriptor.getEvaluatedOption(context, "xTitle", comp));
            this.setJObjectStr(xa, "rotate", (String)descriptor.getEvaluatedOption(context, "xRotate", comp));
            this.setRange(xa, descriptor.getEvaluatedOption(context, "xRange", comp));
            this.setLabels(xa, descriptor.getEvaluatedOption(context, "xLabels", comp));
        }
        catch (JSONException ex) {
            System.out.println("Exception in constructing XAxis");
            ex.printStackTrace();
        }
        return xa;
    }

    private JSONObject getYAxis(FacesContext context, LayoutComponent descriptor, UIComponent comp) {
        JSONObject ya = new JSONObject();
        try {
            this.setJObjectStr(ya, "title", (String)descriptor.getEvaluatedOption(context, "yTitle", comp));
            this.setJObjectInt(ya, "tickCount", (String)descriptor.getEvaluatedOption(context, "yTickCount", comp));
            this.setRange(ya, descriptor.getEvaluatedOption(context, "yRange", comp));
        }
        catch (JSONException ex) {
            System.out.println("Exception in constructing YAxis");
            ex.printStackTrace();
        }
        return ya;
    }

    private void setRange(JSONObject jObj, Object rangeMap) throws JSONException {
        JSONObject rangeObj;
        if (rangeMap == null) {
            return;
        }
        if (rangeMap instanceof Map) {
            Integer upper;
            rangeObj = new JSONObject();
            Integer lower = (Integer)((Map)rangeMap).get("lower");
            if (lower != null) {
                rangeObj.put("lower", lower.intValue());
            }
            if ((upper = (Integer)((Map)rangeMap).get("upper")) != null) {
                rangeObj.put("upper", upper.intValue());
            }
        } else {
            throw new JSONException("Error occured in setRange.  Range Must be a Map with 'lower' and 'upper' key.");
        }
        jObj.put("range", (Object)rangeObj);
    }

    private void setLabels(JSONObject jObj, Object labels) throws JSONException {
        if (labels == null) {
            return;
        }
        if (!(labels instanceof List)) {
            throw new JSONException("xLabels is ignored, must be List<String> or List<Map>");
        }
        if (((List)labels).size() == 0) {
            return;
        }
        Object testLabel = ((List)labels).get(0);
        JSONArray labelArray = new JSONArray();
        if (testLabel instanceof Map) {
            for (Map oneLabel : (List)labels) {
                JSONObject labelObj = new JSONObject();
                this.setJObjectStr(labelObj, "label", (String)oneLabel.get("label"));
                this.setJObjectStr(labelObj, "value", (String)oneLabel.get("value"));
                this.setJObjectStr(labelObj, "title", (String)oneLabel.get("title"));
                labelArray.put((Object)labelObj);
            }
            jObj.put("labels", (Object)labelArray);
        } else if (testLabel instanceof String) {
            for (String oneLabel : (List)labels) {
                labelArray.put((Object)oneLabel);
            }
            jObj.put("labels", (Object)labelArray);
        } else {
            throw new JSONException("xLabels is ignored, must be List<String> or List<Map>");
        }
    }

    private void setJObjectStr(JSONObject jObj, String attr, String value) throws JSONException {
        if (!GuiUtil.isEmpty(value)) {
            jObj.put(attr, (Object)value);
        }
    }

    private void setJObjectInt(JSONObject jObj, String attr, String value) throws JSONException {
        if (!GuiUtil.isEmpty(value)) {
            jObj.put(attr, Integer.parseInt(value));
        }
    }
}

