/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.monitor.stats;

import com.sun.appserv.management.j2ee.statistics.CountStatisticImpl;
import com.sun.appserv.management.j2ee.statistics.StringStatistic;
import com.sun.appserv.management.j2ee.statistics.StringStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.lb.ClusterStats;
import com.sun.enterprise.admin.monitor.stats.lb.InstanceStats;
import com.sun.enterprise.admin.monitor.stats.lb.LoadBalancerStatsInterface;
import com.sun.enterprise.management.monitor.stats.CustomStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.LBFeatureFactory;
import java.util.Date;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public final class LoadBalancerServerStatsImpl
implements CustomStatsImpl {
    private String instanceName = null;
    private String lbName = null;
    private String lbConfigName = null;
    private String clusterName = null;
    private LBFeatureFactory lbff = null;
    private long startTime = 0L;

    public Statistic[] getStatistics() {
        ClusterStats[] cstats;
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        Statistic[] statArr1 = new Statistic[3];
        StringStatisticImpl stat11 = new StringStatisticImpl("Health", "Instance Health", "state of the server", 0L, 0L, "");
        CountStatisticImpl stat21 = new CountStatisticImpl("NumberOfActiveRequests", "Number Of Active Requests", "count", 0L, 0L, 0L);
        CountStatisticImpl stat31 = new CountStatisticImpl("NumberOfTotalRequests", "Number Of Total Requests", "count", 0L, 0L, 0L);
        statArr1[0] = stat11;
        statArr1[1] = stat21;
        statArr1[2] = stat31;
        if (lbstats == null) {
            return statArr1;
        }
        for (ClusterStats cstat : cstats = lbstats.getClusterStats()) {
            for (InstanceStats istat : cstat.getInstanceStats()) {
                if (!istat.getId().equals(this.instanceName)) continue;
                Statistic[] statArr = new Statistic[3];
                String health = istat.getHealth();
                long activeReq = Long.parseLong(istat.getNumActiveRequests());
                long totalReq = Long.parseLong(istat.getNumTotalRequests());
                long sampleTime = new Date().getTime();
                StringStatisticImpl stat1 = new StringStatisticImpl("Health", "Instance Health", "milliseconds", this.startTime, sampleTime, health);
                CountStatisticImpl stat2 = new CountStatisticImpl("NumberOfActiveRequests", "Number Of Active Requests", "count", this.startTime, sampleTime, activeReq);
                CountStatisticImpl stat3 = new CountStatisticImpl("NumberOfTotalRequests", "Number Of Total Requests", "count", this.startTime, sampleTime, totalReq);
                statArr[0] = stat1;
                statArr[1] = stat2;
                statArr[2] = stat3;
                return statArr;
            }
        }
        return null;
    }

    public StringStatistic getHealth() {
        Statistic[] statArr = this.getStatistics();
        return (StringStatistic)statArr[0];
    }

    public CountStatistic getNumberOfActiveRequests() {
        Statistic[] statArr = this.getStatistics();
        return (CountStatistic)statArr[1];
    }

    public CountStatistic getNumberOfTotalRequests() {
        Statistic[] statArr = this.getStatistics();
        return (CountStatistic)statArr[2];
    }

    public LoadBalancerServerStatsImpl(String lbName, String lbConfigName, String clusterName, String instanceName) {
        this.lbName = lbName;
        this.clusterName = clusterName;
        this.instanceName = instanceName;
        this.lbConfigName = lbConfigName;
        this.lbff = ApplicationServer.getServerContext().getPluggableFeatureFactory().getLBFeatureFactory();
        this.startTime = new Date().getTime();
    }

    public LoadBalancerServerStatsImpl() {
    }
}

