/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.deploy;

import com.sun.appserv.management.base.Singleton;
import com.sun.appserv.management.base.UploadDownloadMgr;
import com.sun.appserv.management.base.Utility;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentProgress;
import com.sun.appserv.management.deploy.DeploymentSource;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.appserv.management.util.jmx.NotificationBuilder;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.deploy.DeployThread;
import com.sun.enterprise.management.deploy.DeployThreadParams;
import com.sun.enterprise.management.deploy.DeploymentCallback;
import com.sun.enterprise.management.deploy.DownloadFileSource;
import com.sun.enterprise.management.deploy.Undeployer;
import com.sun.enterprise.management.support.AMXNonConfigImplBase;
import com.sun.enterprise.management.support.UniqueIDGenerator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Notification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeploymentMgrImpl
extends AMXNonConfigImplBase
implements Utility,
Singleton,
DeploymentMgr {
    private final Map<Object, DeployThread> mDeployThreads;
    private final UniqueIDGenerator mDeployIDs;
    private long mDeploymentCompletedNotificationSequenceNumber = 0L;
    private final Set<String> NOTIF_TYPES = GSetUtil.newUnmodifiableStringSet("X-DeploymentMgr.DeploymentStarted", "X-DeploymentMgr.DeploymentAborted", "X-DeploymentMgr.DeploymentProgress", "X-DeploymentMgr.DeploymentCompleted");
    private static final long SECOND_MILLIS = 60000L;
    private static final long MINUTE_MILLIS = 3600000L;
    private static final long DEPLOY_KEEP_ALIVE_MILLIS = 54000000L;

    public void remove(String name) {
        throw new RuntimeException("not applicable");
    }

    public DeploymentMgrImpl() {
        this.mDeployThreads = Collections.synchronizedMap(new HashMap());
        this.mDeployIDs = new UniqueIDGenerator("deploy:");
    }

    protected Set<String> getNotificationTypes(Set<String> existing) {
        existing.addAll(this.NOTIF_TYPES);
        return existing;
    }

    private DeployThread removeDeployThread(Object deployID) {
        this.trace("\n###Removing deploy thread: " + deployID);
        return this.mDeployThreads.remove(deployID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void staleDeployCheck() {
        Set<Object> keySet = this.mDeployThreads.keySet();
        Map<Object, DeployThread> map = this.mDeployThreads;
        synchronized (map) {
            String[] deployIDs;
            for (String deployID : deployIDs = GSetUtil.toStringArray(keySet)) {
                DeployThread deployThread = this.mDeployThreads.get(deployID);
                if (deployThread.getMillisSinceDone() <= 54000000L) continue;
                this.removeDeployThread(deployID);
            }
        }
    }

    private DeployThread addDeployThread(Object deployID) {
        InternalDeploymentCallback callback = new InternalDeploymentCallback(deployID);
        DeployThread deployThread = new DeployThread(deployID, callback, null);
        this.mDeployThreads.put(deployThread.getID(), deployThread);
        return deployThread;
    }

    @Override
    public Object initDeploy() {
        Object deployID = this.mDeployIDs.createID();
        DeployThread deployThread = this.addDeployThread(deployID);
        return deployID;
    }

    @Override
    public void startDeploy(Object deployID, Object uploadID, Object planUploadID, Map<String, String> options) {
        this.staleDeployCheck();
        UploadDownloadMgr mgr = this.getUploadDownloadMgr();
        File deployFile = mgr.takeUpload(uploadID);
        File planFile = planUploadID == null ? null : mgr.takeUpload(planUploadID);
        DeployThreadParams params = new DeployThreadParams(this.getQueryMgr(), options, deployFile, planFile);
        this.startDeploy(deployID, params);
    }

    @Override
    public void startDeploy(Object deployID, Map<String, ? extends Serializable> sourceData, Map<String, ? extends Serializable> planData, Map<String, String> options) {
        DeploymentSource source = DeploymentSupport.mapToDeploymentSource(sourceData);
        DeploymentSource plan = planData == null ? null : DeploymentSupport.mapToDeploymentSource(planData);
        DeployThreadParams params = new DeployThreadParams(this.getQueryMgr(), options, source, plan);
        this.startDeploy(deployID, params);
    }

    private void startDeploy(Object deployID, DeployThreadParams params) {
        DeployThread deployThread = this.getDeployThread(deployID);
        if (deployThread == null) {
            throw new IllegalArgumentException(deployID.toString());
        }
        deployThread.setParams(params);
        this.issueDeploymentStartedNotification(deployID);
        deployThread.start();
    }

    private DeployThread getDeployThread(Object deployID) {
        DeployThread deployThread = this.mDeployThreads.get(deployID);
        if (deployThread == null) {
            IllegalArgumentException e = new IllegalArgumentException("" + deployID);
            e.printStackTrace();
            throw e;
        }
        return deployThread;
    }

    private boolean notifsAreDone(Notification[] notifs) {
        boolean done = false;
        for (int i = notifs.length - 1; i >= 0; --i) {
            String notifType = notifs[notifs.length - 1].getType();
            if (!notifType.equals("X-DeploymentMgr.DeploymentCompleted") && !notifType.equals("X-DeploymentMgr.DeploymentAborted")) continue;
            done = true;
            break;
        }
        return done;
    }

    @Override
    public Notification[] takeNotifications(Object deployID) {
        DeployThread deployThread = this.getDeployThread(deployID);
        Notification[] notifs = deployThread.takeNotifications();
        return notifs;
    }

    @Override
    public boolean abortDeploy(Object deployID) {
        DeployThread deployThread = this.getDeployThread(deployID);
        boolean abortedSuccessfully = deployThread.quit();
        this.issueDeploymentAbortedNotification(deployID);
        return abortedSuccessfully;
    }

    private void issueNotification(Object deployID, Notification notif) {
        this.sendNotification(notif);
        this.trace("\nDeploymentMgrImpl.issueNotification: sent notification for " + deployID + " = " + notif.toString());
        DeployThread deployThread = this.getDeployThread(deployID);
        deployThread.queueNotification(notif);
    }

    protected void issueDeploymentStartedNotification(Object deployID) {
        NotificationBuilder builder = this.getNotificationBuilder("X-DeploymentMgr.DeploymentStarted");
        Notification notif = builder.buildNew();
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentID", (Serializable)deployID);
        this.issueNotification(deployID, notif);
    }

    protected void issueDeploymentDoneNotification(Object deployID, DeploymentStatus deploymentStatus) {
        NotificationBuilder builder = this.getNotificationBuilder("X-DeploymentMgr.DeploymentCompleted");
        Notification notif = builder.buildNew();
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentID", (Serializable)deployID);
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentCompletedStatus", (Serializable)((Object)deploymentStatus.asMap()));
        this.issueNotification(deployID, notif);
    }

    protected void issueDeploymentProgressNotification(Object deployID, DeploymentProgress progress) {
        NotificationBuilder builder = this.getNotificationBuilder("X-DeploymentMgr.DeploymentProgress");
        Notification notif = builder.buildNew();
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentID", (Serializable)deployID);
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentProgress", (Serializable)((Object)progress.asMap()));
        this.issueNotification(deployID, notif);
    }

    protected void issueDeploymentAbortedNotification(Object deployID) {
        NotificationBuilder builder = this.getNotificationBuilder("X-DeploymentMgr.DeploymentAborted");
        Notification notif = builder.buildNew();
        NotificationBuilder.putMapData(notif, "X-DeploymentMgr.DeploymentID", (Serializable)deployID);
        this.issueNotification(deployID, notif);
    }

    @Override
    public Map<String, Serializable> undeploy(String moduleID, Map<String, String> optionalParams) {
        Undeployer undeployer = new Undeployer(moduleID, optionalParams);
        DeploymentStatus undeploymentStatus = undeployer.undeploy();
        return undeploymentStatus.asMap();
    }

    @Override
    public Map<String, Serializable> getFinalDeploymentStatus(Object deployID) {
        DeployThread deployThread = this.removeDeployThread(deployID);
        if (deployThread == null) {
            throw new IllegalArgumentException(deployID.toString());
        }
        return deployThread.getDeploymentStatus().asMap();
    }

    private UploadDownloadMgr getUploadDownloadMgr() {
        return this.getDomainRoot().getUploadDownloadMgr();
    }

    @Override
    public Object initiateFileUpload(long totalSize) throws IOException {
        return this.initiateFileUpload(null, totalSize);
    }

    @Override
    public Object initiateFileUpload(String name, long totalSize) throws IOException {
        this.debug((Object)("initiateFileUpload(" + name + ", " + totalSize + ")"));
        return this.getUploadDownloadMgr().initiateUpload(name, totalSize);
    }

    @Override
    public boolean uploadBytes(Object uploadID, byte[] bytes) throws IOException {
        return this.getUploadDownloadMgr().uploadBytes(uploadID, bytes);
    }

    @Override
    public Object initiateFileDownload(String moduleID, String filename) throws IOException {
        DownloadFileSource source = new DownloadFileSource(moduleID, filename);
        File theFile = source.getDownloadFile();
        boolean deleteWhenDone = source.isTempFile();
        return this.getUploadDownloadMgr().initiateDownload(theFile, deleteWhenDone);
    }

    @Override
    public long getDownloadLength(Object downloadID) {
        return this.getUploadDownloadMgr().getDownloadLength(downloadID);
    }

    @Override
    public byte[] downloadBytes(Object downloadID, int requestSize) throws IOException {
        return this.getUploadDownloadMgr().downloadBytes(downloadID, requestSize);
    }

    private final class InternalDeploymentCallback
    implements DeploymentCallback {
        final Object mDeployID;

        public InternalDeploymentCallback(Object deployID) {
            this.mDeployID = deployID;
        }

        public void deploymentDone(DeploymentStatus status2) {
            DeploymentMgrImpl.this.issueDeploymentDoneNotification(this.mDeployID, status2);
        }

        public void deploymentProgress(DeploymentProgress progress) {
            DeploymentMgrImpl.this.issueDeploymentProgressNotification(this.mDeployID, progress);
        }
    }
}

