/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.config.RefConfig;
import com.sun.appserv.management.helper.RefHelper;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldApplicationsConfigMBean;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomMBeanConfigFactory
extends ConfigFactory {
    public CustomMBeanConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        Map<String, String> m = JMXUtil.attributeListToStringMap(translatedAttrs);
        String DOMAIN = null;
        String name = this.getOld().createMBean(DOMAIN, m);
        ObjectName objectName = this.getOld().getMbeanByName(name);
        this.debug("created custom MBean with name: " + objectName);
        return objectName;
    }

    private OldApplicationsConfigMBean getOld() {
        return this.getOldConfigProxies().getOldApplicationsConfigMBean();
    }

    public ObjectName create(String name, String implClassname, String objectName, boolean enabled, Map<String, String> optional) {
        String[] requiredParams = new String[]{"name", name, "impl-class-name", implClassname, "object-name", objectName, "enabled", "" + enabled};
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    private final String getRefContainerName(String name) {
        QueryMgr queryMgr = this.getDomainRoot().getQueryMgr();
        Set refs = RefHelper.findAllRefConfigsWithName(queryMgr, "X-DeployedItemRefConfig", name);
        RefConfig ref = (RefConfig)GSetUtil.getSingleton(refs);
        Container refContainer = ref.getContainer();
        return refContainer.getName();
    }

    @Override
    public final void removeByName(String name) {
        this.getOld().deleteMBean(this.getRefContainerName(name), name);
    }
}

