/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldConfigsMBean;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigConfigFactory
extends ConfigFactory {
    private String mSrcConfigName = null;
    private String mNewConfigName = null;
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("DynamicReconfigurationEnabled", "SrcConfigKey");

    public ConfigConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        this.trace("ConfigConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        OldConfigsMBean old = this.getOldConfigProxies().getOldConfigsMBean();
        ObjectName objectName = old.copyConfiguration(this.mSrcConfigName, this.mNewConfigName, props);
        return objectName;
    }

    public ObjectName create(String name, Map<String, String> optional) {
        ObjectName amxName;
        String[] requiredParams = new String[]{};
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        this.mNewConfigName = name;
        this.mSrcConfigName = optional.get("SrcConfigKey");
        if (this.mSrcConfigName == null) {
            this.mSrcConfigName = "default-config";
        }
        if ((amxName = this.createNamedChild(name, params)) != null) {
            ConfigConfig config = this.getCallbacks().getProxyFactory().getProxy(amxName, ConfigConfig.class);
            String value = optional.get("DynamicReconfigurationEnabled");
            if (value != null) {
                config.setDynamicReconfigurationEnabled(Boolean.parseBoolean("" + value));
            }
        }
        return amxName;
    }

    @Override
    protected void removeByName(String name) {
        this.getOldConfigProxies().getOldConfigsMBean().deleteConfiguration(name);
    }
}

