/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.repository.impl.cache;

import com.sun.enterprise.admin.wsmgmt.repository.impl.cache.J2eeApplication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheMgr {
    private static CacheMgr _mgr = null;
    private Map _j2eeApplications = new HashMap();
    private Map _ejbModules = new HashMap();
    private Map _webModules = new HashMap();
    private static final String EJB = "EJB_MODULE";
    private static final String WEB = "WEB_MODULE";
    private static final String CACHE_FILE = ".com_sun_appserv_wsindex";
    private static Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public static synchronized CacheMgr getInstance() {
        if (_mgr == null) {
            _mgr = new CacheMgr();
        }
        return _mgr;
    }

    private CacheMgr() {
        this.load();
    }

    private String getPropertyFile() {
        String iRoot = System.getProperty("com.sun.aas.instanceRoot");
        String file = iRoot + File.separator + "generated" + File.separator + CACHE_FILE;
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        FileOutputStream fos = null;
        try {
            Properties pro = new Properties();
            Collection eValues = this._ejbModules.values();
            for (String ejbMod : eValues) {
                pro.put(ejbMod, EJB);
            }
            Collection wValues = this._webModules.values();
            for (String webMod : wValues) {
                pro.put(webMod, WEB);
            }
            Collection aValues = this._j2eeApplications.values();
            for (J2eeApplication app : aValues) {
                pro.put(app.getName(), app.getPersistentValue());
            }
            File file = new File(this.getPropertyFile());
            fos = new FileOutputStream(file);
            pro.store(fos, "");
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Error while saving ws-mgmt cache file", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        FileInputStream fis = null;
        try {
            File file = new File(this.getPropertyFile());
            if (!file.exists()) {
                return;
            }
            fis = new FileInputStream(file);
            Properties pro = new Properties();
            pro.load(fis);
            Enumeration<Object> e = pro.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = pro.getProperty(key);
                if (EJB.equals(val)) {
                    this._ejbModules.put(key, key);
                    continue;
                }
                if (WEB.equals(val)) {
                    this._webModules.put(key, key);
                    continue;
                }
                J2eeApplication app = new J2eeApplication(key, val);
                this._j2eeApplications.put(key, app);
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Error while loading ws-mgmt cache file", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    void addJ2eeApplication(String name, List ejbBundles, List webBundles) {
        J2eeApplication app = new J2eeApplication(name, ejbBundles, webBundles);
        this._j2eeApplications.put(name, app);
    }

    J2eeApplication removeJ2eeApplication(String name) {
        return (J2eeApplication)this._j2eeApplications.remove(name);
    }

    public Map getJ2eeApplications() {
        return this._j2eeApplications;
    }

    public Map getEjbModules() {
        return this._ejbModules;
    }

    void addEjbModule(String name) {
        this._ejbModules.put(name, name);
    }

    String removeEjbModule(String name) {
        return (String)this._ejbModules.remove(name);
    }

    public Map getWebModules() {
        return this._webModules;
    }

    void addWebModule(String name) {
        this._webModules.put(name, name);
    }

    String removeWebModule(String name) {
        return (String)this._webModules.remove(name);
    }
}

