/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.filter.impl;

import com.sun.enterprise.admin.wsmgmt.SOAPMessageContext;
import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;
import com.sun.enterprise.admin.wsmgmt.stats.impl.WebServiceEndpointStatsProviderImpl;
import com.sun.enterprise.admin.wsmgmt.stats.spi.StatsProviderManager;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;

public class AggregateStatsFilter
implements Filter {
    public String getName() {
        return "AggregateStatsFilter";
    }

    public void process(String stage, String endpoint, FilterContext context) {
        WebServiceEndpointStatsProviderImpl impl = (WebServiceEndpointStatsProviderImpl)StatsProviderManager.getInstance().getEndpointStatsProvider(endpoint);
        if (stage.equals("PRE_PROCESS_REQUEST")) {
            impl.setRequestTimeStamp(System.currentTimeMillis(), null, null, 0);
        } else if (stage.equals("POST_PROCESS_RESPONSE")) {
            SOAPMessageContext smc = context.getMessageContext();
            SOAPMessage sm = null;
            SOAPFault fault = null;
            try {
                SOAPBody sb;
                if (smc != null) {
                    sm = smc.getMessage();
                }
                if (sm != null && (sb = sm.getSOAPBody()) != null) {
                    fault = sb.getFault();
                }
            }
            catch (Exception e) {
                impl.setFault(0, System.currentTimeMillis(), context.getExecutionTime(), null, null, null);
                return;
            }
            if (fault == null) {
                impl.setSuccess(0, System.currentTimeMillis(), context.getExecutionTime());
            } else {
                impl.setFault(0, System.currentTimeMillis(), context.getExecutionTime(), fault.getFaultCode(), fault.getFaultString(), fault.getFaultString());
            }
        } else {
            throw new RuntimeException(" Should not be called for this stage of execution of web service end point " + endpoint);
        }
    }
}

