/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.launch;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ASLauncherConfig {
    private String _process = "";
    private String _configFile = "";
    private String _classpathExcludes = "";
    private String _classpathIncludes = "";
    private String _classpathLibDir = "";
    private String _classpathPrefix = "";
    private String _classpathJ2se14Prefix = "";
    private String _classpathJ2se15OrLaterPrefix = "";
    private String _mainClass = "";
    private StringManager _strMgr = null;
    private Properties _sysProperties = null;
    private static boolean bDebug = false;
    private static final String PROCESS = "process";
    private static final String SYSTEM_PROPERTY = "sysproperty";
    private static final String MAIN_CLASS = "main_class";
    private static final String MAIN_CLASS_CLASSNAME = "classname";
    private static final String CLASSPATH = "classpath";
    private static final String CLASSPATH_INCLUDES = "includes";
    private static final String CLASSPATH_EXCLUDES = "excludes";
    private static final String CLASSPATH_PREFIX = "prefix";
    private static final String CLASSPATH_J2SE1_4_PREFIX = "j2se1_4_prefix";
    private static final String CLASSPATH_J2SE1_5_OR_LATER_PREFIX = "j2se1_5_or_later_prefix";
    private static final String CLASSPATH_DIR = "dir";

    protected ASLauncherConfig() {
    }

    protected ASLauncherConfig(String configFile, String process) throws ConfigException {
        this.initializeConfig(configFile, process);
    }

    protected void initializeConfig(String configFile, String process) throws ConfigException {
        this._configFile = configFile;
        this._process = process;
        this._sysProperties = new Properties();
        this._strMgr = StringManager.getManager(ASLauncherConfig.class);
        try {
            boolean bFoundProcess = false;
            String key = null;
            Document doc = this.readDOM(configFile);
            Element element = null;
            NodeList nl = doc.getElementsByTagName(PROCESS);
            for (int ii = 0; ii < nl.getLength(); ++ii) {
                element = (Element)nl.item(ii);
                key = element.getAttribute("name");
                if (!key.equals(process)) continue;
                bFoundProcess = true;
                this.loadProcess(element);
            }
            if (!bFoundProcess) {
                throw new ConfigException(this._strMgr.getString("launcher.process_launcher_config_not_found", (Object[])new String[]{process, configFile}));
            }
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigException(this._strMgr.getString("launcher.process_launcher_config_exception", (Object)this._configFile), (Throwable)e);
        }
    }

    protected void loadProcess(Element process) {
        String key = null;
        String value = null;
        String ifx = null;
        Element element = null;
        NodeList nl = process.getChildNodes();
        for (int ii = 0; ii < nl.getLength(); ++ii) {
            if (!(nl.item(ii) instanceof Element)) continue;
            element = (Element)nl.item(ii);
            if (element.getTagName().equals(SYSTEM_PROPERTY)) {
                key = element.getAttribute("key");
                value = element.getAttribute("value");
                ifx = element.getAttribute("if");
                if (key.equals("") || !ifx.equals("") && System.getProperty(ifx) == null) continue;
                this._sysProperties.setProperty(key, RelativePathResolver.resolvePath((String)value));
                continue;
            }
            if (element.getTagName().equals(MAIN_CLASS)) {
                this._mainClass = element.getAttribute(MAIN_CLASS_CLASSNAME);
                continue;
            }
            if (!element.getTagName().equals(CLASSPATH)) continue;
            this._classpathLibDir = element.getAttribute(CLASSPATH_DIR);
            this._classpathIncludes = element.getAttribute(CLASSPATH_INCLUDES);
            this._classpathExcludes = element.getAttribute(CLASSPATH_EXCLUDES);
            this._classpathPrefix = element.getAttribute(CLASSPATH_PREFIX);
            this._classpathJ2se14Prefix = element.getAttribute(CLASSPATH_J2SE1_4_PREFIX);
            this._classpathJ2se15OrLaterPrefix = element.getAttribute(CLASSPATH_J2SE1_5_OR_LATER_PREFIX);
        }
    }

    protected String getConfigFile() {
        return this._configFile;
    }

    protected String getClasspathLibDir() {
        return this._classpathLibDir;
    }

    protected String getClasspathIncludes() {
        return this._classpathIncludes;
    }

    protected String getClasspathExcludes() {
        return this._classpathExcludes;
    }

    protected String getClasspathPrefix() {
        return this._classpathPrefix;
    }

    protected String getClasspathJ2se14Prefix() {
        return this._classpathJ2se14Prefix;
    }

    protected String getClasspathJ2se15OrLaterPrefix() {
        return this._classpathJ2se15OrLaterPrefix;
    }

    protected String getMainClass() {
        return this._mainClass;
    }

    protected Properties getSystemProperties() {
        return this._sysProperties;
    }

    protected Document readDOM(String file) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(new File(file));
    }
}

