/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.AgentImpl;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.admin.monitor.callflow.ContainerTypeOrApplicationType;
import com.sun.enterprise.admin.monitor.callflow.RequestInfo;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.jasper.servlet.JspServlet;

public class WebContainerListener
implements InstanceListener,
ContainerListener {
    private static final String JSP_SERVLET = JspServlet.class.getName();
    private static final ThreadLocal<AgentImpl.FlowStack<Boolean>> threadLocal = new ThreadLocal(){

        protected AgentImpl.FlowStack<Boolean> initialValue() {
            return new AgentImpl.FlowStack<Boolean>();
        }
    };
    private static final ThreadLocal<Boolean> requestStartTls = new ThreadLocal(){

        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();

    public void instanceEvent(InstanceEvent event) {
        if (!this.callFlowAgent.isEnabled()) {
            return;
        }
        if (!requestStartTls.get().booleanValue()) {
            return;
        }
        if (event.getType().equals("beforeService")) {
            AgentImpl.FlowStack<Boolean> flowStack = threadLocal.get();
            if (flowStack.size() == 0) {
                this.processBeforeDispatchEvent(event);
            }
            flowStack.push(Boolean.TRUE);
            this.processBeforeServiceEvent(event);
        } else if (event.getType().equals("afterService")) {
            this.processAfterServiceEvent(event);
            AgentImpl.FlowStack<Boolean> flowStack = threadLocal.get();
            flowStack.pop();
            if (flowStack.size() == 0) {
                this.processAfterDispatchEvent(event);
            }
        } else if (event.getType().equals("beforeFilter")) {
            AgentImpl.FlowStack<Boolean> flowStack = threadLocal.get();
            if (flowStack.size() == 0) {
                this.processBeforeDispatchEvent(event);
            }
            flowStack.push(Boolean.TRUE);
            this.processBeforeFilterEvent(event);
        } else if (event.getType().equals("afterFilter")) {
            this.processAfterFilterEvent(event);
            AgentImpl.FlowStack<Boolean> flowStack = threadLocal.get();
            flowStack.pop();
            if (flowStack.size() == 0) {
                this.processAfterDispatchEvent(event);
            }
        } else if (event.getType().equals("beforeDispatch")) {
            this.processBeforeDispatchEvent(event);
        } else if (event.getType().equals("afterDispatch")) {
            this.processAfterDispatchEvent(event);
        }
    }

    private void processBeforeServiceEvent(InstanceEvent event) {
        Wrapper wrapper;
        String applicationName;
        Servlet servlet = event.getServlet();
        ServletConfig servletConfig = servlet.getServletConfig();
        String servletName = "UNKNOWN";
        if (servletConfig != null) {
            servletName = servletConfig.getServletName();
        }
        HttpServletRequest req = (HttpServletRequest)event.getRequest();
        String methodName = req.getRequestURI() + ":";
        methodName = !servlet.getClass().getName().equalsIgnoreCase(JSP_SERVLET) ? methodName + servlet.getClass().getName() + ".service" : methodName + this.extractJSPName(req) + ":" + JSP_SERVLET + ".service";
        String callerPrincipal = req.getRemoteUser();
        if (callerPrincipal == null) {
            callerPrincipal = req.getUserPrincipal() != null ? req.getUserPrincipal().getName() : "anonymous";
        }
        if ((applicationName = ((StandardContext)(wrapper = event.getWrapper()).getParent()).getJ2EEApplication()) == null || applicationName.equals("null")) {
            applicationName = "URI:" + req.getRequestURI();
        }
        String moduleName = wrapper.getParent().getName();
        this.callFlowAgent.webMethodStart(methodName, applicationName, moduleName, servletName, ComponentType.SERVLET, callerPrincipal);
    }

    private void processAfterServiceEvent(InstanceEvent event) {
        Throwable exception = event.getException();
        this.callFlowAgent.webMethodEnd(exception);
    }

    private void processBeforeFilterEvent(InstanceEvent event) {
        Wrapper wrapper;
        String applicationName;
        Filter filter = event.getFilter();
        HttpServletRequest req = (HttpServletRequest)event.getRequest();
        String methodName = req.getRequestURI() + ":" + filter.getClass().getName() + ".doFilter";
        String callerPrincipal = req.getRemoteUser();
        if (callerPrincipal == null) {
            callerPrincipal = req.getUserPrincipal() != null ? req.getUserPrincipal().getName() : "anonymous";
        }
        if ((applicationName = ((StandardContext)(wrapper = event.getWrapper()).getParent()).getJ2EEApplication()) == null || applicationName.equals("null")) {
            applicationName = "URI:" + req.getRequestURI();
        }
        String moduleName = wrapper.getParent().getName();
        this.callFlowAgent.webMethodStart(methodName, applicationName, moduleName, filter.getClass().getName(), ComponentType.SERVLET_FILTER, callerPrincipal);
    }

    private void processAfterFilterEvent(InstanceEvent event) {
        Throwable exception = event.getException();
        this.callFlowAgent.webMethodEnd(exception);
    }

    private void processBeforeDispatchEvent(InstanceEvent event) {
        this.callFlowAgent.startTime(ContainerTypeOrApplicationType.WEB_CONTAINER);
    }

    private void processAfterDispatchEvent(InstanceEvent event) {
        this.callFlowAgent.endTime();
    }

    public void containerEvent(ContainerEvent event) {
        if (!this.callFlowAgent.isEnabled()) {
            return;
        }
        Object obj = event.getData();
        if (!(obj instanceof org.apache.coyote.RequestInfo)) {
            return;
        }
        org.apache.coyote.RequestInfo requestInfo = (org.apache.coyote.RequestInfo)obj;
        if ("connectionProcessingStarted".equals(event.getType())) {
            requestStartTls.set(Boolean.TRUE);
            this.callFlowAgent.requestStart(RequestType.REMOTE_WEB);
            this.callFlowAgent.addRequestInfo(RequestInfo.CALLER_IP_ADDRESS, requestInfo.getRemoteAddr());
        } else if ("requestProcessingCompleted".equals(event.getType())) {
            this.callFlowAgent.requestEnd();
        }
    }

    private String extractJSPName(HttpServletRequest request) {
        String jspUri = null;
        String jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file");
        if (jspFile != null) {
            jspUri = jspFile;
        } else {
            jspUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (jspUri != null) {
                String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            } else {
                jspUri = request.getServletPath();
                String pathInfo = request.getPathInfo();
                if (pathInfo != null) {
                    jspUri = jspUri + pathInfo;
                }
            }
        }
        return jspUri;
    }
}

