/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import java.io.Serializable;

public class ByteChunk
implements Serializable {
    public static final long serialVersionUID = 9100504074948693275L;
    public static final int kChunkMaxSize = 0xA00000;
    public static final int kChunkMinSize = 0;
    private int mSize;
    private boolean mIsLast;
    private boolean mIsFirst;
    private byte[] mBytes;
    private String mChunkedFileName;
    private String mTargetDir;
    private String mUniqueId;
    private long mTotalFileSize;

    public ByteChunk(byte[] byteArray, String forFileName, boolean isFirst, boolean isLast, String uniqueId, long totalFileSize) {
        int size = 0;
        if (byteArray != null && ((size = byteArray.length) < 0 || size > 0xA00000)) {
            throw new IllegalArgumentException(size + "");
        }
        this.mSize = size;
        this.mIsFirst = isFirst;
        this.mIsLast = isLast;
        this.mBytes = byteArray;
        this.mChunkedFileName = forFileName;
        this.mUniqueId = uniqueId;
        this.mTotalFileSize = totalFileSize;
    }

    public ByteChunk(byte[] byteArray, String forFileName, boolean isFirst, boolean isLast) {
        this(byteArray, forFileName, isFirst, isLast, forFileName, -1L);
    }

    public boolean isLast() {
        return this.mIsLast;
    }

    public boolean isFirst() {
        return this.mIsFirst;
    }

    public int getSize() {
        return this.mSize;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    public String getChunkedFileName() {
        return this.mChunkedFileName;
    }

    public String getTargetDir() {
        return this.mTargetDir;
    }

    public void setTargetDir(String targetDir) {
        this.mTargetDir = targetDir;
    }

    public String getId() {
        return this.mUniqueId;
    }

    public long getTotalFileSize() {
        return this.mTotalFileSize;
    }
}

