/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.addons;

import com.sun.appserv.addons.AddonException;
import com.sun.appserv.addons.AddonVersion;

public class AddonVersionImpl
implements AddonVersion {
    private String addonName = null;
    private String namePart = null;
    private String version = null;
    private int major = 0;
    private int minor = 0;
    private int patch = 0;
    private final String DEFAULT_VERSION = "00_00_00";
    private final String VERSION_PATTERN = ".*_[0-9][0-9]_[0-9][0-9]_[0-9][0-9]";
    private final String VERSION_SEPARATOR = "_";

    AddonVersionImpl(String addonName) throws AddonException {
        this.addonName = addonName;
        if (addonName.matches(".*_[0-9][0-9]_[0-9][0-9]_[0-9][0-9]")) {
            this.version = addonName.substring(addonName.length() - "00_00_00".length());
            this.namePart = addonName.substring(0, addonName.length() - ("00_00_00".length() + 1));
        } else {
            this.version = "00_00_00";
            this.namePart = addonName;
        }
        this.parseVersion(this.version);
    }

    private void parseVersion(String versionPart) throws AddonException {
        String[] strArr = versionPart.split("_");
        this.setMajor(strArr[0]);
        this.setMinor(strArr[1]);
        this.setPatch(strArr[2]);
    }

    public String getVersion() throws AddonException {
        return this.version;
    }

    public int getMajor() throws AddonException {
        return this.major;
    }

    private void setMajor(String major) throws AddonException {
        try {
            this.major = Integer.valueOf(major);
        }
        catch (Exception e) {
            throw new AddonException(e);
        }
    }

    public int getMinor() throws AddonException {
        return this.minor;
    }

    private void setMinor(String minor) throws AddonException {
        try {
            this.minor = Integer.valueOf(minor);
        }
        catch (Exception e) {
            throw new AddonException(e);
        }
    }

    public int getPatch() throws AddonException {
        return this.patch;
    }

    private void setPatch(String patch) throws AddonException {
        try {
            this.patch = Integer.valueOf(patch);
        }
        catch (Exception e) {
            throw new AddonException(e);
        }
    }

    protected String getName() {
        return this.addonName;
    }

    protected String getNamePart() {
        return this.namePart;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        try {
            sb.append("Version details for the AddOn " + this.addonName + ":");
            sb.append("version = " + this.getVersion() + ":");
            sb.append("major = " + this.getMajor() + ":");
            sb.append("minor = " + this.getMinor() + ":");
            sb.append("patch = " + this.getPatch());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    protected boolean isHigher(AddonVersionImpl newVersion) throws AddonException {
        if (newVersion.getMajor() > this.getMajor()) {
            return true;
        }
        if (newVersion.getMajor() < this.getMajor()) {
            return false;
        }
        if (newVersion.getMinor() > this.getMinor()) {
            return true;
        }
        if (newVersion.getMinor() < this.getMinor()) {
            return false;
        }
        return newVersion.getPatch() > this.getPatch();
    }

    protected boolean isLower(AddonVersionImpl newVersion) throws AddonException {
        if (newVersion.getMajor() < this.getMajor()) {
            return true;
        }
        if (newVersion.getMajor() > this.getMajor()) {
            return false;
        }
        if (newVersion.getMinor() < this.getMinor()) {
            return true;
        }
        if (newVersion.getMinor() > this.getMinor()) {
            return false;
        }
        return newVersion.getPatch() < this.getPatch();
    }
}

