/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.security.SecurityContext;
import java.security.Principal;
import java.security.cert.X509Certificate;

public class WebPrincipal
extends PrincipalImpl {
    private String password;
    private X509Certificate[] certs;
    private boolean useCertificate;
    private SecurityContext secCtx;
    private Principal customPrincipal;

    public WebPrincipal(Principal p, SecurityContext context) {
        super(p.getName());
        if (!(p instanceof PrincipalImpl)) {
            this.customPrincipal = p;
        }
        this.useCertificate = false;
        this.secCtx = context;
    }

    public WebPrincipal(String user, String password, SecurityContext context) {
        super(user);
        this.password = password;
        this.useCertificate = false;
        this.secCtx = context;
    }

    public WebPrincipal(X509Certificate[] certs, SecurityContext context) {
        super(certs[0].getSubjectDN().getName());
        this.certs = certs;
        this.useCertificate = true;
        this.secCtx = context;
    }

    public String getPassword() {
        return this.password;
    }

    public X509Certificate[] getCertificates() {
        return this.certs;
    }

    public boolean isUsingCertificate() {
        return this.useCertificate;
    }

    public SecurityContext getSecurityContext() {
        return this.secCtx;
    }

    public String getName() {
        if (this.customPrincipal == null) {
            return super.getName();
        }
        return this.customPrincipal.getName();
    }

    public boolean equals(Object another) {
        if (this.customPrincipal == null) {
            return super.equals(another);
        }
        return ((Object)this.customPrincipal).equals(another);
    }

    public int hashCode() {
        if (this.customPrincipal == null) {
            return super.hashCode();
        }
        return ((Object)this.customPrincipal).hashCode();
    }

    public String toString() {
        if (this.customPrincipal == null) {
            return super.toString();
        }
        return ((Object)this.customPrincipal).toString();
    }
}

