/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.webservice.ApplicationLoaderEventListenerImpl;
import com.sun.enterprise.webservice.ServiceEngineRtObjectFactory;
import com.sun.enterprise.webservice.WSClientContainer;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.ClientTransportFactory;
import com.sun.xml.rpc.spi.runtime.StubBase;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class ServiceEngineUtil {
    public static final String JBI_ENABLED = "jbi-enabled";
    private static final String seDisablePropertyValue = System.getProperty("com.sun.enterprise.jbi.se.disable");
    private static final boolean seEnabledFlag = !"true".equals(seDisablePropertyValue);
    private static final ApplicationLoaderEventListenerImpl listener = new ApplicationLoaderEventListenerImpl();
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system");

    public static ApplicationLoaderEventListenerImpl getListener() {
        return listener;
    }

    public static boolean isServiceJBIEnabled(ServiceReferenceDescriptor desc) {
        if (ServiceEngineUtil.isServiceEngineEnabled()) {
            Set portsInfo = desc.getPortsInfo();
            for (ServiceRefPortInfo portDesc : portsInfo) {
                if (!ServiceEngineUtil.isPortJbiEnabled(portDesc)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setJBITransportFactory(ServiceRefPortInfo portInfo, Object stubObj, boolean jbiEnabled) {
        if (ServiceEngineUtil.isServiceEngineEnabled()) {
            ServiceReferenceDescriptor serviceRef = portInfo.getServiceReference();
            if (serviceRef != null && stubObj != null && ServiceEngineUtil.isServiceEngineEnabled() && jbiEnabled && serviceRef.getMappingFileUri() != null) {
                ServiceEngineUtil.setTransportFactory((StubBase)stubObj, portInfo);
            }
        } else {
            logger.log(Level.INFO, "Java EE Service Engine's functionality is disabled");
        }
    }

    public static boolean isServiceEngineEnabled() {
        return seEnabledFlag;
    }

    public static ServiceRefPortInfo getPortInfo(WSClientContainer container, QName portName) {
        return container.svcRef.getPortInfoByPort(portName);
    }

    public static boolean isJBIRequest(String delegateClassName) {
        return delegateClassName.equals("com.sun.enterprise.jbi.serviceengine.bridge.transport.NMRServerConnection");
    }

    private static boolean isPortJbiEnabled(ServiceRefPortInfo portInfo) {
        if (portInfo != null) {
            String value = portInfo.getStubPropertyValue(JBI_ENABLED);
            logger.log(Level.FINEST, "JBI_ENABLED flag value is : " + value);
            return "true".equals(value);
        }
        return false;
    }

    private static void setTransportFactory(StubBase stubObj, ServiceRefPortInfo portInfo) {
        block3: {
            try {
                ClientTransportFactory factory = (ClientTransportFactory)ServiceEngineRtObjectFactory.getInstance().getFacade().getTransportFactory(portInfo, true);
                if (factory == null) {
                    return;
                }
                logger.log(Level.INFO, "Before setting setTransportFactory to NMR");
                stubObj._setTransportFactory(factory);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Error during setting of transport factory" + e.getMessage());
            }
        }
    }
}

