/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.i18n.StringManager;

public class SystemPropertyConstants {
    public static final String UNIX_ASENV_FILENAME = "asenv.conf";
    public static final String WINDOWS_ASENV_FILENAME = "asenv.bat";
    public static final String WEB_SERVICES_LIB_PROPERTY = "com.sun.aas.webServicesLib";
    public static final String PERL_ROOT_PROPERTY = "com.sun.aas.perlRoot";
    public static final String IMQ_LIB_PROPERTY = "com.sun.aas.imqLib";
    public static final String IMQ_BIN_PROPERTY = "com.sun.aas.imqBin";
    public static final String CONFIG_ROOT_PROPERTY = "com.sun.aas.configRoot";
    public static final String INSTALL_ROOT_PROPERTY = "com.sun.aas.installRoot";
    public static final String JAVA_ROOT_PROPERTY = "com.sun.aas.javaRoot";
    public static final String ICU_LIB_PROPERTY = "com.sun.aas.icuLib";
    public static final String DEFAULT_LOCALE_PROPERTY = "com.sun.aas.defaultLocale";
    public static final String DOMAINS_ROOT_PROPERTY = "com.sun.aas.domainsRoot";
    public static final String INSTANCE_ROOT_PROPERTY = "com.sun.aas.instanceRoot";
    public static final String AGENT_CERT_NICKNAME = "com.sun.aas.agentCertNickname";
    public static final String AGENT_ROOT_PROPERTY = "com.sun.aas.agentRoot";
    public static final String AGENT_NAME_PROPERTY = "com.sun.aas.agentName";
    public static final String WEBCONSOLE_LIB_PROPERTY = "com.sun.aas.webconsoleLib";
    public static final String WEBCONSOLE_APP_PROPERTY = "com.sun.aas.webconsoleApp";
    public static final String JATO_ROOT_PROPERTY = "com.sun.aas.jatoRoot";
    public static final String ANT_ROOT_PROPERTY = "com.sun.aas.antRoot";
    public static final String ANT_LIB_PROPERTY = "com.sun.aas.antLib";
    public static final String JHELP_ROOT_PROPERTY = "com.sun.aas.jhelpRoot";
    public static final String SERVER_NAME = "com.sun.aas.instanceName";
    public static final String CLUSTER_NAME = "com.sun.aas.clusterName";
    public static final String HADB_ROOT_PROPERTY = "com.sun.aas.hadbRoot";
    public static final String NSS_ROOT_PROPERTY = "com.sun.aas.nssRoot";
    public static final String NSS_BIN_PROPERTY = "com.sun.aas.nssBin";
    public static final String NATIVE_LAUNCHER = "com.sun.aas.nativeLauncher";
    public static final String NATIVE_LAUNCHER_LIB_PREFIX = "com.sun.aas.nativeLauncherLibPrefix";
    public static final String KEYSTORE_PROPERTY = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    public static final String JKS_KEYSTORE = System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "keystore.jks";
    public static final String TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String JKS_TRUSTSTORE = System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "cacerts.jks";
    public static final String ADMIN_REALM = "admin-realm";
    public static final String NSS_DB_PROPERTY = "com.sun.appserv.nss.db";
    public static final String NSS_DB_PASSWORD_PROPERTY = "com.sun.appserv.nss.db.password";
    public static final String CLIENT_TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    public static final String CLIENT_TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String PID_FILE = ".__com_sun_appserv_pid";
    public static final String REF_TS_FILE = "admsn";
    public static final String KILLSERV_SCRIPT = "killserv";
    public static final String KILL_SERV_UNIX = "killserv";
    public static final String KILL_SERV_WIN = "killserv.bat";
    public static final String KILL_SERV_OS = OS.isWindows() ? "killserv.bat" : "killserv";
    public static final String DEFAULT_SERVER_INSTANCE_NAME = "server";
    public static final String JDMK_HOME_PROPERTY = "com.sun.aas.jdmkHome";
    public static final String DERBY_ROOT_PROPERTY = "com.sun.aas.derbyRoot";
    public static final String MFWK_HOME_PROPERTY = "com.sun.aas.mfwkHome";
    public static final String DOMAIN_NAME = "domain.name";
    public static final String HOST_NAME_PROPERTY = "com.sun.aas.hostName";
    public static final String CONFIG_NAME_PROPERTY = "com.sun.aas.configName";
    public static final String DOCROOT_PROPERTY = "docroot";
    public static final String ACCESSLOG_PROPERTY = "accesslog";
    public static final String DEFAULT_SERVER_SOCKET_ADDRESS = "0.0.0.0";
    public static final String CLUSTER_AWARE_FEATURE_FACTORY_CLASS = "com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl";
    public static final String TEMPLATE_CONFIG_NAME = "default-config";
    private static final StringManager sm = StringManager.getManager(SystemPropertyConstants.class);
    public static final String OPEN = "${";
    public static final String CLOSE = "}";

    public static final String getPropertyAsValue(String name) {
        if (name == null) {
            String pn = "spc.null_name";
            String pv = "property";
            throw new IllegalArgumentException(sm.getString("spc.null_name", "property"));
        }
        StringBuffer sb = new StringBuffer();
        sb.append(OPEN).append(name).append(CLOSE);
        return sb.toString();
    }

    public static final String unSystemProperty(String sp) {
        if (sp == null) {
            throw new IllegalArgumentException("null_arg");
        }
        String ret = sp;
        if (SystemPropertyConstants.isSystemPropertySyntax(sp)) {
            ret = sp.substring(2, sp.length() - 1);
        }
        return ret;
    }

    public static final boolean isSystemPropertySyntax(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null_arg");
        }
        boolean sp = false;
        if (s.startsWith(OPEN) && s.endsWith(CLOSE)) {
            sp = true;
        }
        return sp;
    }

    public static final String getDocRootDefaultValue() {
        StringBuffer sb = new StringBuffer(SystemPropertyConstants.getPropertyAsValue(INSTANCE_ROOT_PROPERTY));
        return sb.append("/docroot").toString();
    }

    public static final String getAccessLogDefaultValue() {
        StringBuffer sb = new StringBuffer(SystemPropertyConstants.getPropertyAsValue(INSTANCE_ROOT_PROPERTY));
        return sb.append("/logs/access").toString();
    }

    public static final String getAsAdminScriptLocation() {
        StringBuilder sb = new StringBuilder();
        String ext = OS.isWindows() ? ".bat" : "";
        String ASADMIN = "asadmin";
        String suffix = "bin" + System.getProperty("file.separator") + "asadmin" + ext;
        sb.append(System.getProperty(INSTALL_ROOT_PROPERTY));
        String fs = System.getProperty("file.separator");
        if (!sb.toString().endsWith(fs)) {
            sb.append(fs);
        }
        sb.append(suffix);
        return sb.toString();
    }
}

