/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.ejb.Container;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;

public class InvocationManagerImpl
implements InvocationManager {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    public static boolean debug = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InvocationManagerImpl.class);
    private InheritableThreadLocal frames = new InheritableThreadLocal(){

        protected Object initialValue() {
            return new InvocationArray();
        }

        protected Object childValue(Object parentValue) {
            InvocationArray result = new InvocationArray();
            InvocationArray v = (InvocationArray)parentValue;
            if (v.size() > 0 && v.outsideStartup()) {
                ComponentInvocation parentInv = (ComponentInvocation)v.get(v.size() - 1);
                if (parentInv.getInvocationType() == 0) {
                    ComponentInvocation inv = new ComponentInvocation(null, parentInv.getContainerContext());
                    result.add(inv);
                } else if (parentInv.getInvocationType() != 1) {
                    ComponentInvocation cpy = new ComponentInvocation(parentInv.getInstance(), parentInv.getContainerContext());
                    cpy.setTransaction(parentInv.getTransaction());
                    result.add(cpy);
                }
            }
            return result;
        }
    };
    private J2EETransactionManager tm;

    public void preInvoke(ComponentInvocation inv) throws InvocationException {
        Realm rlm;
        if (debug && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IM: preInvoke" + inv.instance);
        }
        int invType = inv.getInvocationType();
        InvocationArray v = (InvocationArray)this.frames.get();
        if (invType == 4) {
            v.setInvocationAttribute(4);
            return;
        }
        if (invType == 1) {
            SecurityManager sm = ((Container)inv.getContainerContext()).getSecurityManager();
            sm.preInvoke(inv);
        } else if (invType == 0 && (rlm = ((Context)inv.getContainerContext()).getRealm()) instanceof RealmAdapter) {
            RealmAdapter rad = (RealmAdapter)rlm;
            rad.preSetRunAsIdentity(inv);
        }
        v.add(inv);
        int size = v.size();
        ComponentInvocation prev = size < 2 ? null : (ComponentInvocation)v.get(size - 2);
        if (this.tm == null) {
            this.tm = Switch.getSwitch().getTransactionManager();
        }
        this.tm.preInvoke(prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(ComponentInvocation inv) throws InvocationException {
        if (debug && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IM: postInvoke" + inv.instance);
        }
        int invType = inv.getInvocationType();
        InvocationArray v = (InvocationArray)this.frames.get();
        if (invType == 4) {
            v.setInvocationAttribute(3);
            return;
        }
        int size = v.size();
        if (size == 0) {
            throw new InvocationException();
        }
        try {
            Realm rlm;
            if (invType == 1) {
                SecurityManager sm = ((Container)inv.getContainerContext()).getSecurityManager();
                sm.postInvoke(inv);
            } else if (invType == 0 && (rlm = ((Context)inv.getContainerContext()).getRealm()) instanceof RealmAdapter) {
                RealmAdapter rad = (RealmAdapter)rlm;
                rad.postSetRunAsIdentity(inv);
            }
            ComponentInvocation prev = size < 2 ? null : (ComponentInvocation)v.get(size - 2);
            ComponentInvocation curr = (ComponentInvocation)v.get(size - 1);
            this.tm.postInvoke(curr, prev);
            Switch.getSwitch().getPoolManager().postInvoke();
        }
        finally {
            v.remove(size - 1);
        }
    }

    public boolean isInvocationStackEmpty() {
        ArrayList v = (ArrayList)this.frames.get();
        return v.size() == 0;
    }

    public ComponentInvocation getCurrentInvocation() {
        ArrayList v = (ArrayList)this.frames.get();
        int size = v.size();
        if (size == 0) {
            return null;
        }
        return (ComponentInvocation)v.get(size - 1);
    }

    public ComponentInvocation getPreviousInvocation() throws InvocationException {
        ArrayList v = (ArrayList)this.frames.get();
        int i = v.size();
        if (i < 2) {
            return null;
        }
        return (ComponentInvocation)v.get(i - 2);
    }

    public List getAllInvocations() {
        return (ArrayList)this.frames.get();
    }

    public boolean isStartupInvocation() {
        InvocationArray v;
        if (this.frames != null && (v = (InvocationArray)this.frames.get()) != null) {
            return !v.outsideStartup();
        }
        return false;
    }

    class InvocationArray
    extends ArrayList {
        private int invocationAttribute;

        InvocationArray() {
        }

        public void setInvocationAttribute(int attribute) {
            this.invocationAttribute = attribute;
        }

        public int getInvocationAttribute() {
            return this.invocationAttribute;
        }

        public boolean outsideStartup() {
            return this.getInvocationAttribute() != 4;
        }
    }
}

