/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.ConfigChangeCategory;
import com.sun.enterprise.admin.event.tx.JTSEvent;
import com.sun.enterprise.admin.event.tx.JTSEventListener;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JTSConfigChangeEventListener
implements JTSEventListener {
    private static StringManager sm = StringManager.getManager(JTSConfigChangeEventListener.class);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jta");
    public String xPath = "/domain/configs/config[@name='server-config']/transaction-service";
    private static ConfigChangeCategory category = new ConfigChangeCategory("jts", "/{1,}domain/{1,}configs/{1,}config[@name='server\\-config']/{1,}transaction-service.*");

    public static ConfigChangeCategory getCategory() {
        return category;
    }

    public void handleCreate(JTSEvent event) throws AdminEventListenerException {
        throw new AdminEventListenerException("handleCreate is not valid for JTSEvent");
    }

    public void handleDelete(JTSEvent event) throws AdminEventListenerException {
        throw new AdminEventListenerException("handleDelete is not valid for JTSEvent");
    }

    public void handleUpdate(JTSEvent event) throws AdminEventListenerException {
        if (event == null) {
            return;
        }
        ArrayList configChangeList = event.getConfigChangeList();
        if (configChangeList == null) {
            return;
        }
        ConfigUpdate configUpdate = null;
        boolean match = false;
        for (int i = 0; i < configChangeList.size(); ++i) {
            configUpdate = (ConfigUpdate)configChangeList.get(i);
            if (configUpdate.getXPath() == null || !configUpdate.getXPath().endsWith("transaction-service") || !this.xPath.equals(configUpdate.getXPath())) continue;
            match = true;
            break;
        }
        if (match) {
            Set attributeSet = configUpdate.getAttributeSet();
            String next2 = null;
            for (String next2 : attributeSet) {
                if (next2.equals("timeout-in-seconds")) {
                    _logger.log(Level.FINE, " Transaction Timeout interval event occurred");
                    String oldTimeout = configUpdate.getOldValue("timeout-in-seconds");
                    String newTimeout = configUpdate.getNewValue("timeout-in-seconds");
                    if (oldTimeout.equals(newTimeout)) continue;
                    try {
                        Switch.getSwitch().getTransactionManager().setDefaultTransactionTimeout(Integer.parseInt(newTimeout, 10));
                    }
                    catch (Exception ex) {
                        _logger.log(Level.WARNING, "transaction.reconfig_txn_timeout_failed", ex);
                    }
                    continue;
                }
                if (next2.equals("keypoint-interval")) {
                    _logger.log(Level.FINE, "Keypoint interval event occurred");
                    String oldKeyPoint = configUpdate.getOldValue("keypoint-interval");
                    String newKeyPoint = configUpdate.getNewValue("keypoint-interval");
                    if (oldKeyPoint.equals(newKeyPoint)) continue;
                    Configuration.setKeypointTrigger(Integer.parseInt(newKeyPoint, 10));
                    continue;
                }
                if (next2.equals("retry-timeout-in-seconds")) {
                    String oldRetryTiemout = configUpdate.getOldValue("retry-timeout-in-seconds");
                    String newRetryTiemout = configUpdate.getNewValue("retry-timeout-in-seconds");
                    _logger.log(Level.FINE, "retry_timeout_in_seconds reconfig event occurred " + newRetryTiemout);
                    if (oldRetryTiemout.equals(newRetryTiemout)) continue;
                    Configuration.setCommitRetryVar(newRetryTiemout);
                    continue;
                }
                AdminEventMulticaster.notifyFailure(event, "restart");
            }
        }
    }
}

