/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.tests.web.runtime.ASWebProperty;

public class ASSessionManager
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        boolean notApp = false;
        try {
            SessionConfig sessionConfig = descriptor.getSunDescriptor().getSessionConfig();
            SessionManager sessionMgr = null;
            StoreProperties stroeProp = null;
            ManagerProperties mgrProps = null;
            WebProperty[] SPwebProps = null;
            WebProperty[] MPwebProps = null;
            if (sessionConfig != null) {
                sessionMgr = sessionConfig.getSessionManager();
            }
            if (sessionConfig != null && sessionMgr != null) {
                mgrProps = sessionMgr.getManagerProperties();
                stroeProp = sessionMgr.getStoreProperties();
                if (stroeProp != null) {
                    SPwebProps = stroeProp.getWebProperty();
                }
                if (mgrProps != null) {
                    MPwebProps = mgrProps.getWebProperty();
                }
                if (!(SPwebProps != null && SPwebProps.length != 0 || MPwebProps != null && MPwebProps.length != 0)) {
                    notApp = true;
                } else {
                    if ((SPwebProps != null || SPwebProps.length > 0) && ASWebProperty.checkWebProperties(SPwebProps, result, descriptor, this)) {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB session-manager] store-properties - Atleast one name/value pair is not valid in [ {0} ].", new Object[]{descriptor.getName()}));
                    }
                    if ((MPwebProps != null || MPwebProps.length > 0) && ASWebProperty.checkWebProperties(MPwebProps, result, descriptor, this)) {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB session-manager] manager-properties - Atleast one name/value pair is not valid in [ {0} ].", new Object[]{descriptor.getName()}));
                    }
                }
            } else {
                notApp = true;
            }
            if (notApp) {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB session-config] session-manager element not defined in the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB session-config] session manager element(s) and their manager-properties and/or store-properties are valid within the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB session-config] could not create the session-config object"));
        }
        return result;
    }
}

