/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import com.sun.enterprise.tools.verifier.VerifierUtils;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.EventObject;
import java.util.Vector;

public class WebTestsUtil
implements VerifierEventsListener {
    protected final String listenerClassPath = "WEB-INF/classes";
    protected final String libraryClassPath = "WEB-INF/lib";
    private final String separator = System.getProperty("file.separator");
    private static File warFile = new File(System.getProperty("java.io.tmpdir"), "listenertmp");
    private static WebTestsUtil util = null;
    private static ClassLoader cl = null;

    public static WebTestsUtil getUtil(ClassLoader cLoader) {
        if (util == null) {
            util = new WebTestsUtil();
            WebCheckMgrImpl.addVerifierEventsListener(util);
            cl = cLoader;
        }
        return util;
    }

    public File extractJarFile(File warFilePath) throws IOException {
        try {
            warFile = new File(System.getProperty("java.io.tmpdir"), "listenertmp");
            if (!warFile.exists()) {
                warFile.mkdirs();
            }
            VerifierUtils.copyArchiveToDir(warFilePath, warFile);
            return warFile;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void deleteDirectory(String oneDir) {
        File cleanDir = new File(oneDir);
        if (!cleanDir.exists()) {
            return;
        }
        File[] listOfFiles = cleanDir.listFiles();
        if (listOfFiles != null) {
            for (int countFiles = 0; countFiles < listOfFiles.length; ++countFiles) {
                if (listOfFiles[countFiles].isFile()) {
                    listOfFiles[countFiles].delete();
                    continue;
                }
                String nextCleanDir = cleanDir + this.separator + listOfFiles[countFiles].getName();
                File newCleanDir = new File(nextCleanDir);
                this.deleteDirectory(newCleanDir.getAbsolutePath());
            }
        }
        cleanDir.delete();
    }

    public void testFinished(EventObject e) {
    }

    public void allTestsFinished(EventObject e) {
        if (warFile != null && warFile.exists()) {
            this.deleteDirectory(warFile.getAbsolutePath());
        }
        warFile = null;
        util = null;
        cl = null;
        WebCheckMgrImpl.removeVerifierEventsListener(this);
    }

    public void appendCLWithWebInfContents() throws Throwable {
        int i;
        File warclasses = new File(warFile, "WEB-INF/classes");
        File libraries = new File(warFile, "WEB-INF/lib");
        Vector<File> v = new Vector<File>();
        if (libraries.exists()) {
            File[] libs = libraries.listFiles();
            for (i = 0; i < libs.length; ++i) {
                if (!libs[i].getName().endsWith(".jar")) continue;
                v.add(libs[i]);
            }
        }
        URL[] repositories = new URL[v.size() + 1];
        repositories[0] = warclasses.toURI().toURL();
        for (i = 1; i <= v.size(); ++i) {
            repositories[i] = ((File)v.elementAt(i - 1)).toURI().toURL();
        }
        for (i = 0; i < repositories.length; ++i) {
            ((JarClassLoader)cl).appendURL(repositories[i]);
        }
    }

    private ClassLoader getClassLoader() {
        return cl;
    }

    public Class loadClass(String className) throws Throwable {
        if (!(warFile != null && warFile.exists() || this.getClassLoader() != null)) {
            throw new ClassNotFoundException();
        }
        Class<?> c = this.getClassLoader().loadClass(className);
        return c;
    }
}

