/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmrFieldTest;
import java.util.Set;

public class CmrFields
extends CmrFieldTest {
    protected boolean runIndividualCmrTest(Descriptor descriptor, RelationRoleDescriptor role, Class c, Result result) {
        boolean foundIt = false;
        CMRFieldInfo info = null;
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            info = role.getCMRFieldInfo();
        }
        catch (Exception e) {
            this.addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No Local interfaces defined for EJB [ {0} ]", new Object[]{descriptor.getName()}));
            return false;
        }
        if (role.getPartner().getIsMany()) {
            if (info.type.getName().equals("java.util.Collection") || info.type.getName().equals("java.util.Set")) {
                foundIt = true;
            }
        } else {
            EjbBundleDescriptor bundle = ((EjbDescriptor)descriptor).getEjbBundleDescriptor();
            if (((EjbDescriptor)descriptor).getLocalClassName() != null && !"".equals(((EjbDescriptor)descriptor).getLocalClassName())) {
                if (this.isValidInterface(info.type, bundle.getEjbs())) {
                    foundIt = true;
                }
            } else {
                if (role.getRelationshipDescriptor().getIsBidirectional()) {
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Invalid type assigned for container managed relationship [ {0} ] in bean [ {1} ]", new Object[]{info.name, descriptor.getName()}));
                    return false;
                }
                foundIt = true;
            }
        }
        if (foundIt) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Valid type assigned for container managed relationship [ {0} ] in bean [ {1} ]", new Object[]{info.name, descriptor.getName()}));
        } else {
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Invalid type assigned for container managed relationship [ {0} ] in bean [ {1} ]", new Object[]{info.name, descriptor.getName()}));
        }
        return foundIt;
    }

    private boolean isValidInterface(Class fieldType, Set entities) {
        String component = "";
        if (entities == null) {
            return false;
        }
        for (EjbAbstractDescriptor entity : entities) {
            if (!fieldType.getName().equals(entity.getLocalClassName())) continue;
            return true;
        }
        return false;
    }
}

