/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.gui;

import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class ControlPanel
extends JPanel {
    static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    static String allString = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.AllRadioButton", "All Results");
    static String failString = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.FailuresOnlyRadioButton", "Failures Only");
    static String warnString = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.FailuresWarningRadioButton", "Failures and Warnings only");
    static String buttonName = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.buttonName", "Button");
    static String buttonDesc = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.buttonDesc", "This is a button used to select an action");
    static String radioButtonName = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.radioButtonName", "Radio Button");
    static String radioButtonDesc = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.radioButtonDesc", "This is a radio button used to select one from option from many choices");
    static String panelName = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.panelName", "Panel");
    static String panelDesc = smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.panelDesc", "This is a panel in the verifier window");
    static JRadioButton allButton = new JRadioButton(allString);
    static JRadioButton failButton = new JRadioButton(failString);
    static JRadioButton warnButton = new JRadioButton(warnString);
    static final String helpsetName = "Help";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private static HelpBroker mainHB = null;
    private static int reportLevel = 2;
    final DefaultListModel listModel;
    JButton okButton;
    JButton closeButton;
    JButton helpButton;
    JFrame parent;
    HelpSet mainHS = null;

    public ControlPanel(JFrame p) {
        this.parent = p;
        this.getAccessibleContext().setAccessibleName(panelName);
        this.getAccessibleContext().setAccessibleDescription(panelDesc);
        allButton.getAccessibleContext().setAccessibleName(radioButtonName);
        allButton.getAccessibleContext().setAccessibleDescription(radioButtonDesc);
        failButton.getAccessibleContext().setAccessibleName(radioButtonName);
        failButton.getAccessibleContext().setAccessibleDescription(radioButtonDesc);
        warnButton.getAccessibleContext().setAccessibleName(radioButtonName);
        warnButton.getAccessibleContext().setAccessibleDescription(radioButtonDesc);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.ItemsToBeVerifierPanelLabel", "Items to be Verified")));
        this.setLayout(new BoxLayout(this, 0));
        JButton addButton = new JButton(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.AddButton", "Add..."));
        JButton deleteButton = new JButton(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.DeleteButton", "Delete"));
        addButton.getAccessibleContext().setAccessibleName(buttonName);
        addButton.getAccessibleContext().setAccessibleDescription(buttonDesc);
        addButton.setMnemonic('A');
        deleteButton.getAccessibleContext().setAccessibleName(buttonName);
        deleteButton.getAccessibleContext().setAccessibleDescription(buttonDesc);
        deleteButton.setMnemonic('D');
        this.listModel = new DefaultListModel();
        final JList list = new JList(this.listModel);
        list.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.listName", "List"));
        list.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.listDesc", "This is a list"));
        list.setSelectionMode(1);
        JScrollPane listScroller = new JScrollPane(list);
        listScroller.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.scrName", "Scroll Pane"));
        listScroller.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.scrDesc", "This is a scroll pane that helps to scroll the list"));
        listScroller.setPreferredSize(new Dimension(250, 80));
        listScroller.setMinimumSize(new Dimension(250, 80));
        listScroller.setAlignmentX(0.0f);
        JPanel listPane = new JPanel();
        listPane.getAccessibleContext().setAccessibleName(panelName);
        listPane.getAccessibleContext().setAccessibleDescription(panelDesc);
        listPane.setLayout(new BoxLayout(listPane, 1));
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.getAccessibleContext().setAccessibleName(panelName);
        buttonPane.getAccessibleContext().setAccessibleDescription(panelDesc);
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(addButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(deleteButton);
        JPanel listPanel = new JPanel();
        listPanel.getAccessibleContext().setAccessibleName(panelName);
        listPanel.getAccessibleContext().setAccessibleDescription(panelDesc);
        listPanel.setLayout(new BorderLayout());
        listPanel.add((Component)listPane, "Center");
        listPanel.add((Component)buttonPane, "South");
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.fcName", "FileChooser"));
        fileChooser.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.fcDesc", "This dialog box enables selection of files"));
        fileChooser.setApproveButtonMnemonic('O');
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    File[] files = fileChooser.getSelectedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (ControlPanel.this.listModel.contains(files[i])) continue;
                        ControlPanel.this.listModel.addElement(files[i]);
                    }
                    list.setSelectedIndex(ControlPanel.this.listModel.getSize() - 1);
                }
            }
        });
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                fileChooser.rescanCurrentDirectory();
                fileChooser.setFileSelectionMode(0);
                fileChooser.showOpenDialog(null);
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!list.isSelectionEmpty()) {
                    Object[] selections = list.getSelectedValues();
                    for (int i = 0; i < selections.length; ++i) {
                        ControlPanel.this.listModel.removeElement(selections[i]);
                    }
                } else {
                    JOptionPane.showMessageDialog(ControlPanel.this.parent, smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.optionPane.deleteButtonNoFiles", "You must first select file to delete.") + "\n" + smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.optionPane.deleteButtonNoFiles2", "Then click on the Delete button, to delete file from list of files to be verified."), smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.optionPane.deleteTitle", "ERROR"), 0);
                }
            }
        });
        allButton.setMnemonic(76);
        allButton.setActionCommand(allString);
        allButton.setSelected(ControlPanel.getReportLevel() == 2);
        failButton.setMnemonic(70);
        failButton.setActionCommand(failString);
        failButton.setSelected(ControlPanel.getReportLevel() == 0);
        warnButton.setMnemonic(87);
        warnButton.setActionCommand(warnString);
        warnButton.setSelected(ControlPanel.getReportLevel() == 1);
        ButtonGroup group = new ButtonGroup();
        group.add(allButton);
        group.add(failButton);
        group.add(warnButton);
        JPanel radioPanel = new JPanel();
        radioPanel.getAccessibleContext().setAccessibleName(panelName);
        radioPanel.getAccessibleContext().setAccessibleDescription(panelDesc);
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        JLabel d = new JLabel(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.RadioButtonLabel", "Display:"));
        d.setVerticalAlignment(3);
        d.getAccessibleContext().setAccessibleName(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.labelName", "Label"));
        d.getAccessibleContext().setAccessibleDescription(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.labelDesc", "This is a label"));
        radioPanel.add(d);
        radioPanel.add(allButton);
        radioPanel.add(failButton);
        radioPanel.add(warnButton);
        this.okButton = new JButton(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.OKButton", "OK"));
        this.closeButton = new JButton(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.CloseButton", "Close"));
        this.helpButton = new JButton(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.HelpButton", helpsetName));
        this.okButton.getAccessibleContext().setAccessibleName(buttonName);
        this.okButton.getAccessibleContext().setAccessibleDescription(buttonDesc);
        this.okButton.setMnemonic('O');
        this.closeButton.getAccessibleContext().setAccessibleName(buttonName);
        this.closeButton.getAccessibleContext().setAccessibleDescription(buttonDesc);
        this.closeButton.setMnemonic('C');
        this.helpButton.getAccessibleContext().setAccessibleName(buttonName);
        this.helpButton.getAccessibleContext().setAccessibleDescription(buttonDesc);
        this.helpButton.setMnemonic('H');
        boolean mainHelpSetWoes = false;
        boolean usingDeployTool = false;
        if (!usingDeployTool) {
            try {
                ClassLoader cl = ControlPanel.class.getClassLoader();
                URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetName);
                this.mainHS = new HelpSet(cl, url);
            }
            catch (Exception ee) {
                logger.log(Level.WARNING, "com.sun.enterprise.tools.verifier.gui.ControlPanel.debug.helpSetMissing", new Object[]{helpsetName});
                JOptionPane.showMessageDialog(this, smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.optionPane.helpSetMissing1", "Could not find Help Set for {0}.", new Object[]{helpsetName}) + "\n" + smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.optionPane.helpSetMissing2", "Please consult your host administrator. Starting Verifier with JavaHelp disabled."));
                mainHelpSetWoes = true;
            }
            catch (ExceptionInInitializerError ex) {
                logger.log(Level.WARNING, "com.sun.enterprise.tools.verifier.gui.ControlPanel.debug.ExceptionInInitializerError");
                JOptionPane.showMessageDialog(this, smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.optionPane.helpSetMissing1", "Could not find Help Set for {0}.", new Object[]{helpsetName}) + "\n" + smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.optionPane.helpSetMissing2", "Please consult your host administrator.  Starting Verifier with JavaHelp disabled."));
                mainHelpSetWoes = true;
            }
            if (!mainHelpSetWoes) {
                mainHB = this.mainHS.createHelpBroker();
                ControlPanel.setMainHelpBroker(mainHB);
                mainHB.enableHelpKey((Component)this, "Verifier", null);
                CSH.setHelpIDString((Component)this.helpButton, (String)"Verifier");
                this.helpButton.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(mainHB));
            } else {
                this.helpButton.setEnabled(false);
            }
        } else {
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(ControlPanel.this.parent, smh.getLocalString("com.sun.enterprise.tools.verifier.gui.ControlPanel.optionPane.helpDisabled", "Verifier online help disabled."));
                }
            });
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.getAccessibleContext().setAccessibleName(panelName);
        buttonPanel.getAccessibleContext().setAccessibleDescription(panelDesc);
        GridLayout gl = new GridLayout(0, 1);
        gl.setVgap(10);
        gl.setHgap(5);
        buttonPanel.setLayout(gl);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.closeButton);
        buttonPanel.add(this.helpButton);
        buttonPanel.add(new JLabel(""));
        this.add(listPanel);
        this.add(radioPanel);
        this.add(buttonPanel);
        RadioListener myListener = new RadioListener();
        ControlPanel.addRadioButtonListener(myListener);
    }

    public static void setMainHelpBroker(HelpBroker hb) {
        mainHB = hb;
        Thread t = new Thread(){

            public void run() {
                if (mainHB != null) {
                    mainHB.initPresentation();
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    private static void setReportLevel(int rl) {
        reportLevel = rl;
    }

    static int getReportLevel() {
        return reportLevel;
    }

    public static void addRadioButtonListener(ActionListener r) {
        allButton.addActionListener(r);
        failButton.addActionListener(r);
        warnButton.addActionListener(r);
    }

    public void addJarFile(File jarFile) {
        this.listModel.addElement(jarFile);
    }

    public void removeAllJarFiles() {
        this.listModel.clear();
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == allButton) {
                ControlPanel.setReportLevel(2);
            }
            if (e.getSource() == failButton) {
                ControlPanel.setReportLevel(0);
            }
            if (e.getSource() == warnButton) {
                ControlPanel.setReportLevel(1);
            }
        }
    }
}

