/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.SpecVersionMapper;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.AppClientClosureCompiler;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;

public class AppClientVerifier
extends BaseVerifier {
    private ApplicationClientDescriptor appclientd = null;
    private String classPath;
    private boolean isASMode = false;

    public AppClientVerifier(FrameworkContext frameworkContext, ApplicationClientDescriptor appClientDescriptor) {
        this.frameworkContext = frameworkContext;
        this.appclientd = appClientDescriptor;
        this.isASMode = !frameworkContext.isPortabilityMode();
    }

    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.frameworkContext.isAppClient()) && this.areTestsNotRequired(this.frameworkContext.isWebServicesClient()) && this.areTestsNotRequired(this.frameworkContext.isPersistenceUnits())) {
            return;
        }
        this.preVerification();
        this.createClosureCompiler();
        this.verify(this.appclientd, new AppClientCheckMgrImpl(this.frameworkContext));
    }

    public Descriptor getDescriptor() {
        return this.appclientd;
    }

    protected ClassLoader createClassLoader() throws IOException {
        return this.appclientd.getClassLoader();
    }

    protected String getArchiveUri() {
        return FileUtils.makeFriendlyFileName(this.appclientd.getModuleDescriptor().getArchiveUri());
    }

    protected String[] getDDString() {
        String[] dd = new String[]{"META-INF/sun-application-client.xml", "META-INF/application-client.xml"};
        return dd;
    }

    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (this.isASMode) {
            this.classPath = this.getClassPath(this.frameworkContext.getClassPath());
            return this.classPath;
        }
        if (!this.appclientd.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.frameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            assert (ear.isDirectory());
            String earCP = ClassPathBuilder.buildClassPathForEar(ear);
            String libdir = this.appclientd.getApplication().getLibraryDirectory();
            if (libdir != null) {
                earCP = this.getLibdirClasspath(ear_uri, libdir) + earCP;
            }
            String module_uri = this.appclientd.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            assert (module.isFile() && !module.isAbsolute());
            File explodedModuleDir = new File(ear_uri, FileUtils.makeFriendlyFileName(module_uri));
            String moduleCP = ClassPathBuilder.buildClassPathForJar(explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
        } else {
            String module_uri = this.frameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            assert (module.isDirectory() && module.isAbsolute());
            cp = ClassPathBuilder.buildClassPathForJar(module);
        }
        this.classPath = cp;
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = SpecVersionMapper.getAppClientVersion(this.frameworkContext.getJavaEEVersion());
        Object arg = this.isASMode ? this.appclientd.getClassLoader() : this.getClassPath();
        AppClientClosureCompiler cc = new AppClientClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{arg}));
        this.context.setClosureCompiler(cc);
    }
}

