/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.tools.verifier.VerifierResults;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VerifierResultsImpl
implements VerifierResults {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(VerifierResultsImpl.class);
    private static Class resultsReportClass = null;
    private static Method failedCountMethod = null;
    private static Method errorCountMethod = null;
    private static Method warningCountMethod = null;
    private Object resultObj;

    public VerifierResultsImpl(Object result) {
        this.resultObj = result;
    }

    public int getFailedCount() {
        this.init();
        if (failedCountMethod == null || this.resultObj == null) {
            return -1;
        }
        String name = resultsReportClass.getName();
        try {
            Object result = failedCountMethod.invoke(this.resultObj, (Object[])null);
            return (Integer)result;
        }
        catch (IllegalAccessException e) {
            _logger.log(Level.SEVERE, "verification.class.access.error", new Object[]{name});
        }
        catch (InvocationTargetException e) {
            _logger.log(Level.SEVERE, "verification.method.error", new Object[]{"verifyEar", e.getMessage()});
        }
        return -1;
    }

    public int getWarningCount() {
        this.init();
        if (warningCountMethod == null || this.resultObj == null) {
            return -1;
        }
        String name = resultsReportClass.getName();
        try {
            Object result = warningCountMethod.invoke(this.resultObj, (Object[])null);
            return (Integer)result;
        }
        catch (IllegalAccessException e) {
            _logger.log(Level.SEVERE, "verification.class.access.error", new Object[]{name});
        }
        catch (InvocationTargetException e) {
            _logger.log(Level.SEVERE, "verification.method.error", new Object[]{"verifyEar", e.getMessage()});
        }
        return -1;
    }

    public int getErrorCount() {
        this.init();
        if (errorCountMethod == null || this.resultObj == null) {
            return -1;
        }
        String name = resultsReportClass.getName();
        try {
            Object result = errorCountMethod.invoke(this.resultObj, (Object[])null);
            return (Integer)result;
        }
        catch (IllegalAccessException e) {
            _logger.log(Level.SEVERE, "verification.class.access.error", new Object[]{name});
        }
        catch (InvocationTargetException e) {
            _logger.log(Level.SEVERE, "verification.method.error", new Object[]{"verifyEar", e.getMessage()});
        }
        return -1;
    }

    private void init() {
        if (resultsReportClass != null) {
            return;
        }
        String name = null;
        try {
            name = System.getProperty("j2ee.verifier.ResultsReport", "com.sun.enterprise.tools.verifier.ResultsReport");
            resultsReportClass = Class.forName(name);
            warningCountMethod = resultsReportClass.getDeclaredMethod("getWarningCount", null);
            failedCountMethod = resultsReportClass.getDeclaredMethod("getFailedCount", null);
            errorCountMethod = resultsReportClass.getDeclaredMethod("getErrorCount", null);
        }
        catch (ClassNotFoundException e) {
            _logger.log(Level.SEVERE, "verification.class.notfound", new Object[]{name});
        }
        catch (NoSuchMethodException e) {
            _logger.log(Level.SEVERE, "verification.method.notfound", new Object[]{e.getMessage(), name});
        }
    }
}

