/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss.provider;

import com.sun.enterprise.server.ss.provider.ASChannel;
import com.sun.enterprise.server.ss.provider.ASSelectionKey;
import com.sun.enterprise.server.ss.provider.ASServerSocketChannel;
import com.sun.enterprise.server.ss.spi.ASSocketFacadeUtils;
import com.sun.enterprise.server.ss.util.ASSet;
import com.sun.enterprise.server.ss.util.ASWrapperCreator;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASSelector
extends AbstractSelector
implements ASWrapperCreator {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private AbstractSelector sel = null;
    private boolean wakenup = false;
    private boolean wrapSelectionKeys = false;
    private int port = 0;

    ASSelector(AbstractSelector sel, SelectorProvider provider) {
        super(provider);
        this.sel = sel;
    }

    protected void implCloseSelector() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Selector is getting closed :" + this.sel);
        }
        this.sel.close();
    }

    protected SelectionKey register(AbstractSelectableChannel ac, int ops, Object obj) {
        try {
            if (ac instanceof ASChannel) {
                ASChannel asc = (ASChannel)((Object)ac);
                SelectableChannel sc = asc.getActualChannel();
                if (ac instanceof ASServerSocketChannel && ops == 16) {
                    this.port = ((ASServerSocketChannel)ac).getPortNumber();
                    this.wrapSelectionKeys = true;
                }
                return sc.register(this.sel, ops, obj);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "In ASSelector.register channel class = " + ac.getClass().getName(), new Exception());
            }
            return ac.register(this.sel, ops, obj);
        }
        catch (ClosedChannelException ce) {
            throw new RuntimeException(ce);
        }
    }

    public Set keys() {
        if (this.wrapSelectionKeys && ASSocketFacadeUtils.getASSocketService().isServerStartingUp(this.port)) {
            return new ASSet(this.sel.keys(), this);
        }
        return this.sel.keys();
    }

    public Set selectedKeys() {
        if (this.wrapSelectionKeys && ASSocketFacadeUtils.getASSocketService().isServerStartingUp(this.port)) {
            return new ASSet(this.sel.selectedKeys(), this);
        }
        return this.sel.selectedKeys();
    }

    public Selector wakeup() {
        this.wakenup = true;
        return this.sel.wakeup();
    }

    public int select(long l) throws IOException {
        return this.sel.select(l);
    }

    public int selectNow() throws IOException {
        return this.sel.selectNow();
    }

    public int select() throws IOException {
        return this.sel.select();
    }

    boolean wakenUp() {
        boolean result = this.wakenup;
        this.wakenup = false;
        return result;
    }

    public Object wrapIfNecessary(Object next) {
        SelectionKey selKey = (SelectionKey)next;
        if ((selKey.interestOps() & 0x10) != 0) {
            ASServerSocketChannel channel = new ASServerSocketChannel((ServerSocketChannel)selKey.channel(), this.sel.provider());
            ASSelectionKey key = new ASSelectionKey(channel, selKey, this);
            key.attach(selKey.attachment());
            return key;
        }
        return selKey;
    }

    public boolean equals(Object obj) {
        if (obj == this.sel) {
            return true;
        }
        if (obj instanceof Selector) {
            return ((Selector)obj).equals(this.sel);
        }
        return false;
    }

    public int hashCode() {
        return this.sel.hashCode();
    }

    public Selector getSelector() {
        return this.sel;
    }
}

