/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.server.ApplicationManager;
import com.sun.enterprise.server.ManagerFactory;
import com.sun.enterprise.server.StandAloneConnectorModulesManager;
import com.sun.enterprise.server.StandAloneEJBModulesManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

class TargetFileFilter
implements FileFilter {
    private static final Logger sLogger = LogDomains.getLogger("javax.enterprise.system.core");
    String targetType = null;

    TargetFileFilter(String targetType) {
        this.targetType = targetType;
    }

    public boolean accept(File f) {
        boolean flag = false;
        String name = f.getName();
        String fileType = null;
        int lastIndex = -1;
        if (name != null && name.length() > 0) {
            lastIndex = name.lastIndexOf(46);
            try {
                if (lastIndex >= 0) {
                    fileType = name.substring(lastIndex + 1);
                }
                if (!f.isDirectory() && f.canRead() && (name = name.substring(0, lastIndex)) != null && name.length() > 0) {
                    flag = true;
                }
            }
            catch (SecurityException se) {
                sLogger.log(Level.WARNING, "SecurityException occured while accessing :" + f.getName());
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "Exception occured while accessing :" + f.getName());
            }
        }
        if (flag && this.isApplicableToTarget(f) && !this.isRegistered(name, fileType)) {
            sLogger.log(Level.FINE, "Selecting file [" + f.getAbsolutePath() + "] for autodeployment");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isApplicableToTarget(File f) {
        JarFile j = null;
        try {
            j = new JarFile(f);
            Manifest m = j.getManifest();
            Attributes a = m.getMainAttributes();
            String appType = a.getValue("Application-Type");
            if (appType == null) {
                appType = "user";
            }
            if (this.targetType.equals("admin")) {
                if (appType.equals("system-admin") || appType.equals("system-all")) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            if (this.targetType.equals("instance")) {
                if (appType.equals("system-instance") || appType.equals("system-all")) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Exception occured while accessing :" + f.getName());
            boolean bl = false;
            return bl;
        }
        finally {
            if (j != null) {
                try {
                    j.close();
                }
                catch (IOException ioe) {
                    sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRegistered(String name, String type) {
        try {
            if (type.equals("ear")) {
                ApplicationManager amgr = ManagerFactory.getApplicationManager();
                return amgr.isRegistered(name);
            }
            if (type.equals("jar")) {
                StandAloneEJBModulesManager emgr = ManagerFactory.getSAEJBModulesManager();
                return emgr.isRegistered(name);
            }
            if (type.equals("rar")) {
                StandAloneConnectorModulesManager cmgr = ManagerFactory.getSAConnectorModulesManager();
                return cmgr.isRegistered(name);
            }
            if (!type.equals("war")) return false;
        }
        catch (Exception e) {
            sLogger.log(Level.FINE, "error_occured_in_isreg", e);
        }
        return false;
    }
}

