/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.resource.AdminObjectResourceDeployer;
import com.sun.enterprise.resource.ConnectorConnectionPoolDeployer;
import com.sun.enterprise.resource.ConnectorResourceDeployer;
import com.sun.enterprise.resource.CustomResourceDeployer;
import com.sun.enterprise.resource.ExternalJndiResourceDeployer;
import com.sun.enterprise.resource.JdbcConnectionPoolDeployer;
import com.sun.enterprise.resource.JdbcResourceDeployer;
import com.sun.enterprise.resource.MailResourceDeployer;
import com.sun.enterprise.resource.PersistenceManagerFactoryResourceDeployer;
import com.sun.enterprise.resource.ResourceAdapterConfigDeployer;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class ResourceDeployerFactory {
    private ResourceDeployer resourceAdapterConfigDeployer_ = new ResourceAdapterConfigDeployer();
    private ResourceDeployer adminObjectResourceDeployer_ = new AdminObjectResourceDeployer();
    private ResourceDeployer connectorResourceDeployer_ = new ConnectorResourceDeployer();
    private ResourceDeployer connectorConnectionPoolDeployer_ = new ConnectorConnectionPoolDeployer();
    private ResourceDeployer jdbcResourceDeployer_ = new JdbcResourceDeployer();
    private ResourceDeployer pmfResourceDeployer_ = new PersistenceManagerFactoryResourceDeployer();
    private ResourceDeployer customResourceDeployer_ = new CustomResourceDeployer();
    private ResourceDeployer externalJndiResourceDeployer_ = new ExternalJndiResourceDeployer();
    private ResourceDeployer mailResourceDeployer_ = new MailResourceDeployer();
    private ResourceDeployer JdbcConnectionPoolDeployer_ = new JdbcConnectionPoolDeployer();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager("com.sun.enterprise.server");

    public ResourceDeployer getResourceDeployer(String type) throws Exception {
        ResourceDeployer deployer = null;
        if (type.equals("jdbc")) {
            deployer = this.jdbcResourceDeployer_;
        } else if (type.equals("pmf")) {
            deployer = this.pmfResourceDeployer_;
        } else if (type.equals("custom")) {
            deployer = this.customResourceDeployer_;
        } else if (type.equals("external-jndi")) {
            deployer = this.externalJndiResourceDeployer_;
        } else if (type.equals("mail")) {
            deployer = this.mailResourceDeployer_;
        } else if (type.equals("aor")) {
            deployer = this.adminObjectResourceDeployer_;
        } else if (type.equals("cr")) {
            deployer = this.connectorResourceDeployer_;
        } else if (type.equals("ccp")) {
            deployer = this.connectorConnectionPoolDeployer_;
        } else if (type.equals("rac")) {
            deployer = this.resourceAdapterConfigDeployer_;
        } else if (type.equals("jcp")) {
            deployer = this.JdbcConnectionPoolDeployer_;
        } else {
            String msg = localStrings.getString("resource.deployment.resource_type_not_implemented", type);
            throw new Exception(msg);
        }
        return deployer;
    }

    public Object getResource(String type, String name, Resources rbeans) throws Exception {
        return this.getResourceDeployer(type).getResource(name, rbeans);
    }
}

