/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.jms.JmsHostEvent;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.system.ActiveJmsResourceAdapter;

public class JmsHostEventListener
implements com.sun.enterprise.admin.event.jms.JmsHostEventListener {
    private ConnectorRegistry registry = ConnectorRegistry.getInstance();

    public void handleDelete(JmsHostEvent event) throws AdminEventListenerException {
        this.reloadRA(event);
    }

    public void handleUpdate(JmsHostEvent event) throws AdminEventListenerException {
        this.reloadRA(event);
    }

    public void handleCreate(JmsHostEvent event) throws AdminEventListenerException {
        this.reloadRA(event);
    }

    private void reloadRA(JmsHostEvent event) throws AdminEventListenerException {
        try {
            JmsService service = this.getJmsService(event);
            ActiveJmsResourceAdapter aja = this.getAdapter();
            if (aja != null) {
                this.getAdapter().reloadRA(service);
            }
        }
        catch (ConnectorRuntimeException cre) {
            AdminEventListenerException ale = new AdminEventListenerException(cre.getMessage());
            ale.initCause(cre);
            throw ale;
        }
        catch (ConfigException ce) {
            AdminEventListenerException ale = new AdminEventListenerException(ce.getMessage());
            ale.initCause(ce);
            throw ale;
        }
    }

    private ActiveJmsResourceAdapter getAdapter() {
        return (ActiveJmsResourceAdapter)this.registry.getActiveResourceAdapter("jmsra");
    }

    private JmsService getJmsService(JmsHostEvent event) throws ConfigException {
        ConfigContext context = event.getConfigContext();
        return ServerBeansFactory.getJmsServiceBean(context);
    }
}

