/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.server.ResourcesLoader;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorResourcesLoader
extends ResourcesLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public void load() {
        ConfigBean[][] cb = null;
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            cb = resourceUtil.getConnectorResources();
            if (cb != null) {
                this.load(cb);
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "core.connectorresource_read_error");
            _logger.log(Level.SEVERE, "", ce);
        }
    }

    public void loadConnectorResources() {
        ConfigBean[][] cb = null;
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            cb = resourceUtil.getStandAloneNonSystemRarConnectorResourcesWithoutRAConfigs();
            if (cb != null) {
                this.load(cb);
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "core.connectorresource_read_error");
            _logger.log(Level.SEVERE, "", ce);
        }
    }

    public void loadRAConfigs() {
        ConfigBean[][] cb = new ConfigBean[1][];
        try {
            ConfigBean[] raConfBeans = ResourcesUtil.createInstance().getResourceAdapterConfigs();
            if (raConfBeans != null) {
                cb[0] = raConfBeans;
                this.load(cb);
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "core.connectorresource_read_error");
            _logger.log(Level.SEVERE, "", ce);
        }
    }

    public void load(String rarName) {
        ConfigBean[][] cb = null;
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            cb = resourceUtil.getAllConnectorResourcesForRar(rarName);
            if (cb != null) {
                this.load(cb);
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "core.connectorresource_read_error");
            _logger.log(Level.SEVERE, "", ce);
        }
    }

    public void loadRAConfigs(String rarName) {
        ConfigBean[][] cb = new ConfigBean[1][];
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            ConfigBean[] raConfBeans = resourceUtil.getResourceAdapterConfigs(rarName);
            if (raConfBeans != null) {
                cb[0] = raConfBeans;
                this.load(cb);
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "core.connectorresource_read_error");
            _logger.log(Level.SEVERE, "", ce);
        }
    }

    public void loadEmbeddedRarRAConfigs(String appName) {
        ConfigBean[][] cb = new ConfigBean[1][];
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            ConfigBean[] raConfBeans = resourceUtil.getEmbeddedRarResourceAdapterConfigs(appName);
            if (raConfBeans != null) {
                cb[0] = raConfBeans;
                this.load(cb);
            }
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "core.connectorresource_read_error");
            _logger.log(Level.SEVERE, "", ce);
        }
    }

    public void loadEmbeddedRarResources(String appName, Application appDesc) {
        Set rars = appDesc.getRarDescriptors();
        for (ConnectorDescriptor cd : rars) {
            String rarName = cd.getDeployName();
            String embeddedRarName = appName + "#" + FileUtils.makeFriendlyFilenameNoExtension(rarName);
            this.load(embeddedRarName);
        }
    }

    public void stopActiveResourceAdapters() {
        ConnectorRuntime.stopAllActiveResourceAdapters();
    }
}

